/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.InvoiceItemCreateRequest;
import org.threeten.bp.LocalDate;

public class InvoiceCreateRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DUE_DATE = "due_date";
    @SerializedName(value="due_date")
    private LocalDate dueDate;
    public static final String SERIALIZED_NAME_DOCUMENT_DATE = "document_date";
    @SerializedName(value="document_date")
    private LocalDate documentDate;
    public static final String SERIALIZED_NAME_TRANSFER_TO_ACCOUNTING = "transfer_to_accounting";
    @SerializedName(value="transfer_to_accounting")
    private Boolean transferToAccounting;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_PAY = "pay";
    @SerializedName(value="pay")
    private Boolean pay;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<InvoiceItemCreateRequest> items = null;
    public static final String SERIALIZED_NAME_POST = "post";
    @SerializedName(value="post")
    private Boolean post;

    public InvoiceCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the invoice.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public InvoiceCreateRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the account that owns the invoice.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public InvoiceCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string associated with the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InvoiceCreateRequest dueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date on which payment for the invoice is due.")
    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public InvoiceCreateRequest documentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date when the invoice takes effect.")
    public LocalDate getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
    }

    public InvoiceCreateRequest transferToAccounting(Boolean transferToAccounting) {
        this.transferToAccounting = transferToAccounting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to transfer to an external accounting system.")
    public Boolean getTransferToAccounting() {
        return this.transferToAccounting;
    }

    public void setTransferToAccounting(Boolean transferToAccounting) {
        this.transferToAccounting = transferToAccounting;
    }

    public InvoiceCreateRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public InvoiceCreateRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public InvoiceCreateRequest pay(Boolean pay) {
        this.pay = pay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the invoice is automatically picked up for processing in the corresponding payment run.")
    public Boolean getPay() {
        return this.pay;
    }

    public void setPay(Boolean pay) {
        this.pay = pay;
    }

    public InvoiceCreateRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="3-letter ISO 4217 currency code. This field is available only if you have the [Multiple Currencies](https://knowledgecenter.zuora.com/Zuora_Billing/Bill_your_customers/Flexible_Billing/Multiple_Currencies) feature enabled.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public InvoiceCreateRequest items(List<InvoiceItemCreateRequest> items) {
        this.items = items;
        return this;
    }

    public InvoiceCreateRequest addItemsItem(InvoiceItemCreateRequest itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<InvoiceItemCreateRequest>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information of all invoice items.")
    public List<InvoiceItemCreateRequest> getItems() {
        return this.items;
    }

    public void setItems(List<InvoiceItemCreateRequest> items) {
        this.items = items;
    }

    public InvoiceCreateRequest post(Boolean post) {
        this.post = post;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to automatically post an invoice after it is created.")
    public Boolean getPost() {
        return this.post;
    }

    public void setPost(Boolean post) {
        this.post = post;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceCreateRequest invoiceCreateRequest = (InvoiceCreateRequest)o;
        return Objects.equals(this.accountId, invoiceCreateRequest.accountId) && Objects.equals(this.accountNumber, invoiceCreateRequest.accountNumber) && Objects.equals(this.description, invoiceCreateRequest.description) && Objects.equals(this.dueDate, invoiceCreateRequest.dueDate) && Objects.equals(this.documentDate, invoiceCreateRequest.documentDate) && Objects.equals(this.transferToAccounting, invoiceCreateRequest.transferToAccounting) && Objects.equals(this.customFields, invoiceCreateRequest.customFields) && Objects.equals(this.pay, invoiceCreateRequest.pay) && Objects.equals(this.currency, invoiceCreateRequest.currency) && Objects.equals(this.items, invoiceCreateRequest.items) && Objects.equals(this.post, invoiceCreateRequest.post);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accountNumber, this.description, this.dueDate, this.documentDate, this.transferToAccounting, this.customFields, this.pay, this.currency, this.items, this.post);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoiceCreateRequest {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    documentDate: ").append(this.toIndentedString(this.documentDate)).append("\n");
        sb.append("    transferToAccounting: ").append(this.toIndentedString(this.transferToAccounting)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    pay: ").append(this.toIndentedString(this.pay)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    post: ").append(this.toIndentedString(this.post)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

