/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.zuora.JSON;
import com.zuora.model.AssociationRule;
import com.zuora.model.CommitmentTypeEnum;
import com.zuora.model.Condition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitmentBaseAttributes {
    public static final String SERIALIZED_NAME_COMMITMENT_NUMBER = "commitmentNumber";
    @SerializedName(value="commitmentNumber")
    private String commitmentNumber;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private CommitmentTypeEnum type;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private Integer priority;
    public static final String SERIALIZED_NAME_ASSOCIATION_RULES = "associationRules";
    @SerializedName(value="associationRules")
    private List<AssociationRule> associationRules;
    public static final String SERIALIZED_NAME_ELIGIBLE_ACCOUNT_CONDITIONS = "eligibleAccountConditions";
    @SerializedName(value="eligibleAccountConditions")
    private Condition eligibleAccountConditions;
    public static final String SERIALIZED_NAME_ELIGIBLE_CHARGE_CONDITIONS = "eligibleChargeConditions";
    @SerializedName(value="eligibleChargeConditions")
    private Condition eligibleChargeConditions;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "customFields";
    @SerializedName(value="customFields")
    private Map<String, Object> customFields;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CommitmentBaseAttributes commitmentNumber(String commitmentNumber) {
        this.commitmentNumber = commitmentNumber;
        return this;
    }

    @Nullable
    public String getCommitmentNumber() {
        return this.commitmentNumber;
    }

    public void setCommitmentNumber(String commitmentNumber) {
        this.commitmentNumber = commitmentNumber;
    }

    public CommitmentBaseAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CommitmentBaseAttributes type(CommitmentTypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public CommitmentTypeEnum getType() {
        return this.type;
    }

    public void setType(CommitmentTypeEnum type) {
        this.type = type;
    }

    public CommitmentBaseAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CommitmentBaseAttributes priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public CommitmentBaseAttributes associationRules(List<AssociationRule> associationRules) {
        this.associationRules = associationRules;
        return this;
    }

    public CommitmentBaseAttributes addAssociationRulesItem(AssociationRule associationRulesItem) {
        if (this.associationRules == null) {
            this.associationRules = new ArrayList<AssociationRule>();
        }
        this.associationRules.add(associationRulesItem);
        return this;
    }

    @Nullable
    public List<AssociationRule> getAssociationRules() {
        return this.associationRules;
    }

    public void setAssociationRules(List<AssociationRule> associationRules) {
        this.associationRules = associationRules;
    }

    public CommitmentBaseAttributes eligibleAccountConditions(Condition eligibleAccountConditions) {
        this.eligibleAccountConditions = eligibleAccountConditions;
        return this;
    }

    @Nonnull
    public Condition getEligibleAccountConditions() {
        return this.eligibleAccountConditions;
    }

    public void setEligibleAccountConditions(Condition eligibleAccountConditions) {
        this.eligibleAccountConditions = eligibleAccountConditions;
    }

    public CommitmentBaseAttributes eligibleChargeConditions(Condition eligibleChargeConditions) {
        this.eligibleChargeConditions = eligibleChargeConditions;
        return this;
    }

    @Nullable
    public Condition getEligibleChargeConditions() {
        return this.eligibleChargeConditions;
    }

    public void setEligibleChargeConditions(Condition eligibleChargeConditions) {
        this.eligibleChargeConditions = eligibleChargeConditions;
    }

    public CommitmentBaseAttributes customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public CommitmentBaseAttributes putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public CommitmentBaseAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitmentBaseAttributes commitmentBaseAttributes = (CommitmentBaseAttributes)o;
        return Objects.equals(this.commitmentNumber, commitmentBaseAttributes.commitmentNumber) && Objects.equals(this.name, commitmentBaseAttributes.name) && Objects.equals((Object)this.type, (Object)commitmentBaseAttributes.type) && Objects.equals(this.description, commitmentBaseAttributes.description) && Objects.equals(this.priority, commitmentBaseAttributes.priority) && Objects.equals(this.associationRules, commitmentBaseAttributes.associationRules) && Objects.equals(this.eligibleAccountConditions, commitmentBaseAttributes.eligibleAccountConditions) && Objects.equals(this.eligibleChargeConditions, commitmentBaseAttributes.eligibleChargeConditions) && Objects.equals(this.customFields, commitmentBaseAttributes.customFields) && Objects.equals(this.additionalProperties, commitmentBaseAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.commitmentNumber, this.name, this.type, this.description, this.priority, this.associationRules, this.eligibleAccountConditions, this.eligibleChargeConditions, this.customFields, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommitmentBaseAttributes {\n");
        sb.append("    commitmentNumber: ").append(this.toIndentedString(this.commitmentNumber)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    associationRules: ").append(this.toIndentedString(this.associationRules)).append("\n");
        sb.append("    eligibleAccountConditions: ").append(this.toIndentedString(this.eligibleAccountConditions)).append("\n");
        sb.append("    eligibleChargeConditions: ").append(this.toIndentedString(this.eligibleChargeConditions)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayassociationRules;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CommitmentBaseAttributes is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_COMMITMENT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_COMMITMENT_NUMBER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMITMENT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `commitmentNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMITMENT_NUMBER).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        CommitmentTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSOCIATION_RULES) != null && !jsonObj.get(SERIALIZED_NAME_ASSOCIATION_RULES).isJsonNull() && (jsonArrayassociationRules = jsonObj.getAsJsonArray(SERIALIZED_NAME_ASSOCIATION_RULES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ASSOCIATION_RULES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `associationRules` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSOCIATION_RULES).toString()));
            }
            for (int i = 0; i < jsonArrayassociationRules.size(); ++i) {
                AssociationRule.validateJsonElement(jsonArrayassociationRules.get(i));
            }
        }
        Condition.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ELIGIBLE_ACCOUNT_CONDITIONS));
        if (jsonObj.get(SERIALIZED_NAME_ELIGIBLE_CHARGE_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_ELIGIBLE_CHARGE_CONDITIONS).isJsonNull()) {
            Condition.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ELIGIBLE_CHARGE_CONDITIONS));
        }
    }

    public static CommitmentBaseAttributes fromJson(String jsonString) throws IOException {
        return (CommitmentBaseAttributes)JSON.getGson().fromJson(jsonString, CommitmentBaseAttributes.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COMMITMENT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_PRIORITY);
        openapiFields.add(SERIALIZED_NAME_ASSOCIATION_RULES);
        openapiFields.add(SERIALIZED_NAME_ELIGIBLE_ACCOUNT_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_ELIGIBLE_CHARGE_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_FIELDS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_ELIGIBLE_ACCOUNT_CONDITIONS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!CommitmentBaseAttributes.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CommitmentBaseAttributes.class));
            return new TypeAdapter<CommitmentBaseAttributes>(){

                public void write(JsonWriter out, CommitmentBaseAttributes value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    out.beginObject();
                    for (Map.Entry e : obj.entrySet()) {
                        out.name((String)e.getKey());
                        elementAdapter.write(out, (Object)((JsonElement)e.getValue()));
                    }
                    if (value.getAdditionalProperties() != null) {
                        boolean oldSerializeNulls = out.getSerializeNulls();
                        out.setSerializeNulls(true);
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                            } else if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                            } else if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                            } else if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                            } else if (entry.getValue() == null) {
                                obj.add(entry.getKey(), null);
                            } else {
                                JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                                if (jsonElement.isJsonArray()) {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                } else {
                                    obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                                }
                            }
                            out.name(entry.getKey());
                            elementAdapter.write(out, (Object)obj.get(entry.getKey()));
                        }
                        out.setSerializeNulls(oldSerializeNulls);
                    }
                    out.endObject();
                }

                public CommitmentBaseAttributes read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CommitmentBaseAttributes.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    CommitmentBaseAttributes instance = (CommitmentBaseAttributes)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

