/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openapitools.client.ApiClient;
import org.openapitools.client.api.AccountsApi;
import org.openapitools.client.api.BillingDocumentsApi;
import org.openapitools.client.api.ContactsApi;
import org.openapitools.client.api.PaymentMethodsApi;
import org.openapitools.client.api.PaymentsApi;
import org.openapitools.client.api.PlansApi;
import org.openapitools.client.api.PricesApi;
import org.openapitools.client.api.ProductsApi;
import org.openapitools.client.api.SubscriptionPlansApi;
import org.openapitools.client.api.SubscriptionsApi;
import org.openapitools.client.api.WorkflowsApi;

public class ZuoraClient {
    public static final Map<String, String> zuoraBaseUrls = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("LOCAL", "http://localhost:3000");
            this.put("STG", "https://rest-staging2.zuora.com");
            this.put("SBX", "https://rest.apisandbox.zuora.com");
            this.put("CSBX", "https://rest.test.zuora.com");
            this.put("SBX_NA", "https://rest.sandbox.na.zuora.com");
            this.put("PROD", "https://rest.zuora.com");
            this.put("PROD_NA", "https://rest.na.zuora.com");
        }
    });
    private final String clientId;
    private final String clientSecret;
    private final String baseUrl;
    private final String oauthUrl;
    private final ApiClient apiClient;
    private final Timer timer;
    private TimerTask reinitTask;
    private String bearerToken = null;
    private final Map<String, String> defaultHeaders = new HashMap<String, String>();
    private int connectionTimeout = 65000;
    private int readTimeout = 65000;
    private int writeTimeout = 65000;

    public ZuoraClient(String clientId, String clientSecret, ZuoraEnv env) {
        this(clientId, clientSecret, env.baseUrl);
    }

    public ZuoraClient(String clientId, String clientSecret, String zuoraBaseUrl) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        if (zuoraBaseUrls.get("LOCAL").equals(zuoraBaseUrl)) {
            this.oauthUrl = zuoraBaseUrls.get("SBX");
            this.baseUrl = zuoraBaseUrl;
        } else {
            this.oauthUrl = zuoraBaseUrl;
            this.baseUrl = this.oauthUrl + "/v2";
        }
        this.apiClient = new ApiClient();
        this.apiClient.setBasePath(this.baseUrl);
        this.apiClient.setConnectTimeout(this.connectionTimeout);
        this.apiClient.setReadTimeout(this.readTimeout);
        this.apiClient.setWriteTimeout(this.writeTimeout);
        this.timer = new Timer();
    }

    private ZuoraClient(String baseUrl, Map<String, String> headers) {
        this.clientId = null;
        this.clientSecret = null;
        this.oauthUrl = null;
        this.baseUrl = baseUrl;
        this.timer = null;
        this.apiClient = new ApiClient();
        this.apiClient.setBasePath(this.baseUrl);
        headers.forEach((arg_0, arg_1) -> ((ApiClient)this.apiClient).addDefaultHeader(arg_0, arg_1));
    }

    public void addDefaultHeaders(Map<String, String> defaultHeaders) {
        this.defaultHeaders.putAll(defaultHeaders);
        defaultHeaders.forEach((arg_0, arg_1) -> ((ApiClient)this.apiClient).addDefaultHeader(arg_0, arg_1));
    }

    public void setCacheEnabled(boolean enabled) {
        if (enabled) {
            this.apiClient.addDefaultHeader("zuora-cache-enabled", "true");
            return;
        }
        this.apiClient.addDefaultHeader("zuora-cache-enabled", "false");
    }

    public void setConnectTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.apiClient.setConnectTimeout(this.connectionTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        this.apiClient.setReadTimeout(this.readTimeout);
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
        this.apiClient.setWriteTimeout(this.writeTimeout);
    }

    private String fetchBearerToken() {
        OkHttpClient client = new OkHttpClient();
        FormBody formBody = new FormBody.Builder().add("client_id", this.clientId).add("client_secret", this.clientSecret).add("grant_type", "client_credentials").build();
        Request request = new Request.Builder().url(this.oauthUrl + "/oauth/token").headers(Headers.of(this.defaultHeaders)).post((RequestBody)formBody).build();
        String token = null;
        try {
            Response response = client.newCall(request).execute();
            String body = response.body().string();
            JsonObject json = JsonParser.parseString((String)body).getAsJsonObject();
            token = json.get("access_token").getAsString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return token;
    }

    private void auth() {
        String token = this.fetchBearerToken();
        this.apiClient.addDefaultHeader("Authorization", "Bearer " + token);
        this.apiClient.addDefaultHeader("x-donut-auth", "Bearer " + token);
        this.setBearerToken(token);
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    private void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public void initialize() {
        if (this.reinitTask != null) {
            return;
        }
        this.auth();
        int reinitInterval = 3300000;
        final ZuoraClient zc = this;
        this.reinitTask = new TimerTask(){

            @Override
            public void run() {
                zc.auth();
            }
        };
        this.timer.scheduleAtFixedRate(this.reinitTask, 0L, (long)reinitInterval);
    }

    public AccountsApi accounts() {
        return new AccountsApi(this.apiClient);
    }

    public ContactsApi contact() {
        return new ContactsApi(this.apiClient);
    }

    public ProductsApi products() {
        return new ProductsApi(this.apiClient);
    }

    public PricesApi prices() {
        return new PricesApi(this.apiClient);
    }

    public PlansApi plans() {
        return new PlansApi(this.apiClient);
    }

    public BillingDocumentsApi billingDocuments() {
        return new BillingDocumentsApi(this.apiClient);
    }

    public PaymentMethodsApi paymentMethods() {
        return new PaymentMethodsApi(this.apiClient);
    }

    public SubscriptionsApi subscriptions() {
        return new SubscriptionsApi(this.apiClient);
    }

    public SubscriptionPlansApi subscriptionPlans() {
        return new SubscriptionPlansApi(this.apiClient);
    }

    public PaymentsApi payments() {
        return new PaymentsApi(this.apiClient);
    }

    public WorkflowsApi workflows() {
        return new WorkflowsApi(this.apiClient);
    }

    public static enum ZuoraEnv {
        LOCAL("http://localhost:3000"),
        STG("https://rest-staging2.zuora.com"),
        SBX("https://rest.apisandbox.zuora.com"),
        CSBX("https://rest.test.zuora.com"),
        SBX_NA("https://rest.sandbox.na.zuora.com"),
        PROD("https://rest.zuora.com"),
        PROD_NA("https://rest.na.zuora.com");

        private final String baseUrl;

        private ZuoraEnv(String baseUrl) {
            this.baseUrl = baseUrl;
        }
    }
}

