/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CustomObjectBulkJobErrorResponseCollection;
import com.zuora.model.CustomObjectBulkJobRequest;
import com.zuora.model.CustomObjectBulkJobResponse;
import com.zuora.model.CustomObjectBulkJobResponseCollection;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class CustomObjectJobsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CustomObjectJobsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomObjectJobsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getAllCustomObjectBulkJobsCall(String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, Integer pageSize, String cursor, String status, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/objects/jobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllCustomObjectBulkJobsValidateBeforeCall(String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, Integer pageSize, String cursor, String status, ApiCallback _callback) throws ApiException {
        return this.getAllCustomObjectBulkJobsCall(acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, pageSize, cursor, status, _callback);
    }

    public CustomObjectBulkJobResponseCollection getAllCustomObjectBulkJobs(String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, Integer pageSize, String cursor, String status) throws ApiException {
        ApiResponse<CustomObjectBulkJobResponseCollection> localVarResp = this.getAllCustomObjectBulkJobsWithHttpInfo(acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, pageSize, cursor, status);
        return localVarResp.getData();
    }

    private ApiResponse<CustomObjectBulkJobResponseCollection> getAllCustomObjectBulkJobsWithHttpInfo(String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, Integer pageSize, String cursor, String status) throws ApiException {
        Call localVarCall = this.getAllCustomObjectBulkJobsValidateBeforeCall(acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, pageSize, cursor, status, null);
        Type localVarReturnType = new TypeToken<CustomObjectBulkJobResponseCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAllCustomObjectBulkJobsAsync(String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, Integer pageSize, String cursor, String status, ApiCallback<CustomObjectBulkJobResponseCollection> _callback) throws ApiException {
        Call localVarCall = this.getAllCustomObjectBulkJobsValidateBeforeCall(acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, pageSize, cursor, status, _callback);
        Type localVarReturnType = new TypeToken<CustomObjectBulkJobResponseCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetAllCustomObjectBulkJobsApi getAllCustomObjectBulkJobsApi() {
        return new GetAllCustomObjectBulkJobsApi();
    }

    private Call getCustomObjectBulkJobCall(UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/objects/jobs/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCustomObjectBulkJobValidateBeforeCall(UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getCustomObjectBulkJob(Async)");
        }
        return this.getCustomObjectBulkJobCall(id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
    }

    public CustomObjectBulkJobResponse getCustomObjectBulkJob(UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion) throws ApiException {
        ApiResponse<CustomObjectBulkJobResponse> localVarResp = this.getCustomObjectBulkJobWithHttpInfo(id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CustomObjectBulkJobResponse> getCustomObjectBulkJobWithHttpInfo(UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion) throws ApiException {
        Call localVarCall = this.getCustomObjectBulkJobValidateBeforeCall(id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CustomObjectBulkJobResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getCustomObjectBulkJobAsync(UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback<CustomObjectBulkJobResponse> _callback) throws ApiException {
        Call localVarCall = this.getCustomObjectBulkJobValidateBeforeCall(id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CustomObjectBulkJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCustomObjectBulkJobApi getCustomObjectBulkJobApi(UUID id) {
        return new GetCustomObjectBulkJobApi(id);
    }

    private Call getCustomObjectBulkJobErrorsCall(UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/objects/jobs/{id}/errors".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCustomObjectBulkJobErrorsValidateBeforeCall(UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getCustomObjectBulkJobErrors(Async)");
        }
        return this.getCustomObjectBulkJobErrorsCall(id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
    }

    public CustomObjectBulkJobErrorResponseCollection getCustomObjectBulkJobErrors(UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion) throws ApiException {
        ApiResponse<CustomObjectBulkJobErrorResponseCollection> localVarResp = this.getCustomObjectBulkJobErrorsWithHttpInfo(id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CustomObjectBulkJobErrorResponseCollection> getCustomObjectBulkJobErrorsWithHttpInfo(UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion) throws ApiException {
        Call localVarCall = this.getCustomObjectBulkJobErrorsValidateBeforeCall(id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CustomObjectBulkJobErrorResponseCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getCustomObjectBulkJobErrorsAsync(UUID id, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback<CustomObjectBulkJobErrorResponseCollection> _callback) throws ApiException {
        Call localVarCall = this.getCustomObjectBulkJobErrorsValidateBeforeCall(id, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CustomObjectBulkJobErrorResponseCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCustomObjectBulkJobErrorsApi getCustomObjectBulkJobErrorsApi(UUID id) {
        return new GetCustomObjectBulkJobErrorsApi(id);
    }

    private Call pATCHCustomObjectBulkJobCall(UUID id, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/objects/jobs/{id}/cancel".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call pATCHCustomObjectBulkJobValidateBeforeCall(UUID id, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling pATCHCustomObjectBulkJob(Async)");
        }
        return this.pATCHCustomObjectBulkJobCall(id, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
    }

    public CustomObjectBulkJobResponse pATCHCustomObjectBulkJob(UUID id, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion) throws ApiException {
        ApiResponse<CustomObjectBulkJobResponse> localVarResp = this.pATCHCustomObjectBulkJobWithHttpInfo(id, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CustomObjectBulkJobResponse> pATCHCustomObjectBulkJobWithHttpInfo(UUID id, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion) throws ApiException {
        Call localVarCall = this.pATCHCustomObjectBulkJobValidateBeforeCall(id, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CustomObjectBulkJobResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call pATCHCustomObjectBulkJobAsync(UUID id, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback<CustomObjectBulkJobResponse> _callback) throws ApiException {
        Call localVarCall = this.pATCHCustomObjectBulkJobValidateBeforeCall(id, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CustomObjectBulkJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PATCHCustomObjectBulkJobApi pATCHCustomObjectBulkJobApi(UUID id) {
        return new PATCHCustomObjectBulkJobApi(id);
    }

    private Call postCustomObjectBulkJobCall(CustomObjectBulkJobRequest customObjectBulkJobRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CustomObjectBulkJobRequest localVarPostBody = customObjectBulkJobRequest;
        String localVarPath = "/objects/jobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postCustomObjectBulkJobValidateBeforeCall(CustomObjectBulkJobRequest customObjectBulkJobRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback _callback) throws ApiException {
        if (customObjectBulkJobRequest == null) {
            throw new ApiException("Missing the required parameter 'customObjectBulkJobRequest' when calling postCustomObjectBulkJob(Async)");
        }
        return this.postCustomObjectBulkJobCall(customObjectBulkJobRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
    }

    public CustomObjectBulkJobResponse postCustomObjectBulkJob(CustomObjectBulkJobRequest customObjectBulkJobRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion) throws ApiException {
        ApiResponse<CustomObjectBulkJobResponse> localVarResp = this.postCustomObjectBulkJobWithHttpInfo(customObjectBulkJobRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CustomObjectBulkJobResponse> postCustomObjectBulkJobWithHttpInfo(CustomObjectBulkJobRequest customObjectBulkJobRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion) throws ApiException {
        Call localVarCall = this.postCustomObjectBulkJobValidateBeforeCall(customObjectBulkJobRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CustomObjectBulkJobResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postCustomObjectBulkJobAsync(CustomObjectBulkJobRequest customObjectBulkJobRequest, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback<CustomObjectBulkJobResponse> _callback) throws ApiException {
        Call localVarCall = this.postCustomObjectBulkJobValidateBeforeCall(customObjectBulkJobRequest, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CustomObjectBulkJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostCustomObjectBulkJobApi postCustomObjectBulkJobApi(CustomObjectBulkJobRequest customObjectBulkJobRequest) {
        return new PostCustomObjectBulkJobApi(customObjectBulkJobRequest);
    }

    private Call postUploadFileForCustomObjectBulkJobCall(String contentType, UUID id, String _file, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        String localVarPostBody = _file;
        String localVarPath = "/objects/jobs/{id}/files".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"text/csv"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postUploadFileForCustomObjectBulkJobValidateBeforeCall(String contentType, UUID id, String _file, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback _callback) throws ApiException {
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling postUploadFileForCustomObjectBulkJob(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postUploadFileForCustomObjectBulkJob(Async)");
        }
        if (_file == null) {
            throw new ApiException("Missing the required parameter '_file' when calling postUploadFileForCustomObjectBulkJob(Async)");
        }
        return this.postUploadFileForCustomObjectBulkJobCall(contentType, id, _file, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
    }

    public CustomObjectBulkJobResponse postUploadFileForCustomObjectBulkJob(String contentType, UUID id, String _file, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion) throws ApiException {
        ApiResponse<CustomObjectBulkJobResponse> localVarResp = this.postUploadFileForCustomObjectBulkJobWithHttpInfo(contentType, id, _file, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CustomObjectBulkJobResponse> postUploadFileForCustomObjectBulkJobWithHttpInfo(String contentType, UUID id, String _file, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion) throws ApiException {
        Call localVarCall = this.postUploadFileForCustomObjectBulkJobValidateBeforeCall(contentType, id, _file, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CustomObjectBulkJobResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postUploadFileForCustomObjectBulkJobAsync(String contentType, UUID id, String _file, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraTrackId, String zuoraEntityIds, String authorization, LocalDate zuoraVersion, ApiCallback<CustomObjectBulkJobResponse> _callback) throws ApiException {
        Call localVarCall = this.postUploadFileForCustomObjectBulkJobValidateBeforeCall(contentType, id, _file, idempotencyKey, acceptEncoding, contentEncoding, zuoraTrackId, zuoraEntityIds, authorization, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CustomObjectBulkJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostUploadFileForCustomObjectBulkJobApi postUploadFileForCustomObjectBulkJobApi(String contentType, UUID id, String _file) {
        return new PostUploadFileForCustomObjectBulkJobApi(contentType, id, _file);
    }

    public class PostUploadFileForCustomObjectBulkJobApi {
        private final String contentType;
        private final UUID id;
        private final String _file;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private LocalDate zuoraVersion;

        private PostUploadFileForCustomObjectBulkJobApi(String contentType, UUID id, String _file) {
            this.contentType = contentType;
            this.id = id;
            this._file = _file;
        }

        public PostUploadFileForCustomObjectBulkJobApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostUploadFileForCustomObjectBulkJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostUploadFileForCustomObjectBulkJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostUploadFileForCustomObjectBulkJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostUploadFileForCustomObjectBulkJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostUploadFileForCustomObjectBulkJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostUploadFileForCustomObjectBulkJobApi zuoraVersion(LocalDate zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectJobsApi.this.postUploadFileForCustomObjectBulkJobCall(this.contentType, this.id, this._file, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }

        public CustomObjectBulkJobResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectJobsApi.this.postUploadFileForCustomObjectBulkJobWithHttpInfo(this.contentType, this.id, this._file, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
            return (CustomObjectBulkJobResponse)localVarResp.getData();
        }

        private ApiResponse<CustomObjectBulkJobResponse> executeWithHttpInfo() throws ApiException {
            return CustomObjectJobsApi.this.postUploadFileForCustomObjectBulkJobWithHttpInfo(this.contentType, this.id, this._file, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CustomObjectBulkJobResponse> _callback) throws ApiException {
            return CustomObjectJobsApi.this.postUploadFileForCustomObjectBulkJobAsync(this.contentType, this.id, this._file, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }
    }

    public class PostCustomObjectBulkJobApi {
        private final CustomObjectBulkJobRequest customObjectBulkJobRequest;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private LocalDate zuoraVersion;

        private PostCustomObjectBulkJobApi(CustomObjectBulkJobRequest customObjectBulkJobRequest) {
            this.customObjectBulkJobRequest = customObjectBulkJobRequest;
        }

        public PostCustomObjectBulkJobApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostCustomObjectBulkJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostCustomObjectBulkJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostCustomObjectBulkJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostCustomObjectBulkJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostCustomObjectBulkJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostCustomObjectBulkJobApi zuoraVersion(LocalDate zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectJobsApi.this.postCustomObjectBulkJobCall(this.customObjectBulkJobRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }

        public CustomObjectBulkJobResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectJobsApi.this.postCustomObjectBulkJobWithHttpInfo(this.customObjectBulkJobRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
            return (CustomObjectBulkJobResponse)localVarResp.getData();
        }

        private ApiResponse<CustomObjectBulkJobResponse> executeWithHttpInfo() throws ApiException {
            return CustomObjectJobsApi.this.postCustomObjectBulkJobWithHttpInfo(this.customObjectBulkJobRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CustomObjectBulkJobResponse> _callback) throws ApiException {
            return CustomObjectJobsApi.this.postCustomObjectBulkJobAsync(this.customObjectBulkJobRequest, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }
    }

    public class PATCHCustomObjectBulkJobApi {
        private final UUID id;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private LocalDate zuoraVersion;

        private PATCHCustomObjectBulkJobApi(UUID id) {
            this.id = id;
        }

        public PATCHCustomObjectBulkJobApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PATCHCustomObjectBulkJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PATCHCustomObjectBulkJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PATCHCustomObjectBulkJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PATCHCustomObjectBulkJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PATCHCustomObjectBulkJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PATCHCustomObjectBulkJobApi zuoraVersion(LocalDate zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectJobsApi.this.pATCHCustomObjectBulkJobCall(this.id, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }

        public CustomObjectBulkJobResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectJobsApi.this.pATCHCustomObjectBulkJobWithHttpInfo(this.id, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
            return (CustomObjectBulkJobResponse)localVarResp.getData();
        }

        private ApiResponse<CustomObjectBulkJobResponse> executeWithHttpInfo() throws ApiException {
            return CustomObjectJobsApi.this.pATCHCustomObjectBulkJobWithHttpInfo(this.id, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CustomObjectBulkJobResponse> _callback) throws ApiException {
            return CustomObjectJobsApi.this.pATCHCustomObjectBulkJobAsync(this.id, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }
    }

    public class GetCustomObjectBulkJobErrorsApi {
        private final UUID id;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private LocalDate zuoraVersion;

        private GetCustomObjectBulkJobErrorsApi(UUID id) {
            this.id = id;
        }

        public GetCustomObjectBulkJobErrorsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCustomObjectBulkJobErrorsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCustomObjectBulkJobErrorsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCustomObjectBulkJobErrorsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCustomObjectBulkJobErrorsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCustomObjectBulkJobErrorsApi zuoraVersion(LocalDate zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectJobsApi.this.getCustomObjectBulkJobErrorsCall(this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }

        public CustomObjectBulkJobErrorResponseCollection execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectJobsApi.this.getCustomObjectBulkJobErrorsWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
            return (CustomObjectBulkJobErrorResponseCollection)localVarResp.getData();
        }

        private ApiResponse<CustomObjectBulkJobErrorResponseCollection> executeWithHttpInfo() throws ApiException {
            return CustomObjectJobsApi.this.getCustomObjectBulkJobErrorsWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CustomObjectBulkJobErrorResponseCollection> _callback) throws ApiException {
            return CustomObjectJobsApi.this.getCustomObjectBulkJobErrorsAsync(this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }
    }

    public class GetCustomObjectBulkJobApi {
        private final UUID id;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private LocalDate zuoraVersion;

        private GetCustomObjectBulkJobApi(UUID id) {
            this.id = id;
        }

        public GetCustomObjectBulkJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCustomObjectBulkJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCustomObjectBulkJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCustomObjectBulkJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCustomObjectBulkJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCustomObjectBulkJobApi zuoraVersion(LocalDate zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectJobsApi.this.getCustomObjectBulkJobCall(this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }

        public CustomObjectBulkJobResponse execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectJobsApi.this.getCustomObjectBulkJobWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
            return (CustomObjectBulkJobResponse)localVarResp.getData();
        }

        private ApiResponse<CustomObjectBulkJobResponse> executeWithHttpInfo() throws ApiException {
            return CustomObjectJobsApi.this.getCustomObjectBulkJobWithHttpInfo(this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CustomObjectBulkJobResponse> _callback) throws ApiException {
            return CustomObjectJobsApi.this.getCustomObjectBulkJobAsync(this.id, this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, _callback);
        }
    }

    public class GetAllCustomObjectBulkJobsApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String authorization;
        private LocalDate zuoraVersion;
        private Integer pageSize;
        private String cursor;
        private String status;

        private GetAllCustomObjectBulkJobsApi() {
        }

        public GetAllCustomObjectBulkJobsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetAllCustomObjectBulkJobsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetAllCustomObjectBulkJobsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetAllCustomObjectBulkJobsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetAllCustomObjectBulkJobsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetAllCustomObjectBulkJobsApi zuoraVersion(LocalDate zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetAllCustomObjectBulkJobsApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetAllCustomObjectBulkJobsApi cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetAllCustomObjectBulkJobsApi status(String status) {
            this.status = status;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomObjectJobsApi.this.getAllCustomObjectBulkJobsCall(this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.pageSize, this.cursor, this.status, _callback);
        }

        public CustomObjectBulkJobResponseCollection execute() throws ApiException {
            ApiResponse localVarResp = CustomObjectJobsApi.this.getAllCustomObjectBulkJobsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.pageSize, this.cursor, this.status);
            return (CustomObjectBulkJobResponseCollection)localVarResp.getData();
        }

        private ApiResponse<CustomObjectBulkJobResponseCollection> executeWithHttpInfo() throws ApiException {
            return CustomObjectJobsApi.this.getAllCustomObjectBulkJobsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.pageSize, this.cursor, this.status);
        }

        public Call executeAsync(ApiCallback<CustomObjectBulkJobResponseCollection> _callback) throws ApiException {
            return CustomObjectJobsApi.this.getAllCustomObjectBulkJobsAsync(this.acceptEncoding, this.contentEncoding, this.zuoraTrackId, this.zuoraEntityIds, this.authorization, this.zuoraVersion, this.pageSize, this.cursor, this.status, _callback);
        }
    }
}

