/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.DeleteBatchQueryJobResponse;
import com.zuora.model.GetAggregateQueryJobResponse;
import com.zuora.model.SubmitBatchQueryRequest;
import com.zuora.model.SubmitBatchQueryResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AggregateQueriesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AggregateQueriesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AggregateQueriesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call deleteBatchQueryJobCall(String jobid, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/batch-query/jobs/{jobid}".replace("{jobid}", this.localVarApiClient.escapeString(jobid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteBatchQueryJobValidateBeforeCall(String jobid, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (jobid == null) {
            throw new ApiException("Missing the required parameter 'jobid' when calling deleteBatchQueryJob(Async)");
        }
        return this.deleteBatchQueryJobCall(jobid, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
    }

    public DeleteBatchQueryJobResponse deleteBatchQueryJob(String jobid, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        ApiResponse<DeleteBatchQueryJobResponse> localVarResp = this.deleteBatchQueryJobWithHttpInfo(jobid, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<DeleteBatchQueryJobResponse> deleteBatchQueryJobWithHttpInfo(String jobid, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        Call localVarCall = this.deleteBatchQueryJobValidateBeforeCall(jobid, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<DeleteBatchQueryJobResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteBatchQueryJobAsync(String jobid, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback<DeleteBatchQueryJobResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteBatchQueryJobValidateBeforeCall(jobid, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<DeleteBatchQueryJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteBatchQueryJobApi deleteBatchQueryJobApi(String jobid) {
        return new DeleteBatchQueryJobApi(jobid);
    }

    private Call getBatchQueryJobCall(String jobid, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/batch-query/jobs/{jobid}".replace("{jobid}", this.localVarApiClient.escapeString(jobid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBatchQueryJobValidateBeforeCall(String jobid, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (jobid == null) {
            throw new ApiException("Missing the required parameter 'jobid' when calling getBatchQueryJob(Async)");
        }
        return this.getBatchQueryJobCall(jobid, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
    }

    public GetAggregateQueryJobResponse getBatchQueryJob(String jobid, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        ApiResponse<GetAggregateQueryJobResponse> localVarResp = this.getBatchQueryJobWithHttpInfo(jobid, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetAggregateQueryJobResponse> getBatchQueryJobWithHttpInfo(String jobid, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getBatchQueryJobValidateBeforeCall(jobid, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetAggregateQueryJobResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getBatchQueryJobAsync(String jobid, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback<GetAggregateQueryJobResponse> _callback) throws ApiException {
        Call localVarCall = this.getBatchQueryJobValidateBeforeCall(jobid, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetAggregateQueryJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetBatchQueryJobApi getBatchQueryJobApi(String jobid) {
        return new GetBatchQueryJobApi(jobid);
    }

    private Call getLastBatchQueryJobCall(String partner, String project, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/batch-query/jobs/partner/{partner}/project/{project}".replace("{partner}", this.localVarApiClient.escapeString(partner.toString())).replace("{project}", this.localVarApiClient.escapeString(project.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLastBatchQueryJobValidateBeforeCall(String partner, String project, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (partner == null) {
            throw new ApiException("Missing the required parameter 'partner' when calling getLastBatchQueryJob(Async)");
        }
        if (project == null) {
            throw new ApiException("Missing the required parameter 'project' when calling getLastBatchQueryJob(Async)");
        }
        return this.getLastBatchQueryJobCall(partner, project, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
    }

    public GetAggregateQueryJobResponse getLastBatchQueryJob(String partner, String project, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        ApiResponse<GetAggregateQueryJobResponse> localVarResp = this.getLastBatchQueryJobWithHttpInfo(partner, project, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetAggregateQueryJobResponse> getLastBatchQueryJobWithHttpInfo(String partner, String project, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getLastBatchQueryJobValidateBeforeCall(partner, project, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetAggregateQueryJobResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getLastBatchQueryJobAsync(String partner, String project, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback<GetAggregateQueryJobResponse> _callback) throws ApiException {
        Call localVarCall = this.getLastBatchQueryJobValidateBeforeCall(partner, project, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetAggregateQueryJobResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetLastBatchQueryJobApi getLastBatchQueryJobApi(String partner, String project) {
        return new GetLastBatchQueryJobApi(partner, project);
    }

    private Call postBatchQueryJobCall(SubmitBatchQueryRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SubmitBatchQueryRequest localVarPostBody = body;
        String localVarPath = "/v1/batch-query/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postBatchQueryJobValidateBeforeCall(SubmitBatchQueryRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postBatchQueryJob(Async)");
        }
        return this.postBatchQueryJobCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
    }

    public SubmitBatchQueryResponse postBatchQueryJob(SubmitBatchQueryRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        ApiResponse<SubmitBatchQueryResponse> localVarResp = this.postBatchQueryJobWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<SubmitBatchQueryResponse> postBatchQueryJobWithHttpInfo(SubmitBatchQueryRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion) throws ApiException {
        Call localVarCall = this.postBatchQueryJobValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<SubmitBatchQueryResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call postBatchQueryJobAsync(SubmitBatchQueryRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraEntityIds, String zuoraTrackId, String zuoraVersion, ApiCallback<SubmitBatchQueryResponse> _callback) throws ApiException {
        Call localVarCall = this.postBatchQueryJobValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraEntityIds, zuoraTrackId, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<SubmitBatchQueryResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostBatchQueryJobApi postBatchQueryJobApi(SubmitBatchQueryRequest body) {
        return new PostBatchQueryJobApi(body);
    }

    public class PostBatchQueryJobApi {
        private final SubmitBatchQueryRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;

        private PostBatchQueryJobApi(SubmitBatchQueryRequest body) {
            this.body = body;
        }

        public PostBatchQueryJobApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public PostBatchQueryJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PostBatchQueryJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PostBatchQueryJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PostBatchQueryJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PostBatchQueryJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PostBatchQueryJobApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AggregateQueriesApi.this.postBatchQueryJobCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }

        public SubmitBatchQueryResponse execute() throws ApiException {
            ApiResponse localVarResp = AggregateQueriesApi.this.postBatchQueryJobWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
            return (SubmitBatchQueryResponse)localVarResp.getData();
        }

        private ApiResponse<SubmitBatchQueryResponse> executeWithHttpInfo() throws ApiException {
            return AggregateQueriesApi.this.postBatchQueryJobWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<SubmitBatchQueryResponse> _callback) throws ApiException {
            return AggregateQueriesApi.this.postBatchQueryJobAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }
    }

    public class GetLastBatchQueryJobApi {
        private final String partner;
        private final String project;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;

        private GetLastBatchQueryJobApi(String partner, String project) {
            this.partner = partner;
            this.project = project;
        }

        public GetLastBatchQueryJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetLastBatchQueryJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetLastBatchQueryJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetLastBatchQueryJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetLastBatchQueryJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetLastBatchQueryJobApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AggregateQueriesApi.this.getLastBatchQueryJobCall(this.partner, this.project, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }

        public GetAggregateQueryJobResponse execute() throws ApiException {
            ApiResponse localVarResp = AggregateQueriesApi.this.getLastBatchQueryJobWithHttpInfo(this.partner, this.project, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
            return (GetAggregateQueryJobResponse)localVarResp.getData();
        }

        private ApiResponse<GetAggregateQueryJobResponse> executeWithHttpInfo() throws ApiException {
            return AggregateQueriesApi.this.getLastBatchQueryJobWithHttpInfo(this.partner, this.project, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetAggregateQueryJobResponse> _callback) throws ApiException {
            return AggregateQueriesApi.this.getLastBatchQueryJobAsync(this.partner, this.project, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }
    }

    public class GetBatchQueryJobApi {
        private final String jobid;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;

        private GetBatchQueryJobApi(String jobid) {
            this.jobid = jobid;
        }

        public GetBatchQueryJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetBatchQueryJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetBatchQueryJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetBatchQueryJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetBatchQueryJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetBatchQueryJobApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AggregateQueriesApi.this.getBatchQueryJobCall(this.jobid, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }

        public GetAggregateQueryJobResponse execute() throws ApiException {
            ApiResponse localVarResp = AggregateQueriesApi.this.getBatchQueryJobWithHttpInfo(this.jobid, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
            return (GetAggregateQueryJobResponse)localVarResp.getData();
        }

        private ApiResponse<GetAggregateQueryJobResponse> executeWithHttpInfo() throws ApiException {
            return AggregateQueriesApi.this.getBatchQueryJobWithHttpInfo(this.jobid, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetAggregateQueryJobResponse> _callback) throws ApiException {
            return AggregateQueriesApi.this.getBatchQueryJobAsync(this.jobid, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }
    }

    public class DeleteBatchQueryJobApi {
        private final String jobid;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraEntityIds;
        private String zuoraTrackId;
        private String zuoraVersion;

        private DeleteBatchQueryJobApi(String jobid) {
            this.jobid = jobid;
        }

        public DeleteBatchQueryJobApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteBatchQueryJobApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteBatchQueryJobApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteBatchQueryJobApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteBatchQueryJobApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteBatchQueryJobApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AggregateQueriesApi.this.deleteBatchQueryJobCall(this.jobid, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }

        public DeleteBatchQueryJobResponse execute() throws ApiException {
            ApiResponse localVarResp = AggregateQueriesApi.this.deleteBatchQueryJobWithHttpInfo(this.jobid, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
            return (DeleteBatchQueryJobResponse)localVarResp.getData();
        }

        private ApiResponse<DeleteBatchQueryJobResponse> executeWithHttpInfo() throws ApiException {
            return AggregateQueriesApi.this.deleteBatchQueryJobWithHttpInfo(this.jobid, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<DeleteBatchQueryJobResponse> _callback) throws ApiException {
            return AggregateQueriesApi.this.deleteBatchQueryJobAsync(this.jobid, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraEntityIds, this.zuoraTrackId, this.zuoraVersion, _callback);
        }
    }
}

