/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.EnumMapper;
import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.PriceTier;
import com.zuora.sdk.Tier;
import com.zuora.sdk.internal.DecimalUtil;
import com.zuora.sdk.internal.ProductRatePlanChargesQuery;
import com.zuora.sdk.internal.RatePlansBySubscriptionIdQuery;
import com.zuora.sdk.internal.apis.data.GETProductRatePlanChargePricingTierType;
import com.zuora.sdk.internal.apis.data.GETProductRatePlanChargePricingType;
import com.zuora.sdk.internal.apis.data.GETTierType;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.mapstruct.factory.Mappers;

public class TierMapper {
    void populateStartingUnits(PriceCreateRequest priceCreateRequest) {
        int defPrecision = priceCreateRequest.getPrecision().intValue();
        List tiers = priceCreateRequest.getTiers().stream().sorted(Comparator.comparing(PriceTier::getTier)).collect(Collectors.toList());
        BigDecimal nextStartingUnit = BigDecimal.ZERO;
        for (PriceTier tier : tiers) {
            tier.setStartingUnit(nextStartingUnit.doubleValue());
            nextStartingUnit = DecimalUtil.getNextStartingUnitByPrecision(BigDecimal.valueOf(tier.getUpTo()), defPrecision);
        }
    }

    List<PriceTier> mapPricing(ProductRatePlanChargesQuery.Node productrateplancharge) {
        PriceEnum.ChargeModel chargeModel = ((EnumMapper)Mappers.getMapper(EnumMapper.class)).fromChargeModel(productrateplancharge.getChargeModel());
        if (productrateplancharge.getProductrateplanchargetiers() == null) {
            throw ZuoraSdkException.builder().build();
        }
        if (!PriceEnum.ChargeModel.getTieredModels().contains((Object)chargeModel)) {
            return Collections.emptyList();
        }
        return this.toTiers(this.mapTiers(productrateplancharge.getProductrateplanchargetiers()));
    }

    PriceTier populateTier(PriceTier.PriceTierBuilder tier, Map<Currency, Double> amounts, String priceFormat) {
        return priceFormat.replace(" ", "").equals("PerUnit") ? tier.unitAmounts(amounts).build() : tier.amounts(amounts).build();
    }

    List<Tier> mapRatePlanChargeToTiers(RatePlansBySubscriptionIdQuery.Node1 rateplancharge) {
        PriceEnum.ChargeModel chargeModel = ((EnumMapper)Mappers.getMapper(EnumMapper.class)).fromChargeModel(rateplancharge.getChargeModel());
        if (rateplancharge.getRateplanchargetiers() == null || rateplancharge.getRateplanchargetiers().getEdges() == null) {
            throw ZuoraSdkException.builder().build();
        }
        if (!PriceEnum.ChargeModel.getTieredModels().contains((Object)chargeModel)) {
            return Collections.emptyList();
        }
        List<RatePlansBySubscriptionIdQuery.Edge2> tiers = rateplancharge.getRateplanchargetiers().getEdges();
        this.mapTiers(rateplancharge.getRateplanchargetiers());
        return tiers.stream().map(RatePlansBySubscriptionIdQuery.Edge2::getNode).filter(Objects::nonNull).filter(node2 -> node2.getPriceFormat() != null).sorted(Comparator.comparing(nodeL -> (BigDecimal)nodeL.getTier())).map(zTier -> {
            Tier.TierBuilder tierBuilder = Tier.builder().tier(((BigDecimal)zTier.getTier()).intValue()).startingUnit(zTier.getStartingUnit()).upTo(zTier.getEndingUnit());
            if (zTier.getPriceFormat() == null) {
                return tierBuilder.build();
            }
            if (zTier.getPriceFormat().equals("Flat Fee")) {
                tierBuilder.amount(zTier.getPrice());
            } else {
                tierBuilder.unitAmount(zTier.getPrice());
            }
            return tierBuilder.build();
        }).collect(Collectors.toList());
    }

    Map<Currency, Double> mapProductRatePlanChargeAmountsToPrice(List<ProductRatePlanChargesQuery.Edge1> zTiers, PriceEnum.ChargeModel chargeModel) {
        HashMap<Currency, Double> amounts = new HashMap<Currency, Double>();
        if (zTiers == null) {
            return amounts;
        }
        for (ProductRatePlanChargesQuery.Edge1 zTier : zTiers) {
            ProductRatePlanChargesQuery.Node1 node1 = zTier.getNode();
            if (node1 == null || node1.getActive() == null || !node1.getActive().booleanValue()) continue;
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.OVERAGE) || chargeModel.equals((Object)PriceEnum.ChargeModel.TIERED_WITH_OVERAGE)) {
                if (node1.getOveragePrice() == null) continue;
                amounts.put(Currency.getInstance(node1.getCurrency()), node1.getOveragePrice());
                continue;
            }
            Double amount = node1.getPrice();
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_PERCENTAGE)) {
                amount = node1.getDiscountPercentage();
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_FIXED_AMOUNT)) {
                amount = node1.getDiscountAmount();
            }
            amounts.put(Currency.getInstance(node1.getCurrency()), amount);
        }
        return amounts;
    }

    Double toDiscountAmountsFromRatePlan(List<RatePlansBySubscriptionIdQuery.Edge2> zTiers) {
        if (zTiers == null) {
            return null;
        }
        Optional<RatePlansBySubscriptionIdQuery.Node2> tier = zTiers.stream().map(RatePlansBySubscriptionIdQuery.Edge2::getNode).filter(Objects::nonNull).findFirst();
        return tier.map(RatePlansBySubscriptionIdQuery.Node2::getDiscountAmount).orElse(null);
    }

    Double toDiscountPercentFromRatePlan(List<RatePlansBySubscriptionIdQuery.Edge2> zTiers) {
        if (zTiers == null) {
            return null;
        }
        Optional<RatePlansBySubscriptionIdQuery.Node2> discountTier = zTiers.stream().map(RatePlansBySubscriptionIdQuery.Edge2::getNode).filter(node2 -> node2 != null && node2.getDiscountPercentage() != null && node2.getDiscountPercentage() != 0.0).findFirst();
        return discountTier.map(RatePlansBySubscriptionIdQuery.Node2::getDiscountPercentage).orElse(null);
    }

    Double toOverageAmountsFromRatePlan(List<RatePlansBySubscriptionIdQuery.Edge2> zTiers) {
        if (zTiers == null) {
            return null;
        }
        Optional<RatePlansBySubscriptionIdQuery.Node2> tier = zTiers.stream().map(RatePlansBySubscriptionIdQuery.Edge2::getNode).filter(Objects::nonNull).findFirst();
        return tier.map(RatePlansBySubscriptionIdQuery.Node2::getOveragePrice).orElse(null);
    }

    Double toAmountsFromRatePlan(List<RatePlansBySubscriptionIdQuery.Edge2> zTiers) {
        if (zTiers == null) {
            return null;
        }
        Optional<RatePlansBySubscriptionIdQuery.Node2> tier = zTiers.stream().map(RatePlansBySubscriptionIdQuery.Edge2::getNode).filter(Objects::nonNull).findFirst();
        return tier.map(RatePlansBySubscriptionIdQuery.Node2::getPrice).orElse(null);
    }

    Map<Currency, Double> toAmountsFromTiers(List<GqlTier> zTiers) {
        HashMap<Currency, Double> amounts = new HashMap<Currency, Double>();
        if (zTiers == null) {
            return amounts;
        }
        zTiers.forEach(node2 -> amounts.put(node2.getCurrency(), node2.getPrice()));
        return amounts;
    }

    List<PriceTier> toTiers(List<GqlTier> gqlTiers) {
        HashMap<String, List> tierMap = new HashMap<String, List>();
        ArrayList<PriceTier> tiers = new ArrayList<PriceTier>();
        gqlTiers.forEach(node2 -> {
            if (!tierMap.containsKey(node2.getTierKey())) {
                tierMap.put(node2.getTierKey(), new ArrayList());
            }
            ((List)tierMap.get(node2.getTierKey())).add(node2);
        });
        tierMap.forEach((tierNum, tier) -> {
            Map<Currency, Double> amounts = this.toAmountsFromTiers((List<GqlTier>)tier);
            GqlTier baseTier = (GqlTier)tier.get(0);
            if (baseTier.getPriceFormat() == null) {
                throw ZuoraSdkException.builder().build();
            }
            PriceTier.PriceTierBuilder tierBuilder = PriceTier.builder().tier(Integer.valueOf(tierNum)).startingUnit(baseTier.getStartingUnit()).upTo(baseTier.getEndingUnit());
            tiers.add(this.populateTier(tierBuilder, amounts, baseTier.getPriceFormat()));
        });
        return tiers;
    }

    List<PriceTier> mapPricingToTiers(List<GETProductRatePlanChargePricingType> pricings) {
        ArrayList<GqlTier> gqlTierList = new ArrayList<GqlTier>();
        pricings.forEach(pricing -> {
            Currency currency = Currency.getInstance(pricing.currency());
            gqlTierList.addAll(this.mapTiers(pricing.tiers(), currency));
        });
        return this.toTiers(gqlTierList);
    }

    List<Tier> mapZTiersToTiers(List<GETTierType> tiers) {
        return tiers.stream().map(zTier -> {
            Tier.TierBuilder tierBuilder = Tier.builder().tier(zTier.tier()).startingUnit(zTier.startingUnit()).upTo(zTier.endingUnit());
            if (zTier.priceFormat().equals("PerUnit")) {
                tierBuilder.unitAmount(zTier.price());
            } else {
                tierBuilder.amount(zTier.price());
            }
            return tierBuilder.build();
        }).collect(Collectors.toList());
    }

    List<GqlTier> mapSubscriptionTiers(List<GETTierType> zTiers, Currency currency) {
        if (zTiers == null) {
            return Collections.emptyList();
        }
        return zTiers.stream().map(zTier -> GqlTier.builder().tierKey(String.valueOf(zTier.tier())).price(zTier.price()).startingUnit(zTier.startingUnit()).endingUnit(zTier.endingUnit() == null ? null : zTier.endingUnit()).priceFormat(zTier.priceFormat()).currency(currency).build()).collect(Collectors.toList());
    }

    List<GqlTier> mapTiers(List<GETProductRatePlanChargePricingTierType> zTiers, Currency currency) {
        if (zTiers == null) {
            return Collections.emptyList();
        }
        return zTiers.stream().map(zTier -> GqlTier.builder().tierKey(String.valueOf(zTier.tier())).price(Double.valueOf(zTier.price())).startingUnit(Double.valueOf(zTier.startingUnit())).endingUnit(zTier.endingUnit() == null ? null : Double.valueOf(zTier.endingUnit())).priceFormat(zTier.priceFormat()).currency(currency).build()).collect(Collectors.toList());
    }

    List<GqlTier> mapTiers(RatePlansBySubscriptionIdQuery.Rateplanchargetiers zTiers) {
        if (zTiers.getEdges() == null) {
            return Collections.emptyList();
        }
        return zTiers.getEdges().stream().map(RatePlansBySubscriptionIdQuery.Edge2::getNode).filter(node1 -> node1 != null && node1.getPriceFormat() != null).map(node2 -> GqlTier.builder().tierKey(String.valueOf(node2.getTier())).price(node2.getPrice()).discountAmount(node2.getDiscountAmount()).discountPercentage(node2.getDiscountPercentage()).startingUnit(node2.getStartingUnit()).endingUnit(node2.getEndingUnit()).priceFormat(node2.getPriceFormat()).currency(Currency.getInstance(node2.getCurrency())).build()).collect(Collectors.toList());
    }

    List<GqlTier> mapTiers(ProductRatePlanChargesQuery.Productrateplanchargetiers zTiers) {
        if (zTiers.getEdges() == null) {
            return Collections.emptyList();
        }
        return zTiers.getEdges().stream().map(ProductRatePlanChargesQuery.Edge1::getNode).filter(node1 -> node1 != null && node1.getPriceFormat() != null && node1.getActive() != null && node1.getActive() != false).map(node2 -> GqlTier.builder().tierKey(String.valueOf(node2.getTier())).price(node2.getPrice()).discountAmount(node2.getDiscountAmount()).discountPercentage(node2.getDiscountPercentage()).priceFormat(node2.getPriceFormat()).startingUnit(node2.getStartingUnit()).endingUnit(node2.getEndingUnit()).currency(Currency.getInstance(node2.getCurrency())).overageAmount(node2.getOveragePrice()).build()).collect(Collectors.toList());
    }

    private static class GqlTier {
        private final String tierKey;
        private final Double startingUnit;
        private final Double endingUnit;
        private final String priceFormat;
        private final Double price;
        private final Double discountAmount;
        private final Double discountPercentage;
        private final Double overageAmount;
        private final Currency currency;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        GqlTier(String tierKey, Double startingUnit, Double endingUnit, String priceFormat, Double price, Double discountAmount, Double discountPercentage, Double overageAmount, Currency currency) {
            this.tierKey = tierKey;
            this.startingUnit = startingUnit;
            this.endingUnit = endingUnit;
            this.priceFormat = priceFormat;
            this.price = price;
            this.discountAmount = discountAmount;
            this.discountPercentage = discountPercentage;
            this.overageAmount = overageAmount;
            this.currency = currency;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected static GqlTierBuilder builder() {
            return new GqlTierBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getTierKey() {
            return this.tierKey;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Double getStartingUnit() {
            return this.startingUnit;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Double getEndingUnit() {
            return this.endingUnit;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getPriceFormat() {
            return this.priceFormat;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Double getPrice() {
            return this.price;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Double getDiscountAmount() {
            return this.discountAmount;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Double getDiscountPercentage() {
            return this.discountPercentage;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Double getOverageAmount() {
            return this.overageAmount;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Currency getCurrency() {
            return this.currency;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected static class GqlTierBuilder {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private String tierKey;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private Double startingUnit;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private Double endingUnit;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private String priceFormat;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private Double price;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private Double discountAmount;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private Double discountPercentage;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private Double overageAmount;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private Currency currency;

            @SuppressFBWarnings(justification="generated code")
            @Generated
            GqlTierBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public GqlTierBuilder tierKey(String tierKey) {
                this.tierKey = tierKey;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public GqlTierBuilder startingUnit(Double startingUnit) {
                this.startingUnit = startingUnit;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public GqlTierBuilder endingUnit(Double endingUnit) {
                this.endingUnit = endingUnit;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public GqlTierBuilder priceFormat(String priceFormat) {
                this.priceFormat = priceFormat;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public GqlTierBuilder price(Double price) {
                this.price = price;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public GqlTierBuilder discountAmount(Double discountAmount) {
                this.discountAmount = discountAmount;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public GqlTierBuilder discountPercentage(Double discountPercentage) {
                this.discountPercentage = discountPercentage;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public GqlTierBuilder overageAmount(Double overageAmount) {
                this.overageAmount = overageAmount;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public GqlTierBuilder currency(Currency currency) {
                this.currency = currency;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public GqlTier build() {
                return new GqlTier(this.tierKey, this.startingUnit, this.endingUnit, this.priceFormat, this.price, this.discountAmount, this.discountPercentage, this.overageAmount, this.currency);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "TierMapper.GqlTier.GqlTierBuilder(tierKey=" + this.tierKey + ", startingUnit=" + this.startingUnit + ", endingUnit=" + this.endingUnit + ", priceFormat=" + this.priceFormat + ", price=" + this.price + ", discountAmount=" + this.discountAmount + ", discountPercentage=" + this.discountPercentage + ", overageAmount=" + this.overageAmount + ", currency=" + this.currency + ")";
            }
        }
    }
}

