/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.Payment;
import com.zuora.sdk.PaymentCreateRequest;
import com.zuora.sdk.PaymentMethod;
import com.zuora.sdk.RefundCreateRequest;
import com.zuora.sdk.TransactionMapper;
import com.zuora.sdk.internal.models.ZPayment;
import com.zuora.sdk.internal.models.ZRefund;
import com.zuora.sdk.internal.models.enums.RefundType;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

class TransactionMapperImpl
extends TransactionMapper {
    TransactionMapperImpl() {
    }

    @Override
    ZRefund.Builder toApi(RefundCreateRequest refundCreateRequest) {
        if (refundCreateRequest == null) {
            return null;
        }
        ZRefund.Builder builder = new ZRefund.Builder();
        builder.accountId(refundCreateRequest.getAccount());
        builder.softDescriptor(refundCreateRequest.getStatementDescriptor());
        builder.referenceId(refundCreateRequest.getReference());
        if (refundCreateRequest.getDate() != null) {
            builder.refundDate(DateTimeFormatter.ISO_LOCAL_DATE.format(refundCreateRequest.getDate()));
        }
        builder.comment(refundCreateRequest.getDescription());
        builder.reasonCode(refundCreateRequest.getReason());
        builder.paymentId(refundCreateRequest.getPaymentId());
        Map<String, Object> map = refundCreateRequest.getCustomFields();
        if (map != null) {
            builder.refundObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.amount(refundCreateRequest.getAmount());
        builder.type(Boolean.TRUE.equals(refundCreateRequest.getExternal()) ? RefundType.EXTERNAL : RefundType.ELECTRONIC);
        builder.methodType(refundCreateRequest.getType().getApiType());
        return builder;
    }

    @Override
    ZPayment.Builder toApi(PaymentCreateRequest paymentCreateRequest) {
        if (paymentCreateRequest == null) {
            return null;
        }
        ZPayment.Builder builder = new ZPayment.Builder();
        builder.accountId(paymentCreateRequest.getAccount());
        builder.authTransactionId(paymentCreateRequest.getAuthorisationCode());
        builder.comment(paymentCreateRequest.getDescription());
        if (paymentCreateRequest.getDate() != null) {
            builder.effectiveDate(DateTimeFormatter.ISO_LOCAL_DATE.format(paymentCreateRequest.getDate()));
        }
        builder.gatewayId(paymentCreateRequest.getGateway());
        builder.referenceId(paymentCreateRequest.getReference());
        builder.softDescriptor(paymentCreateRequest.getStatementDescriptor());
        builder.paymentMethodId(paymentCreateRequest.getPaymentMethod());
        Map<String, Object> map = paymentCreateRequest.getCustomFields();
        if (map != null) {
            builder.paymentObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.currency(paymentCreateRequest.getCurrency());
        builder.softDescriptorPhone(paymentCreateRequest.getSoftDescriptorPhone());
        builder.amount(paymentCreateRequest.getAmount());
        Map<String, String> map1 = paymentCreateRequest.getGatewayOptions();
        if (map1 != null) {
            builder.gatewayOptions(new HashMap<String, String>(map1));
        }
        builder.gatewayOrderId(paymentCreateRequest.getGatewayOrderId());
        return builder;
    }

    @Override
    ZPayment.Builder toApi(Payment payment) {
        if (payment == null) {
            return null;
        }
        ZPayment.Builder builder = new ZPayment.Builder();
        builder.id(payment.getId());
        builder.accountId(payment.getAccount());
        builder.authTransactionId(payment.getAuthorisationCode());
        builder.comment(payment.getDescription());
        if (payment.getDate() != null) {
            builder.effectiveDate(DateTimeFormatter.ISO_LOCAL_DATE.format(payment.getDate()));
        }
        builder.gatewayId(payment.getGateway());
        builder.referenceId(payment.getReference());
        builder.softDescriptor(payment.getStatementDescriptor());
        builder.paymentMethodId(this.paymentPaymentMethodId(payment));
        Map<String, Object> map = payment.getCustomFields();
        if (map != null) {
            builder.paymentObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.currency(payment.getCurrency());
        builder.softDescriptorPhone(payment.getSoftDescriptorPhone());
        builder.amount(payment.getAmount());
        Map<String, String> map1 = payment.getGatewayOptions();
        if (map1 != null) {
            builder.gatewayOptions(new HashMap<String, String>(map1));
        }
        builder.gatewayOrderId(payment.getGatewayOrderId());
        return builder;
    }

    private String paymentPaymentMethodId(Payment payment) {
        if (payment == null) {
            return null;
        }
        PaymentMethod paymentMethod = payment.getPaymentMethod();
        if (paymentMethod == null) {
            return null;
        }
        String id = paymentMethod.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

