/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.zuora.sdk.ApiMapper;
import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.Plan;
import com.zuora.sdk.PlanCreateRequest;
import com.zuora.sdk.PlanMapper;
import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceMapper;
import com.zuora.sdk.Product;
import com.zuora.sdk.ProductCreateRequest;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.ApolloClientUtil;
import com.zuora.sdk.internal.HawkClient;
import com.zuora.sdk.internal.ProductBySkuQuery;
import com.zuora.sdk.internal.ProductsQuery;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import com.zuora.sdk.internal.models.ZProduct;
import com.zuora.sdk.internal.models.ZProductRatePlan;
import com.zuora.sdk.internal.type.ProductFilterInput;
import com.zuora.sdk.internal.type.ProductFilterKey;
import com.zuora.sdk.utils.Filter;
import com.zuora.sdk.utils.OQProductFilterVisitor;
import com.zuora.sdk.utils.PaginatedStreamHelper;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.OkHttpClient;
import org.mapstruct.factory.Mappers;

public class ProductAPI {
    private static final Integer BATCH_SIZE = 10;
    private final HawkClient hawkClient;
    private final ApolloClient gqlClient;
    private final ZuoraClient client;
    private APIContext context;
    private OkHttpClient okHttpClient = new OkHttpClient();
    private PlanMapper planMapper = (PlanMapper)Mappers.getMapper(PlanMapper.class);
    private PriceMapper priceMapper = (PriceMapper)Mappers.getMapper(PriceMapper.class);

    ProductAPI(ZuoraClient client) {
        this.client = client;
        this.context = client.getContext();
        this.hawkClient = client.getHawkClient();
        this.gqlClient = this.hawkClient.getGqlClient();
    }

    /*
     * WARNING - void declaration
     */
    public Product create(ProductCreateRequest productCreateRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        ProductCreateRequest productCreateRequest2 = productCreateRequest;
        try {
            void zProduct;
            void product;
            ZProduct zProduct2 = ApiMapper.Mapper.toApi(productCreateRequest2).build();
            String string = zProduct2.create(product.context);
            product.client.customObjects().saveAssociations((BaseFacade)zProduct, string);
            zProduct.getPlans().forEach(productPlan -> {
                productPlan.setProduct(string);
                Plan plan = this.client.plans().create((PlanCreateRequest)productPlan);
                this.client.customObjects().saveAssociations((BaseFacade)productPlan, plan.getId());
                productPlan.getPrices().forEach(planItem -> {
                    planItem.setPlan(plan.getId());
                    this.client.prices().create((PriceCreateRequest)planItem);
                });
            });
            object = product.get(string);
            return object;
        }
        finally {
            productCreateRequest2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void delete(Product product) throws ZuoraSdkException {
        Meter meter;
        String string;
        long l = System.currentTimeMillis();
        ProductAPI productAPI = this;
        Product product2 = product;
        try {
            void product3;
            ZProduct.delete((APIContext)product3.context, (String)product2.getId());
            productAPI = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        product2 = SharedMetricRegistries.getOrCreate((String)"zuora");
        String string2 = "com.zuora.sdk.ProductAPI".substring("com.zuora.sdk.ProductAPI".lastIndexOf(".") + 1);
        if (null != productAPI) {
            string = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{productAPI.getClass().getSimpleName(), string2, "delete"});
            meter = product2.meter(string);
            meter.mark();
        } else {
            string = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string2, "delete"});
            meter = product2.meter(string);
            meter.mark();
        }
        string = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string2, "delete"});
        meter = product2.histogram(string);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (productAPI != null) {
            throw productAPI;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Product update(Product product) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Product product2 = product;
        try {
            void product3;
            ApiMapper.Mapper.toApi(product2).build().update(product3.context);
            object = product3.get(product2.getId());
            return object;
        }
        finally {
            product2 = null;
        }
    }

    public Product get(String productId) throws ZuoraSdkException {
        try {
            CompletableFuture response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new ProductBySkuQuery(ProductFilterKey.ID, productId)));
            if (response.get().getData() == null || ((ProductBySkuQuery.Data)response.get().getData()).getProducts().getEdges().isEmpty()) {
                return null;
            }
            Product product = this.mapNestedProduct(((ProductBySkuQuery.Data)response.get().getData()).getProducts().getEdges().get(0).getNode());
            ZProduct zProduct = ZProduct.get((APIContext)this.context, (String)productId);
            product = product.toBuilder().customFields(zProduct.productObjectCustomFields()).build();
            return product;
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).message(e.getMessage()).build();
        }
    }

    public Stream<Product> stream() throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        try {
            object = ((ProductAPI)object).stream(null);
            return object;
        }
        finally {
            Object object2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Stream<Product> stream(Filter filter) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Filter filter2 = filter;
        try {
            void filter3;
            object = new PaginatedStreamHelper().run(cursor -> {
                ProductFilterInput filterInput = null;
                if (filter2 != null) {
                    OQProductFilterVisitor visitor = new OQProductFilterVisitor();
                    filter2.accept(visitor);
                    filterInput = visitor.toInput();
                }
                ProductsQuery query = new ProductsQuery((Input<String>)Input.optional((Object)cursor), (Input<ProductFilterInput>)Input.optional(filterInput));
                CompletableFuture response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)query));
                ProductsQuery.Products data = ((ProductsQuery.Data)response.join().getData()).getProducts();
                List products2 = data.getEdges().stream().map(edge -> this.mapNestedProduct(edge.getNode())).collect(Collectors.toList());
                return new PaginatedStreamHelper.Page(products2, data.getPageInfo().getEndCursor());
            });
            return object;
        }
        finally {
            filter2 = null;
        }
    }

    private Product mapNestedProduct(ProductsQuery.Node productResp) {
        LocalDate now = LocalDate.now(this.context.getEntityProfileInfo().tenantZoneId());
        LocalDate startDate = LocalDate.parse(productResp.getEffectiveStartDate());
        LocalDate endDate = LocalDate.parse(productResp.getEffectiveEndDate());
        ZonedDateTime createTime = ZonedDateTime.parse(productResp.getCreatedDate());
        ZonedDateTime updateTime = ZonedDateTime.parse(productResp.getUpdatedDate());
        boolean active = !(!now.isEqual(startDate) && !now.isAfter(startDate) || !now.isEqual(endDate) && !now.isBefore(endDate));
        Product product = Product.builder().id(productResp.getId()).name(productResp.getName()).sku(productResp.getSKU()).startDate(startDate).endDate(endDate).description(productResp.getDescription()).createdBy(productResp.getCreatedById()).createTime(createTime).updatedBy(productResp.getUpdatedById()).updateTime(updateTime).active(active).build();
        if (productResp.getProductrateplans() != null) {
            product.toBuilder().plans(productResp.getProductrateplans().getEdges().stream().map(ratePlan -> {
                LocalDate planStartDate = LocalDate.parse(ratePlan.getNode().getEffectiveStartDate());
                LocalDate planEndDate = LocalDate.parse(ratePlan.getNode().getEffectiveEndDate());
                boolean planActive = now.isEqual(planStartDate) || now.isAfter(planStartDate) && (now.isEqual(planEndDate) || now.isBefore(planEndDate));
                String planId = ratePlan.getNode().getId();
                Plan plan = Plan.builder().id(planId).name(ratePlan.getNode().getName()).startDate(LocalDate.parse(ratePlan.getNode().getEffectiveStartDate())).endDate(LocalDate.parse(ratePlan.getNode().getEffectiveEndDate())).product(product.getId()).createdBy(ratePlan.getNode().getCreatedById()).createTime(ZonedDateTime.parse(ratePlan.getNode().getCreatedDate())).updatedBy(ratePlan.getNode().getUpdatedById()).updateTime(ZonedDateTime.parse(ratePlan.getNode().getUpdatedDate())).description(ratePlan.getNode().getDescription()).active(planActive).build();
                ZProductRatePlan productRatePlan = ZProductRatePlan.get((APIContext)this.context, (String)planId);
                plan = plan.toBuilder().activeCurrencies(productRatePlan.activeCurrencies()).customFields(productRatePlan.productRatePlanObjectCustomFields()).build();
                product.addPlan(plan);
                return plan;
            }).collect(Collectors.toList()));
        }
        return product;
    }

    private Product mapNestedProduct(ProductBySkuQuery.Node productResp) {
        LocalDate now = LocalDate.now(this.context.getEntityProfileInfo().tenantZoneId());
        LocalDate startDate = LocalDate.parse(productResp.getEffectiveStartDate());
        LocalDate endDate = LocalDate.parse(productResp.getEffectiveEndDate());
        ZonedDateTime createTime = ZonedDateTime.parse(productResp.getCreatedDate());
        ZonedDateTime updateTime = ZonedDateTime.parse(productResp.getUpdatedDate());
        boolean active = !(!now.isEqual(startDate) && !now.isAfter(startDate) || !now.isEqual(endDate) && !now.isBefore(endDate));
        Product product = Product.builder().id(productResp.getId()).name(productResp.getName()).sku(productResp.getSKU()).startDate(startDate).endDate(endDate).description(productResp.getDescription()).createdBy(productResp.getCreatedById()).createTime(createTime).updatedBy(productResp.getUpdatedById()).updateTime(updateTime).active(active).build();
        if (productResp.getProductrateplans() != null) {
            product.toBuilder().plans(productResp.getProductrateplans().getEdges().stream().map(ratePlan -> {
                Plan plan = this.client.plans().get(ratePlan.getNode().getId());
                product.addPlan(plan);
                return plan;
            }).collect(Collectors.toList()));
        }
        return product;
    }

    /*
     * WARNING - void declaration
     */
    public Product findBySku(String string) throws ZuoraSdkException {
        Meter meter;
        String string2;
        Product product;
        Object object;
        long l = System.currentTimeMillis();
        ProductAPI productAPI = this;
        String string3 = string;
        try {
            try {
                void sku;
                object = ApolloClientUtil.toCompletableFuture(sku.gqlClient.query((Query)new ProductBySkuQuery(ProductFilterKey.SKU, string3)));
                product = ((Response)((CompletableFuture)object).get()).getData() == null || ((ProductBySkuQuery.Data)((Response)((CompletableFuture)object).get()).getData()).getProducts().getEdges().isEmpty() ? null : super.mapNestedProduct(((ProductBySkuQuery.Data)((Response)((CompletableFuture)object).get()).getData()).getProducts().getEdges().get(0).getNode());
            }
            catch (Exception exception) {
                throw ZuoraSdkException.builder().cause(exception.getCause()).message(exception.toString()).build();
            }
        }
        catch (Throwable throwable) {
            productAPI = null;
        }
        productAPI = product;
        string3 = null;
        object = SharedMetricRegistries.getOrCreate((String)"zuora");
        String string4 = "com.zuora.sdk.ProductAPI".substring("com.zuora.sdk.ProductAPI".lastIndexOf(".") + 1);
        if (null != string3) {
            string2 = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{string3.getClass().getSimpleName(), string4, "findBySku"});
            meter = object.meter(string2);
            meter.mark();
        } else {
            string2 = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string4, "findBySku"});
            meter = object.meter(string2);
            meter.mark();
        }
        string2 = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string4, "findBySku"});
        meter = object.histogram(string2);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (string3 != null) {
            throw string3;
        }
        return productAPI;
    }

    public List<Plan> getPlans(Product product) throws ZuoraSdkException {
        Product aProduct = this.findBySku(product.getSku());
        return aProduct.getPlans();
    }
}

