/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.utils;

import com.zuora.sdk.utils.Condition;
import com.zuora.sdk.utils.ConditionOperator;
import com.zuora.sdk.utils.Conjunction;
import com.zuora.sdk.utils.ConjunctionOperator;
import com.zuora.sdk.utils.FilterVisitor;

public abstract class Filter {
    public abstract void accept(FilterVisitor var1);

    public static Filter and(Filter ... conditions) {
        return new Conjunction(ConjunctionOperator.AND, conditions);
    }

    public static Filter or(Filter ... conditions) {
        return new Conjunction(ConjunctionOperator.OR, conditions);
    }

    public static Filter lt(String field, String value) {
        return new Condition(field, value, ConditionOperator.LT);
    }

    public static Filter le(String field, String value) {
        return new Condition(field, value, ConditionOperator.LE);
    }

    public static Filter eq(String field, String value) {
        return new Condition(field, value, ConditionOperator.EQ);
    }

    public static Filter ge(String field, String value) {
        return new Condition(field, value, ConditionOperator.GE);
    }

    public static Filter gt(String field, String value) {
        return new Condition(field, value, ConditionOperator.GT);
    }

    public static Filter sw(String field, String value) {
        return new Condition(field, value, ConditionOperator.SW);
    }

    public static Filter ne(String field, String value) {
        return new Condition(field, value, ConditionOperator.NE);
    }
}

