/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.enums;

import com.google.common.base.Strings;
import com.zuora.sdk.internal.exceptions.InvalidRequestException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

public enum PaymentMethodState {
    ACTIVE("Active"),
    CLOSED("Closed"),
    SCRUBBED("Scrubbed");

    private final String apiValue;

    public static PaymentMethodState fromApi(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        for (PaymentMethodState v : PaymentMethodState.values()) {
            if (!v.getApiValue().equals(value)) continue;
            return v;
        }
        throw InvalidRequestException.builder().addViolation(InvalidRequestException.Reason.InvalidValue, "PaymentMethodState", "invalid value " + value).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private PaymentMethodState(String apiValue) {
        this.apiValue = apiValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getApiValue() {
        return this.apiValue;
    }
}

