/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.zuora.sdk.Account;
import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.Plan;
import com.zuora.sdk.StartOn;
import com.zuora.sdk.Subscription;
import com.zuora.sdk.SubscriptionAPIHelper;
import com.zuora.sdk.SubscriptionCreateRequest;
import com.zuora.sdk.SubscriptionPlan;
import com.zuora.sdk.SubscriptionPlanItem;
import com.zuora.sdk.SubscriptionPlanItemMapper;
import com.zuora.sdk.SubscriptionUpdateAction;
import com.zuora.sdk.SubscriptionUpdateRequest;
import com.zuora.sdk.Term;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.ApolloClientUtil;
import com.zuora.sdk.internal.HawkClient;
import com.zuora.sdk.internal.RatePlansBySubscriptionIdQuery;
import com.zuora.sdk.internal.Tools;
import com.zuora.sdk.internal.apis.SubscriptionsAPI;
import com.zuora.sdk.internal.apis.data.CreateOrderCreateSubscription;
import com.zuora.sdk.internal.apis.data.CreateOrderCreateSubscriptionTerms;
import com.zuora.sdk.internal.apis.data.CreateOrderCreateSubscriptionTermsInitialTerm;
import com.zuora.sdk.internal.apis.data.CreateOrderOrderAction;
import com.zuora.sdk.internal.apis.data.CreateOrderRatePlanOverride;
import com.zuora.sdk.internal.apis.data.GETSubscriptionTypeWithSuccess;
import com.zuora.sdk.internal.apis.data.OrderCreateRequestSubscriptions;
import com.zuora.sdk.internal.apis.data.PostOrderResponseType;
import com.zuora.sdk.internal.apis.data.PostOrderResponseTypeSubscriptions;
import com.zuora.sdk.internal.apis.data.RenewalTerm;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import com.zuora.sdk.internal.models.ZOrder;
import com.zuora.sdk.internal.models.enums.TermPeriodType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.mapstruct.factory.Mappers;

public class SubscriptionAPI {
    private static final Pattern uuidPattern = Pattern.compile("^\\w{8}-?\\w{4}-?\\w{4}-?\\w{4}-?\\w{12}$");
    private final APIContext context;
    private final ApolloClient gqlClient;
    private final HawkClient hawkClient;
    private final ZuoraClient client;
    private final LocalDate tenantToday;
    private final SubscriptionPlanItemMapper subscriptionPlanItemMapper = (SubscriptionPlanItemMapper)Mappers.getMapper(SubscriptionPlanItemMapper.class);
    private final ZoneId timeZone;

    SubscriptionAPI(ZuoraClient client) {
        this.client = client;
        this.context = client.getContext();
        this.timeZone = this.context.getEntityProfileInfo().tenantZoneId();
        this.hawkClient = client.getHawkClient();
        this.gqlClient = this.hawkClient.getGqlClient();
        this.tenantToday = client.today();
    }

    /*
     * WARNING - void declaration
     */
    public Subscription create(SubscriptionCreateRequest subscriptionCreateRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        SubscriptionCreateRequest subscriptionCreateRequest2 = subscriptionCreateRequest;
        try {
            void subRequest;
            void orderRatePlans;
            List currency;
            CreateOrderCreateSubscription createOrderCreateSubscription;
            Object object2;
            void terms;
            void initialTerm;
            Term term = subscriptionCreateRequest2.getInitialTerm();
            Object object3 = new CreateOrderCreateSubscriptionTerms();
            object3.autoRenew(Boolean.valueOf(initialTerm.isAutoRenew()));
            if (terms != null) {
                object3.initialTerm(new CreateOrderCreateSubscriptionTermsInitialTerm().startDate(initialTerm.getTermStartDate().toString()).period(terms.getIntervalCount()).periodType(terms.getInterval()).termType(terms.getType().name()));
                if (initialTerm.getRenewalTerm() != null) {
                    void renewalTerm;
                    object2 = initialTerm.getRenewalTerm();
                    if (((Term)object2).getType() == Term.TermType.EVERGREEN) {
                        renewalTerm.renewalSetting("RENEW_TO_EVERGREEN");
                    } else {
                        renewalTerm.renewalSetting("RENEW_WITH_SPECIFIC_TERM");
                        renewalTerm.renewalTerms(Collections.singletonList(new RenewalTerm().period(((Term)object2).getIntervalCount()).periodType(((Term)object2).getInterval())));
                    }
                }
            }
            object2 = new ArrayList();
            Currency currency2 = Currency.getInstance(initialTerm.getAccount().getCurrency());
            if (initialTerm.getPlans() != null) {
                void plans;
                createOrderCreateSubscription = initialTerm.getPlans();
                currency = createOrderCreateSubscription.stream().map(arg_0 -> SubscriptionAPI.lambda$create$0((Currency)plans, arg_0)).collect(Collectors.toList());
            }
            createOrderCreateSubscription = new CreateOrderCreateSubscription().terms((CreateOrderCreateSubscriptionTerms)orderRatePlans).notes(initialTerm.description).subscribeToRatePlans(currency);
            List<OrderCreateRequestSubscriptions> list = Collections.singletonList(new OrderCreateRequestSubscriptions().customFields(initialTerm.getCustomFields()).orderActions(Collections.singletonList(SubscriptionAPIHelper.getCreateSubscriptionOrderAction(createOrderCreateSubscription, initialTerm.getStartOn()))));
            ZOrder.Builder builder = (ZOrder.Builder)((ZOrder.Builder)((ZOrder.Builder)((ZOrder.Builder)new ZOrder.Builder().existingAccountNumber(initialTerm.getAccount().getAccountKey())).orderDate(subRequest.tenantToday.toString())).subscriptions(list)).processingOptions(SubscriptionAPIHelper.getProcessingOptions(initialTerm.getProcessingOption()));
            ZOrder zOrder = builder.build();
            PostOrderResponseType postOrderResponseType = zOrder.createInternally(subRequest.context);
            String string = ((PostOrderResponseTypeSubscriptions)postOrderResponseType.subscriptions().get(0)).subscriptionId();
            subRequest.client.customObjects().saveAssociations((BaseFacade)initialTerm, string);
            object = subRequest.get(string);
            return object;
        }
        finally {
            subscriptionCreateRequest2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Subscription update(Subscription subscription2, SubscriptionUpdateRequest subscriptionUpdateRequest) {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        SubscriptionUpdateRequest subscriptionUpdateRequest2 = subscriptionUpdateRequest;
        try {
            void effectiveDate;
            void subscription4;
            void currency;
            void subscriptionUpdateRequest3;
            Currency currency2 = Currency.getInstance(subscriptionUpdateRequest3.getInvoiceAccount().getCurrency());
            List list = currency.getSubscriptionUpdateActions().stream().map(action -> this.getOrderAction((SubscriptionUpdateAction)action, currency2)).collect(Collectors.toList());
            OrderCreateRequestSubscriptions orderCreateRequestSubscriptions = new OrderCreateRequestSubscriptions().subscriptionNumber(subscriptionUpdateRequest3.getKey()).orderActions(list);
            LocalDate localDate = currency.getEffectiveDate() != null ? currency.getEffectiveDate() : subscription4.tenantToday;
            ZOrder zOrder = ((ZOrder.Builder)((ZOrder.Builder)((ZOrder.Builder)((ZOrder.Builder)new ZOrder.Builder().existingAccountNumber(subscriptionUpdateRequest3.getAccount().getAccountKey())).subscriptions(Collections.singletonList(effectiveDate))).orderDate(localDate.toString())).processingOptions(SubscriptionAPIHelper.getProcessingOptions(currency.getProcessingOptions()))).build();
            PostOrderResponseType postOrderResponseType = zOrder.createInternally(subscription4.context);
            String string = ((PostOrderResponseTypeSubscriptions)postOrderResponseType.subscriptions().get(0)).subscriptionId();
            object = subscription4.get(string);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    private CreateOrderOrderAction getOrderAction(SubscriptionUpdateAction subscriptionUpdateAction, Currency currency) {
        OrderType actionType = subscriptionUpdateAction.getActionType();
        StartOn startOn = subscriptionUpdateAction.getStartOn();
        switch (actionType) {
            case RENEW_SUBSCRIPTION: {
                return SubscriptionAPIHelper.getRenewOrderAction(startOn);
            }
            case ADD_PRODUCT: {
                return SubscriptionAPIHelper.getAddProductOrderAction(subscriptionUpdateAction.getPlan(), currency, startOn);
            }
            case REMOVE_PRODUCT: {
                return SubscriptionAPIHelper.getRemoveProductOrderAction(startOn, subscriptionUpdateAction.getSubscriptionPlanId());
            }
            case UPDATE_PRODUCT: {
                return SubscriptionAPIHelper.getUpdateProductOrderAction(subscriptionUpdateAction.getSubscriptionPlanId(), subscriptionUpdateAction.getSubscriptionPlanItems(), currency, startOn);
            }
            case OWNER_TRANSFER: {
                return SubscriptionAPIHelper.getOwnerTransferOrderAction(subscriptionUpdateAction.getSubscriptionOwner(), subscriptionUpdateAction.getInvoiceOwner(), startOn);
            }
            case TERMS_AND_CONDITIONS: {
                return SubscriptionAPIHelper.getTermsAndConditionsOrderAction(startOn, subscriptionUpdateAction.getCurrentTerm(), subscriptionUpdateAction.getRenewalTerm(), subscriptionUpdateAction.isAutoRenew());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Subscription addPlan(Subscription subscription2, Plan plan, StartOn startOn) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        Plan plan2 = plan;
        StartOn startOn2 = startOn;
        try {
            void subscription4;
            void currency;
            void startOn3;
            void plan3;
            Currency currency2 = Currency.getInstance(plan3.getAccount().getCurrency());
            CreateOrderOrderAction createOrderOrderAction = SubscriptionAPIHelper.getAddProductOrderAction((Plan)startOn3, currency2, (StartOn)currency);
            object = super.getOrderCreateRequestSubscriptions((Subscription)plan3, createOrderOrderAction);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Subscription updateSubscriptionPlanItem(Subscription subscription2, SubscriptionPlanItem subscriptionPlanItem, StartOn startOn) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        SubscriptionPlanItem subscriptionPlanItem2 = subscriptionPlanItem;
        StartOn startOn2 = startOn;
        try {
            void subscription4;
            void currency;
            void startOn3;
            void subscriptionPlanItem3;
            Currency currency2 = Currency.getInstance(subscriptionPlanItem3.getAccount().getCurrency());
            CreateOrderOrderAction createOrderOrderAction = SubscriptionAPIHelper.getUpdateProductOrderAction(startOn3.getSubscriptionPlan(), Collections.singletonList(startOn3), currency2, (StartOn)currency);
            object = super.getOrderCreateRequestSubscriptions((Subscription)subscriptionPlanItem3, createOrderOrderAction);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    private Subscription getOrderCreateRequestSubscriptions(Subscription subscription2, CreateOrderOrderAction orderAction) {
        OrderCreateRequestSubscriptions subscriptionChange = new OrderCreateRequestSubscriptions().subscriptionNumber(subscription2.getKey()).customFields(subscription2.getCustomFields()).orderActions(Collections.singletonList(orderAction));
        ZOrder newOrder = ((ZOrder.Builder)((ZOrder.Builder)((ZOrder.Builder)new ZOrder.Builder().existingAccountNumber(subscription2.getAccount().getAccountKey())).subscriptions(Collections.singletonList(subscriptionChange))).orderDate(this.tenantToday.toString())).build();
        PostOrderResponseType orderResponseType = newOrder.createInternally(this.context);
        if (!orderResponseType.success().booleanValue()) {
            throw ZuoraSdkException.builder().message(orderResponseType.getRawResponse()).build();
        }
        String subKey = ((PostOrderResponseTypeSubscriptions)orderResponseType.subscriptions().get(0)).subscriptionId();
        return this.get(subKey);
    }

    /*
     * WARNING - void declaration
     */
    public Subscription cancel(Subscription subscription2, StartOn startOn) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        StartOn startOn2 = startOn;
        try {
            void startOn3;
            void subscription4;
            Object object2 = SubscriptionAPIHelper.getCancelOrderAction(subscription4.tenantToday, CancellationPolicy.SPECIFIC_DATE, startOn2);
            object = super.getOrderCreateRequestSubscriptions((Subscription)startOn3, (CreateOrderOrderAction)object2);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Subscription ownerTransfer(Subscription subscription2, String string, String string2, StartOn startOn) {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        String string3 = string;
        String string4 = string2;
        StartOn startOn2 = startOn;
        try {
            void destinationAccountNumber;
            void subscription4;
            void startOn3;
            void destinationInvoiceAccountNumber;
            CreateOrderOrderAction createOrderOrderAction = SubscriptionAPIHelper.getOwnerTransferOrderAction((String)destinationInvoiceAccountNumber, (String)startOn3, startOn2);
            object = super.getOrderCreateRequestSubscriptions((Subscription)destinationAccountNumber, createOrderOrderAction);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Subscription renew(Subscription subscription2) {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        try {
            void effectiveDate;
            void subscription4;
            if (subscription3.getInitialTerm().getType() == Term.TermType.EVERGREEN || subscription3.getTermEndDate() == null) {
                throw ZuoraSdkException.builder().message("Evergreen Subscriptions cannot be renewed").build();
            }
            Object object2 = subscription3.getTermEndDate();
            String string = SubscriptionAPIHelper.getRenewOrderAction(StartOn.builder().contractEffective((LocalDate)object2).customerAcceptance((LocalDate)object2).serviceActivation((LocalDate)object2).build());
            object = super.getOrderCreateRequestSubscriptions((Subscription)effectiveDate, (CreateOrderOrderAction)string);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    public Subscription get(String subscriptionKey) throws ZuoraSdkException {
        Optional optionalMap;
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("field", "Name");
        filter.put("value", subscriptionKey);
        filter.put("operator", "EQ");
        if (uuidPattern.matcher(subscriptionKey).matches()) {
            filter.put("field", "Id");
        }
        if (!(optionalMap = this.hawkClient.getRecords("subscription", filter).stream().min((sub1, sub2) -> Double.compare((Double)sub2.get("version"), (Double)sub1.get("version")))).isPresent()) {
            return null;
        }
        Map sub = (Map)optionalMap.get();
        Account account2 = this.client.accounts().get((String)sub.get("accountId"));
        Subscription.SubscriptionBuilder builder = Subscription.builder().id((String)sub.get("id")).account(account2).state(Subscription.State.getByLabel((String)sub.get("status"))).initialTerm(Term.builder().type(Term.TermType.valueOf((String)sub.get("termType"))).intervalCount(Tools.doubleToInt((Double)((Double)sub.get("initialTerm")))).interval(sub.get("initialTermPeriodType") != null ? TermPeriodType.getByLabel((String)((String)sub.get("initialTermPeriodType"))).getApiValue() : null).build()).renewalTerm(Term.builder().type(Term.getRenewalTermType((String)sub.get("renewalSetting"))).intervalCount(Tools.doubleToInt((Double)((Double)sub.get("renewalTerm")))).interval(sub.get("renewalTermPeriodType") != null ? TermPeriodType.getByLabel((String)((String)sub.get("renewalTermPeriodType"))).getApiValue() : null).build()).currentTerm(Term.builder().type(Term.TermType.valueOf((String)sub.get("termType"))).intervalCount(Tools.doubleToInt((Double)((Double)sub.get("currentTerm")))).interval(sub.get("currentTermPeriodType") != null ? TermPeriodType.getByLabel((String)((String)sub.get("currentTermPeriodType"))).getApiValue() : null).startDate(Tools.toLocalDate((String)((String)sub.get("termStartDate")))).endDate(Tools.toLocalDate((String)((String)sub.get("termEndDate")))).build()).startDate(Tools.toLocalDate((String)((String)sub.get("subscriptionStartDate")))).endDate(Tools.toLocalDate((String)((String)sub.get("subscriptionEndDate")))).termEndDate(Tools.toLocalDate((String)((String)sub.get("termEndDate")))).termStartDate(LocalDate.parse((String)sub.get("termStartDate"))).description((String)sub.get("notes")).contractEffective(Tools.toLocalDate((String)((String)sub.get("contractEffectiveDate")))).serviceActivation(Tools.toLocalDate((String)((String)sub.get("serviceActivationDate")))).customerAcceptance(Tools.toLocalDate((String)((String)sub.get("customerAcceptanceDate")))).invoiceSeparately((Boolean)sub.get("invoiceSeparately")).invoiceAccount(account2.getId().equals(sub.get("invoiceOwnerId")) ? account2 : this.client.accounts().get((String)sub.get("invoiceOwnerId"))).version(Tools.doubleToInt((Double)((Double)sub.get("version")))).canceledDate(Tools.toLocalDate((String)((String)sub.get("cancelledDate")))).createdBy((String)sub.get("createdById")).createTime(ZonedDateTime.parse((String)sub.get("createdDate"))).updatedBy((String)sub.get("updatedById")).updateTime(ZonedDateTime.parse((String)sub.get("updatedDate"))).autoRenew((Boolean)sub.get("autoRenew")).key((String)sub.get("name")).client(this.client);
        GETSubscriptionTypeWithSuccess getSubscriptionTypeWithSuccess = SubscriptionsAPI.retrieveByKey((APIContext)this.context, (String)((String)sub.get("id")));
        builder.mrr(getSubscriptionTypeWithSuccess.contractedMrr()).customFields(getSubscriptionTypeWithSuccess.subscriptionObjectCustomFields()).tcv(getSubscriptionTypeWithSuccess.totalContractedValue());
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public Subscription removeSubscriptionPlan(Subscription subscription2, SubscriptionPlan subscriptionPlan, StartOn startOn) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Subscription subscription3 = subscription2;
        SubscriptionPlan subscriptionPlan2 = subscriptionPlan;
        StartOn startOn2 = startOn;
        try {
            void subscriptionPlan3;
            void subscription4;
            void startOn3;
            Object object2 = SubscriptionAPIHelper.getRemoveProductOrderAction(startOn2, startOn3.getId());
            object = super.getOrderCreateRequestSubscriptions((Subscription)subscriptionPlan3, (CreateOrderOrderAction)object2);
            return object;
        }
        finally {
            subscription3 = null;
        }
    }

    public List<SubscriptionPlan> getSubscriptionPlans(String subscriptionId) throws ZuoraSdkException {
        try {
            Response response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new RatePlansBySubscriptionIdQuery(subscriptionId))).join();
            if (response.getData() == null) {
                throw ZuoraSdkException.builder().build();
            }
            if (((RatePlansBySubscriptionIdQuery.Data)response.getData()).getRateplans() == null || ((RatePlansBySubscriptionIdQuery.Data)response.getData()).getRateplans().getEdges() == null) {
                return new ArrayList<SubscriptionPlan>();
            }
            return ((RatePlansBySubscriptionIdQuery.Data)response.getData()).getRateplans().getEdges().stream().filter(plan -> plan.getNode() == null || !String.valueOf(plan.getNode().getAmendmentType()).equals(OrderType.REMOVE_PRODUCT.getApiValue())).map(plan -> {
                List<SubscriptionPlanItem> subscriptionPlanItems = Collections.emptyList();
                if (plan.getNode().getRateplancharges() != null && plan.getNode().getRateplancharges().getEdges() != null) {
                    subscriptionPlanItems = plan.getNode().getRateplancharges().getEdges().stream().map(edge -> this.subscriptionPlanItemMapper.fromApi(edge.getNode()).build()).collect(Collectors.toList());
                }
                return SubscriptionPlan.builder().client(this.client).id(plan.getNode().getId()).name(plan.getNode().getName()).plan(plan.getNode().getProductRatePlanId()).subscription(plan.getNode().getSubscriptionId()).createdBy(plan.getNode().getCreatedById()).createTime(Tools.toZonedDateTime((ZoneId)this.timeZone, (String)plan.getNode().getCreatedDate())).updatedBy(plan.getNode().getUpdatedDate()).updateTime(Tools.toZonedDateTime((ZoneId)this.timeZone, (String)plan.getNode().getUpdatedDate())).subscriptionPlanItems(subscriptionPlanItems).build();
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().operationName("getSubscriptionPlans").cause((Throwable)e).build();
        }
    }

    private static /* synthetic */ CreateOrderRatePlanOverride lambda$create$0(Currency currency, Plan plan) {
        return SubscriptionAPIHelper.getCreateOrderRatePlanOverride(plan, currency);
    }

    static enum CancellationPolicy {
        SPECIFIC_DATE("SpecificDate"),
        END_OF_CURRENT_TERM("EndOfCurrentTerm"),
        END_OF_LAST_INVOICE_PERIOD("EndOfLastInvoicePeriod");

        private final String apiValue;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private CancellationPolicy(String apiValue) {
            this.apiValue = apiValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getApiValue() {
            return this.apiValue;
        }
    }

    static enum OrderType {
        CREATE_SUBSCRIPTION("CreateSubscription"),
        CANCEL_SUBSCRIPTION("CancelSubscription"),
        RENEW_SUBSCRIPTION("RenewSubscription"),
        OWNER_TRANSFER("OwnerTransfer"),
        ADD_PRODUCT("AddProduct"),
        REMOVE_PRODUCT("RemoveProduct"),
        UPDATE_PRODUCT("UpdateProduct"),
        TERMS_AND_CONDITIONS("TermsAndConditions");

        private final String apiValue;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private OrderType(String apiValue) {
            this.apiValue = apiValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getApiValue() {
            return this.apiValue;
        }
    }

    static enum TriggerDateEnum {
        CONTRACT_EFFECTIVE("ContractEffective"),
        SERVICE_ACTIVATION("ServiceActivation"),
        CUSTOMER_ACCEPTANCE("CustomerAcceptance");

        private final String apiValue;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private TriggerDateEnum(String apiValue) {
            this.apiValue = apiValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getApiValue() {
            return this.apiValue;
        }
    }
}

