/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.Plan;
import com.zuora.sdk.PlanCreateRequest;
import com.zuora.sdk.PlanMapper;
import com.zuora.sdk.internal.models.ZProductRatePlan;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

class PlanMapperImpl
extends PlanMapper {
    PlanMapperImpl() {
    }

    @Override
    ZProductRatePlan.Builder toApi(Plan plan) {
        Map<String, Object> map;
        if (plan == null) {
            return null;
        }
        ZProductRatePlan.Builder builder = new ZProductRatePlan.Builder();
        builder.productId(plan.getProduct());
        if (plan.getStartDate() != null) {
            builder.effectiveStartDate(DateTimeFormatter.ISO_LOCAL_DATE.format(plan.getStartDate()));
        }
        if (plan.getEndDate() != null) {
            builder.effectiveEndDate(DateTimeFormatter.ISO_LOCAL_DATE.format(plan.getEndDate()));
        }
        if ((map = plan.getCustomFields()) != null) {
            builder.productRatePlanObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.description(plan.getDescription());
        builder.id(plan.getId());
        builder.name(plan.getName());
        builder.activeCurrencies(plan.getActiveCurrencies());
        return builder;
    }

    @Override
    ZProductRatePlan.Builder toApi(PlanCreateRequest plan) {
        if (plan == null) {
            return null;
        }
        ZProductRatePlan.Builder builder = new ZProductRatePlan.Builder();
        builder.productId(plan.getProduct());
        builder.effectiveStartDate(plan.getStartDate());
        builder.effectiveEndDate(plan.getEndDate());
        Map<String, Object> map = plan.getCustomFields();
        if (map != null) {
            builder.productRatePlanObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.description(plan.getDescription());
        builder.id(plan.getId());
        builder.name(plan.getName());
        builder.activeCurrencies(plan.getActiveCurrencies());
        return builder;
    }
}

