/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.Account;
import com.zuora.sdk.AccountCreateRequest;
import com.zuora.sdk.ApiMapper;
import com.zuora.sdk.Contact;
import com.zuora.sdk.ContactCreateRequest;
import com.zuora.sdk.PaymentCreateRequest;
import com.zuora.sdk.Plan;
import com.zuora.sdk.PlanCreateRequest;
import com.zuora.sdk.ProductCreateRequest;
import com.zuora.sdk.RefundCreateRequest;
import com.zuora.sdk.internal.ProductRatePlanByIdQuery;
import com.zuora.sdk.internal.apis.data.POSTAccountTypeBillToContact;
import com.zuora.sdk.internal.apis.data.POSTAccountTypeSoldToContact;
import com.zuora.sdk.internal.models.ZAccount;
import com.zuora.sdk.internal.models.ZContact;
import com.zuora.sdk.internal.models.ZPayment;
import com.zuora.sdk.internal.models.ZProduct;
import com.zuora.sdk.internal.models.ZProductRatePlan;
import com.zuora.sdk.internal.models.ZRefund;
import com.zuora.sdk.internal.models.enums.RefundType;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

class ApiMapperImpl
implements ApiMapper {
    ApiMapperImpl() {
    }

    @Override
    public ZAccount.Builder toApi(AccountCreateRequest account2) {
        if (account2 == null) {
            return null;
        }
        ZAccount.Builder builder = new ZAccount.Builder();
        builder.accountNumber(account2.getAccountKey());
        builder.billToContact(this.toBillTo(account2.getBillTo()));
        builder.soldToContact(this.toSoldTo(account2.getSoldTo()));
        builder.parentId(account2.getParentAccount());
        builder.paymentTerm(account2.getPaymentTerms());
        builder.notes(account2.getDescription());
        builder.hpmCreditCardPaymentMethodId(account2.getPaymentMethod());
        Map<String, Object> map = account2.getCustomFields();
        if (map != null) {
            builder.accountObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.name(account2.getName());
        builder.batch(account2.getBatch());
        builder.crmId(account2.getCrmId());
        builder.currency(account2.getCurrency());
        builder.autoPay(account2.getAutoPay());
        builder.billCycleDay(Integer.valueOf(account2.getBillCycleDay().getValue()));
        return builder;
    }

    @Override
    public ZAccount.Builder toApi(Account account2) {
        if (account2 == null) {
            return null;
        }
        ZAccount.Builder builder = new ZAccount.Builder();
        builder.accountNumber(account2.getAccountKey());
        builder.billToContact(this.contactToPOSTAccountTypeBillToContact(account2.getBillTo()));
        builder.soldToContact(this.contactToPOSTAccountTypeSoldToContact(account2.getSoldTo()));
        builder.parentId(account2.getParentAccount());
        builder.paymentTerm(account2.getPaymentTerms());
        builder.notes(account2.getDescription());
        Map<String, Object> map = account2.getCustomFields();
        if (map != null) {
            builder.accountObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.id(account2.getId());
        builder.name(account2.getName());
        builder.batch(account2.getBatch());
        builder.crmId(account2.getCrmId());
        builder.currency(account2.getCurrency());
        builder.autoPay(account2.getAutoPay());
        builder.billCycleDay(Integer.valueOf(account2.getBillCycleDay().getValue()));
        return builder;
    }

    @Override
    public ZContact.Builder toApi(ContactCreateRequest contact) {
        if (contact == null) {
            return null;
        }
        ZContact.Builder builder = new ZContact.Builder();
        builder.homePhone(contact.getPhone());
        builder.personalEmail(contact.getEmail());
        builder.accountId(contact.getAccount());
        Map<String, Object> map = contact.getCustomFields();
        if (map != null) {
            builder.contactObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.lastName(contact.getLastName());
        builder.firstName(contact.getFirstName());
        builder.workEmail(contact.getWorkEmail());
        builder.address1(contact.getAddress().getLine1());
        builder.address2(contact.getAddress().getLine2());
        builder.city(contact.getAddress().getCity());
        builder.state(contact.getAddress().getState());
        builder.country(contact.getAddress().getCountry());
        builder.postalCode(contact.getAddress().getPostalCode());
        return builder;
    }

    @Override
    public ZContact.Builder toApi(Contact contact) {
        if (contact == null) {
            return null;
        }
        ZContact.Builder builder = new ZContact.Builder();
        builder.homePhone(contact.getPhone());
        builder.personalEmail(contact.getEmail());
        builder.accountId(contact.getAccount());
        Map<String, Object> map = contact.getCustomFields();
        if (map != null) {
            builder.contactObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.lastName(contact.getLastName());
        builder.id(contact.getId());
        builder.firstName(contact.getFirstName());
        builder.workEmail(contact.getWorkEmail());
        builder.address1(contact.getAddress().getLine1());
        builder.address2(contact.getAddress().getLine2());
        builder.city(contact.getAddress().getCity());
        builder.state(contact.getAddress().getState());
        builder.country(contact.getAddress().getCountry());
        builder.postalCode(contact.getAddress().getPostalCode());
        return builder;
    }

    @Override
    public ZProduct.Builder toApi(ProductCreateRequest product) {
        if (product == null) {
            return null;
        }
        ZProduct.Builder builder = new ZProduct.Builder();
        if (product.getStartDate() != null) {
            builder.effectiveStartDate(DateTimeFormatter.ISO_LOCAL_DATE.format(product.getStartDate()));
        }
        if (product.getEndDate() != null) {
            builder.effectiveEndDate(DateTimeFormatter.ISO_LOCAL_DATE.format(product.getEndDate()));
        }
        builder.sKU(product.getSku());
        Map<String, Object> map = product.getCustomFields();
        if (map != null) {
            builder.productObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.description(product.getDescription());
        builder.name(product.getName());
        return builder;
    }

    @Override
    public ZProductRatePlan.Builder toApi(Plan plan) {
        Map<String, Object> map;
        if (plan == null) {
            return null;
        }
        ZProductRatePlan.Builder builder = new ZProductRatePlan.Builder();
        builder.productId(plan.getProduct());
        if (plan.getStartDate() != null) {
            builder.effectiveStartDate(DateTimeFormatter.ISO_LOCAL_DATE.format(plan.getStartDate()));
        }
        if (plan.getEndDate() != null) {
            builder.effectiveEndDate(DateTimeFormatter.ISO_LOCAL_DATE.format(plan.getEndDate()));
        }
        if ((map = plan.getCustomFields()) != null) {
            builder.productRatePlanObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.description(plan.getDescription());
        builder.id(plan.getId());
        builder.name(plan.getName());
        builder.activeCurrencies(plan.getActiveCurrencies());
        return builder;
    }

    @Override
    public ZProductRatePlan.Builder toApi(PlanCreateRequest plan) {
        if (plan == null) {
            return null;
        }
        ZProductRatePlan.Builder builder = new ZProductRatePlan.Builder();
        builder.productId(plan.getProduct());
        builder.effectiveStartDate(plan.getStartDate());
        builder.effectiveEndDate(plan.getEndDate());
        Map<String, Object> map = plan.getCustomFields();
        if (map != null) {
            builder.productRatePlanObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.description(plan.getDescription());
        builder.id(plan.getId());
        builder.name(plan.getName());
        builder.activeCurrencies(plan.getActiveCurrencies());
        return builder;
    }

    @Override
    public Plan fromApi(ProductRatePlanByIdQuery.ProductrateplanById productRatePlan) {
        if (productRatePlan == null) {
            return null;
        }
        Plan.PlanBuilder plan = Plan.builder();
        if (productRatePlan.getEffectiveStartDate() != null) {
            plan.startDate(LocalDate.parse(productRatePlan.getEffectiveStartDate()));
        }
        if (productRatePlan.getEffectiveEndDate() != null) {
            plan.endDate(LocalDate.parse(productRatePlan.getEffectiveEndDate()));
        }
        if (productRatePlan.getCreatedDate() != null) {
            plan.createTime(ZonedDateTime.parse(productRatePlan.getCreatedDate()));
        }
        if (productRatePlan.getUpdatedDate() != null) {
            plan.updateTime(ZonedDateTime.parse(productRatePlan.getUpdatedDate()));
        }
        plan.createdBy(productRatePlan.getCreatedById());
        plan.updatedBy(productRatePlan.getUpdatedById());
        plan.name(productRatePlan.getName());
        plan.description(productRatePlan.getDescription());
        plan.id(productRatePlan.getId());
        return plan.build();
    }

    @Override
    public ZRefund.Builder toApi(RefundCreateRequest refundCreateRequest) {
        if (refundCreateRequest == null) {
            return null;
        }
        ZRefund.Builder builder = new ZRefund.Builder();
        builder.accountId(refundCreateRequest.getAccount());
        builder.softDescriptor(refundCreateRequest.getStatementDescriptor());
        builder.referenceId(refundCreateRequest.getReference());
        if (refundCreateRequest.getDate() != null) {
            builder.refundDate(DateTimeFormatter.ISO_LOCAL_DATE.format(refundCreateRequest.getDate()));
        }
        builder.comment(refundCreateRequest.getDescription());
        builder.reasonCode(refundCreateRequest.getReason());
        builder.paymentId(refundCreateRequest.getPaymentId());
        Map<String, Object> map = refundCreateRequest.getCustomFields();
        if (map != null) {
            builder.refundObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.amount(refundCreateRequest.getAmount());
        builder.type(Boolean.TRUE.equals(refundCreateRequest.getExternal()) ? RefundType.EXTERNAL : RefundType.ELECTRONIC);
        builder.methodType(refundCreateRequest.getType().getApiType());
        return builder;
    }

    @Override
    public ZPayment.Builder toApi(PaymentCreateRequest paymentCreateRequest) {
        if (paymentCreateRequest == null) {
            return null;
        }
        ZPayment.Builder builder = new ZPayment.Builder();
        builder.accountId(paymentCreateRequest.getAccount());
        builder.authTransactionId(paymentCreateRequest.getAuthorisationCode());
        builder.comment(paymentCreateRequest.getDescription());
        if (paymentCreateRequest.getDate() != null) {
            builder.effectiveDate(DateTimeFormatter.ISO_LOCAL_DATE.format(paymentCreateRequest.getDate()));
        }
        builder.gatewayId(paymentCreateRequest.getGateway());
        builder.referenceId(paymentCreateRequest.getReference());
        builder.softDescriptor(paymentCreateRequest.getStatementDescriptor());
        builder.paymentMethodId(paymentCreateRequest.getPaymentMethod());
        Map<String, Object> map = paymentCreateRequest.getCustomFields();
        if (map != null) {
            builder.paymentObjectCustomFields(new HashMap<String, Object>(map));
        }
        builder.currency(paymentCreateRequest.getCurrency());
        builder.softDescriptorPhone(paymentCreateRequest.getSoftDescriptorPhone());
        builder.amount(paymentCreateRequest.getAmount());
        Map<String, String> map1 = paymentCreateRequest.getGatewayOptions();
        if (map1 != null) {
            builder.gatewayOptions(new HashMap<String, String>(map1));
        }
        builder.gatewayOrderId(paymentCreateRequest.getGatewayOrderId());
        return builder;
    }

    protected POSTAccountTypeBillToContact contactToPOSTAccountTypeBillToContact(Contact contact) {
        if (contact == null) {
            return null;
        }
        POSTAccountTypeBillToContact pOSTAccountTypeBillToContact = new POSTAccountTypeBillToContact();
        pOSTAccountTypeBillToContact.workEmail(contact.getWorkEmail());
        pOSTAccountTypeBillToContact.firstName(contact.getFirstName());
        pOSTAccountTypeBillToContact.lastName(contact.getLastName());
        return pOSTAccountTypeBillToContact;
    }

    protected POSTAccountTypeSoldToContact contactToPOSTAccountTypeSoldToContact(Contact contact) {
        if (contact == null) {
            return null;
        }
        POSTAccountTypeSoldToContact pOSTAccountTypeSoldToContact = new POSTAccountTypeSoldToContact();
        pOSTAccountTypeSoldToContact.workEmail(contact.getWorkEmail());
        pOSTAccountTypeSoldToContact.firstName(contact.getFirstName());
        pOSTAccountTypeSoldToContact.lastName(contact.getLastName());
        return pOSTAccountTypeSoldToContact;
    }
}

