/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.chargemodels;

import com.zuora.sdk.chargemodels.ChargeModelInterface;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class Tiered
implements ChargeModelInterface {
    final Currency currency;
    private final ChargeModelInterface.Type type;
    @NonNull
    private String unitOfMeasure;
    private List<Tier> tiers;
    private Double quantity;
    private Double minQuantity;
    private Double maxQuantity;

    @Override
    public ChargeModelInterface.Type getType() {
        return ChargeModelInterface.Type.TIERED;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static Double $default$quantity() {
        return 1.0;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Tiered(Currency currency, ChargeModelInterface.Type type, @NonNull String unitOfMeasure, List<Tier> tiers, Double quantity, Double minQuantity, Double maxQuantity) {
        if (unitOfMeasure == null) {
            throw new NullPointerException("unitOfMeasure is marked non-null but is null");
        }
        this.currency = currency;
        this.type = type;
        this.unitOfMeasure = unitOfMeasure;
        this.tiers = tiers;
        this.quantity = quantity;
        this.minQuantity = minQuantity;
        this.maxQuantity = maxQuantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static TieredBuilder builder() {
        return new TieredBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TieredBuilder toBuilder() {
        TieredBuilder builder = new TieredBuilder().currency(this.currency).type(this.type).unitOfMeasure(this.unitOfMeasure).quantity(this.quantity).minQuantity(this.minQuantity).maxQuantity(this.maxQuantity);
        if (this.tiers != null) {
            builder.tiers(this.tiers);
        }
        return builder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Tiered(currency=" + this.getCurrency() + ", type=" + (Object)((Object)this.getType()) + ", unitOfMeasure=" + this.getUnitOfMeasure() + ", tiers=" + this.getTiers() + ", quantity=" + this.getQuantity() + ", minQuantity=" + this.getMinQuantity() + ", maxQuantity=" + this.getMaxQuantity() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Currency getCurrency() {
        return this.currency;
    }

    @Override
    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Tier> getTiers() {
        return this.tiers;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getQuantity() {
        return this.quantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getMinQuantity() {
        return this.minQuantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getMaxQuantity() {
        return this.maxQuantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMinQuantity(Double minQuantity) {
        this.minQuantity = minQuantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMaxQuantity(Double maxQuantity) {
        this.maxQuantity = maxQuantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUnitOfMeasure(@NonNull String unitOfMeasure) {
        if (unitOfMeasure == null) {
            throw new NullPointerException("unitOfMeasure is marked non-null but is null");
        }
        this.unitOfMeasure = unitOfMeasure;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTiers(List<Tier> tiers) {
        this.tiers = tiers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class TieredBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Currency currency;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ChargeModelInterface.Type type;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String unitOfMeasure;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Tier> tiers;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean quantity$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double quantity$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double minQuantity;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double maxQuantity;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        TieredBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TieredBuilder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TieredBuilder type(ChargeModelInterface.Type type) {
            this.type = type;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TieredBuilder unitOfMeasure(@NonNull String unitOfMeasure) {
            if (unitOfMeasure == null) {
                throw new NullPointerException("unitOfMeasure is marked non-null but is null");
            }
            this.unitOfMeasure = unitOfMeasure;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TieredBuilder tier(Tier tier) {
            if (this.tiers == null) {
                this.tiers = new ArrayList();
            }
            this.tiers.add(tier);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TieredBuilder tiers(Collection<? extends Tier> tiers) {
            if (tiers == null) {
                throw new NullPointerException("tiers cannot be null");
            }
            if (this.tiers == null) {
                this.tiers = new ArrayList();
            }
            this.tiers.addAll(tiers);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TieredBuilder clearTiers() {
            if (this.tiers != null) {
                this.tiers.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TieredBuilder quantity(Double quantity) {
            this.quantity$value = quantity;
            this.quantity$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TieredBuilder minQuantity(Double minQuantity) {
            this.minQuantity = minQuantity;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TieredBuilder maxQuantity(Double maxQuantity) {
            this.maxQuantity = maxQuantity;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Tiered build() {
            List<Tier> tiers;
            switch (this.tiers == null ? 0 : this.tiers.size()) {
                case 0: {
                    tiers = Collections.emptyList();
                    break;
                }
                case 1: {
                    tiers = Collections.singletonList(this.tiers.get(0));
                    break;
                }
                default: {
                    tiers = Collections.unmodifiableList(new ArrayList<Tier>(this.tiers));
                }
            }
            Double quantity$value = this.quantity$value;
            if (!this.quantity$set) {
                quantity$value = Tiered.$default$quantity();
            }
            return new Tiered(this.currency, this.type, this.unitOfMeasure, tiers, quantity$value, this.minQuantity, this.maxQuantity);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Tiered.TieredBuilder(currency=" + this.currency + ", type=" + (Object)((Object)this.type) + ", unitOfMeasure=" + this.unitOfMeasure + ", tiers=" + this.tiers + ", quantity$value=" + this.quantity$value + ", minQuantity=" + this.minQuantity + ", maxQuantity=" + this.maxQuantity + ")";
        }
    }

    public static class Tier {
        private Map<Currency, Double> amounts;
        private Map<Currency, Double> unitAmounts;
        private Integer tier;
        private Double upTo;
        Double startingUnit;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        Tier(Map<Currency, Double> amounts, Map<Currency, Double> unitAmounts, Integer tier, Double upTo, Double startingUnit) {
            this.amounts = amounts;
            this.unitAmounts = unitAmounts;
            this.tier = tier;
            this.upTo = upTo;
            this.startingUnit = startingUnit;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static TierBuilder tierBuilder() {
            return new TierBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TierBuilder toBuilder() {
            TierBuilder builder = new TierBuilder().tier(this.tier).upTo(this.upTo).startingUnit(this.startingUnit);
            if (this.amounts != null) {
                builder.amounts(this.amounts);
            }
            if (this.unitAmounts != null) {
                builder.unitAmounts(this.unitAmounts);
            }
            return builder;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Tiered.Tier(amounts=" + this.getAmounts() + ", unitAmounts=" + this.getUnitAmounts() + ", tier=" + this.getTier() + ", upTo=" + this.getUpTo() + ", startingUnit=" + this.getStartingUnit() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Map<Currency, Double> getAmounts() {
            return this.amounts;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Map<Currency, Double> getUnitAmounts() {
            return this.unitAmounts;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Integer getTier() {
            return this.tier;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Double getUpTo() {
            return this.upTo;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Double getStartingUnit() {
            return this.startingUnit;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setAmounts(Map<Currency, Double> amounts) {
            this.amounts = amounts;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public void setUnitAmounts(Map<Currency, Double> unitAmounts) {
            this.unitAmounts = unitAmounts;
        }

        public static class TierBuilder {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private ArrayList<Currency> amounts$key;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private ArrayList<Double> amounts$value;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private ArrayList<Currency> unitAmounts$key;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private ArrayList<Double> unitAmounts$value;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private Integer tier;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private Double upTo;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private Double startingUnit;

            public TierBuilder startingUnit(Double startingUnit) {
                this.startingUnit = startingUnit;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            TierBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TierBuilder amount(Currency amountKey, Double amountValue) {
                if (this.amounts$key == null) {
                    this.amounts$key = new ArrayList();
                    this.amounts$value = new ArrayList();
                }
                this.amounts$key.add(amountKey);
                this.amounts$value.add(amountValue);
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TierBuilder amounts(Map<? extends Currency, ? extends Double> amounts) {
                if (amounts == null) {
                    throw new NullPointerException("amounts cannot be null");
                }
                if (this.amounts$key == null) {
                    this.amounts$key = new ArrayList();
                    this.amounts$value = new ArrayList();
                }
                for (Map.Entry<? extends Currency, ? extends Double> $lombokEntry : amounts.entrySet()) {
                    this.amounts$key.add($lombokEntry.getKey());
                    this.amounts$value.add($lombokEntry.getValue());
                }
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TierBuilder clearAmounts() {
                if (this.amounts$key != null) {
                    this.amounts$key.clear();
                    this.amounts$value.clear();
                }
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TierBuilder unitAmount(Currency unitAmountKey, Double unitAmountValue) {
                if (this.unitAmounts$key == null) {
                    this.unitAmounts$key = new ArrayList();
                    this.unitAmounts$value = new ArrayList();
                }
                this.unitAmounts$key.add(unitAmountKey);
                this.unitAmounts$value.add(unitAmountValue);
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TierBuilder unitAmounts(Map<? extends Currency, ? extends Double> unitAmounts) {
                if (unitAmounts == null) {
                    throw new NullPointerException("unitAmounts cannot be null");
                }
                if (this.unitAmounts$key == null) {
                    this.unitAmounts$key = new ArrayList();
                    this.unitAmounts$value = new ArrayList();
                }
                for (Map.Entry<? extends Currency, ? extends Double> $lombokEntry : unitAmounts.entrySet()) {
                    this.unitAmounts$key.add($lombokEntry.getKey());
                    this.unitAmounts$value.add($lombokEntry.getValue());
                }
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TierBuilder clearUnitAmounts() {
                if (this.unitAmounts$key != null) {
                    this.unitAmounts$key.clear();
                    this.unitAmounts$value.clear();
                }
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TierBuilder tier(Integer tier) {
                this.tier = tier;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public TierBuilder upTo(Double upTo) {
                this.upTo = upTo;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public Tier build() {
                Map<Currency, Double> unitAmounts;
                Map<Currency, Double> amounts;
                switch (this.amounts$key == null ? 0 : this.amounts$key.size()) {
                    case 0: {
                        amounts = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        amounts = Collections.singletonMap(this.amounts$key.get(0), this.amounts$value.get(0));
                        break;
                    }
                    default: {
                        amounts = new LinkedHashMap(this.amounts$key.size() < 0x40000000 ? 1 + this.amounts$key.size() + (this.amounts$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.amounts$key.size(); ++$i) {
                            amounts.put(this.amounts$key.get($i), this.amounts$value.get($i));
                        }
                        amounts = Collections.unmodifiableMap(amounts);
                    }
                }
                switch (this.unitAmounts$key == null ? 0 : this.unitAmounts$key.size()) {
                    case 0: {
                        unitAmounts = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        unitAmounts = Collections.singletonMap(this.unitAmounts$key.get(0), this.unitAmounts$value.get(0));
                        break;
                    }
                    default: {
                        unitAmounts = new LinkedHashMap(this.unitAmounts$key.size() < 0x40000000 ? 1 + this.unitAmounts$key.size() + (this.unitAmounts$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.unitAmounts$key.size(); ++$i) {
                            unitAmounts.put(this.unitAmounts$key.get($i), this.unitAmounts$value.get($i));
                        }
                        unitAmounts = Collections.unmodifiableMap(unitAmounts);
                    }
                }
                return new Tier(amounts, unitAmounts, this.tier, this.upTo, this.startingUnit);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "Tiered.Tier.TierBuilder(amounts$key=" + this.amounts$key + ", amounts$value=" + this.amounts$value + ", unitAmounts$key=" + this.unitAmounts$key + ", unitAmounts$value=" + this.unitAmounts$value + ", tier=" + this.tier + ", upTo=" + this.upTo + ", startingUnit=" + this.startingUnit + ")";
            }
        }
    }
}

