/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.Plan;
import com.zuora.sdk.ProcessingOption;
import com.zuora.sdk.StartOn;
import com.zuora.sdk.Subscription;
import com.zuora.sdk.SubscriptionAPI;
import com.zuora.sdk.SubscriptionPlan;
import com.zuora.sdk.SubscriptionPlanItem;
import com.zuora.sdk.SubscriptionUpdateAction;
import com.zuora.sdk.Term;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class SubscriptionUpdateRequest {
    private final Subscription subscription;
    private final ProcessingOption processingOptions;
    private final LocalDate effectiveDate;
    private List<SubscriptionUpdateAction> subscriptionUpdateActions;

    @SuppressFBWarnings(justification="generated code")
    @Generated
    SubscriptionUpdateRequest(Subscription subscription2, ProcessingOption processingOptions, LocalDate effectiveDate, List<SubscriptionUpdateAction> subscriptionUpdateActions) {
        this.subscription = subscription2;
        this.processingOptions = processingOptions;
        this.effectiveDate = effectiveDate;
        this.subscriptionUpdateActions = subscriptionUpdateActions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SubscriptionUpdateRequestBuilder builder() {
        return new SubscriptionUpdateRequestBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Subscription getSubscription() {
        return this.subscription;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ProcessingOption getProcessingOptions() {
        return this.processingOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<SubscriptionUpdateAction> getSubscriptionUpdateActions() {
        return this.subscriptionUpdateActions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSubscriptionUpdateActions(List<SubscriptionUpdateAction> subscriptionUpdateActions) {
        this.subscriptionUpdateActions = subscriptionUpdateActions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionUpdateRequest)) {
            return false;
        }
        SubscriptionUpdateRequest other = (SubscriptionUpdateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Subscription this$subscription = this.getSubscription();
        Subscription other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !((Object)this$subscription).equals(other$subscription)) {
            return false;
        }
        ProcessingOption this$processingOptions = this.getProcessingOptions();
        ProcessingOption other$processingOptions = other.getProcessingOptions();
        if (this$processingOptions == null ? other$processingOptions != null : !((Object)this$processingOptions).equals(other$processingOptions)) {
            return false;
        }
        LocalDate this$effectiveDate = this.getEffectiveDate();
        LocalDate other$effectiveDate = other.getEffectiveDate();
        if (this$effectiveDate == null ? other$effectiveDate != null : !((Object)this$effectiveDate).equals(other$effectiveDate)) {
            return false;
        }
        List<SubscriptionUpdateAction> this$subscriptionUpdateActions = this.getSubscriptionUpdateActions();
        List<SubscriptionUpdateAction> other$subscriptionUpdateActions = other.getSubscriptionUpdateActions();
        return !(this$subscriptionUpdateActions == null ? other$subscriptionUpdateActions != null : !((Object)this$subscriptionUpdateActions).equals(other$subscriptionUpdateActions));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionUpdateRequest;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Subscription $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : ((Object)$subscription).hashCode());
        ProcessingOption $processingOptions = this.getProcessingOptions();
        result = result * 59 + ($processingOptions == null ? 43 : ((Object)$processingOptions).hashCode());
        LocalDate $effectiveDate = this.getEffectiveDate();
        result = result * 59 + ($effectiveDate == null ? 43 : ((Object)$effectiveDate).hashCode());
        List<SubscriptionUpdateAction> $subscriptionUpdateActions = this.getSubscriptionUpdateActions();
        result = result * 59 + ($subscriptionUpdateActions == null ? 43 : ((Object)$subscriptionUpdateActions).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SubscriptionUpdateRequest(subscription=" + this.getSubscription() + ", processingOptions=" + this.getProcessingOptions() + ", effectiveDate=" + this.getEffectiveDate() + ", subscriptionUpdateActions=" + this.getSubscriptionUpdateActions() + ")";
    }

    public static class SubscriptionUpdateRequestBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Subscription subscription;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ProcessingOption processingOptions;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate effectiveDate;
        private List<SubscriptionUpdateAction> subscriptionUpdateActions = new ArrayList<SubscriptionUpdateAction>();

        private SubscriptionUpdateRequestBuilder subscriptionUpdateActions(List<SubscriptionUpdateAction> subscriptionUpdateActions) {
            this.subscriptionUpdateActions = subscriptionUpdateActions;
            return this;
        }

        public SubscriptionUpdateRequestBuilder renew(StartOn startOn) {
            this.subscriptionUpdateActions.add(this.getAction(startOn, SubscriptionAPI.OrderType.RENEW_SUBSCRIPTION).build());
            return this;
        }

        public SubscriptionUpdateRequestBuilder addPlan(StartOn startOn, Plan plan) {
            this.subscriptionUpdateActions.add(this.getAction(startOn, SubscriptionAPI.OrderType.ADD_PRODUCT).plan(plan).build());
            return this;
        }

        public SubscriptionUpdateRequestBuilder removeSubscriptionPlan(StartOn startOn, SubscriptionPlan subscriptionPlan) {
            this.removeSubscriptionPlan(startOn, subscriptionPlan.getId());
            return this;
        }

        public SubscriptionUpdateRequestBuilder removeSubscriptionPlan(StartOn startOn, String subscriptionPlanId) {
            this.subscriptionUpdateActions.add(this.getAction(startOn, SubscriptionAPI.OrderType.REMOVE_PRODUCT).subscriptionPlanId(subscriptionPlanId).build());
            return this;
        }

        public SubscriptionUpdateRequestBuilder updateSubscriptionPlanItem(StartOn startOn, SubscriptionPlanItem subscriptionPlanItem) {
            this.subscriptionUpdateActions.add(this.getUpdateProductAction(startOn, subscriptionPlanItem.getSubscriptionPlan()).subscriptionPlanItem(subscriptionPlanItem).build());
            return this;
        }

        public SubscriptionUpdateRequestBuilder updateSubscriptionPlan(StartOn startOn, SubscriptionPlan subscriptionPlan) {
            this.subscriptionUpdateActions.add(this.getUpdateProductAction(startOn, subscriptionPlan.getId()).subscriptionPlanItems(subscriptionPlan.getSubscriptionPlanItems()).build());
            return this;
        }

        public SubscriptionUpdateRequestBuilder ownerTransfer(StartOn startOn, String destinationAccountKey, String destinationInvoiceAccountKey) {
            this.subscriptionUpdateActions.add(this.getAction(startOn, SubscriptionAPI.OrderType.OWNER_TRANSFER).subscriptionOwner(destinationAccountKey).invoiceOwner(destinationInvoiceAccountKey).build());
            return this;
        }

        public SubscriptionUpdateRequestBuilder updateTerms(StartOn startOn, Term currentTerm, Term renewalTerm, boolean autoRenew) {
            this.subscriptionUpdateActions.add(this.getAction(startOn, SubscriptionAPI.OrderType.TERMS_AND_CONDITIONS).currentTerm(currentTerm).renewalTerm(renewalTerm).autoRenew(autoRenew).build());
            return this;
        }

        public SubscriptionUpdateRequestBuilder replaceSubscriptionPlan(StartOn startOn, SubscriptionPlan existingSubscriptionPlan, Plan replacementPlan) {
            this.removeSubscriptionPlan(startOn, existingSubscriptionPlan);
            this.addPlan(startOn, replacementPlan);
            return this;
        }

        private SubscriptionUpdateAction.SubscriptionUpdateActionBuilder getUpdateProductAction(StartOn startOn, String subscriptionPlanId) {
            return this.getAction(startOn, SubscriptionAPI.OrderType.UPDATE_PRODUCT).subscriptionPlanId(subscriptionPlanId);
        }

        private SubscriptionUpdateAction.SubscriptionUpdateActionBuilder getAction(StartOn startOn, SubscriptionAPI.OrderType orderType) {
            return SubscriptionUpdateAction.builder().actionType(orderType).startOn(startOn);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SubscriptionUpdateRequestBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionUpdateRequestBuilder subscription(Subscription subscription2) {
            this.subscription = subscription2;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionUpdateRequestBuilder processingOptions(ProcessingOption processingOptions) {
            this.processingOptions = processingOptions;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionUpdateRequestBuilder effectiveDate(LocalDate effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SubscriptionUpdateRequest build() {
            return new SubscriptionUpdateRequest(this.subscription, this.processingOptions, this.effectiveDate, this.subscriptionUpdateActions);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SubscriptionUpdateRequest.SubscriptionUpdateRequestBuilder(subscription=" + this.subscription + ", processingOptions=" + this.processingOptions + ", effectiveDate=" + this.effectiveDate + ", subscriptionUpdateActions=" + this.subscriptionUpdateActions + ")";
        }
    }
}

