/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.chargemodels;

import com.zuora.sdk.chargemodels.ChargeModelInterface;
import com.zuora.sdk.chargemodels.Tiered;
import com.zuora.sdk.core.models.enums.ListPriceBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class FlatFee
implements ChargeModelInterface {
    private final ChargeModelInterface.Type type;
    @NonNull
    private Map<Currency, Double> amounts;
    private ListPriceBase priceBaseInterval;

    @Override
    public ChargeModelInterface.Type getType() {
        return ChargeModelInterface.Type.FLAT_FEE;
    }

    @Override
    public String getUnitOfMeasure() {
        return null;
    }

    @Override
    public Double getQuantity() {
        return null;
    }

    @Override
    public List<Tiered.Tier> getTiers() {
        return null;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static ListPriceBase $default$priceBaseInterval() {
        return ListPriceBase.PER_BILLING_PERIOD;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    FlatFee(ChargeModelInterface.Type type, @NonNull Map<Currency, Double> amounts, ListPriceBase priceBaseInterval) {
        if (amounts == null) {
            throw new NullPointerException("amounts is marked non-null but is null");
        }
        this.type = type;
        this.amounts = amounts;
        this.priceBaseInterval = priceBaseInterval;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static FlatFeeBuilder builder() {
        return new FlatFeeBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FlatFeeBuilder toBuilder() {
        FlatFeeBuilder builder = new FlatFeeBuilder().type(this.type).priceBaseInterval(this.priceBaseInterval);
        if (this.amounts != null) {
            builder.amounts(this.amounts);
        }
        return builder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "FlatFee(type=" + (Object)((Object)this.getType()) + ", amounts=" + this.getAmounts() + ", priceBaseInterval=" + this.getPriceBaseInterval() + ")";
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<Currency, Double> getAmounts() {
        return this.amounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ListPriceBase getPriceBaseInterval() {
        return this.priceBaseInterval;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAmounts(@NonNull Map<Currency, Double> amounts) {
        if (amounts == null) {
            throw new NullPointerException("amounts is marked non-null but is null");
        }
        this.amounts = amounts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPriceBaseInterval(ListPriceBase priceBaseInterval) {
        this.priceBaseInterval = priceBaseInterval;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class FlatFeeBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ChargeModelInterface.Type type;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Currency> amounts$key;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Double> amounts$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean priceBaseInterval$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ListPriceBase priceBaseInterval$value;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        FlatFeeBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlatFeeBuilder type(ChargeModelInterface.Type type) {
            this.type = type;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlatFeeBuilder amount(Currency amountKey, Double amountValue) {
            if (this.amounts$key == null) {
                this.amounts$key = new ArrayList();
                this.amounts$value = new ArrayList();
            }
            this.amounts$key.add(amountKey);
            this.amounts$value.add(amountValue);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlatFeeBuilder amounts(Map<? extends Currency, ? extends Double> amounts) {
            if (amounts == null) {
                throw new NullPointerException("amounts cannot be null");
            }
            if (this.amounts$key == null) {
                this.amounts$key = new ArrayList();
                this.amounts$value = new ArrayList();
            }
            for (Map.Entry<? extends Currency, ? extends Double> $lombokEntry : amounts.entrySet()) {
                this.amounts$key.add($lombokEntry.getKey());
                this.amounts$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlatFeeBuilder clearAmounts() {
            if (this.amounts$key != null) {
                this.amounts$key.clear();
                this.amounts$value.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlatFeeBuilder priceBaseInterval(ListPriceBase priceBaseInterval) {
            this.priceBaseInterval$value = priceBaseInterval;
            this.priceBaseInterval$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FlatFee build() {
            Map<Currency, Double> amounts;
            switch (this.amounts$key == null ? 0 : this.amounts$key.size()) {
                case 0: {
                    amounts = Collections.emptyMap();
                    break;
                }
                case 1: {
                    amounts = Collections.singletonMap(this.amounts$key.get(0), this.amounts$value.get(0));
                    break;
                }
                default: {
                    amounts = new LinkedHashMap(this.amounts$key.size() < 0x40000000 ? 1 + this.amounts$key.size() + (this.amounts$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.amounts$key.size(); ++$i) {
                        amounts.put(this.amounts$key.get($i), this.amounts$value.get($i));
                    }
                    amounts = Collections.unmodifiableMap(amounts);
                }
            }
            ListPriceBase priceBaseInterval$value = this.priceBaseInterval$value;
            if (!this.priceBaseInterval$set) {
                priceBaseInterval$value = FlatFee.$default$priceBaseInterval();
            }
            return new FlatFee(this.type, amounts, priceBaseInterval$value);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "FlatFee.FlatFeeBuilder(type=" + (Object)((Object)this.type) + ", amounts$key=" + this.amounts$key + ", amounts$value=" + this.amounts$value + ", priceBaseInterval$value=" + this.priceBaseInterval$value + ")";
        }
    }
}

