/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.apollographql.apollo.ApolloClient;
import com.zuora.sdk.ApiMapper;
import com.zuora.sdk.PaymentMethod;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.core.APIContext;
import com.zuora.sdk.core.apis.PaymentMethodsAPI;
import com.zuora.sdk.core.apis.data.GETPaymentMethodResponse;
import com.zuora.sdk.core.exceptions.ZuoraSdkException;
import com.zuora.sdk.utils.HawkClient;
import java.util.NoSuchElementException;

public class PaymentMethodAPI<T> {
    private final APIContext context;
    private final HawkClient hawkClient;
    private final ApolloClient gqlClient;
    private final ZuoraClient client;

    PaymentMethodAPI(ZuoraClient client) {
        this.client = client;
        this.context = client.getContext();
        this.hawkClient = client.getHawkClient();
        this.gqlClient = this.hawkClient.getGqlClient();
    }

    public PaymentMethod get(String id) throws ZuoraSdkException {
        GETPaymentMethodResponse rawResult = (GETPaymentMethodResponse)new PaymentMethodsAPI.PaymentMethodRetrieveRequest(this.context, id).execute().head();
        if (rawResult == null) {
            throw new NoSuchElementException();
        }
        PaymentMethod.PaymentMethodBuilder paymentMethod = ApiMapper.Mapper.fromApi(rawResult);
        return paymentMethod.build();
    }
}

