/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.zuora.sdk.Account;
import com.zuora.sdk.AccountCreateRequest;
import com.zuora.sdk.Address;
import com.zuora.sdk.BillingDetails;
import com.zuora.sdk.BillingDocumentSettings;
import com.zuora.sdk.Contact;
import com.zuora.sdk.ContactCreateRequest;
import com.zuora.sdk.CreditCard;
import com.zuora.sdk.Payment;
import com.zuora.sdk.PaymentCreateRequest;
import com.zuora.sdk.PaymentMethod;
import com.zuora.sdk.Plan;
import com.zuora.sdk.PlanCreateRequest;
import com.zuora.sdk.ProductBySkuQuery;
import com.zuora.sdk.ProductCreateRequest;
import com.zuora.sdk.ProductRatePlanByIdQuery;
import com.zuora.sdk.ProductRatePlanChargeByIdQuery;
import com.zuora.sdk.RatePlansBySubscriptionIdQuery;
import com.zuora.sdk.Refund;
import com.zuora.sdk.RefundCreateRequest;
import com.zuora.sdk.SmoothingModel;
import com.zuora.sdk.Subscription;
import com.zuora.sdk.SubscriptionPlanItem;
import com.zuora.sdk.TaxCertificate;
import com.zuora.sdk.TaxIdentifier;
import com.zuora.sdk.Term;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.chargemodels.ChargeModelInterface;
import com.zuora.sdk.chargemodels.DiscountAmount;
import com.zuora.sdk.chargemodels.DiscountPercentage;
import com.zuora.sdk.chargemodels.FlatFee;
import com.zuora.sdk.chargemodels.Overage;
import com.zuora.sdk.chargemodels.PerUnit;
import com.zuora.sdk.chargemodels.Tiered;
import com.zuora.sdk.chargemodels.TieredWithOverage;
import com.zuora.sdk.chargemodels.Volume;
import com.zuora.sdk.core.APIContext;
import com.zuora.sdk.core.apis.data.GETARPaymentTypewithSuccess;
import com.zuora.sdk.core.apis.data.GETAccountTypeBillToContact;
import com.zuora.sdk.core.apis.data.GETAccountTypeSoldToContact;
import com.zuora.sdk.core.apis.data.GETPaymentMethodResponse;
import com.zuora.sdk.core.apis.data.GETSubscriptionTypeWithSuccess;
import com.zuora.sdk.core.apis.data.POSTAccountTypeBillToContact;
import com.zuora.sdk.core.apis.data.POSTAccountTypeSoldToContact;
import com.zuora.sdk.core.apis.data.POSTPMMandateInfo;
import com.zuora.sdk.core.apis.data.ProxyCreateOrModifyProductRatePlanChargeTierData;
import com.zuora.sdk.core.apis.data.ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier;
import com.zuora.sdk.core.exceptions.ZuoraSdkException;
import com.zuora.sdk.core.internal.Tools;
import com.zuora.sdk.core.models.ZAccount;
import com.zuora.sdk.core.models.ZContact;
import com.zuora.sdk.core.models.ZPayment;
import com.zuora.sdk.core.models.ZProduct;
import com.zuora.sdk.core.models.ZProductRatePlan;
import com.zuora.sdk.core.models.ZProductRatePlanCharge;
import com.zuora.sdk.core.models.ZRefund;
import com.zuora.sdk.core.models.ZSubscription;
import com.zuora.sdk.core.models.enums.AccountStatus;
import com.zuora.sdk.core.models.enums.AccountingCodeType;
import com.zuora.sdk.core.models.enums.ApplyType;
import com.zuora.sdk.core.models.enums.BillCycleType;
import com.zuora.sdk.core.models.enums.BillingPeriodAlignment;
import com.zuora.sdk.core.models.enums.BillingPeriodType;
import com.zuora.sdk.core.models.enums.BillingTiming;
import com.zuora.sdk.core.models.enums.ChargeModel;
import com.zuora.sdk.core.models.enums.ChargeType;
import com.zuora.sdk.core.models.enums.DiscountLevel;
import com.zuora.sdk.core.models.enums.EndDateCondition;
import com.zuora.sdk.core.models.enums.ListPriceBase;
import com.zuora.sdk.core.models.enums.OverageCalculationOption;
import com.zuora.sdk.core.models.enums.OverageUnusedUnitsCreditOption;
import com.zuora.sdk.core.models.enums.PaymentStatus;
import com.zuora.sdk.core.models.enums.PaymentType;
import com.zuora.sdk.core.models.enums.RefundType;
import com.zuora.sdk.core.models.enums.TaxMode;
import com.zuora.sdk.core.models.enums.TransferredToAccounting;
import com.zuora.sdk.core.models.enums.TriggerEvent;
import com.zuora.sdk.core.models.enums.UpToPeriodsType;
import com.zuora.sdk.enums.BankAccountType;
import com.zuora.sdk.enums.MethodType;
import com.zuora.sdk.enums.MitConsentAgreementSrc;
import com.zuora.sdk.enums.MitProfileAction;
import com.zuora.sdk.enums.MitProfileType;
import com.zuora.sdk.enums.PaymentMethodState;
import com.zuora.sdk.enums.PaymentMethodType;
import com.zuora.sdk.enums.RatingGroup;
import com.zuora.sdk.enums.RefundState;
import com.zuora.sdk.enums.TaxCertificateStatus;
import com.zuora.sdk.planitems.PlanItem;
import com.zuora.sdk.planitems.PlanItemCreateRequest;
import com.zuora.sdk.planitems.PlanItemEnum;
import com.zuora.sdk.planitems.PlanItemType;
import com.zuora.sdk.planitems.RecurringPlanItem;
import com.zuora.sdk.planitems.UsagePlanItem;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
interface ApiMapper {
    public static final ApiMapper Mapper = (ApiMapper)Mappers.getMapper(ApiMapper.class);

    @Mappings(value={@Mapping(source="accountKey", target="accountNumber"), @Mapping(source="billTo", target="billToContact"), @Mapping(source="soldTo", target="soldToContact"), @Mapping(source="parentAccount", target="parentId"), @Mapping(source="paymentTerms", target="paymentTerm"), @Mapping(source="description", target="notes"), @Mapping(target="paymentMethod", ignore=true), @Mapping(source="paymentMethod", target="hpmCreditCardPaymentMethodId"), @Mapping(source="customFields", target="accountObjectCustomFields"), @Mapping(expression="java(account.getBillCycleDay().getValue())", target="billCycleDay")})
    public ZAccount.Builder toApi(AccountCreateRequest var1);

    @Mappings(value={@Mapping(source="accountKey", target="accountNumber"), @Mapping(source="billTo", target="billToContact"), @Mapping(source="soldTo", target="soldToContact"), @Mapping(source="parentAccount", target="parentId"), @Mapping(source="paymentTerms", target="paymentTerm"), @Mapping(source="description", target="notes"), @Mapping(expression="java(account.getBillCycleDay().getValue())", target="billCycleDay"), @Mapping(source="customFields", target="accountObjectCustomFields")})
    public ZAccount.Builder toApi(Account var1);

    default public POSTAccountTypeBillToContact toBillTo(ContactCreateRequest contact) {
        if (contact == null) {
            return null;
        }
        POSTAccountTypeBillToContact postAccountTypeBillToContact = new POSTAccountTypeBillToContact();
        postAccountTypeBillToContact.address1(contact.getAddress().getLine1());
        postAccountTypeBillToContact.address2(contact.getAddress().getLine2());
        postAccountTypeBillToContact.city(contact.getAddress().getCity());
        postAccountTypeBillToContact.state(contact.getAddress().getState());
        postAccountTypeBillToContact.country(contact.getAddress().getCountry());
        postAccountTypeBillToContact.zipCode(contact.getAddress().getPostalCode());
        postAccountTypeBillToContact.workEmail(contact.getWorkEmail());
        postAccountTypeBillToContact.firstName(contact.getFirstName());
        postAccountTypeBillToContact.lastName(contact.getLastName());
        postAccountTypeBillToContact.homePhone(contact.getPhone());
        postAccountTypeBillToContact.personalEmail(contact.getEmail());
        postAccountTypeBillToContact.contactObjectCustomFields(contact.getCustomFields());
        return postAccountTypeBillToContact;
    }

    default public POSTAccountTypeSoldToContact toSoldTo(ContactCreateRequest contact) {
        if (contact == null) {
            return null;
        }
        POSTAccountTypeSoldToContact postAccountTypeSoldToContact = new POSTAccountTypeSoldToContact();
        postAccountTypeSoldToContact.address1(contact.getAddress().getLine1());
        postAccountTypeSoldToContact.address2(contact.getAddress().getLine2());
        postAccountTypeSoldToContact.city(contact.getAddress().getCity());
        postAccountTypeSoldToContact.state(contact.getAddress().getState());
        postAccountTypeSoldToContact.country(contact.getAddress().getCountry());
        postAccountTypeSoldToContact.zipCode(contact.getAddress().getPostalCode());
        postAccountTypeSoldToContact.workEmail(contact.getWorkEmail());
        postAccountTypeSoldToContact.firstName(contact.getFirstName());
        postAccountTypeSoldToContact.lastName(contact.getLastName());
        postAccountTypeSoldToContact.homePhone(contact.getPhone());
        postAccountTypeSoldToContact.personalEmail(contact.getEmail());
        postAccountTypeSoldToContact.contactObjectCustomFields(contact.getCustomFields());
        return postAccountTypeSoldToContact;
    }

    default public Account toAccount(ZAccount account2, ZuoraClient client) {
        GETAccountTypeBillToContact billToRes = account2.Z_BillToContact();
        GETAccountTypeSoldToContact soldToRes = account2.Z_SoldToContact();
        if (billToRes == null) {
            throw new IllegalStateException("Expected a billTo contact.");
        }
        if (soldToRes == null) {
            throw new IllegalStateException("Expected a soldTo contact.");
        }
        Address billToAddress = Address.builder().state(billToRes.state()).city(billToRes.city()).country(billToRes.country()).line1(billToRes.address1()).line2(billToRes.address2()).postalCode(billToRes.zipCode()).build();
        Contact billTo = Contact.builder().account(account2.id()).firstName(billToRes.firstName()).lastName(billToRes.lastName()).phone(billToRes.homePhone()).email(billToRes.personalEmail()).address(billToAddress).workEmail(billToRes.workEmail()).customFields(billToRes.contactObjectCustomFields()).build();
        Address soldToAddress = Address.builder().state(soldToRes.state()).city(soldToRes.city()).country(soldToRes.country()).line1(soldToRes.address1()).line2(soldToRes.address2()).postalCode(soldToRes.zipCode()).build();
        Contact soldTo = Contact.builder().account(account2.id()).firstName(soldToRes.firstName()).lastName(soldToRes.lastName()).phone(soldToRes.homePhone()).email(soldToRes.personalEmail()).address(soldToAddress).workEmail(soldToRes.workEmail()).customFields(soldToRes.contactObjectCustomFields()).build();
        Account.BillCycleDay billCycleDay = Account.BillCycleDay.values()[Integer.parseInt(account2.billingAndPayment().billCycleDay())];
        Account.AccountBuilder accountBuilder = Account.builder().enabled(AccountStatus.ACTIVE.getApiValue().equals(account2.basicInfo().status())).id(account2.id()).crmId(account2.crmId()).description(account2.notes()).batch(account2.batch()).name(account2.basicInfo().name()).accountKey(account2.basicInfo().accountNumber()).currency(account2.billingAndPayment().currency()).billCycleDay(billCycleDay).paymentTerms(account2.paymentTerm()).autoPay(account2.autoPay()).billTo(billTo).soldTo(soldTo).billingDocumentSettings(BillingDocumentSettings.builder().creditMemoTemplate(account2.creditMemoTemplateId()).debitMemoTemplate(account2.debitMemoTemplateId()).invoiceTemplate(account2.invoiceTemplateId()).email(account2.invoiceDeliveryPrefsEmail()).print(account2.invoiceDeliveryPrefsPrint()).build()).balance(String.valueOf(account2.balance())).contractedMrr(account2.contractedMrr()).creditBalance(String.valueOf(account2.creditBalance())).totalInvoiceBalance(String.valueOf(account2.totalInvoiceBalance())).totalDebitMemoBalance(account2.totalDebitMemoBalance()).unappliedCreditMemoAmount(account2.unappliedCreditMemoAmount()).unappliedPaymentAmount(account2.unappliedPaymentAmount()).customFields(account2.accountObjectCustomFields()).client(client);
        if (account2.taxInfo() != null) {
            accountBuilder.taxIdentifier(TaxIdentifier.builder().id(account2.taxInfo().vATId()).build()).taxCertificate(TaxCertificate.builder().id(account2.taxInfo().exemptCertificateId()).companyCode(account2.taxInfo().companyCode()).startDate(account2.taxInfo().exemptEffectiveDate()).endDate(account2.taxInfo().exemptExpirationDate()).issuingJurisdiction(account2.taxInfo().exemptIssuingJurisdiction()).state(TaxCertificateStatus.getByLabel(account2.taxInfo().exemptStatus())).build());
        }
        Account acc = accountBuilder.build();
        account2.getAssociations().forEach(acc::associate);
        return acc;
    }

    @Mappings(value={@Mapping(expression="java(contact.getAddress().getLine1())", target="address1"), @Mapping(expression="java(contact.getAddress().getLine2())", target="address2"), @Mapping(expression="java(contact.getAddress().getCity())", target="city"), @Mapping(expression="java(contact.getAddress().getState())", target="state"), @Mapping(expression="java(contact.getAddress().getCountry())", target="country"), @Mapping(expression="java(contact.getAddress().getPostalCode())", target="postalCode"), @Mapping(source="phone", target="homePhone"), @Mapping(source="email", target="personalEmail"), @Mapping(source="account", target="accountId"), @Mapping(source="customFields", target="contactObjectCustomFields")})
    public ZContact.Builder toApi(ContactCreateRequest var1);

    @Mappings(value={@Mapping(expression="java(contact.getAddress().getLine1())", target="address1"), @Mapping(expression="java(contact.getAddress().getLine2())", target="address2"), @Mapping(expression="java(contact.getAddress().getCity())", target="city"), @Mapping(expression="java(contact.getAddress().getState())", target="state"), @Mapping(expression="java(contact.getAddress().getCountry())", target="country"), @Mapping(expression="java(contact.getAddress().getPostalCode())", target="postalCode"), @Mapping(source="phone", target="homePhone"), @Mapping(source="email", target="personalEmail"), @Mapping(source="account", target="accountId"), @Mapping(source="customFields", target="contactObjectCustomFields")})
    public ZContact.Builder toApi(Contact var1);

    default public Contact toContact(ZContact zContact) {
        return Contact.builder().id(zContact.id()).account(zContact.accountId()).firstName(zContact.firstName()).lastName(zContact.lastName()).phone(zContact.homePhone()).email(zContact.personalEmail()).workEmail(zContact.workEmail()).address(Address.builder().line1(zContact.address1()).line2(zContact.address2()).city(zContact.city()).state(zContact.state()).country(zContact.country()).postalCode(zContact.postalCode()).build()).createdBy(zContact.createdById()).createTime(ZonedDateTime.parse(zContact.createdDate())).updatedBy(zContact.updatedById()).updateTime(ZonedDateTime.parse(zContact.updatedDate())).customFields(zContact.contactObjectCustomFields()).build();
    }

    @Mappings(value={@Mapping(source="startDate", target="effectiveStartDate"), @Mapping(source="endDate", target="effectiveEndDate"), @Mapping(source="sku", target="sKU"), @Mapping(source="customFields", target="productObjectCustomFields")})
    public ZProduct.Builder toApi(ProductCreateRequest var1);

    @Mappings(value={@Mapping(source="plan.product", target="productId"), @Mapping(source="startDate", target="effectiveStartDate"), @Mapping(source="endDate", target="effectiveEndDate"), @Mapping(source="customFields", target="productRatePlanObjectCustomFields")})
    public ZProductRatePlan.Builder toApi(Plan var1);

    @Mappings(value={@Mapping(source="plan.product", target="productId"), @Mapping(source="startDate", target="effectiveStartDate"), @Mapping(source="endDate", target="effectiveEndDate"), @Mapping(source="customFields", target="productRatePlanObjectCustomFields")})
    public ZProductRatePlan.Builder toApi(PlanCreateRequest var1);

    @Mappings(value={@Mapping(source="effectiveStartDate", target="startDate"), @Mapping(source="effectiveEndDate", target="endDate"), @Mapping(source="createdDate", target="createTime"), @Mapping(source="updatedDate", target="updateTime"), @Mapping(source="createdById", target="createdBy"), @Mapping(source="updatedById", target="updatedBy")})
    public Plan fromApi(ProductRatePlanByIdQuery.ProductrateplanById var1);

    default public ZProductRatePlanCharge toApi(PlanItem planItem, Map<String, Object> uomMap) {
        ZProductRatePlanCharge.Builder zProductRatePlanCharge = (ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)new ZProductRatePlanCharge.Builder().name(planItem.getName())).chargeModel(ChargeModel.getByLabel((String)planItem.getChargeModel().getType().getApiValue()))).chargeType(ChargeType.getByLabel((String)planItem.getPlanItemType().getApiValue()))).deferredRevenueAccount(planItem.getAccountingCode())).recognizedRevenueAccount(planItem.getAccountingCode())).triggerEvent(TriggerEvent.getByLabel((String)planItem.getStartEvent().getValue()))).taxCode(planItem.getTaxCode())).taxMode(planItem.isTaxInclusive() ? TaxMode.TAX_INCLUSIVE : TaxMode.TAX_EXCLUSIVE)).billingTiming(planItem.getTiming())).description(planItem.getDescription())).productRatePlanId(planItem.getPlan())).billingPeriodAlignment(BillingPeriodAlignment.getByLabel((String)planItem.getAlignment().label));
        if (planItem.getPlanItemType().equals((Object)PlanItemType.ItemType.RECURRING)) {
            this.getRecurringPlanItem(zProductRatePlanCharge, planItem.getOn(), planItem.getInterval(), planItem.getIntervalCount(), planItem.getDurationInterval(), planItem.getDurationIntervalCount());
        }
        if (planItem.getPlanItemType().equals((Object)PlanItemType.ItemType.USAGE)) {
            this.getRecurringPlanItem(zProductRatePlanCharge, planItem.getOn(), planItem.getInterval(), planItem.getIntervalCount(), planItem.getDurationInterval(), planItem.getDurationIntervalCount());
            zProductRatePlanCharge.ratingGroup(com.zuora.sdk.core.models.enums.RatingGroup.getByLabel((String)planItem.getRatingGroup().getApiValue()));
        }
        return this.getzProductRatePlanCharge(uomMap, zProductRatePlanCharge, planItem.getChargeModel());
    }

    default public ZProductRatePlanCharge getzProductRatePlanCharge(Map<String, Object> uomMap, ZProductRatePlanCharge.Builder zProductRatePlanCharge, ChargeModelInterface chargeModel2) {
        if (chargeModel2.getUnitOfMeasure() != null) {
            ((ZProductRatePlanCharge.Builder)zProductRatePlanCharge.defaultQuantity(chargeModel2.getQuantity())).uOM(chargeModel2.getUnitOfMeasure());
        }
        ArrayList zTiers = new ArrayList();
        if (chargeModel2.getTiers() != null) {
            Map uom = (Map)uomMap.get(chargeModel2.getUnitOfMeasure());
            Double increaser = 1.0 / Math.pow(10.0, (Double)uom.get("precision"));
            double startingUnit = 0.0;
            for (Tiered.Tier tier : chargeModel2.getTiers()) {
                double finalStartingUnit;
                if (!tier.getAmounts().isEmpty()) {
                    finalStartingUnit = startingUnit;
                    tier.getAmounts().forEach((currency, amount) -> zTiers.add(new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier().price(amount).endingUnit(tier.getUpTo()).priceFormat("Flat Fee").currency(currency.getCurrencyCode()).startingUnit(Double.valueOf(finalStartingUnit))));
                } else {
                    finalStartingUnit = startingUnit;
                    tier.getUnitAmounts().forEach((currency, amount) -> zTiers.add(new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier().price(amount).priceFormat("Per Unit").endingUnit(tier.getUpTo()).currency(currency.getCurrencyCode()).startingUnit(Double.valueOf(finalStartingUnit))));
                }
                if (tier.getUpTo() == null) continue;
                startingUnit = tier.getUpTo() + increaser;
            }
            if (chargeModel2.getType() == ChargeModelInterface.Type.TIERED_WITH_OVERAGE) {
                double startingUnitOverage = startingUnit;
                ((TieredWithOverage)chargeModel2).getUnitAmounts().forEach((currency, price) -> zTiers.add(new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier().price(price).priceFormat("Per Unit").currency(currency.getCurrencyCode()).startingUnit(Double.valueOf(startingUnitOverage))));
            }
        } else {
            Map<Currency, Double> amounts = Collections.EMPTY_MAP;
            if (chargeModel2.getType() == ChargeModelInterface.Type.FLAT_FEE) {
                amounts = ((FlatFee)chargeModel2).getAmounts();
            }
            if (chargeModel2.getType() == ChargeModelInterface.Type.PER_UNIT) {
                amounts = ((PerUnit)chargeModel2).getUnitAmounts();
            }
            if (chargeModel2.getType() == ChargeModelInterface.Type.OVERAGE) {
                amounts = ((Overage)chargeModel2).getUnitAmounts();
            }
            if (chargeModel2.getType().equals((Object)ChargeModelInterface.Type.DISCOUNT_AMOUNT)) {
                DiscountAmount discountAmount = (DiscountAmount)chargeModel2;
                ((ZProductRatePlanCharge.Builder)zProductRatePlanCharge.applyDiscountTo(ChargeModelInterface.ApplyDiscountTo.getApiValueBySet(discountAmount.getApplyDiscountTo()))).discountLevel(discountAmount.getDiscountLevel());
                discountAmount.getAmounts().forEach((currency, price) -> zTiers.add(new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier().discountAmount(price).currency(currency.getCurrencyCode())));
            } else if (chargeModel2.getType().equals((Object)ChargeModelInterface.Type.DISCOUNT_PERCENTAGE)) {
                DiscountPercentage discountPercentage = (DiscountPercentage)chargeModel2;
                ((ZProductRatePlanCharge.Builder)zProductRatePlanCharge.applyDiscountTo(ChargeModelInterface.ApplyDiscountTo.getApiValueBySet(discountPercentage.getApplyDiscountTo()))).discountLevel(discountPercentage.getDiscountLevel());
                discountPercentage.getPercentages().forEach((currency, percentage) -> zTiers.add(new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier().discountPercentage(percentage).currency(currency.getCurrencyCode())));
            } else {
                amounts.forEach((currency, price) -> zTiers.add(new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier().price(price).currency(currency.getCurrencyCode())));
            }
        }
        if (chargeModel2.getType() == ChargeModelInterface.Type.OVERAGE) {
            zProductRatePlanCharge.includedUnits(((Overage)chargeModel2).getIncludedUnits());
            SmoothingModel smoothingModel = ((Overage)chargeModel2).getSmoothingModel();
            if (smoothingModel != null) {
                zProductRatePlanCharge.smoothingModel(smoothingModel.getType() == SmoothingModel.Type.ROLLING_WINDOW ? "RollingWindow" : "Rollover");
                if (smoothingModel.getType().equals((Object)SmoothingModel.Type.ROLLING_WINDOW)) {
                    zProductRatePlanCharge.numberOfPeriod(smoothingModel.getIntervalCount());
                    zProductRatePlanCharge.overageCalculationOption(smoothingModel.getApplyAtEndOfSmoothingPeriod() != false ? OverageCalculationOption.END_OF_SMOOTHING_PERIOD : OverageCalculationOption.PER_BILLING_PERIOD);
                    zProductRatePlanCharge.overageUnusedUnitsCreditOption(smoothingModel.getCreditUnusedUnits() != false ? OverageUnusedUnitsCreditOption.CREDIT_BY_SPECIFIC_RATE : OverageUnusedUnitsCreditOption.NO_CREDIT);
                } else if (smoothingModel.getType().equals((Object)SmoothingModel.Type.ROLLOVER)) {
                    zProductRatePlanCharge.numberOfPeriod(smoothingModel.getIntervalCount());
                }
            }
        }
        zProductRatePlanCharge.productRatePlanChargeTierData(new ProxyCreateOrModifyProductRatePlanChargeTierData().productRatePlanChargeTier(zTiers));
        return zProductRatePlanCharge.build();
    }

    default public void getRecurringPlanItem(ZProductRatePlanCharge.Builder zProductRatePlanCharge, PlanItemEnum.RecurringOn on, PlanItemEnum.Interval interval2, Integer intervalCount, PlanItemEnum.Interval durationInterval, Integer durationIntervalCount) {
        if (on.name().startsWith("_")) {
            ((ZProductRatePlanCharge.Builder)zProductRatePlanCharge.billCycleType(BillCycleType.SPECIFIC_DAY_OF_MONTH)).billCycleDay(Integer.valueOf(on.getValue()));
        } else {
            zProductRatePlanCharge.billCycleType(BillCycleType.getByLabel((String)on.getValue()));
        }
        if (interval2.equals((Object)PlanItemEnum.Interval.SPECIFIC_MONTH) | interval2.equals((Object)PlanItemEnum.Interval.SPECIFIC_WEEK)) {
            ((ZProductRatePlanCharge.Builder)zProductRatePlanCharge.billingPeriod(BillingPeriodType.getByLabel((String)interval2.getValue()))).specificBillingPeriod(intervalCount);
        } else {
            zProductRatePlanCharge.billingPeriod(BillingPeriodType.getByLabel((String)interval2.getValue()));
        }
        if (durationInterval == null) {
            zProductRatePlanCharge.endDateCondition(EndDateCondition.SUBSCRIPTION_END);
        } else {
            UpToPeriodsType upToPeriodsType = UpToPeriodsType.BILLING_PERIODS;
            if (durationInterval.equals((Object)PlanItemEnum.Interval.MONTH)) {
                upToPeriodsType = UpToPeriodsType.MONTHS;
            } else if (durationInterval.equals((Object)PlanItemEnum.Interval.WEEK)) {
                upToPeriodsType = UpToPeriodsType.WEEKS;
            }
            ((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)zProductRatePlanCharge.endDateCondition(EndDateCondition.FIXED_PERIOD)).upToPeriods(durationIntervalCount)).upToPeriodsType(upToPeriodsType);
        }
    }

    default public ZProductRatePlanCharge toApi(PlanItemCreateRequest planItem, Map<String, Object> uomMap) {
        ZProductRatePlanCharge.Builder zProductRatePlanCharge = (ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)new ZProductRatePlanCharge.Builder().name(planItem.getName())).chargeModel(ChargeModel.getByLabel((String)planItem.getChargeModel().getType().getApiValue()))).chargeType(ChargeType.getByLabel((String)planItem.getPlanItemType().getApiValue()))).deferredRevenueAccount(planItem.getAccountingCode())).recognizedRevenueAccount(planItem.getAccountingCode())).triggerEvent(TriggerEvent.getByLabel((String)planItem.getStartEvent().getValue()))).taxCode(planItem.getTaxCode())).taxMode(planItem.isTaxInclusive() ? TaxMode.TAX_INCLUSIVE : TaxMode.TAX_EXCLUSIVE)).description(planItem.getDescription())).productRatePlanId(planItem.getPlan());
        if (!planItem.getChargeModel().getType().equals((Object)ChargeModelInterface.Type.DISCOUNT_AMOUNT) & !planItem.getChargeModel().getType().equals((Object)ChargeModelInterface.Type.DISCOUNT_PERCENTAGE)) {
            zProductRatePlanCharge.billingTiming(planItem.getTiming());
        }
        if (planItem.getPlanItemType().equals((Object)PlanItemType.ItemType.RECURRING) && planItem instanceof RecurringPlanItem) {
            RecurringPlanItem recurringPlanItem = (RecurringPlanItem)planItem;
            this.getRecurringPlanItem(zProductRatePlanCharge, recurringPlanItem.getOn(), recurringPlanItem.getInterval(), recurringPlanItem.getIntervalCount(), recurringPlanItem.getDurationInterval(), recurringPlanItem.getDurationIntervalCount());
            ((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)zProductRatePlanCharge.billCycleType(BillCycleType.getByLabel((String)recurringPlanItem.getOn().getValue()))).billingPeriod(BillingPeriodType.getByLabel((String)recurringPlanItem.getInterval().getValue()))).billingPeriodAlignment(BillingPeriodAlignment.getByLabel((String)recurringPlanItem.getAlignment().label));
        }
        if (planItem.getPlanItemType().equals((Object)PlanItemType.ItemType.USAGE) && planItem instanceof UsagePlanItem) {
            UsagePlanItem usagePlanItem = (UsagePlanItem)planItem;
            this.getRecurringPlanItem(zProductRatePlanCharge, usagePlanItem.getOn(), usagePlanItem.getInterval(), null, null, null);
            ((ZProductRatePlanCharge.Builder)((ZProductRatePlanCharge.Builder)zProductRatePlanCharge.billCycleType(BillCycleType.getByLabel((String)usagePlanItem.getOn().getValue()))).billingPeriod(BillingPeriodType.getByLabel((String)usagePlanItem.getInterval().getValue()))).billingPeriodAlignment(BillingPeriodAlignment.getByLabel((String)usagePlanItem.getAlignment().label));
            if (usagePlanItem.getRatingGroup() != null) {
                zProductRatePlanCharge.ratingGroup(com.zuora.sdk.core.models.enums.RatingGroup.getByLabel((String)usagePlanItem.getRatingGroup().getApiValue()));
            }
        }
        return this.getzProductRatePlanCharge(uomMap, zProductRatePlanCharge, planItem.getChargeModel());
    }

    default public PlanItem getPlanItem(String accountingCode, ChargeModelInterface chargeModel, String id, String chargeType, String triggerEvent, String name, String billingPeriodAlignment, String billingPeriod, String billCycleType, String taxCode, String taxMode, String billingTiming, String description, String createdById, String updatedById, String createdDate, String updatedDate, String ratingGroup) {
        return PlanItem.builder().accountingCode(accountingCode).createTime(ZonedDateTime.parse(createdDate)).updateTime(ZonedDateTime.parse(updatedDate)).createdBy(createdById).updatedBy(updatedById).chargeModel(chargeModel).id(id).planItemType(PlanItemType.ItemType.getByLabel(chargeType)).startEvent(PlanItemEnum.Event.getEventByName(triggerEvent)).name(name).alignment(PlanItemEnum.Alignment.getByLabel(billingPeriodAlignment)).interval(PlanItemEnum.Interval.getIntervalByName(billingPeriod)).on(PlanItemEnum.RecurringOn.getBillCycleTypeByName(billCycleType)).taxCode(taxCode).taxInclusive(Objects.equals(TaxMode.getByLabel((String)taxMode), TaxMode.TAX_INCLUSIVE)).description(description).timing(BillingTiming.getByLabel((String)billingTiming)).ratingGroup(RatingGroup.getByApiValue(ratingGroup)).build();
    }

    default public PlanItem fromProductBySkuQuery(ProductBySkuQuery.Node2 productRatePlanCharge) {
        return this.getPlanItem(productRatePlanCharge.getRecognizedRevenueAccountingCode().getName(), this.getChargeModel(productRatePlanCharge), productRatePlanCharge.getId(), productRatePlanCharge.getChargeType(), productRatePlanCharge.getTriggerEvent(), productRatePlanCharge.getName(), productRatePlanCharge.getBillingPeriodAlignment(), productRatePlanCharge.getBillingPeriod(), productRatePlanCharge.getBillCycleType(), productRatePlanCharge.getTaxCode(), productRatePlanCharge.getTaxMode(), productRatePlanCharge.getBillingTiming(), productRatePlanCharge.getDescription(), productRatePlanCharge.getCreatedById(), productRatePlanCharge.getUpdatedById(), productRatePlanCharge.getCreatedDate(), productRatePlanCharge.getUpdatedDate(), productRatePlanCharge.getRatingGroup());
    }

    default public PlanItem fromProductRatePlanCharge(ProductRatePlanByIdQuery.Node productRatePlanCharge) {
        return this.getPlanItem(productRatePlanCharge.getRecognizedRevenueAccountingCode().getName(), this.getChargeModel(productRatePlanCharge), productRatePlanCharge.getId(), productRatePlanCharge.getChargeType(), productRatePlanCharge.getTriggerEvent(), productRatePlanCharge.getName(), productRatePlanCharge.getBillingPeriodAlignment(), productRatePlanCharge.getBillingPeriod(), productRatePlanCharge.getBillCycleType(), productRatePlanCharge.getTaxCode(), productRatePlanCharge.getTaxMode(), productRatePlanCharge.getBillingTiming(), productRatePlanCharge.getDescription(), productRatePlanCharge.getCreatedById(), productRatePlanCharge.getUpdatedById(), productRatePlanCharge.getCreatedDate(), productRatePlanCharge.getUpdatedDate(), productRatePlanCharge.getRatingGroup());
    }

    default public PlanItem fromProductRatePlanCharge(ProductRatePlanChargeByIdQuery.ProductrateplanchargeById productRatePlanCharge) {
        return this.getPlanItem(productRatePlanCharge.getRecognizedRevenueAccountingCode().getName(), this.getChargeModel(productRatePlanCharge), productRatePlanCharge.getId(), productRatePlanCharge.getChargeType(), productRatePlanCharge.getTriggerEvent(), productRatePlanCharge.getName(), productRatePlanCharge.getBillingPeriodAlignment(), productRatePlanCharge.getBillingPeriod(), productRatePlanCharge.getBillCycleType(), productRatePlanCharge.getTaxCode(), productRatePlanCharge.getTaxMode(), productRatePlanCharge.getBillingTiming(), productRatePlanCharge.getDescription(), productRatePlanCharge.getCreatedById(), productRatePlanCharge.getUpdatedById(), productRatePlanCharge.getCreatedDate(), productRatePlanCharge.getUpdatedDate(), productRatePlanCharge.getRatingGroup());
    }

    default public FlatFee getFlatFee(Map<Currency, Double> amounts, String listPriceBase) {
        return FlatFee.builder().amounts(amounts).priceBaseInterval(ListPriceBase.getByLabel((String)listPriceBase)).build();
    }

    default public PerUnit getPerUnit(Map<Currency, Double> amounts, String listPriceBase, String uom, Double quantity, Double maxQuantity, Double minQuantity) {
        return PerUnit.builder().unitAmounts(amounts).priceBaseInterval(ListPriceBase.getByLabel((String)listPriceBase)).unitOfMeasure(uom).quantity(quantity).maxQuantity(maxQuantity).minQuantity(minQuantity).build();
    }

    default public ChargeModelInterface getTieredorVolume(PlanItemEnum.ChargeModel chargeModel, String uom, Double quantity, Double maxQuantity, Double minQuantity, List<Tiered.Tier> tiers) {
        switch (chargeModel) {
            case VOLUME: {
                return Volume.builder().unitOfMeasure(uom).quantity(quantity).maxQuantity(maxQuantity).minQuantity(minQuantity).tiers(tiers).build();
            }
            case TIERED: {
                return Tiered.builder().unitOfMeasure(uom).quantity(quantity).maxQuantity(maxQuantity).minQuantity(minQuantity).tiers(tiers).build();
            }
            case TIERED_WITH_OVERAGE: {
                return TieredWithOverage.builder().unitOfMeasure(uom).quantity(quantity).maxQuantity(maxQuantity).minQuantity(minQuantity).tiers(tiers).build();
            }
        }
        return null;
    }

    default public Overage getOverage(Double includedUnits, Double quantity, String uom, Integer intervalCount, Map<Currency, Double> unitAmounts, String smoothingModel, String overageCalculationOption, String overageUnusedUnitsCreditOption) {
        Overage.OverageBuilder overageBuilder = Overage.builder().includedUnits(includedUnits).quantity(quantity).unitOfMeasure(uom);
        if (unitAmounts != null) {
            overageBuilder.unitAmounts(unitAmounts);
        }
        SmoothingModel.Type type = null;
        if (StringUtils.isNotBlank((CharSequence)smoothingModel)) {
            if (smoothingModel.equals("Rollover")) {
                type = SmoothingModel.Type.ROLLOVER;
            } else if (smoothingModel.equals("Rolling Window")) {
                type = SmoothingModel.Type.ROLLING_WINDOW;
            }
        }
        return overageBuilder.smoothingModel(SmoothingModel.builder().type(type).intervalCount(intervalCount).applyAtEndOfSmoothingPeriod(overageCalculationOption == OverageCalculationOption.END_OF_SMOOTHING_PERIOD.getApiValue()).creditUnusedUnits(overageUnusedUnitsCreditOption != OverageUnusedUnitsCreditOption.NO_CREDIT.getApiValue()).build()).build();
    }

    default public DiscountAmount getDiscountAmount(Map<Currency, Double> amounts, String applyDiscountTo, String discountLevel) {
        return DiscountAmount.builder().amounts(amounts).discountLevel(DiscountLevel.getByLabel((String)discountLevel)).applyDiscountTo(ChargeModelInterface.ApplyDiscountTo.getSetValueByApiValue(ApplyType.getByLabel((String)applyDiscountTo))).build();
    }

    default public DiscountPercentage getDiscountPercentage(Map<Currency, Double> amounts, String applyDiscountTo, String discountLevel) {
        return DiscountPercentage.builder().percentages(amounts).discountLevel(DiscountLevel.getByLabel((String)discountLevel)).applyDiscountTo(ChargeModelInterface.ApplyDiscountTo.getSetValueByApiValue(ApplyType.getByLabel((String)applyDiscountTo))).build();
    }

    default public ChargeModelInterface getChargeModel(ProductBySkuQuery.Node2 charge) {
        if (charge.getProductrateplanchargetiers().getEdges() == null) {
            throw new NoSuchElementException();
        }
        List tiers = charge.getProductrateplanchargetiers().getEdges().stream().map(tier -> tier.getNode()).collect(Collectors.toList());
        PlanItemEnum.ChargeModel chargeModel = PlanItemEnum.ChargeModel.getChargeModelByName(charge.getChargeModel());
        switch (chargeModel) {
            case FLAT_FEE: {
                return this.getFlatFee(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getPrice())), charge.getListPriceBase());
            }
            case PER_UNIT: {
                return this.getPerUnit(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getPrice())), charge.getListPriceBase(), charge.getUOM(), charge.getDefaultQuantity(), charge.getMaxQuantity(), charge.getMinQuantity());
            }
            case VOLUME: 
            case TIERED: 
            case TIERED_WITH_OVERAGE: 
            case OVERAGE: {
                List<Tiered.Tier> tierList = this.getTiers(new Gson().toJsonTree(tiers.stream().filter(node2 -> node2.getPrice() != null).collect(Collectors.toList())).getAsJsonArray());
                if (chargeModel == PlanItemEnum.ChargeModel.TIERED || chargeModel == PlanItemEnum.ChargeModel.VOLUME) {
                    return this.getTieredorVolume(chargeModel, charge.getUOM(), charge.getDefaultQuantity(), charge.getMaxQuantity(), charge.getMinQuantity(), tierList);
                }
                Map<Currency, Double> unitAmounts = tiers.stream().filter(node2 -> node2.getOveragePrice() != null).collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getOveragePrice()));
                if (chargeModel == PlanItemEnum.ChargeModel.OVERAGE) {
                    return this.getOverage(charge.getIncludedUnits(), charge.getDefaultQuantity(), charge.getUOM(), ((BigDecimal)charge.getNumberOfPeriod()).intValue(), unitAmounts, charge.getSmoothingModel(), charge.getOverageCalculationOption(), charge.getOverageUnusedUnitsCreditOption());
                }
                if (chargeModel == PlanItemEnum.ChargeModel.TIERED_WITH_OVERAGE) {
                    TieredWithOverage tieredWithOverage = (TieredWithOverage)this.getTieredorVolume(chargeModel, charge.getUOM(), charge.getDefaultQuantity(), charge.getMaxQuantity(), charge.getMinQuantity(), tierList);
                    if (unitAmounts != null) {
                        tieredWithOverage.setUnitAmounts(unitAmounts);
                    }
                    return tieredWithOverage;
                }
            }
            case DISCOUNT_FIXED: {
                return this.getDiscountAmount(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getDiscountAmount())), charge.getApplyDiscountTo(), charge.getDiscountLevel());
            }
            case DISCOUNT_PERCENT: {
                return this.getDiscountPercentage(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getDiscountPercentage())), charge.getApplyDiscountTo(), charge.getDiscountLevel());
            }
        }
        return null;
    }

    default public ChargeModelInterface getChargeModel(ProductRatePlanByIdQuery.Node charge) {
        if (charge.getProductrateplanchargetiers().getEdges() == null) {
            throw new NoSuchElementException();
        }
        List tiers = charge.getProductrateplanchargetiers().getEdges().stream().map(tier -> tier.getNode()).collect(Collectors.toList());
        if (tiers == null || tiers.isEmpty()) {
            throw new NoSuchElementException();
        }
        PlanItemEnum.ChargeModel chargeModel = PlanItemEnum.ChargeModel.getChargeModelByName(charge.getChargeModel());
        switch (chargeModel) {
            case FLAT_FEE: {
                return this.getFlatFee(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getPrice())), charge.getListPriceBase());
            }
            case PER_UNIT: {
                return this.getPerUnit(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getPrice())), charge.getListPriceBase(), charge.getUOM(), charge.getDefaultQuantity(), charge.getMaxQuantity(), charge.getMinQuantity());
            }
            case VOLUME: 
            case TIERED: 
            case TIERED_WITH_OVERAGE: 
            case OVERAGE: {
                List<Tiered.Tier> tierList = this.getTiers(new Gson().toJsonTree(tiers.stream().filter(node2 -> node2.getPrice() != null).collect(Collectors.toList())).getAsJsonArray());
                if (chargeModel == PlanItemEnum.ChargeModel.TIERED || chargeModel == PlanItemEnum.ChargeModel.VOLUME) {
                    return this.getTieredorVolume(chargeModel, charge.getUOM(), charge.getDefaultQuantity(), charge.getMaxQuantity(), charge.getMinQuantity(), tierList);
                }
                Map<Currency, Double> unitAmounts = tiers.stream().filter(node2 -> node2.getOveragePrice() != null).collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getOveragePrice()));
                if (chargeModel == PlanItemEnum.ChargeModel.OVERAGE) {
                    return this.getOverage(charge.getIncludedUnits(), charge.getDefaultQuantity(), charge.getUOM(), ((BigDecimal)charge.getNumberOfPeriod()).intValue(), unitAmounts, charge.getSmoothingModel(), charge.getOverageCalculationOption(), charge.getOverageUnusedUnitsCreditOption());
                }
                if (chargeModel == PlanItemEnum.ChargeModel.TIERED_WITH_OVERAGE) {
                    TieredWithOverage tieredWithOverage = (TieredWithOverage)this.getTieredorVolume(chargeModel, charge.getUOM(), charge.getDefaultQuantity(), charge.getMaxQuantity(), charge.getMinQuantity(), tierList);
                    if (unitAmounts != null) {
                        tieredWithOverage.setUnitAmounts(unitAmounts);
                    }
                    return tieredWithOverage;
                }
            }
            case DISCOUNT_FIXED: {
                return this.getDiscountAmount(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getDiscountAmount())), charge.getApplyDiscountTo(), charge.getDiscountLevel());
            }
            case DISCOUNT_PERCENT: {
                return this.getDiscountPercentage(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getDiscountPercentage())), charge.getApplyDiscountTo(), charge.getDiscountLevel());
            }
        }
        return null;
    }

    default public ChargeModelInterface getChargeModel(ProductRatePlanChargeByIdQuery.ProductrateplanchargeById charge) {
        if (charge.getProductrateplanchargetiers().getEdges() == null) {
            throw new NoSuchElementException();
        }
        List tiers = charge.getProductrateplanchargetiers().getEdges().stream().map(tier -> tier.getNode()).collect(Collectors.toList());
        if (tiers.isEmpty()) {
            throw new NoSuchElementException();
        }
        PlanItemEnum.ChargeModel chargeModel = PlanItemEnum.ChargeModel.getChargeModelByName(charge.getChargeModel());
        switch (chargeModel) {
            case FLAT_FEE: {
                return this.getFlatFee(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getPrice())), charge.getListPriceBase());
            }
            case PER_UNIT: {
                return this.getPerUnit(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getPrice())), charge.getListPriceBase(), charge.getUOM(), charge.getDefaultQuantity(), charge.getMaxQuantity(), charge.getMinQuantity());
            }
            case VOLUME: 
            case TIERED: 
            case TIERED_WITH_OVERAGE: 
            case OVERAGE: {
                List<Tiered.Tier> tierList = this.getTiers(new Gson().toJsonTree(tiers.stream().filter(node2 -> node2.getPrice() != null).collect(Collectors.toList())).getAsJsonArray());
                if (chargeModel == PlanItemEnum.ChargeModel.TIERED || chargeModel == PlanItemEnum.ChargeModel.VOLUME) {
                    return this.getTieredorVolume(chargeModel, charge.getUOM(), charge.getDefaultQuantity(), charge.getMaxQuantity(), charge.getMinQuantity(), tierList);
                }
                Map<Currency, Double> unitAmounts = tiers.stream().filter(node2 -> node2.getOveragePrice() != null).collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getOveragePrice()));
                if (chargeModel == PlanItemEnum.ChargeModel.OVERAGE) {
                    return this.getOverage(charge.getIncludedUnits(), charge.getDefaultQuantity(), charge.getUOM(), ((BigDecimal)charge.getNumberOfPeriod()).intValue(), unitAmounts, charge.getSmoothingModel(), charge.getOverageCalculationOption(), charge.getOverageUnusedUnitsCreditOption());
                }
                if (chargeModel == PlanItemEnum.ChargeModel.TIERED_WITH_OVERAGE) {
                    TieredWithOverage tieredWithOverage = (TieredWithOverage)this.getTieredorVolume(chargeModel, charge.getUOM(), charge.getDefaultQuantity(), charge.getMaxQuantity(), charge.getMinQuantity(), tierList);
                    if (unitAmounts != null) {
                        tieredWithOverage.setUnitAmounts(unitAmounts);
                    }
                    return tieredWithOverage;
                }
            }
            case DISCOUNT_FIXED: {
                return this.getDiscountAmount(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getDiscountAmount())), charge.getApplyDiscountTo(), charge.getDiscountLevel());
            }
            case DISCOUNT_PERCENT: {
                return this.getDiscountPercentage(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getDiscountPercentage())), charge.getApplyDiscountTo(), charge.getDiscountLevel());
            }
        }
        return null;
    }

    default public JsonObject getFirstTier(Map<Integer, List<JsonObject>> tierMap, Integer key) {
        List<JsonObject> x = tierMap.get(key);
        if (x == null) {
            throw ZuoraSdkException.builder().build();
        }
        JsonObject firstTier = x.get(0);
        if (firstTier == null) {
            throw ZuoraSdkException.builder().build();
        }
        return firstTier;
    }

    default public List<Tiered.Tier> getTiers(JsonArray tiers) {
        HashMap tierMap = new HashMap();
        tiers.forEach(aTier -> {
            JsonObject tier = aTier.getAsJsonObject();
            if (!tierMap.containsKey(tier.get("tier").getAsInt())) {
                tierMap.put(tier.get("tier").getAsInt(), new ArrayList());
            }
            ((List)tierMap.get(tier.get("tier").getAsInt())).add(tier);
        });
        return tierMap.keySet().stream().map(key -> {
            JsonObject initialTier = this.getFirstTier(tierMap, (Integer)key);
            Tiered.Tier.TierBuilder tierBuilder = Tiered.Tier.tierBuilder().tier((Integer)key);
            if (initialTier.get("endingUnit") != null) {
                tierBuilder.upTo(initialTier.get("endingUnit").getAsDouble());
            }
            if (initialTier.get("startingUnit") != null) {
                tierBuilder.startingUnit(initialTier.get("startingUnit").getAsDouble());
            }
            HashMap amounts = new HashMap();
            String type = initialTier.get("priceFormat").getAsString();
            ((List)tierMap.get(key)).forEach(tier -> amounts.put(Currency.getInstance(tier.get("currency").getAsString()), tier.get("price").getAsDouble()));
            if (type.equals("Flat Fee")) {
                tierBuilder.amounts(amounts);
            } else if (type.equals("Per Unit")) {
                tierBuilder.unitAmounts(amounts);
            } else {
                throw ZuoraSdkException.builder().build();
            }
            return tierBuilder.build();
        }).collect(Collectors.toList());
    }

    default public Subscription fromApi(GETSubscriptionTypeWithSuccess zSubscription, ZAccount subAccount, ZuoraClient client) {
        Subscription subscription2 = Subscription.builder().key(zSubscription.subscriptionNumber()).id(zSubscription.id()).state(Subscription.State.getByLabel(zSubscription.status())).initialTerm(Term.builder().type(Term.TermType.valueOf(zSubscription.termType())).intervalCount(zSubscription.initialTerm()).interval(zSubscription.initialTermPeriodType()).build()).currentTerm(Term.builder().type(Term.TermType.valueOf(zSubscription.termType())).intervalCount(zSubscription.currentTerm()).interval(zSubscription.currentTermPeriodType()).startDate(LocalDate.parse(zSubscription.termStartDate())).endDate(zSubscription.termEndDate() == null ? null : LocalDate.parse(zSubscription.termEndDate())).build()).startDate(zSubscription.subscriptionStartDate() == null ? null : LocalDate.parse(zSubscription.subscriptionStartDate())).endDate(zSubscription.subscriptionEndDate() == null ? null : LocalDate.parse(zSubscription.subscriptionEndDate())).termEndDate(zSubscription.termEndDate() == null ? null : LocalDate.parse(zSubscription.termEndDate())).termStartDate(LocalDate.parse(zSubscription.termStartDate())).description(zSubscription.notes()).contractEffective(LocalDate.parse(zSubscription.contractEffectiveDate())).serviceActivation(LocalDate.parse(zSubscription.serviceActivationDate())).customerAcceptance(LocalDate.parse(zSubscription.customerAcceptanceDate())).invoiceSeparately(zSubscription.invoiceSeparately().equals("true")).invoiceAccount(this.toAccount(subAccount, client)).account(this.toAccount(subAccount, client)).mrr(zSubscription.contractedMrr()).tcv(zSubscription.totalContractedValue()).client(client).build();
        if (zSubscription.renewalSetting().equalsIgnoreCase("RENEW_WITH_SPECIFIC_TERM")) {
            subscription2 = subscription2.toBuilder().renewalTerm(Term.builder().type(Term.TermType.valueOf(zSubscription.termType())).intervalCount(zSubscription.renewalTerm()).interval(zSubscription.renewalTermPeriodType()).build()).build();
        }
        return subscription2;
    }

    default public Subscription fromApi(ZSubscription zSubscription, ZuoraClient client) {
        Account account2 = client.accounts().get(zSubscription.accountId());
        Account invAccount = client.accounts().get(zSubscription.invoiceOwnerId());
        Subscription subscription2 = Subscription.builder().key(zSubscription.name()).id(zSubscription.id()).state(Subscription.State.getByLabel(zSubscription.status().getApiValue())).initialTerm(Term.builder().type(Term.TermType.valueOf(zSubscription.termType().name())).intervalCount(zSubscription.initialTerm()).interval(zSubscription.initialTermPeriodType().name().toLowerCase()).build()).currentTerm(Term.builder().type(Term.TermType.valueOf(zSubscription.termType().name())).intervalCount(zSubscription.currentTerm()).interval(zSubscription.currentTermPeriodType().name().toLowerCase()).startDate(Tools.toLocalDate((String)zSubscription.termStartDate())).endDate(Tools.toLocalDate((String)zSubscription.termEndDate())).build()).startDate(Tools.toLocalDate((String)zSubscription.subscriptionStartDate())).endDate(Tools.toLocalDate((String)zSubscription.subscriptionEndDate())).termEndDate(Tools.toLocalDate((String)zSubscription.termEndDate())).termStartDate(Tools.toLocalDate((String)zSubscription.termStartDate())).description(zSubscription.notes()).contractEffective(Tools.toLocalDate((String)zSubscription.contractEffectiveDate())).serviceActivation(Tools.toLocalDate((String)zSubscription.serviceActivationDate())).customerAcceptance(Tools.toLocalDate((String)zSubscription.contractAcceptanceDate())).invoiceSeparately(zSubscription.invoiceSeparately()).invoiceAccount(invAccount).account(account2).version(zSubscription.version()).mrr(zSubscription.contractedMrr()).tcv(zSubscription.totalContractedValue()).canceledDate(Tools.toLocalDate((String)zSubscription.cancelledDate())).createdBy(zSubscription.createdById()).createTime(ZonedDateTime.parse(zSubscription.createdDate())).updatedBy(zSubscription.updatedById()).updateTime(ZonedDateTime.parse(zSubscription.updatedDate())).autoRenew(zSubscription.autoRenew()).customFields(zSubscription.subscriptionObjectCustomFields()).client(client).build();
        if (zSubscription.renewalSetting().name().equalsIgnoreCase("RENEW_WITH_SPECIFIC_TERM")) {
            subscription2 = subscription2.toBuilder().renewalTerm(Term.builder().type(Term.TermType.valueOf(zSubscription.termType().name())).intervalCount(zSubscription.renewalTerm()).interval(zSubscription.renewalTermPeriodType().name().toLowerCase()).build()).build();
        }
        return subscription2;
    }

    default public List<SubscriptionPlanItem> getSubscriptionPlanItems(List<RatePlansBySubscriptionIdQuery.Edge1> ratePlanCharges) {
        if (ratePlanCharges == null) {
            return Collections.EMPTY_LIST;
        }
        return ratePlanCharges.stream().map(charge -> SubscriptionPlanItem.builder().id(charge.getNode().getId()).name(charge.getNode().getName()).startEvent(PlanItemEnum.Event.getEventByName(charge.getNode().getTriggerEvent())).chargeModel(this.getChargeModel(charge.getNode())).planItemType(PlanItemType.ItemType.getByLabel(charge.getNode().getChargeType())).on(PlanItemEnum.RecurringOn.getBillCycleTypeByName(charge.getNode().getBillCycleType())).interval(PlanItemEnum.Interval.getIntervalByName(charge.getNode().getBillingPeriod())).alignment(PlanItemEnum.Alignment.getByLabel(charge.getNode().getBillingPeriodAlignment())).timing(BillingTiming.getByLabel((String)charge.getNode().getBillingTiming())).invoicedThroughDate(charge.getNode().getChargedThroughDate() == null ? null : LocalDate.parse(charge.getNode().getChargedThroughDate())).description(charge.getNode().getDescription()).done(charge.getNode().isProcessed()).endDate(charge.getNode().getEffectiveEndDate() == null ? null : LocalDate.parse(charge.getNode().getEffectiveEndDate())).startDate(LocalDate.parse(charge.getNode().getEffectiveStartDate())).durationInterval(PlanItemEnum.Interval.getIntervalByName(charge.getNode().getUpToPeriodsType())).durationIntervalCount(charge.getNode().getUpToPeriods() == null ? null : Integer.valueOf(charge.getNode().getUpToPeriods().toString())).number(charge.getNode().getChargeNumber()).processedThroughDate(charge.getNode().getProcessedThroughDate() == null ? null : LocalDate.parse(charge.getNode().getProcessedThroughDate())).segment(charge.getNode().getSegment()).version(Integer.valueOf(charge.getNode().getVersion().toString())).createdBy(charge.getNode().getCreatedById()).createTime(ZonedDateTime.parse(charge.getNode().getCreatedDate())).updatedBy(charge.getNode().getUpdatedById()).updateTime(ZonedDateTime.parse(charge.getNode().getUpdatedDate())).subscriptionPlan(charge.getNode().getRatePlanId()).planItem(charge.getNode().getProductRatePlanChargeId()).build()).collect(Collectors.toList());
    }

    default public ChargeModelInterface getChargeModel(RatePlansBySubscriptionIdQuery.Node1 charge) {
        List tiers = charge.getRateplanchargetiers().getEdges().stream().map(tier -> tier.getNode()).collect(Collectors.toList());
        if (tiers == null || tiers.isEmpty()) {
            throw new NoSuchElementException();
        }
        PlanItemEnum.ChargeModel chargeModel = PlanItemEnum.ChargeModel.getChargeModelByName(charge.getChargeModel());
        switch (chargeModel) {
            case FLAT_FEE: {
                return this.getFlatFee(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getPrice())), charge.getListPriceBase());
            }
            case PER_UNIT: {
                return this.getPerUnit(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getPrice())), charge.getListPriceBase(), charge.getUOM(), charge.getQuantity(), null, null);
            }
            case VOLUME: 
            case TIERED: 
            case TIERED_WITH_OVERAGE: 
            case OVERAGE: {
                List<Tiered.Tier> tierList = this.getTiers(new Gson().toJsonTree(tiers.stream().filter(node2 -> node2.getPrice() != null).collect(Collectors.toList())).getAsJsonArray());
                if (chargeModel == PlanItemEnum.ChargeModel.TIERED || chargeModel == PlanItemEnum.ChargeModel.VOLUME) {
                    return this.getTieredorVolume(chargeModel, charge.getUOM(), charge.getQuantity(), null, null, tierList);
                }
                Map<Currency, Double> unitAmounts = tiers.stream().filter(node2 -> node2.getOveragePrice() != null).collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getOveragePrice()));
                if (chargeModel == PlanItemEnum.ChargeModel.OVERAGE) {
                    return this.getOverage(null, charge.getQuantity(), charge.getUOM(), ((BigDecimal)charge.getNumberOfPeriods()).intValue(), unitAmounts, null, charge.getOverageCalculationOption(), charge.getOverageUnusedUnitsCreditOption());
                }
                if (chargeModel == PlanItemEnum.ChargeModel.TIERED_WITH_OVERAGE) {
                    TieredWithOverage tieredWithOverage = (TieredWithOverage)this.getTieredorVolume(chargeModel, charge.getUOM(), charge.getQuantity(), null, null, tierList);
                    if (unitAmounts != null) {
                        tieredWithOverage.setUnitAmounts(unitAmounts);
                    }
                    return tieredWithOverage;
                }
            }
            case DISCOUNT_FIXED: {
                return this.getDiscountAmount(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getDiscountAmount())), charge.getApplyDiscountTo(), charge.getDiscountLevel());
            }
            case DISCOUNT_PERCENT: {
                return this.getDiscountPercentage(tiers.stream().collect(Collectors.toMap(item -> Currency.getInstance(item.getCurrency()), item -> item.getDiscountPercentage())), charge.getApplyDiscountTo(), charge.getDiscountLevel());
            }
        }
        return null;
    }

    @Mappings(value={@Mapping(source="account", target="accountId"), @Mapping(source="statementDescriptor", target="softDescriptor"), @Mapping(expression="java(Boolean.TRUE.equals(refundCreateRequest.getExternal()) ? com.zuora.sdk.core.models.enums.RefundType.EXTERNAL : com.zuora.sdk.core.models.enums.RefundType.ELECTRONIC)", target="type"), @Mapping(source="reference", target="referenceId"), @Mapping(source="date", target="refundDate"), @Mapping(source="description", target="comment"), @Mapping(source="reason", target="reasonCode"), @Mapping(source="paymentId", target="paymentId"), @Mapping(expression="java(refundCreateRequest.getType().getApiType())", target="methodType"), @Mapping(source="customFields", target="refundObjectCustomFields")})
    public ZRefund.Builder toApi(RefundCreateRequest var1);

    default public Refund fromApi(ZRefund zRefund, ZuoraClient client) {
        ZoneId tenantZoneId = client.getContext().getEntityProfileInfo().tenantZoneId();
        return Refund.builder().account(zRefund.accountId()).amount(zRefund.amount()).cancelTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zRefund.cancelledOn())).description(zRefund.comment()).createdBy(zRefund.createdById()).createTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zRefund.createdDate())).creditMemo(zRefund.creditMemoId()).transferredToAccounting(zRefund.financeInformation() == null ? null : TransferredToAccounting.getByLabel((String)zRefund.financeInformation().transferredToAccounting())).gateway(zRefund.gatewayId()).id(zRefund.id()).type(MethodType.fromApi(zRefund.methodType())).name(zRefund.number()).paymentMethod(zRefund.paymentMethodId() == null ? null : client.paymentMethods().get(zRefund.paymentMethodId())).paymentMethodSnapshot(zRefund.paymentMethodSnapshotId() == null ? null : client.paymentMethods().get(zRefund.paymentMethodSnapshotId())).payoutId(zRefund.payoutId()).reason(zRefund.reasonCode()).reference(zRefund.referenceId()).date(Tools.toLocalDate((String)zRefund.refundDate())).statementDescriptor(zRefund.softDescriptor()).state(RefundState.fromApi(zRefund.status())).external(RefundType.EXTERNAL.equals((Object)zRefund.type())).updatedBy(zRefund.updatedById()).updateTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zRefund.updatedDate())).customFields(zRefund.refundObjectCustomFields()).build();
    }

    @Mappings(value={@Mapping(source="account", target="accountId"), @Mapping(source="authorisationCode", target="authTransactionId"), @Mapping(source="description", target="comment"), @Mapping(source="date", target="effectiveDate"), @Mapping(source="gateway", target="gatewayId"), @Mapping(source="reference", target="referenceId"), @Mapping(source="statementDescriptor", target="softDescriptor"), @Mapping(source="paymentMethod", target="paymentMethodId"), @Mapping(source="customFields", target="paymentObjectCustomFields"), @Mapping(target="financeInformation", ignore=true)})
    public ZPayment.Builder toApi(PaymentCreateRequest var1);

    default public Payment fromApi(ZPayment zPayment, ZuoraClient client) {
        ZoneId tenantZoneId = client.getContext().getEntityProfileInfo().tenantZoneId();
        Payment.PaymentBuilder paymentBuilder = Payment.builder();
        paymentBuilder.id(zPayment.id());
        paymentBuilder.amount(zPayment.amount());
        paymentBuilder.currency(zPayment.currency());
        paymentBuilder.softDescriptorPhone(zPayment.softDescriptorPhone());
        paymentBuilder.secondPaymentReferenceId(zPayment.secondPaymentReferenceId());
        paymentBuilder.payoutId(zPayment.payoutId());
        paymentBuilder.markedForSubmissionOn(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zPayment.markedForSubmissionOn()));
        paymentBuilder.gatewayResponseCode(zPayment.gatewayResponseCode());
        paymentBuilder.gatewayReconciliationStatus(zPayment.gatewayReconciliationStatus());
        paymentBuilder.gatewayReconciliationReason(zPayment.gatewayReconciliationReason());
        paymentBuilder.gatewayOrderId(zPayment.gatewayOrderId());
        paymentBuilder.account(zPayment.accountId());
        paymentBuilder.authorisationCode(zPayment.authTransactionId());
        paymentBuilder.description(zPayment.comment());
        paymentBuilder.date(zPayment.effectiveDate() == null ? null : LocalDate.parse(zPayment.effectiveDate()));
        paymentBuilder.gateway(zPayment.gatewayId());
        paymentBuilder.reference(zPayment.referenceId());
        paymentBuilder.statementDescriptor(zPayment.softDescriptor());
        paymentBuilder.customFields(zPayment.paymentObjectCustomFields());
        paymentBuilder.amountApplied(zPayment.appliedAmount());
        paymentBuilder.amountUnapplied(zPayment.unappliedAmount());
        paymentBuilder.name(zPayment.number());
        paymentBuilder.createdBy(zPayment.createdById());
        paymentBuilder.createTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zPayment.createdDate()));
        paymentBuilder.updatedBy(zPayment.updatedById());
        paymentBuilder.updateTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zPayment.updatedDate()));
        paymentBuilder.state(zPayment.status());
        paymentBuilder.amountRefunded(zPayment.refundAmount());
        paymentBuilder.cancelTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zPayment.cancelledOn()));
        paymentBuilder.submitTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)zPayment.submittedOn()));
        if (zPayment.type() == PaymentType.EXTERNAL) {
            paymentBuilder.external(true);
        } else {
            paymentBuilder.external(false);
        }
        if (zPayment.Z_FinanceInformation() != null) {
            Payment.PaymentFinanceInformation.PaymentFinanceInformationBuilder paymentFinanceInformation = Payment.PaymentFinanceInformation.builder();
            paymentFinanceInformation.bankAccountAccountingCode(zPayment.Z_FinanceInformation().bankAccountAccountingCode());
            paymentFinanceInformation.transferredToAccounting(TransferredToAccounting.getByLabel((String)zPayment.Z_FinanceInformation().transferredToAccounting()));
            paymentFinanceInformation.unappliedPaymentAccountingCode(zPayment.Z_FinanceInformation().unappliedPaymentAccountingCode());
            paymentFinanceInformation.bankAccountAccountingCodeType(AccountingCodeType.getByLabel((String)zPayment.Z_FinanceInformation().bankAccountAccountingCodeType()));
            paymentFinanceInformation.unappliedPaymentAccountingCodeType(AccountingCodeType.getByLabel((String)zPayment.Z_FinanceInformation().unappliedPaymentAccountingCodeType()));
            paymentBuilder.financeInformation(paymentFinanceInformation.build());
        }
        return paymentBuilder.build();
    }

    default public PaymentMethod.PaymentMethodBuilder fromApi(GETPaymentMethodResponse rawPaymentMethod) {
        PaymentMethodType type;
        PaymentMethod.PaymentMethodBuilder builder = new PaymentMethod.PaymentMethodBuilder();
        BillingDetails.BillingDetailsBuilder billingDetails = null;
        if (rawPaymentMethod.accountHolderInfo() != null) {
            Address address = Address.builder().city(rawPaymentMethod.accountHolderInfo().city()).country(rawPaymentMethod.accountHolderInfo().country()).state(rawPaymentMethod.accountHolderInfo().state()).postalCode(rawPaymentMethod.accountHolderInfo().zipCode()).line1(rawPaymentMethod.accountHolderInfo().addressLine1()).line2(rawPaymentMethod.accountHolderInfo().addressLine2()).build();
            billingDetails = BillingDetails.builder().email(rawPaymentMethod.accountHolderInfo().email()).name(rawPaymentMethod.accountHolderInfo().accountHolderName()).phone(rawPaymentMethod.accountHolderInfo().phone());
            billingDetails.address(address);
        }
        builder.id(rawPaymentMethod.id()).accountKey(rawPaymentMethod.accountKey()).accountName(rawPaymentMethod.bankAccountName()).accountNumber(rawPaymentMethod.accountNumber()).accountType(BankAccountType.fromApi(rawPaymentMethod.bankAccountType())).identityNumber(rawPaymentMethod.identityNumber()).bankName(rawPaymentMethod.bankName()).bankCode(rawPaymentMethod.bankCode()).branchCode(rawPaymentMethod.branchCode()).type(PaymentMethodType.fromApi(rawPaymentMethod.type())).state(PaymentMethodState.fromApi(rawPaymentMethod.status())).billingDetails(billingDetails == null ? null : billingDetails.build()).email(rawPaymentMethod.email()).businessIdentificationCode(rawPaymentMethod.businessIdentificationCode()).IBAN(rawPaymentMethod.iBAN()).identityNumber(rawPaymentMethod.identityNumber()).preapprovalKey(rawPaymentMethod.preapprovalKey()).isDefault(Boolean.TRUE.equals(rawPaymentMethod.isDefault())).customFields(rawPaymentMethod.paymentMethodObjectCustomFields());
        if (rawPaymentMethod.mandateInfo() != null) {
            POSTPMMandateInfo mandateInfo = rawPaymentMethod.mandateInfo();
            builder.mitConsentAgreementRef(mandateInfo.mitConsentAgreementRef()).mitConsentAgreementSrc(MitConsentAgreementSrc.fromApi(mandateInfo.mitConsentAgreementSrc())).mitNetworkTransactionId(mandateInfo.mitTransactionId()).mitProfileAction(MitProfileAction.fromApi(mandateInfo.mitProfileAction())).mitProfileType(MitProfileType.fromApi(mandateInfo.mitProfileType())).mitProfileAgreementOn(mandateInfo.mitProfileAgreedOn()).mandateId(mandateInfo.mandateId()).mandateReceivedStatus(mandateInfo.mandateReceivedStatus()).existingMandateStatus(mandateInfo.existingMandateStatus()).mandateCreationDate(mandateInfo.mandateCreationDate()).mandateUpdateDate(mandateInfo.mandateUpdateDate()).mandateReason(mandateInfo.mandateReason()).mandateStatus(mandateInfo.mandateStatus());
        }
        if (PaymentMethodType.CARD.equals((Object)(type = PaymentMethodType.fromApi(rawPaymentMethod.type())))) {
            CreditCard creditCard = CreditCard.builder().number(rawPaymentMethod.cardNumber()).brand(rawPaymentMethod.cardType()).expiryMonth(rawPaymentMethod.expirationMonth()).expiryYear(rawPaymentMethod.expirationYear()).build();
            builder.card(creditCard);
        } else if (PaymentMethodType.ACH_DEBIT.equals((Object)type)) {
            builder.accountNumber(rawPaymentMethod.bankAccountNumber());
        }
        return builder;
    }

    default public Payment fromApi(GETARPaymentTypewithSuccess rawPayment, APIContext context) {
        ZoneId tenantZoneId = context.getEntityProfileInfo().tenantZoneId();
        Payment.PaymentBuilder paymentBuilder = Payment.builder();
        paymentBuilder.id(rawPayment.id());
        paymentBuilder.amount(rawPayment.amount());
        paymentBuilder.currency(rawPayment.currency());
        paymentBuilder.softDescriptorPhone(rawPayment.softDescriptorPhone());
        paymentBuilder.secondPaymentReferenceId(rawPayment.secondPaymentReferenceId());
        paymentBuilder.payoutId(rawPayment.payoutId());
        paymentBuilder.markedForSubmissionOn(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)rawPayment.markedForSubmissionOn()));
        paymentBuilder.gatewayResponseCode(rawPayment.gatewayResponseCode());
        paymentBuilder.gatewayReconciliationStatus(rawPayment.gatewayReconciliationStatus());
        paymentBuilder.gatewayReconciliationReason(rawPayment.gatewayReconciliationReason());
        paymentBuilder.gatewayOrderId(rawPayment.gatewayOrderId());
        paymentBuilder.account(rawPayment.accountId());
        paymentBuilder.authorisationCode(rawPayment.authTransactionId());
        paymentBuilder.description(rawPayment.comment());
        paymentBuilder.date(rawPayment.effectiveDate() == null ? null : LocalDate.parse(rawPayment.effectiveDate()));
        paymentBuilder.gateway(rawPayment.gatewayId());
        paymentBuilder.reference(rawPayment.referenceId());
        paymentBuilder.statementDescriptor(rawPayment.softDescriptor());
        paymentBuilder.customFields(rawPayment.paymentObjectCustomFields());
        paymentBuilder.amountApplied(rawPayment.appliedAmount());
        paymentBuilder.amountUnapplied(rawPayment.unappliedAmount());
        paymentBuilder.name(rawPayment.number());
        paymentBuilder.createdBy(rawPayment.createdById());
        paymentBuilder.createTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)rawPayment.createdDate()));
        paymentBuilder.updatedBy(rawPayment.updatedById());
        paymentBuilder.updateTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)rawPayment.updatedDate()));
        paymentBuilder.state(rawPayment.status() == null ? null : PaymentStatus.getByLabel((String)rawPayment.status()));
        paymentBuilder.amountRefunded(rawPayment.refundAmount());
        paymentBuilder.cancelTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)rawPayment.cancelledOn()));
        paymentBuilder.submitTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)rawPayment.submittedOn()));
        if (PaymentType.EXTERNAL.getApiValue().equals(rawPayment.type())) {
            paymentBuilder.external(true);
        } else {
            paymentBuilder.external(false);
        }
        if (rawPayment.financeInformation() != null) {
            Payment.PaymentFinanceInformation.PaymentFinanceInformationBuilder paymentFinanceInformation = Payment.PaymentFinanceInformation.builder();
            paymentFinanceInformation.bankAccountAccountingCode(rawPayment.financeInformation().bankAccountAccountingCode());
            paymentFinanceInformation.transferredToAccounting(TransferredToAccounting.getByLabel((String)rawPayment.financeInformation().transferredToAccounting()));
            paymentFinanceInformation.unappliedPaymentAccountingCode(rawPayment.financeInformation().unappliedPaymentAccountingCode());
            paymentFinanceInformation.bankAccountAccountingCodeType(AccountingCodeType.getByLabel((String)rawPayment.financeInformation().bankAccountAccountingCodeType()));
            paymentFinanceInformation.unappliedPaymentAccountingCodeType(AccountingCodeType.getByLabel((String)rawPayment.financeInformation().unappliedPaymentAccountingCodeType()));
            paymentBuilder.financeInformation(paymentFinanceInformation.build());
        }
        return paymentBuilder.build();
    }
}

