/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.CreatePaymentRunRequest;
import com.zuora.model.GetPaymentRunDataArrayResponse;
import com.zuora.model.GetPaymentRunSummaryResponse;
import com.zuora.model.GetPaymentRunsResponse;
import com.zuora.model.PaymentRunResponse;
import com.zuora.model.UpdatePaymentRunRequest;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class PaymentRunsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentRunsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentRunsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createPaymentRunCall(CreatePaymentRunRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreatePaymentRunRequest localVarPostBody = body;
        String localVarPath = "/v1/payment-runs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPaymentRunValidateBeforeCall(CreatePaymentRunRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createPaymentRun(Async)");
        }
        return this.createPaymentRunCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected PaymentRunResponse createPaymentRun(CreatePaymentRunRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<PaymentRunResponse> localVarResp = this.createPaymentRunWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentRunResponse> createPaymentRunWithHttpInfo(CreatePaymentRunRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.createPaymentRunValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<PaymentRunResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createPaymentRunAsync(CreatePaymentRunRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<PaymentRunResponse> _callback) throws ApiException {
        Call localVarCall = this.createPaymentRunValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<PaymentRunResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreatePaymentRunApi createPaymentRunApi(CreatePaymentRunRequest body) {
        return new CreatePaymentRunApi(body);
    }

    private Call deletePaymentRunCall(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-runs/{paymentRunKey}".replace("{paymentRunKey}", this.localVarApiClient.escapeString(paymentRunKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deletePaymentRunValidateBeforeCall(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (paymentRunKey == null) {
            throw new ApiException("Missing the required parameter 'paymentRunKey' when calling deletePaymentRun(Async)");
        }
        return this.deletePaymentRunCall(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected CommonResponse deletePaymentRun(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.deletePaymentRunWithHttpInfo(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> deletePaymentRunWithHttpInfo(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.deletePaymentRunValidateBeforeCall(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deletePaymentRunAsync(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.deletePaymentRunValidateBeforeCall(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeletePaymentRunApi deletePaymentRunApi(String paymentRunKey) {
        return new DeletePaymentRunApi(paymentRunKey);
    }

    private Call getPaymentRunCall(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-runs/{paymentRunKey}".replace("{paymentRunKey}", this.localVarApiClient.escapeString(paymentRunKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentRunValidateBeforeCall(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (paymentRunKey == null) {
            throw new ApiException("Missing the required parameter 'paymentRunKey' when calling getPaymentRun(Async)");
        }
        return this.getPaymentRunCall(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected PaymentRunResponse getPaymentRun(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<PaymentRunResponse> localVarResp = this.getPaymentRunWithHttpInfo(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentRunResponse> getPaymentRunWithHttpInfo(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getPaymentRunValidateBeforeCall(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<PaymentRunResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPaymentRunAsync(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<PaymentRunResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentRunValidateBeforeCall(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<PaymentRunResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentRunApi getPaymentRunApi(String paymentRunKey) {
        return new GetPaymentRunApi(paymentRunKey);
    }

    private Call getPaymentRunDataCall(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-runs/{paymentRunKey}/data".replace("{paymentRunKey}", this.localVarApiClient.escapeString(paymentRunKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentRunDataValidateBeforeCall(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (paymentRunKey == null) {
            throw new ApiException("Missing the required parameter 'paymentRunKey' when calling getPaymentRunData(Async)");
        }
        return this.getPaymentRunDataCall(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected GetPaymentRunDataArrayResponse getPaymentRunData(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<GetPaymentRunDataArrayResponse> localVarResp = this.getPaymentRunDataWithHttpInfo(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentRunDataArrayResponse> getPaymentRunDataWithHttpInfo(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getPaymentRunDataValidateBeforeCall(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<GetPaymentRunDataArrayResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPaymentRunDataAsync(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<GetPaymentRunDataArrayResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentRunDataValidateBeforeCall(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentRunDataArrayResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentRunDataApi getPaymentRunDataApi(String paymentRunKey) {
        return new GetPaymentRunDataApi(paymentRunKey);
    }

    private Call getPaymentRunSummaryCall(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-runs/{paymentRunKey}/summary".replace("{paymentRunKey}", this.localVarApiClient.escapeString(paymentRunKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentRunSummaryValidateBeforeCall(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (paymentRunKey == null) {
            throw new ApiException("Missing the required parameter 'paymentRunKey' when calling getPaymentRunSummary(Async)");
        }
        return this.getPaymentRunSummaryCall(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected GetPaymentRunSummaryResponse getPaymentRunSummary(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<GetPaymentRunSummaryResponse> localVarResp = this.getPaymentRunSummaryWithHttpInfo(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentRunSummaryResponse> getPaymentRunSummaryWithHttpInfo(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getPaymentRunSummaryValidateBeforeCall(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<GetPaymentRunSummaryResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPaymentRunSummaryAsync(String paymentRunKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<GetPaymentRunSummaryResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentRunSummaryValidateBeforeCall(paymentRunKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentRunSummaryResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentRunSummaryApi getPaymentRunSummaryApi(String paymentRunKey) {
        return new GetPaymentRunSummaryApi(paymentRunKey);
    }

    private Call getPaymentRunsCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String createdById, OffsetDateTime createdDate, String status, LocalDate targetDate, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-runs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (createdById != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdById", createdById));
        }
        if (createdDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createdDate", createdDate));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (targetDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("targetDate", targetDate));
        }
        if (updatedById != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedById", updatedById));
        }
        if (updatedDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("updatedDate", updatedDate));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentRunsValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String createdById, OffsetDateTime createdDate, String status, LocalDate targetDate, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        return this.getPaymentRunsCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, createdById, createdDate, status, targetDate, updatedById, updatedDate, sort, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected GetPaymentRunsResponse getPaymentRuns(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String createdById, OffsetDateTime createdDate, String status, LocalDate targetDate, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<GetPaymentRunsResponse> localVarResp = this.getPaymentRunsWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, createdById, createdDate, status, targetDate, updatedById, updatedDate, sort, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentRunsResponse> getPaymentRunsWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String createdById, OffsetDateTime createdDate, String status, LocalDate targetDate, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.getPaymentRunsValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, createdById, createdDate, status, targetDate, updatedById, updatedDate, sort, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<GetPaymentRunsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPaymentRunsAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String createdById, OffsetDateTime createdDate, String status, LocalDate targetDate, String updatedById, OffsetDateTime updatedDate, String sort, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<GetPaymentRunsResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentRunsValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, createdById, createdDate, status, targetDate, updatedById, updatedDate, sort, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentRunsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentRunsApi getPaymentRunsApi() {
        return new GetPaymentRunsApi();
    }

    private Call updatePaymentRunCall(String paymentRunKey, UpdatePaymentRunRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdatePaymentRunRequest localVarPostBody = body;
        String localVarPath = "/v1/payment-runs/{paymentRunKey}".replace("{paymentRunKey}", this.localVarApiClient.escapeString(paymentRunKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("Zuora-Working-Org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePaymentRunValidateBeforeCall(String paymentRunKey, UpdatePaymentRunRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback _callback) throws ApiException {
        if (paymentRunKey == null) {
            throw new ApiException("Missing the required parameter 'paymentRunKey' when calling updatePaymentRun(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatePaymentRun(Async)");
        }
        return this.updatePaymentRunCall(paymentRunKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
    }

    protected PaymentRunResponse updatePaymentRun(String paymentRunKey, UpdatePaymentRunRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        ApiResponse<PaymentRunResponse> localVarResp = this.updatePaymentRunWithHttpInfo(paymentRunKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentRunResponse> updatePaymentRunWithHttpInfo(String paymentRunKey, UpdatePaymentRunRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg) throws ApiException {
        Call localVarCall = this.updatePaymentRunValidateBeforeCall(paymentRunKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, null);
        Type localVarReturnType = new TypeToken<PaymentRunResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updatePaymentRunAsync(String paymentRunKey, UpdatePaymentRunRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, String zuoraWorkingOrg, ApiCallback<PaymentRunResponse> _callback) throws ApiException {
        Call localVarCall = this.updatePaymentRunValidateBeforeCall(paymentRunKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, zuoraWorkingOrg, _callback);
        Type localVarReturnType = new TypeToken<PaymentRunResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdatePaymentRunApi updatePaymentRunApi(String paymentRunKey, UpdatePaymentRunRequest body) {
        return new UpdatePaymentRunApi(paymentRunKey, body);
    }

    public class UpdatePaymentRunApi {
        private final String paymentRunKey;
        private final UpdatePaymentRunRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private UpdatePaymentRunApi(String paymentRunKey, UpdatePaymentRunRequest body) {
            this.paymentRunKey = paymentRunKey;
            this.body = body;
        }

        public UpdatePaymentRunApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdatePaymentRunApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdatePaymentRunApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdatePaymentRunApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdatePaymentRunApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdatePaymentRunApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdatePaymentRunApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public UpdatePaymentRunApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentRunsApi.this.updatePaymentRunCall(this.paymentRunKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public PaymentRunResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentRunsApi.this.updatePaymentRunWithHttpInfo(this.paymentRunKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (PaymentRunResponse)localVarResp.getData();
        }

        private ApiResponse<PaymentRunResponse> executeWithHttpInfo() throws ApiException {
            return PaymentRunsApi.this.updatePaymentRunWithHttpInfo(this.paymentRunKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<PaymentRunResponse> _callback) throws ApiException {
            return PaymentRunsApi.this.updatePaymentRunAsync(this.paymentRunKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetPaymentRunsApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String createdById;
        private OffsetDateTime createdDate;
        private String status;
        private LocalDate targetDate;
        private String updatedById;
        private OffsetDateTime updatedDate;
        private String sort;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetPaymentRunsApi() {
        }

        public GetPaymentRunsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentRunsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentRunsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentRunsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentRunsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentRunsApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetPaymentRunsApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetPaymentRunsApi createdById(String createdById) {
            this.createdById = createdById;
            return this;
        }

        public GetPaymentRunsApi createdDate(OffsetDateTime createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public GetPaymentRunsApi status(String status) {
            this.status = status;
            return this;
        }

        public GetPaymentRunsApi targetDate(LocalDate targetDate) {
            this.targetDate = targetDate;
            return this;
        }

        public GetPaymentRunsApi updatedById(String updatedById) {
            this.updatedById = updatedById;
            return this;
        }

        public GetPaymentRunsApi updatedDate(OffsetDateTime updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public GetPaymentRunsApi sort(String sort) {
            this.sort = sort;
            return this;
        }

        public GetPaymentRunsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentRunsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetPaymentRunsApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentRunsApi.this.getPaymentRunsCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.createdById, this.createdDate, this.status, this.targetDate, this.updatedById, this.updatedDate, this.sort, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public GetPaymentRunsResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentRunsApi.this.getPaymentRunsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.createdById, this.createdDate, this.status, this.targetDate, this.updatedById, this.updatedDate, this.sort, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (GetPaymentRunsResponse)localVarResp.getData();
        }

        private ApiResponse<GetPaymentRunsResponse> executeWithHttpInfo() throws ApiException {
            return PaymentRunsApi.this.getPaymentRunsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.createdById, this.createdDate, this.status, this.targetDate, this.updatedById, this.updatedDate, this.sort, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<GetPaymentRunsResponse> _callback) throws ApiException {
            return PaymentRunsApi.this.getPaymentRunsAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.createdById, this.createdDate, this.status, this.targetDate, this.updatedById, this.updatedDate, this.sort, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetPaymentRunSummaryApi {
        private final String paymentRunKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetPaymentRunSummaryApi(String paymentRunKey) {
            this.paymentRunKey = paymentRunKey;
        }

        public GetPaymentRunSummaryApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentRunSummaryApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentRunSummaryApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentRunSummaryApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentRunSummaryApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentRunSummaryApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetPaymentRunSummaryApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentRunsApi.this.getPaymentRunSummaryCall(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public GetPaymentRunSummaryResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentRunsApi.this.getPaymentRunSummaryWithHttpInfo(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (GetPaymentRunSummaryResponse)localVarResp.getData();
        }

        private ApiResponse<GetPaymentRunSummaryResponse> executeWithHttpInfo() throws ApiException {
            return PaymentRunsApi.this.getPaymentRunSummaryWithHttpInfo(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<GetPaymentRunSummaryResponse> _callback) throws ApiException {
            return PaymentRunsApi.this.getPaymentRunSummaryAsync(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetPaymentRunDataApi {
        private final String paymentRunKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetPaymentRunDataApi(String paymentRunKey) {
            this.paymentRunKey = paymentRunKey;
        }

        public GetPaymentRunDataApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentRunDataApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentRunDataApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentRunDataApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentRunDataApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentRunDataApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetPaymentRunDataApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentRunsApi.this.getPaymentRunDataCall(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public GetPaymentRunDataArrayResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentRunsApi.this.getPaymentRunDataWithHttpInfo(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (GetPaymentRunDataArrayResponse)localVarResp.getData();
        }

        private ApiResponse<GetPaymentRunDataArrayResponse> executeWithHttpInfo() throws ApiException {
            return PaymentRunsApi.this.getPaymentRunDataWithHttpInfo(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<GetPaymentRunDataArrayResponse> _callback) throws ApiException {
            return PaymentRunsApi.this.getPaymentRunDataAsync(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class GetPaymentRunApi {
        private final String paymentRunKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private GetPaymentRunApi(String paymentRunKey) {
            this.paymentRunKey = paymentRunKey;
        }

        public GetPaymentRunApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentRunApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentRunApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentRunApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentRunApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentRunApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetPaymentRunApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public GetPaymentRunApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentRunsApi.this.getPaymentRunCall(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public PaymentRunResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentRunsApi.this.getPaymentRunWithHttpInfo(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (PaymentRunResponse)localVarResp.getData();
        }

        private ApiResponse<PaymentRunResponse> executeWithHttpInfo() throws ApiException {
            return PaymentRunsApi.this.getPaymentRunWithHttpInfo(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<PaymentRunResponse> _callback) throws ApiException {
            return PaymentRunsApi.this.getPaymentRunAsync(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class DeletePaymentRunApi {
        private final String paymentRunKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private DeletePaymentRunApi(String paymentRunKey) {
            this.paymentRunKey = paymentRunKey;
        }

        public DeletePaymentRunApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeletePaymentRunApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeletePaymentRunApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeletePaymentRunApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeletePaymentRunApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeletePaymentRunApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public DeletePaymentRunApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentRunsApi.this.deletePaymentRunCall(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentRunsApi.this.deletePaymentRunWithHttpInfo(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return PaymentRunsApi.this.deletePaymentRunWithHttpInfo(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return PaymentRunsApi.this.deletePaymentRunAsync(this.paymentRunKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }

    public class CreatePaymentRunApi {
        private final CreatePaymentRunRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;
        private String zuoraWorkingOrg;

        private CreatePaymentRunApi(CreatePaymentRunRequest body) {
            this.body = body;
        }

        public CreatePaymentRunApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreatePaymentRunApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreatePaymentRunApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreatePaymentRunApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreatePaymentRunApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreatePaymentRunApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreatePaymentRunApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreatePaymentRunApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public CreatePaymentRunApi zuoraWorkingOrg(String zuoraWorkingOrg) {
            this.zuoraWorkingOrg = zuoraWorkingOrg;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentRunsApi.this.createPaymentRunCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }

        public PaymentRunResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentRunsApi.this.createPaymentRunWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
            return (PaymentRunResponse)localVarResp.getData();
        }

        private ApiResponse<PaymentRunResponse> executeWithHttpInfo() throws ApiException {
            return PaymentRunsApi.this.createPaymentRunWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg);
        }

        public Call executeAsync(ApiCallback<PaymentRunResponse> _callback) throws ApiException {
            return PaymentRunsApi.this.createPaymentRunAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, this.zuoraWorkingOrg, _callback);
        }
    }
}

