/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.SubscriptionPreviewBillingDocumentItemResponse;
import org.threeten.bp.LocalDate;

public class SubscriptionPreviewBillingDocumentsResponse {
    public static final String SERIALIZED_NAME_SUBTOTAL = "subtotal";
    @SerializedName(value="subtotal")
    private BigDecimal subtotal;
    public static final String SERIALIZED_NAME_TAX = "tax";
    @SerializedName(value="tax")
    private BigDecimal tax;
    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(value="total")
    private BigDecimal total;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_ITEMS = "billing_document_items";
    @SerializedName(value="billing_document_items")
    private List<SubscriptionPreviewBillingDocumentItemResponse> billingDocumentItems = null;

    public SubscriptionPreviewBillingDocumentsResponse() {
    }

    public SubscriptionPreviewBillingDocumentsResponse(BigDecimal subtotal, BigDecimal tax, BigDecimal total) {
        this();
        this.subtotal = subtotal;
        this.tax = tax;
        this.total = total;
    }

    @Nullable
    @ApiModelProperty(value="The total amount exclusive of tax.")
    public BigDecimal getSubtotal() {
        return this.subtotal;
    }

    @Nullable
    @ApiModelProperty(value="The total tax amount.")
    public BigDecimal getTax() {
        return this.tax;
    }

    @Nullable
    @ApiModelProperty(value="The total amount.")
    public BigDecimal getTotal() {
        return this.total;
    }

    public SubscriptionPreviewBillingDocumentsResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of billing document. Can be one of the credit memo, debit memo, or invoice.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SubscriptionPreviewBillingDocumentsResponse targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public SubscriptionPreviewBillingDocumentsResponse billingDocumentItems(List<SubscriptionPreviewBillingDocumentItemResponse> billingDocumentItems) {
        this.billingDocumentItems = billingDocumentItems;
        return this;
    }

    public SubscriptionPreviewBillingDocumentsResponse addBillingDocumentItemsItem(SubscriptionPreviewBillingDocumentItemResponse billingDocumentItemsItem) {
        if (this.billingDocumentItems == null) {
            this.billingDocumentItems = new ArrayList<SubscriptionPreviewBillingDocumentItemResponse>();
        }
        this.billingDocumentItems.add(billingDocumentItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<SubscriptionPreviewBillingDocumentItemResponse> getBillingDocumentItems() {
        return this.billingDocumentItems;
    }

    public void setBillingDocumentItems(List<SubscriptionPreviewBillingDocumentItemResponse> billingDocumentItems) {
        this.billingDocumentItems = billingDocumentItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionPreviewBillingDocumentsResponse subscriptionPreviewBillingDocumentsResponse = (SubscriptionPreviewBillingDocumentsResponse)o;
        return Objects.equals(this.subtotal, subscriptionPreviewBillingDocumentsResponse.subtotal) && Objects.equals(this.tax, subscriptionPreviewBillingDocumentsResponse.tax) && Objects.equals(this.total, subscriptionPreviewBillingDocumentsResponse.total) && Objects.equals((Object)this.type, (Object)subscriptionPreviewBillingDocumentsResponse.type) && Objects.equals(this.targetDate, subscriptionPreviewBillingDocumentsResponse.targetDate) && Objects.equals(this.billingDocumentItems, subscriptionPreviewBillingDocumentsResponse.billingDocumentItems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subtotal, this.tax, this.total, this.type, this.targetDate, this.billingDocumentItems});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionPreviewBillingDocumentsResponse {\n");
        sb.append("    subtotal: ").append(this.toIndentedString(this.subtotal)).append("\n");
        sb.append("    tax: ").append(this.toIndentedString(this.tax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("    billingDocumentItems: ").append(this.toIndentedString(this.billingDocumentItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        CREDIT_MEMO("credit_memo"),
        DEBIT_MEMO("debit_memo"),
        INVOICE("invoice"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

