/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.DebitMemo;
import org.openapitools.client.model.DebitMemoCreateRequest;
import org.openapitools.client.model.DebitMemoItemListResponse;
import org.openapitools.client.model.DebitMemoListResponse;
import org.openapitools.client.model.DebitMemoPatchRequest;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListQueryParams;
import org.openapitools.client.model.PayDebitMemoRequest;

public class DebitMemosApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DebitMemosApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DebitMemosApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call cancelDebitMemoCall(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/debit_memos/{debit_memo_id}/cancel".replace("{debit_memo_id}", this.localVarApiClient.escapeString(debitMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (debitMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo.fields[]", debitMemoFields));
        }
        if (debitMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo_items.fields[]", debitMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelDebitMemoValidateBeforeCall(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoId == null) {
            throw new ApiException("Missing the required parameter 'debitMemoId' when calling cancelDebitMemo(Async)");
        }
        return this.cancelDebitMemoCall(debitMemoId, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<DebitMemo> cancelDebitMemoWithHttpInfo(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelDebitMemoValidateBeforeCall(debitMemoId, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelDebitMemoAsync(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<DebitMemo> _callback) throws ApiException {
        Call localVarCall = this.cancelDebitMemoValidateBeforeCall(debitMemoId, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelDebitMemoParams cancelDebitMemoParams(String debitMemoId) {
        return new CancelDebitMemoParams(debitMemoId);
    }

    public DebitMemo cancelDebitMemo(String debitMemoId) throws ApiException {
        CancelDebitMemoParams params = new CancelDebitMemoParams(debitMemoId);
        return this.executeCancelDebitMemoAPICall(params).getData();
    }

    public DebitMemo cancelDebitMemo(String debitMemoId, List<String> expand) throws ApiException {
        CancelDebitMemoParams params = new CancelDebitMemoParams(debitMemoId);
        params.expand(expand);
        return this.executeCancelDebitMemoAPICall(params).getData();
    }

    public DebitMemo cancelDebitMemo(String debitMemoId, List<String> expand, Headers headers) throws ApiException {
        CancelDebitMemoParams params = new CancelDebitMemoParams(debitMemoId).expand(expand).headers(headers);
        return this.executeCancelDebitMemoAPICall(params).getData();
    }

    public DebitMemo cancel(CancelDebitMemoParams params) throws ApiException {
        return this.executeCancelDebitMemoAPICall(params).getData();
    }

    public ApiResponse<DebitMemo> cancelWithHttpInfo(CancelDebitMemoParams params) throws ApiException {
        return this.executeCancelDebitMemoAPICall(params);
    }

    ApiResponse<DebitMemo> executeCancelDebitMemoAPICall(CancelDebitMemoParams params) throws ApiException {
        return this.cancelDebitMemoWithHttpInfo(params.debitMemoId, params.fields, params.debitMemoFields, params.debitMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call createDebitMemoCall(DebitMemoCreateRequest debitMemoCreateRequest, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        DebitMemoCreateRequest localVarPostBody = debitMemoCreateRequest;
        String localVarPath = "/debit_memos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (debitMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo.fields[]", debitMemoFields));
        }
        if (debitMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo_items.fields[]", debitMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createDebitMemoValidateBeforeCall(DebitMemoCreateRequest debitMemoCreateRequest, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'debitMemoCreateRequest' when calling createDebitMemo(Async)");
        }
        return this.createDebitMemoCall(debitMemoCreateRequest, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<DebitMemo> createDebitMemoWithHttpInfo(DebitMemoCreateRequest debitMemoCreateRequest, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createDebitMemoValidateBeforeCall(debitMemoCreateRequest, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createDebitMemoAsync(DebitMemoCreateRequest debitMemoCreateRequest, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<DebitMemo> _callback) throws ApiException {
        Call localVarCall = this.createDebitMemoValidateBeforeCall(debitMemoCreateRequest, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateDebitMemoParams createDebitMemoParams(DebitMemoCreateRequest debitMemoCreateRequest) {
        return new CreateDebitMemoParams(debitMemoCreateRequest);
    }

    public DebitMemo createDebitMemo(DebitMemoCreateRequest debitMemoCreateRequest) throws ApiException {
        CreateDebitMemoParams params = new CreateDebitMemoParams(debitMemoCreateRequest);
        return this.executeCreateDebitMemoAPICall(params).getData();
    }

    public DebitMemo createDebitMemo(DebitMemoCreateRequest debitMemoCreateRequest, List<String> expand) throws ApiException {
        CreateDebitMemoParams params = new CreateDebitMemoParams(debitMemoCreateRequest);
        params.expand(expand);
        return this.executeCreateDebitMemoAPICall(params).getData();
    }

    public DebitMemo createDebitMemo(DebitMemoCreateRequest debitMemoCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateDebitMemoParams params = new CreateDebitMemoParams(debitMemoCreateRequest).expand(expand).headers(headers);
        return this.executeCreateDebitMemoAPICall(params).getData();
    }

    public DebitMemo create(CreateDebitMemoParams params) throws ApiException {
        return this.executeCreateDebitMemoAPICall(params).getData();
    }

    public ApiResponse<DebitMemo> createWithHttpInfo(CreateDebitMemoParams params) throws ApiException {
        return this.executeCreateDebitMemoAPICall(params);
    }

    ApiResponse<DebitMemo> executeCreateDebitMemoAPICall(CreateDebitMemoParams params) throws ApiException {
        return this.createDebitMemoWithHttpInfo(params.debitMemoCreateRequest, params.fields, params.debitMemoFields, params.debitMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call deleteDebitMemoCall(String debitMemoId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/debit_memos/{debit_memo_id}".replace("{debit_memo_id}", this.localVarApiClient.escapeString(debitMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDebitMemoValidateBeforeCall(String debitMemoId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoId == null) {
            throw new ApiException("Missing the required parameter 'debitMemoId' when calling deleteDebitMemo(Async)");
        }
        return this.deleteDebitMemoCall(debitMemoId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deleteDebitMemoWithHttpInfo(String debitMemoId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteDebitMemoValidateBeforeCall(debitMemoId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteDebitMemoAsync(String debitMemoId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteDebitMemoValidateBeforeCall(debitMemoId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteDebitMemoParams deleteDebitMemoParams(String debitMemoId) {
        return new DeleteDebitMemoParams(debitMemoId);
    }

    public void deleteDebitMemo(String debitMemoId) throws ApiException {
        DeleteDebitMemoParams params = new DeleteDebitMemoParams(debitMemoId);
        this.executeDeleteDebitMemoAPICall(params);
    }

    public void deleteDebitMemo(String debitMemoId, Headers headers) throws ApiException {
        DeleteDebitMemoParams params = new DeleteDebitMemoParams(debitMemoId).headers(headers);
        this.executeDeleteDebitMemoAPICall(params);
    }

    public void delete(DeleteDebitMemoParams params) throws ApiException {
        this.executeDeleteDebitMemoAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeleteDebitMemoParams params) throws ApiException {
        return this.executeDeleteDebitMemoAPICall(params);
    }

    ApiResponse<Void> executeDeleteDebitMemoAPICall(DeleteDebitMemoParams params) throws ApiException {
        return this.deleteDebitMemoWithHttpInfo(params.debitMemoId, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getDebitMemoCall(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/debit_memos/{debit_memo_id}".replace("{debit_memo_id}", this.localVarApiClient.escapeString(debitMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (debitMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo.fields[]", debitMemoFields));
        }
        if (debitMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo_items.fields[]", debitMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDebitMemoValidateBeforeCall(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoId == null) {
            throw new ApiException("Missing the required parameter 'debitMemoId' when calling getDebitMemo(Async)");
        }
        return this.getDebitMemoCall(debitMemoId, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<DebitMemo> getDebitMemoWithHttpInfo(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getDebitMemoValidateBeforeCall(debitMemoId, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getDebitMemoAsync(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<DebitMemo> _callback) throws ApiException {
        Call localVarCall = this.getDebitMemoValidateBeforeCall(debitMemoId, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDebitMemoParams getDebitMemoParams(String debitMemoId) {
        return new GetDebitMemoParams(debitMemoId);
    }

    public DebitMemo getDebitMemo(String debitMemoId) throws ApiException {
        GetDebitMemoParams params = new GetDebitMemoParams(debitMemoId);
        return this.executeGetDebitMemoAPICall(params).getData();
    }

    public DebitMemo getDebitMemo(String debitMemoId, List<String> expand) throws ApiException {
        GetDebitMemoParams params = new GetDebitMemoParams(debitMemoId);
        params.expand(expand);
        return this.executeGetDebitMemoAPICall(params).getData();
    }

    public DebitMemo getDebitMemo(String debitMemoId, List<String> expand, Headers headers) throws ApiException {
        GetDebitMemoParams params = new GetDebitMemoParams(debitMemoId).expand(expand).headers(headers);
        return this.executeGetDebitMemoAPICall(params).getData();
    }

    public DebitMemo get(GetDebitMemoParams params) throws ApiException {
        return this.executeGetDebitMemoAPICall(params).getData();
    }

    public ApiResponse<DebitMemo> getWithHttpInfo(GetDebitMemoParams params) throws ApiException {
        return this.executeGetDebitMemoAPICall(params);
    }

    ApiResponse<DebitMemo> executeGetDebitMemoAPICall(GetDebitMemoParams params) throws ApiException {
        return this.getDebitMemoWithHttpInfo(params.debitMemoId, params.fields, params.debitMemoFields, params.debitMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getDebitMemoItemsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> debitMemoItemFields, List<String> taxationItemsFields, List<String> debitMemoFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/debit_memo_items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (debitMemoItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo_item.fields[]", debitMemoItemFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (debitMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo.fields[]", debitMemoFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDebitMemoItemsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> debitMemoItemFields, List<String> taxationItemsFields, List<String> debitMemoFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getDebitMemoItemsCall(cursor, expand, filter, sort, pageSize, fields, debitMemoItemFields, taxationItemsFields, debitMemoFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<DebitMemoItemListResponse> getDebitMemoItemsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> debitMemoItemFields, List<String> taxationItemsFields, List<String> debitMemoFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getDebitMemoItemsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, debitMemoItemFields, taxationItemsFields, debitMemoFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<DebitMemoItemListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getDebitMemoItemsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> debitMemoItemFields, List<String> taxationItemsFields, List<String> debitMemoFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<DebitMemoItemListResponse> _callback) throws ApiException {
        Call localVarCall = this.getDebitMemoItemsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, debitMemoItemFields, taxationItemsFields, debitMemoFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemoItemListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDebitMemoItemsParams getDebitMemoItemsParams() {
        return new GetDebitMemoItemsParams();
    }

    public DebitMemoItemListResponse getDebitMemoItems() throws ApiException {
        GetDebitMemoItemsParams params = new GetDebitMemoItemsParams();
        return this.executeGetDebitMemoItemsAPICall(params).getData();
    }

    public DebitMemoItemListResponse getDebitMemoItems(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetDebitMemoItemsParams params = new GetDebitMemoItemsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetDebitMemoItemsAPICall(params).getData();
    }

    public DebitMemoItemListResponse getDebitMemoItems(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetDebitMemoItemsParams params = new GetDebitMemoItemsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetDebitMemoItemsAPICall(params).getData();
    }

    public DebitMemoItemListResponse list(GetDebitMemoItemsParams params) throws ApiException {
        return this.executeGetDebitMemoItemsAPICall(params).getData();
    }

    public ApiResponse<DebitMemoItemListResponse> listWithHttpInfo(GetDebitMemoItemsParams params) throws ApiException {
        return this.executeGetDebitMemoItemsAPICall(params);
    }

    ApiResponse<DebitMemoItemListResponse> executeGetDebitMemoItemsAPICall(GetDebitMemoItemsParams params) throws ApiException {
        return this.getDebitMemoItemsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.debitMemoItemFields, params.taxationItemsFields, params.debitMemoFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getDebitMemoesCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/debit_memos";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (debitMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo.fields[]", debitMemoFields));
        }
        if (debitMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo_items.fields[]", debitMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDebitMemoesValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getDebitMemoesCall(cursor, expand, filter, sort, pageSize, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<DebitMemoListResponse> getDebitMemoesWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getDebitMemoesValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<DebitMemoListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getDebitMemoesAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<DebitMemoListResponse> _callback) throws ApiException {
        Call localVarCall = this.getDebitMemoesValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemoListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetDebitMemoesParams getDebitMemoesParams() {
        return new GetDebitMemoesParams();
    }

    public DebitMemoListResponse getDebitMemoes() throws ApiException {
        GetDebitMemoesParams params = new GetDebitMemoesParams();
        return this.executeGetDebitMemoesAPICall(params).getData();
    }

    public DebitMemoListResponse getDebitMemoes(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetDebitMemoesParams params = new GetDebitMemoesParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetDebitMemoesAPICall(params).getData();
    }

    public DebitMemoListResponse getDebitMemoes(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetDebitMemoesParams params = new GetDebitMemoesParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetDebitMemoesAPICall(params).getData();
    }

    public DebitMemoListResponse list(GetDebitMemoesParams params) throws ApiException {
        return this.executeGetDebitMemoesAPICall(params).getData();
    }

    public ApiResponse<DebitMemoListResponse> listWithHttpInfo(GetDebitMemoesParams params) throws ApiException {
        return this.executeGetDebitMemoesAPICall(params);
    }

    ApiResponse<DebitMemoListResponse> executeGetDebitMemoesAPICall(GetDebitMemoesParams params) throws ApiException {
        return this.getDebitMemoesWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.debitMemoFields, params.debitMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call patchDebitMemoCall(String debitMemoId, DebitMemoPatchRequest debitMemoPatchRequest, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        DebitMemoPatchRequest localVarPostBody = debitMemoPatchRequest;
        String localVarPath = "/debit_memos/{debit_memo_id}".replace("{debit_memo_id}", this.localVarApiClient.escapeString(debitMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (debitMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo.fields[]", debitMemoFields));
        }
        if (debitMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo_items.fields[]", debitMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchDebitMemoValidateBeforeCall(String debitMemoId, DebitMemoPatchRequest debitMemoPatchRequest, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoId == null) {
            throw new ApiException("Missing the required parameter 'debitMemoId' when calling patchDebitMemo(Async)");
        }
        if (debitMemoPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'debitMemoPatchRequest' when calling patchDebitMemo(Async)");
        }
        return this.patchDebitMemoCall(debitMemoId, debitMemoPatchRequest, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<DebitMemo> patchDebitMemoWithHttpInfo(String debitMemoId, DebitMemoPatchRequest debitMemoPatchRequest, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.patchDebitMemoValidateBeforeCall(debitMemoId, debitMemoPatchRequest, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call patchDebitMemoAsync(String debitMemoId, DebitMemoPatchRequest debitMemoPatchRequest, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<DebitMemo> _callback) throws ApiException {
        Call localVarCall = this.patchDebitMemoValidateBeforeCall(debitMemoId, debitMemoPatchRequest, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PatchDebitMemoParams patchDebitMemoParams(String debitMemoId, DebitMemoPatchRequest debitMemoPatchRequest) {
        return new PatchDebitMemoParams(debitMemoId, debitMemoPatchRequest);
    }

    public DebitMemo patchDebitMemo(String debitMemoId, DebitMemoPatchRequest debitMemoPatchRequest) throws ApiException {
        PatchDebitMemoParams params = new PatchDebitMemoParams(debitMemoId, debitMemoPatchRequest);
        return this.executePatchDebitMemoAPICall(params).getData();
    }

    public DebitMemo patchDebitMemo(String debitMemoId, DebitMemoPatchRequest debitMemoPatchRequest, List<String> expand) throws ApiException {
        PatchDebitMemoParams params = new PatchDebitMemoParams(debitMemoId, debitMemoPatchRequest);
        params.expand(expand);
        return this.executePatchDebitMemoAPICall(params).getData();
    }

    public DebitMemo patchDebitMemo(String debitMemoId, DebitMemoPatchRequest debitMemoPatchRequest, List<String> expand, Headers headers) throws ApiException {
        PatchDebitMemoParams params = new PatchDebitMemoParams(debitMemoId, debitMemoPatchRequest).expand(expand).headers(headers);
        return this.executePatchDebitMemoAPICall(params).getData();
    }

    public DebitMemo update(PatchDebitMemoParams params) throws ApiException {
        return this.executePatchDebitMemoAPICall(params).getData();
    }

    public ApiResponse<DebitMemo> updateWithHttpInfo(PatchDebitMemoParams params) throws ApiException {
        return this.executePatchDebitMemoAPICall(params);
    }

    ApiResponse<DebitMemo> executePatchDebitMemoAPICall(PatchDebitMemoParams params) throws ApiException {
        return this.patchDebitMemoWithHttpInfo(params.debitMemoId, params.debitMemoPatchRequest, params.fields, params.debitMemoFields, params.debitMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call payDebitMemoCall(String debitMemoId, PayDebitMemoRequest payDebitMemoRequest, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PayDebitMemoRequest localVarPostBody = payDebitMemoRequest;
        String localVarPath = "/debit_memos/{debit_memo_id}/pay".replace("{debit_memo_id}", this.localVarApiClient.escapeString(debitMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (debitMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo.fields[]", debitMemoFields));
        }
        if (debitMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo_items.fields[]", debitMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call payDebitMemoValidateBeforeCall(String debitMemoId, PayDebitMemoRequest payDebitMemoRequest, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoId == null) {
            throw new ApiException("Missing the required parameter 'debitMemoId' when calling payDebitMemo(Async)");
        }
        if (payDebitMemoRequest == null) {
            throw new ApiException("Missing the required parameter 'payDebitMemoRequest' when calling payDebitMemo(Async)");
        }
        return this.payDebitMemoCall(debitMemoId, payDebitMemoRequest, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<DebitMemo> payDebitMemoWithHttpInfo(String debitMemoId, PayDebitMemoRequest payDebitMemoRequest, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.payDebitMemoValidateBeforeCall(debitMemoId, payDebitMemoRequest, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call payDebitMemoAsync(String debitMemoId, PayDebitMemoRequest payDebitMemoRequest, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<DebitMemo> _callback) throws ApiException {
        Call localVarCall = this.payDebitMemoValidateBeforeCall(debitMemoId, payDebitMemoRequest, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PayDebitMemoParams payDebitMemoParams(String debitMemoId, PayDebitMemoRequest payDebitMemoRequest) {
        return new PayDebitMemoParams(debitMemoId, payDebitMemoRequest);
    }

    public DebitMemo payDebitMemo(String debitMemoId, PayDebitMemoRequest payDebitMemoRequest) throws ApiException {
        PayDebitMemoParams params = new PayDebitMemoParams(debitMemoId, payDebitMemoRequest);
        return this.executePayDebitMemoAPICall(params).getData();
    }

    public DebitMemo payDebitMemo(String debitMemoId, PayDebitMemoRequest payDebitMemoRequest, List<String> expand) throws ApiException {
        PayDebitMemoParams params = new PayDebitMemoParams(debitMemoId, payDebitMemoRequest);
        params.expand(expand);
        return this.executePayDebitMemoAPICall(params).getData();
    }

    public DebitMemo payDebitMemo(String debitMemoId, PayDebitMemoRequest payDebitMemoRequest, List<String> expand, Headers headers) throws ApiException {
        PayDebitMemoParams params = new PayDebitMemoParams(debitMemoId, payDebitMemoRequest).expand(expand).headers(headers);
        return this.executePayDebitMemoAPICall(params).getData();
    }

    public DebitMemo pay(PayDebitMemoParams params) throws ApiException {
        return this.executePayDebitMemoAPICall(params).getData();
    }

    public ApiResponse<DebitMemo> payWithHttpInfo(PayDebitMemoParams params) throws ApiException {
        return this.executePayDebitMemoAPICall(params);
    }

    ApiResponse<DebitMemo> executePayDebitMemoAPICall(PayDebitMemoParams params) throws ApiException {
        return this.payDebitMemoWithHttpInfo(params.debitMemoId, params.payDebitMemoRequest, params.fields, params.debitMemoFields, params.debitMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call postsDebitMemoCall(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/debit_memos/{debit_memo_id}/post".replace("{debit_memo_id}", this.localVarApiClient.escapeString(debitMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (debitMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo.fields[]", debitMemoFields));
        }
        if (debitMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo_items.fields[]", debitMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postsDebitMemoValidateBeforeCall(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoId == null) {
            throw new ApiException("Missing the required parameter 'debitMemoId' when calling postsDebitMemo(Async)");
        }
        return this.postsDebitMemoCall(debitMemoId, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<DebitMemo> postsDebitMemoWithHttpInfo(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.postsDebitMemoValidateBeforeCall(debitMemoId, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call postsDebitMemoAsync(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<DebitMemo> _callback) throws ApiException {
        Call localVarCall = this.postsDebitMemoValidateBeforeCall(debitMemoId, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostsDebitMemoParams postsDebitMemoParams(String debitMemoId) {
        return new PostsDebitMemoParams(debitMemoId);
    }

    public DebitMemo postsDebitMemo(String debitMemoId) throws ApiException {
        PostsDebitMemoParams params = new PostsDebitMemoParams(debitMemoId);
        return this.executePostsDebitMemoAPICall(params).getData();
    }

    public DebitMemo postsDebitMemo(String debitMemoId, List<String> expand) throws ApiException {
        PostsDebitMemoParams params = new PostsDebitMemoParams(debitMemoId);
        params.expand(expand);
        return this.executePostsDebitMemoAPICall(params).getData();
    }

    public DebitMemo postsDebitMemo(String debitMemoId, List<String> expand, Headers headers) throws ApiException {
        PostsDebitMemoParams params = new PostsDebitMemoParams(debitMemoId).expand(expand).headers(headers);
        return this.executePostsDebitMemoAPICall(params).getData();
    }

    public DebitMemo post(PostsDebitMemoParams params) throws ApiException {
        return this.executePostsDebitMemoAPICall(params).getData();
    }

    public ApiResponse<DebitMemo> postWithHttpInfo(PostsDebitMemoParams params) throws ApiException {
        return this.executePostsDebitMemoAPICall(params);
    }

    ApiResponse<DebitMemo> executePostsDebitMemoAPICall(PostsDebitMemoParams params) throws ApiException {
        return this.postsDebitMemoWithHttpInfo(params.debitMemoId, params.fields, params.debitMemoFields, params.debitMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call unpostsDebitMemoCall(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/debit_memos/{debit_memo_id}/unpost".replace("{debit_memo_id}", this.localVarApiClient.escapeString(debitMemoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (debitMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo.fields[]", debitMemoFields));
        }
        if (debitMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memo_items.fields[]", debitMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unpostsDebitMemoValidateBeforeCall(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (debitMemoId == null) {
            throw new ApiException("Missing the required parameter 'debitMemoId' when calling unpostsDebitMemo(Async)");
        }
        return this.unpostsDebitMemoCall(debitMemoId, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<DebitMemo> unpostsDebitMemoWithHttpInfo(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.unpostsDebitMemoValidateBeforeCall(debitMemoId, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call unpostsDebitMemoAsync(String debitMemoId, List<String> fields, List<String> debitMemoFields, List<String> debitMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<DebitMemo> _callback) throws ApiException {
        Call localVarCall = this.unpostsDebitMemoValidateBeforeCall(debitMemoId, fields, debitMemoFields, debitMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<DebitMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UnpostsDebitMemoParams unpostsDebitMemoParams(String debitMemoId) {
        return new UnpostsDebitMemoParams(debitMemoId);
    }

    public DebitMemo unpostsDebitMemo(String debitMemoId) throws ApiException {
        UnpostsDebitMemoParams params = new UnpostsDebitMemoParams(debitMemoId);
        return this.executeUnpostsDebitMemoAPICall(params).getData();
    }

    public DebitMemo unpostsDebitMemo(String debitMemoId, List<String> expand) throws ApiException {
        UnpostsDebitMemoParams params = new UnpostsDebitMemoParams(debitMemoId);
        params.expand(expand);
        return this.executeUnpostsDebitMemoAPICall(params).getData();
    }

    public DebitMemo unpostsDebitMemo(String debitMemoId, List<String> expand, Headers headers) throws ApiException {
        UnpostsDebitMemoParams params = new UnpostsDebitMemoParams(debitMemoId).expand(expand).headers(headers);
        return this.executeUnpostsDebitMemoAPICall(params).getData();
    }

    public DebitMemo unpost(UnpostsDebitMemoParams params) throws ApiException {
        return this.executeUnpostsDebitMemoAPICall(params).getData();
    }

    public ApiResponse<DebitMemo> unpostWithHttpInfo(UnpostsDebitMemoParams params) throws ApiException {
        return this.executeUnpostsDebitMemoAPICall(params);
    }

    ApiResponse<DebitMemo> executeUnpostsDebitMemoAPICall(UnpostsDebitMemoParams params) throws ApiException {
        return this.unpostsDebitMemoWithHttpInfo(params.debitMemoId, params.fields, params.debitMemoFields, params.debitMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class UnpostsDebitMemoParams {
        private final String debitMemoId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> debitMemoFields;
        private List<String> debitMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UnpostsDebitMemoParams(String debitMemoId) {
            this.debitMemoId = debitMemoId;
        }

        public UnpostsDebitMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UnpostsDebitMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UnpostsDebitMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UnpostsDebitMemoParams debitMemoFields(List<String> debitMemoFields) {
            this.debitMemoFields = debitMemoFields;
            return this;
        }

        public UnpostsDebitMemoParams debitMemoItemsFields(List<String> debitMemoItemsFields) {
            this.debitMemoItemsFields = debitMemoItemsFields;
            return this;
        }

        public UnpostsDebitMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public UnpostsDebitMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public UnpostsDebitMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public UnpostsDebitMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UnpostsDebitMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UnpostsDebitMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class PostsDebitMemoParams {
        private final String debitMemoId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> debitMemoFields;
        private List<String> debitMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PostsDebitMemoParams(String debitMemoId) {
            this.debitMemoId = debitMemoId;
        }

        public PostsDebitMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PostsDebitMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PostsDebitMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PostsDebitMemoParams debitMemoFields(List<String> debitMemoFields) {
            this.debitMemoFields = debitMemoFields;
            return this;
        }

        public PostsDebitMemoParams debitMemoItemsFields(List<String> debitMemoItemsFields) {
            this.debitMemoItemsFields = debitMemoItemsFields;
            return this;
        }

        public PostsDebitMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public PostsDebitMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public PostsDebitMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public PostsDebitMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PostsDebitMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PostsDebitMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class PayDebitMemoParams {
        private final String debitMemoId;
        private final PayDebitMemoRequest payDebitMemoRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> debitMemoFields;
        private List<String> debitMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PayDebitMemoParams(String debitMemoId, PayDebitMemoRequest payDebitMemoRequest) {
            this.debitMemoId = debitMemoId;
            this.payDebitMemoRequest = payDebitMemoRequest;
        }

        public PayDebitMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PayDebitMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PayDebitMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PayDebitMemoParams debitMemoFields(List<String> debitMemoFields) {
            this.debitMemoFields = debitMemoFields;
            return this;
        }

        public PayDebitMemoParams debitMemoItemsFields(List<String> debitMemoItemsFields) {
            this.debitMemoItemsFields = debitMemoItemsFields;
            return this;
        }

        public PayDebitMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public PayDebitMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public PayDebitMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public PayDebitMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PayDebitMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PayDebitMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class PatchDebitMemoParams {
        private final String debitMemoId;
        private final DebitMemoPatchRequest debitMemoPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> debitMemoFields;
        private List<String> debitMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PatchDebitMemoParams(String debitMemoId, DebitMemoPatchRequest debitMemoPatchRequest) {
            this.debitMemoId = debitMemoId;
            this.debitMemoPatchRequest = debitMemoPatchRequest;
        }

        public PatchDebitMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PatchDebitMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PatchDebitMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PatchDebitMemoParams debitMemoFields(List<String> debitMemoFields) {
            this.debitMemoFields = debitMemoFields;
            return this;
        }

        public PatchDebitMemoParams debitMemoItemsFields(List<String> debitMemoItemsFields) {
            this.debitMemoItemsFields = debitMemoItemsFields;
            return this;
        }

        public PatchDebitMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public PatchDebitMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public PatchDebitMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public PatchDebitMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PatchDebitMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PatchDebitMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetDebitMemoesParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> debitMemoFields;
        private List<String> debitMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetDebitMemoesParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetDebitMemoesParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetDebitMemoesParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetDebitMemoesParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetDebitMemoesParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetDebitMemoesParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetDebitMemoesParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetDebitMemoesParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetDebitMemoesParams debitMemoFields(List<String> debitMemoFields) {
            this.debitMemoFields = debitMemoFields;
            return this;
        }

        public GetDebitMemoesParams debitMemoItemsFields(List<String> debitMemoItemsFields) {
            this.debitMemoItemsFields = debitMemoItemsFields;
            return this;
        }

        public GetDebitMemoesParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public GetDebitMemoesParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetDebitMemoesParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }
    }

    public static class GetDebitMemoItemsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> debitMemoItemFields;
        private List<String> taxationItemsFields;
        private List<String> debitMemoFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetDebitMemoItemsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetDebitMemoItemsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetDebitMemoItemsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetDebitMemoItemsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetDebitMemoItemsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetDebitMemoItemsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetDebitMemoItemsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetDebitMemoItemsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetDebitMemoItemsParams debitMemoItemFields(List<String> debitMemoItemFields) {
            this.debitMemoItemFields = debitMemoItemFields;
            return this;
        }

        public GetDebitMemoItemsParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public GetDebitMemoItemsParams debitMemoFields(List<String> debitMemoFields) {
            this.debitMemoFields = debitMemoFields;
            return this;
        }
    }

    public static class GetDebitMemoParams {
        private final String debitMemoId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> debitMemoFields;
        private List<String> debitMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetDebitMemoParams(String debitMemoId) {
            this.debitMemoId = debitMemoId;
        }

        public GetDebitMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetDebitMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetDebitMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetDebitMemoParams debitMemoFields(List<String> debitMemoFields) {
            this.debitMemoFields = debitMemoFields;
            return this;
        }

        public GetDebitMemoParams debitMemoItemsFields(List<String> debitMemoItemsFields) {
            this.debitMemoItemsFields = debitMemoItemsFields;
            return this;
        }

        public GetDebitMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public GetDebitMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetDebitMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public GetDebitMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetDebitMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetDebitMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class DeleteDebitMemoParams {
        private final String debitMemoId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public DeleteDebitMemoParams(String debitMemoId) {
            this.debitMemoId = debitMemoId;
        }

        public DeleteDebitMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateDebitMemoParams {
        private final DebitMemoCreateRequest debitMemoCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> debitMemoFields;
        private List<String> debitMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateDebitMemoParams(DebitMemoCreateRequest debitMemoCreateRequest) {
            this.debitMemoCreateRequest = debitMemoCreateRequest;
        }

        public CreateDebitMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateDebitMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateDebitMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateDebitMemoParams debitMemoFields(List<String> debitMemoFields) {
            this.debitMemoFields = debitMemoFields;
            return this;
        }

        public CreateDebitMemoParams debitMemoItemsFields(List<String> debitMemoItemsFields) {
            this.debitMemoItemsFields = debitMemoItemsFields;
            return this;
        }

        public CreateDebitMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public CreateDebitMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CreateDebitMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public CreateDebitMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateDebitMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateDebitMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CancelDebitMemoParams {
        private final String debitMemoId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> debitMemoFields;
        private List<String> debitMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CancelDebitMemoParams(String debitMemoId) {
            this.debitMemoId = debitMemoId;
        }

        public CancelDebitMemoParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CancelDebitMemoParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CancelDebitMemoParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CancelDebitMemoParams debitMemoFields(List<String> debitMemoFields) {
            this.debitMemoFields = debitMemoFields;
            return this;
        }

        public CancelDebitMemoParams debitMemoItemsFields(List<String> debitMemoItemsFields) {
            this.debitMemoItemsFields = debitMemoItemsFields;
            return this;
        }

        public CancelDebitMemoParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public CancelDebitMemoParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CancelDebitMemoParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public CancelDebitMemoParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CancelDebitMemoParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CancelDebitMemoParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

