/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.Account;
import org.openapitools.client.model.AccountCreateRequest;
import org.openapitools.client.model.AccountPatchRequest;
import org.openapitools.client.model.AccountPreviewRequest;
import org.openapitools.client.model.AccountPreviewResponse;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GenerateBillingDocumentsAccountRequest;
import org.openapitools.client.model.GenerateBillingDocumentsAccountResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.ListAccountResponse;
import org.openapitools.client.model.ListQueryParams;

public class AccountsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AccountsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createAccountCall(AccountCreateRequest accountCreateRequest, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AccountCreateRequest localVarPostBody = accountCreateRequest;
        String localVarPath = "/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (subscriptionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscriptions.fields[]", subscriptionsFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (paymentMethodsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_methods.fields[]", paymentMethodsFields));
        }
        if (paymentsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payments.fields[]", paymentsFields));
        }
        if (billingDocumentsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_documents.fields[]", billingDocumentsFields));
        }
        if (billingDocumentItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_document_items.fields[]", billingDocumentItemsFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (soldToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sold_to.fields[]", soldToFields));
        }
        if (defaultPaymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "default_payment_method.fields[]", defaultPaymentMethodFields));
        }
        if (usageRecordsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "usage_records.fields[]", usageRecordsFields));
        }
        if (invoicesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoices.fields[]", invoicesFields));
        }
        if (creditMemosFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memos.fields[]", creditMemosFields));
        }
        if (debitMemosFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memos.fields[]", debitMemosFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createAccountValidateBeforeCall(AccountCreateRequest accountCreateRequest, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (accountCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'accountCreateRequest' when calling createAccount(Async)");
        }
        return this.createAccountCall(accountCreateRequest, fields, accountFields, subscriptionsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceOwnerAccountFields, planFields, paymentMethodsFields, paymentsFields, billingDocumentsFields, billingDocumentItemsFields, billToFields, soldToFields, defaultPaymentMethodFields, usageRecordsFields, invoicesFields, creditMemosFields, debitMemosFields, prepaidBalanceFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Account> createAccountWithHttpInfo(AccountCreateRequest accountCreateRequest, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createAccountValidateBeforeCall(accountCreateRequest, fields, accountFields, subscriptionsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceOwnerAccountFields, planFields, paymentMethodsFields, paymentsFields, billingDocumentsFields, billingDocumentItemsFields, billToFields, soldToFields, defaultPaymentMethodFields, usageRecordsFields, invoicesFields, creditMemosFields, debitMemosFields, prepaidBalanceFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Account>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createAccountAsync(AccountCreateRequest accountCreateRequest, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Account> _callback) throws ApiException {
        Call localVarCall = this.createAccountValidateBeforeCall(accountCreateRequest, fields, accountFields, subscriptionsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceOwnerAccountFields, planFields, paymentMethodsFields, paymentsFields, billingDocumentsFields, billingDocumentItemsFields, billToFields, soldToFields, defaultPaymentMethodFields, usageRecordsFields, invoicesFields, creditMemosFields, debitMemosFields, prepaidBalanceFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateAccountParams createAccountParams(AccountCreateRequest accountCreateRequest) {
        return new CreateAccountParams(accountCreateRequest);
    }

    public Account createAccount(AccountCreateRequest accountCreateRequest) throws ApiException {
        CreateAccountParams params = new CreateAccountParams(accountCreateRequest);
        return this.executeCreateAccountAPICall(params).getData();
    }

    public Account createAccount(AccountCreateRequest accountCreateRequest, List<String> expand) throws ApiException {
        CreateAccountParams params = new CreateAccountParams(accountCreateRequest);
        params.expand(expand);
        return this.executeCreateAccountAPICall(params).getData();
    }

    public Account createAccount(AccountCreateRequest accountCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateAccountParams params = new CreateAccountParams(accountCreateRequest).expand(expand).headers(headers);
        return this.executeCreateAccountAPICall(params).getData();
    }

    public Account create(CreateAccountParams params) throws ApiException {
        return this.executeCreateAccountAPICall(params).getData();
    }

    public ApiResponse<Account> createWithHttpInfo(CreateAccountParams params) throws ApiException {
        return this.executeCreateAccountAPICall(params);
    }

    ApiResponse<Account> executeCreateAccountAPICall(CreateAccountParams params) throws ApiException {
        return this.createAccountWithHttpInfo(params.accountCreateRequest, params.fields, params.accountFields, params.subscriptionsFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.invoiceOwnerAccountFields, params.planFields, params.paymentMethodsFields, params.paymentsFields, params.billingDocumentsFields, params.billingDocumentItemsFields, params.billToFields, params.soldToFields, params.defaultPaymentMethodFields, params.usageRecordsFields, params.invoicesFields, params.creditMemosFields, params.debitMemosFields, params.prepaidBalanceFields, params.transactionsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call deleteAccountCall(String accountId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/accounts/{account_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAccountValidateBeforeCall(String accountId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling deleteAccount(Async)");
        }
        return this.deleteAccountCall(accountId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deleteAccountWithHttpInfo(String accountId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteAccountValidateBeforeCall(accountId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteAccountAsync(String accountId, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAccountValidateBeforeCall(accountId, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteAccountParams deleteAccountParams(String accountId) {
        return new DeleteAccountParams(accountId);
    }

    public void deleteAccount(String accountId) throws ApiException {
        DeleteAccountParams params = new DeleteAccountParams(accountId);
        this.executeDeleteAccountAPICall(params);
    }

    public void deleteAccount(String accountId, Headers headers) throws ApiException {
        DeleteAccountParams params = new DeleteAccountParams(accountId).headers(headers);
        this.executeDeleteAccountAPICall(params);
    }

    public void delete(DeleteAccountParams params) throws ApiException {
        this.executeDeleteAccountAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeleteAccountParams params) throws ApiException {
        return this.executeDeleteAccountAPICall(params);
    }

    ApiResponse<Void> executeDeleteAccountAPICall(DeleteAccountParams params) throws ApiException {
        return this.deleteAccountWithHttpInfo(params.accountId, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call generateBillingDocumentsCall(String accountId, GenerateBillingDocumentsAccountRequest generateBillingDocumentsAccountRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        GenerateBillingDocumentsAccountRequest localVarPostBody = generateBillingDocumentsAccountRequest;
        String localVarPath = "/accounts/{account_id}/bill".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call generateBillingDocumentsValidateBeforeCall(String accountId, GenerateBillingDocumentsAccountRequest generateBillingDocumentsAccountRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling generateBillingDocuments(Async)");
        }
        if (generateBillingDocumentsAccountRequest == null) {
            throw new ApiException("Missing the required parameter 'generateBillingDocumentsAccountRequest' when calling generateBillingDocuments(Async)");
        }
        return this.generateBillingDocumentsCall(accountId, generateBillingDocumentsAccountRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<GenerateBillingDocumentsAccountResponse> generateBillingDocumentsWithHttpInfo(String accountId, GenerateBillingDocumentsAccountRequest generateBillingDocumentsAccountRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.generateBillingDocumentsValidateBeforeCall(accountId, generateBillingDocumentsAccountRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<GenerateBillingDocumentsAccountResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call generateBillingDocumentsAsync(String accountId, GenerateBillingDocumentsAccountRequest generateBillingDocumentsAccountRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<GenerateBillingDocumentsAccountResponse> _callback) throws ApiException {
        Call localVarCall = this.generateBillingDocumentsValidateBeforeCall(accountId, generateBillingDocumentsAccountRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GenerateBillingDocumentsAccountResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GenerateBillingDocumentsParams generateBillingDocumentsParams(String accountId, GenerateBillingDocumentsAccountRequest generateBillingDocumentsAccountRequest) {
        return new GenerateBillingDocumentsParams(accountId, generateBillingDocumentsAccountRequest);
    }

    public GenerateBillingDocumentsAccountResponse generateBillingDocuments(String accountId, GenerateBillingDocumentsAccountRequest generateBillingDocumentsAccountRequest) throws ApiException {
        GenerateBillingDocumentsParams params = new GenerateBillingDocumentsParams(accountId, generateBillingDocumentsAccountRequest);
        return this.executeGenerateBillingDocumentsAPICall(params).getData();
    }

    public GenerateBillingDocumentsAccountResponse generateBillingDocuments(String accountId, GenerateBillingDocumentsAccountRequest generateBillingDocumentsAccountRequest, Headers headers) throws ApiException {
        GenerateBillingDocumentsParams params = new GenerateBillingDocumentsParams(accountId, generateBillingDocumentsAccountRequest).headers(headers);
        return this.executeGenerateBillingDocumentsAPICall(params).getData();
    }

    public GenerateBillingDocumentsAccountResponse generateBillingDocuments(GenerateBillingDocumentsParams params) throws ApiException {
        return this.executeGenerateBillingDocumentsAPICall(params).getData();
    }

    public ApiResponse<GenerateBillingDocumentsAccountResponse> generateBillingDocumentsWithHttpInfo(GenerateBillingDocumentsParams params) throws ApiException {
        return this.executeGenerateBillingDocumentsAPICall(params);
    }

    ApiResponse<GenerateBillingDocumentsAccountResponse> executeGenerateBillingDocumentsAPICall(GenerateBillingDocumentsParams params) throws ApiException {
        return this.generateBillingDocumentsWithHttpInfo(params.accountId, params.generateBillingDocumentsAccountRequest, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getAccountCall(String accountId, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/accounts/{account_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (subscriptionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscriptions.fields[]", subscriptionsFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (paymentMethodsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_methods.fields[]", paymentMethodsFields));
        }
        if (paymentsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payments.fields[]", paymentsFields));
        }
        if (billingDocumentsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_documents.fields[]", billingDocumentsFields));
        }
        if (billingDocumentItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_document_items.fields[]", billingDocumentItemsFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (soldToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sold_to.fields[]", soldToFields));
        }
        if (defaultPaymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "default_payment_method.fields[]", defaultPaymentMethodFields));
        }
        if (usageRecordsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "usage_records.fields[]", usageRecordsFields));
        }
        if (invoicesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoices.fields[]", invoicesFields));
        }
        if (creditMemosFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memos.fields[]", creditMemosFields));
        }
        if (debitMemosFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memos.fields[]", debitMemosFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountValidateBeforeCall(String accountId, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling getAccount(Async)");
        }
        return this.getAccountCall(accountId, fields, accountFields, subscriptionsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceOwnerAccountFields, planFields, paymentMethodsFields, paymentsFields, billingDocumentsFields, billingDocumentItemsFields, billToFields, soldToFields, defaultPaymentMethodFields, usageRecordsFields, invoicesFields, creditMemosFields, debitMemosFields, prepaidBalanceFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Account> getAccountWithHttpInfo(String accountId, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getAccountValidateBeforeCall(accountId, fields, accountFields, subscriptionsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceOwnerAccountFields, planFields, paymentMethodsFields, paymentsFields, billingDocumentsFields, billingDocumentItemsFields, billToFields, soldToFields, defaultPaymentMethodFields, usageRecordsFields, invoicesFields, creditMemosFields, debitMemosFields, prepaidBalanceFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Account>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getAccountAsync(String accountId, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Account> _callback) throws ApiException {
        Call localVarCall = this.getAccountValidateBeforeCall(accountId, fields, accountFields, subscriptionsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceOwnerAccountFields, planFields, paymentMethodsFields, paymentsFields, billingDocumentsFields, billingDocumentItemsFields, billToFields, soldToFields, defaultPaymentMethodFields, usageRecordsFields, invoicesFields, creditMemosFields, debitMemosFields, prepaidBalanceFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetAccountParams getAccountParams(String accountId) {
        return new GetAccountParams(accountId);
    }

    public Account getAccount(String accountId) throws ApiException {
        GetAccountParams params = new GetAccountParams(accountId);
        return this.executeGetAccountAPICall(params).getData();
    }

    public Account getAccount(String accountId, List<String> expand) throws ApiException {
        GetAccountParams params = new GetAccountParams(accountId);
        params.expand(expand);
        return this.executeGetAccountAPICall(params).getData();
    }

    public Account getAccount(String accountId, List<String> expand, Headers headers) throws ApiException {
        GetAccountParams params = new GetAccountParams(accountId).expand(expand).headers(headers);
        return this.executeGetAccountAPICall(params).getData();
    }

    public Account get(GetAccountParams params) throws ApiException {
        return this.executeGetAccountAPICall(params).getData();
    }

    public ApiResponse<Account> getWithHttpInfo(GetAccountParams params) throws ApiException {
        return this.executeGetAccountAPICall(params);
    }

    ApiResponse<Account> executeGetAccountAPICall(GetAccountParams params) throws ApiException {
        return this.getAccountWithHttpInfo(params.accountId, params.fields, params.accountFields, params.subscriptionsFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.invoiceOwnerAccountFields, params.planFields, params.paymentMethodsFields, params.paymentsFields, params.billingDocumentsFields, params.billingDocumentItemsFields, params.billToFields, params.soldToFields, params.defaultPaymentMethodFields, params.usageRecordsFields, params.invoicesFields, params.creditMemosFields, params.debitMemosFields, params.prepaidBalanceFields, params.transactionsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getAccountsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (subscriptionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscriptions.fields[]", subscriptionsFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (paymentMethodsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_methods.fields[]", paymentMethodsFields));
        }
        if (paymentsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payments.fields[]", paymentsFields));
        }
        if (billingDocumentsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_documents.fields[]", billingDocumentsFields));
        }
        if (billingDocumentItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_document_items.fields[]", billingDocumentItemsFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (soldToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sold_to.fields[]", soldToFields));
        }
        if (defaultPaymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "default_payment_method.fields[]", defaultPaymentMethodFields));
        }
        if (usageRecordsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "usage_records.fields[]", usageRecordsFields));
        }
        if (invoicesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoices.fields[]", invoicesFields));
        }
        if (creditMemosFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memos.fields[]", creditMemosFields));
        }
        if (debitMemosFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memos.fields[]", debitMemosFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getAccountsCall(cursor, expand, filter, sort, pageSize, fields, accountFields, subscriptionsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceOwnerAccountFields, planFields, paymentMethodsFields, paymentsFields, billingDocumentsFields, billingDocumentItemsFields, billToFields, soldToFields, defaultPaymentMethodFields, usageRecordsFields, invoicesFields, creditMemosFields, debitMemosFields, prepaidBalanceFields, transactionsFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<ListAccountResponse> getAccountsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getAccountsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, accountFields, subscriptionsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceOwnerAccountFields, planFields, paymentMethodsFields, paymentsFields, billingDocumentsFields, billingDocumentItemsFields, billToFields, soldToFields, defaultPaymentMethodFields, usageRecordsFields, invoicesFields, creditMemosFields, debitMemosFields, prepaidBalanceFields, transactionsFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<ListAccountResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getAccountsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<ListAccountResponse> _callback) throws ApiException {
        Call localVarCall = this.getAccountsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, accountFields, subscriptionsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceOwnerAccountFields, planFields, paymentMethodsFields, paymentsFields, billingDocumentsFields, billingDocumentItemsFields, billToFields, soldToFields, defaultPaymentMethodFields, usageRecordsFields, invoicesFields, creditMemosFields, debitMemosFields, prepaidBalanceFields, transactionsFields, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<ListAccountResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetAccountsParams getAccountsParams() {
        return new GetAccountsParams();
    }

    public ListAccountResponse getAccounts() throws ApiException {
        GetAccountsParams params = new GetAccountsParams();
        return this.executeGetAccountsAPICall(params).getData();
    }

    public ListAccountResponse getAccounts(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetAccountsParams params = new GetAccountsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetAccountsAPICall(params).getData();
    }

    public ListAccountResponse getAccounts(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetAccountsParams params = new GetAccountsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetAccountsAPICall(params).getData();
    }

    public ListAccountResponse list(GetAccountsParams params) throws ApiException {
        return this.executeGetAccountsAPICall(params).getData();
    }

    public ApiResponse<ListAccountResponse> listWithHttpInfo(GetAccountsParams params) throws ApiException {
        return this.executeGetAccountsAPICall(params);
    }

    ApiResponse<ListAccountResponse> executeGetAccountsAPICall(GetAccountsParams params) throws ApiException {
        return this.getAccountsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.accountFields, params.subscriptionsFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.invoiceOwnerAccountFields, params.planFields, params.paymentMethodsFields, params.paymentsFields, params.billingDocumentsFields, params.billingDocumentItemsFields, params.billToFields, params.soldToFields, params.defaultPaymentMethodFields, params.usageRecordsFields, params.invoicesFields, params.creditMemosFields, params.debitMemosFields, params.prepaidBalanceFields, params.transactionsFields, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call previewAccountCall(String accountId, AccountPreviewRequest accountPreviewRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AccountPreviewRequest localVarPostBody = accountPreviewRequest;
        String localVarPath = "/accounts/{account_id}/preview".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call previewAccountValidateBeforeCall(String accountId, AccountPreviewRequest accountPreviewRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling previewAccount(Async)");
        }
        if (accountPreviewRequest == null) {
            throw new ApiException("Missing the required parameter 'accountPreviewRequest' when calling previewAccount(Async)");
        }
        return this.previewAccountCall(accountId, accountPreviewRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<AccountPreviewResponse> previewAccountWithHttpInfo(String accountId, AccountPreviewRequest accountPreviewRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.previewAccountValidateBeforeCall(accountId, accountPreviewRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<AccountPreviewResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call previewAccountAsync(String accountId, AccountPreviewRequest accountPreviewRequest, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<AccountPreviewResponse> _callback) throws ApiException {
        Call localVarCall = this.previewAccountValidateBeforeCall(accountId, accountPreviewRequest, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<AccountPreviewResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PreviewAccountParams previewAccountParams(String accountId, AccountPreviewRequest accountPreviewRequest) {
        return new PreviewAccountParams(accountId, accountPreviewRequest);
    }

    public AccountPreviewResponse previewAccount(String accountId, AccountPreviewRequest accountPreviewRequest) throws ApiException {
        PreviewAccountParams params = new PreviewAccountParams(accountId, accountPreviewRequest);
        return this.executePreviewAccountAPICall(params).getData();
    }

    public AccountPreviewResponse previewAccount(String accountId, AccountPreviewRequest accountPreviewRequest, Headers headers) throws ApiException {
        PreviewAccountParams params = new PreviewAccountParams(accountId, accountPreviewRequest).headers(headers);
        return this.executePreviewAccountAPICall(params).getData();
    }

    public AccountPreviewResponse previewAccount(PreviewAccountParams params) throws ApiException {
        return this.executePreviewAccountAPICall(params).getData();
    }

    public ApiResponse<AccountPreviewResponse> previewAccountWithHttpInfo(PreviewAccountParams params) throws ApiException {
        return this.executePreviewAccountAPICall(params);
    }

    ApiResponse<AccountPreviewResponse> executePreviewAccountAPICall(PreviewAccountParams params) throws ApiException {
        return this.previewAccountWithHttpInfo(params.accountId, params.accountPreviewRequest, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call updateAccountCall(String accountId, AccountPatchRequest accountPatchRequest, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AccountPatchRequest localVarPostBody = accountPatchRequest;
        String localVarPath = "/accounts/{account_id}".replace("{account_id}", this.localVarApiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (subscriptionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscriptions.fields[]", subscriptionsFields));
        }
        if (subscriptionPlansFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_plans.fields[]", subscriptionPlansFields));
        }
        if (subscriptionItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "subscription_items.fields[]", subscriptionItemsFields));
        }
        if (invoiceOwnerAccountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_owner_account.fields[]", invoiceOwnerAccountFields));
        }
        if (planFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "plan.fields[]", planFields));
        }
        if (paymentMethodsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_methods.fields[]", paymentMethodsFields));
        }
        if (paymentsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payments.fields[]", paymentsFields));
        }
        if (billingDocumentsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_documents.fields[]", billingDocumentsFields));
        }
        if (billingDocumentItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "billing_document_items.fields[]", billingDocumentItemsFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (soldToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sold_to.fields[]", soldToFields));
        }
        if (defaultPaymentMethodFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "default_payment_method.fields[]", defaultPaymentMethodFields));
        }
        if (usageRecordsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "usage_records.fields[]", usageRecordsFields));
        }
        if (invoicesFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoices.fields[]", invoicesFields));
        }
        if (creditMemosFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memos.fields[]", creditMemosFields));
        }
        if (debitMemosFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "debit_memos.fields[]", debitMemosFields));
        }
        if (prepaidBalanceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "prepaid_balance.fields[]", prepaidBalanceFields));
        }
        if (transactionsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "transactions.fields[]", transactionsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAccountValidateBeforeCall(String accountId, AccountPatchRequest accountPatchRequest, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling updateAccount(Async)");
        }
        if (accountPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'accountPatchRequest' when calling updateAccount(Async)");
        }
        return this.updateAccountCall(accountId, accountPatchRequest, fields, accountFields, subscriptionsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceOwnerAccountFields, planFields, paymentMethodsFields, paymentsFields, billingDocumentsFields, billingDocumentItemsFields, billToFields, soldToFields, defaultPaymentMethodFields, usageRecordsFields, invoicesFields, creditMemosFields, debitMemosFields, prepaidBalanceFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Account> updateAccountWithHttpInfo(String accountId, AccountPatchRequest accountPatchRequest, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateAccountValidateBeforeCall(accountId, accountPatchRequest, fields, accountFields, subscriptionsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceOwnerAccountFields, planFields, paymentMethodsFields, paymentsFields, billingDocumentsFields, billingDocumentItemsFields, billToFields, soldToFields, defaultPaymentMethodFields, usageRecordsFields, invoicesFields, creditMemosFields, debitMemosFields, prepaidBalanceFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Account>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updateAccountAsync(String accountId, AccountPatchRequest accountPatchRequest, List<String> fields, List<String> accountFields, List<String> subscriptionsFields, List<String> subscriptionPlansFields, List<String> subscriptionItemsFields, List<String> invoiceOwnerAccountFields, List<String> planFields, List<String> paymentMethodsFields, List<String> paymentsFields, List<String> billingDocumentsFields, List<String> billingDocumentItemsFields, List<String> billToFields, List<String> soldToFields, List<String> defaultPaymentMethodFields, List<String> usageRecordsFields, List<String> invoicesFields, List<String> creditMemosFields, List<String> debitMemosFields, List<String> prepaidBalanceFields, List<String> transactionsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Account> _callback) throws ApiException {
        Call localVarCall = this.updateAccountValidateBeforeCall(accountId, accountPatchRequest, fields, accountFields, subscriptionsFields, subscriptionPlansFields, subscriptionItemsFields, invoiceOwnerAccountFields, planFields, paymentMethodsFields, paymentsFields, billingDocumentsFields, billingDocumentItemsFields, billToFields, soldToFields, defaultPaymentMethodFields, usageRecordsFields, invoicesFields, creditMemosFields, debitMemosFields, prepaidBalanceFields, transactionsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Account>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateAccountParams updateAccountParams(String accountId, AccountPatchRequest accountPatchRequest) {
        return new UpdateAccountParams(accountId, accountPatchRequest);
    }

    public Account updateAccount(String accountId, AccountPatchRequest accountPatchRequest) throws ApiException {
        UpdateAccountParams params = new UpdateAccountParams(accountId, accountPatchRequest);
        return this.executeUpdateAccountAPICall(params).getData();
    }

    public Account updateAccount(String accountId, AccountPatchRequest accountPatchRequest, List<String> expand) throws ApiException {
        UpdateAccountParams params = new UpdateAccountParams(accountId, accountPatchRequest);
        params.expand(expand);
        return this.executeUpdateAccountAPICall(params).getData();
    }

    public Account updateAccount(String accountId, AccountPatchRequest accountPatchRequest, List<String> expand, Headers headers) throws ApiException {
        UpdateAccountParams params = new UpdateAccountParams(accountId, accountPatchRequest).expand(expand).headers(headers);
        return this.executeUpdateAccountAPICall(params).getData();
    }

    public Account update(UpdateAccountParams params) throws ApiException {
        return this.executeUpdateAccountAPICall(params).getData();
    }

    public ApiResponse<Account> updateWithHttpInfo(UpdateAccountParams params) throws ApiException {
        return this.executeUpdateAccountAPICall(params);
    }

    ApiResponse<Account> executeUpdateAccountAPICall(UpdateAccountParams params) throws ApiException {
        return this.updateAccountWithHttpInfo(params.accountId, params.accountPatchRequest, params.fields, params.accountFields, params.subscriptionsFields, params.subscriptionPlansFields, params.subscriptionItemsFields, params.invoiceOwnerAccountFields, params.planFields, params.paymentMethodsFields, params.paymentsFields, params.billingDocumentsFields, params.billingDocumentItemsFields, params.billToFields, params.soldToFields, params.defaultPaymentMethodFields, params.usageRecordsFields, params.invoicesFields, params.creditMemosFields, params.debitMemosFields, params.prepaidBalanceFields, params.transactionsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class UpdateAccountParams {
        private final String accountId;
        private final AccountPatchRequest accountPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> accountFields;
        private List<String> subscriptionsFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> paymentMethodsFields;
        private List<String> paymentsFields;
        private List<String> billingDocumentsFields;
        private List<String> billingDocumentItemsFields;
        private List<String> billToFields;
        private List<String> soldToFields;
        private List<String> defaultPaymentMethodFields;
        private List<String> usageRecordsFields;
        private List<String> invoicesFields;
        private List<String> creditMemosFields;
        private List<String> debitMemosFields;
        private List<String> prepaidBalanceFields;
        private List<String> transactionsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UpdateAccountParams(String accountId, AccountPatchRequest accountPatchRequest) {
            this.accountId = accountId;
            this.accountPatchRequest = accountPatchRequest;
        }

        public UpdateAccountParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UpdateAccountParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UpdateAccountParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UpdateAccountParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public UpdateAccountParams subscriptionsFields(List<String> subscriptionsFields) {
            this.subscriptionsFields = subscriptionsFields;
            return this;
        }

        public UpdateAccountParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public UpdateAccountParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public UpdateAccountParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public UpdateAccountParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public UpdateAccountParams paymentMethodsFields(List<String> paymentMethodsFields) {
            this.paymentMethodsFields = paymentMethodsFields;
            return this;
        }

        public UpdateAccountParams paymentsFields(List<String> paymentsFields) {
            this.paymentsFields = paymentsFields;
            return this;
        }

        public UpdateAccountParams billingDocumentsFields(List<String> billingDocumentsFields) {
            this.billingDocumentsFields = billingDocumentsFields;
            return this;
        }

        public UpdateAccountParams billingDocumentItemsFields(List<String> billingDocumentItemsFields) {
            this.billingDocumentItemsFields = billingDocumentItemsFields;
            return this;
        }

        public UpdateAccountParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public UpdateAccountParams soldToFields(List<String> soldToFields) {
            this.soldToFields = soldToFields;
            return this;
        }

        public UpdateAccountParams defaultPaymentMethodFields(List<String> defaultPaymentMethodFields) {
            this.defaultPaymentMethodFields = defaultPaymentMethodFields;
            return this;
        }

        public UpdateAccountParams usageRecordsFields(List<String> usageRecordsFields) {
            this.usageRecordsFields = usageRecordsFields;
            return this;
        }

        public UpdateAccountParams invoicesFields(List<String> invoicesFields) {
            this.invoicesFields = invoicesFields;
            return this;
        }

        public UpdateAccountParams creditMemosFields(List<String> creditMemosFields) {
            this.creditMemosFields = creditMemosFields;
            return this;
        }

        public UpdateAccountParams debitMemosFields(List<String> debitMemosFields) {
            this.debitMemosFields = debitMemosFields;
            return this;
        }

        public UpdateAccountParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public UpdateAccountParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }

        public UpdateAccountParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UpdateAccountParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UpdateAccountParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class PreviewAccountParams {
        private final String accountId;
        private final AccountPreviewRequest accountPreviewRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PreviewAccountParams(String accountId, AccountPreviewRequest accountPreviewRequest) {
            this.accountId = accountId;
            this.accountPreviewRequest = accountPreviewRequest;
        }

        public PreviewAccountParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class GetAccountsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> accountFields;
        private List<String> subscriptionsFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> paymentMethodsFields;
        private List<String> paymentsFields;
        private List<String> billingDocumentsFields;
        private List<String> billingDocumentItemsFields;
        private List<String> billToFields;
        private List<String> soldToFields;
        private List<String> defaultPaymentMethodFields;
        private List<String> usageRecordsFields;
        private List<String> invoicesFields;
        private List<String> creditMemosFields;
        private List<String> debitMemosFields;
        private List<String> prepaidBalanceFields;
        private List<String> transactionsFields;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetAccountsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetAccountsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetAccountsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetAccountsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetAccountsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetAccountsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetAccountsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetAccountsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetAccountsParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetAccountsParams subscriptionsFields(List<String> subscriptionsFields) {
            this.subscriptionsFields = subscriptionsFields;
            return this;
        }

        public GetAccountsParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public GetAccountsParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public GetAccountsParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public GetAccountsParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public GetAccountsParams paymentMethodsFields(List<String> paymentMethodsFields) {
            this.paymentMethodsFields = paymentMethodsFields;
            return this;
        }

        public GetAccountsParams paymentsFields(List<String> paymentsFields) {
            this.paymentsFields = paymentsFields;
            return this;
        }

        public GetAccountsParams billingDocumentsFields(List<String> billingDocumentsFields) {
            this.billingDocumentsFields = billingDocumentsFields;
            return this;
        }

        public GetAccountsParams billingDocumentItemsFields(List<String> billingDocumentItemsFields) {
            this.billingDocumentItemsFields = billingDocumentItemsFields;
            return this;
        }

        public GetAccountsParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public GetAccountsParams soldToFields(List<String> soldToFields) {
            this.soldToFields = soldToFields;
            return this;
        }

        public GetAccountsParams defaultPaymentMethodFields(List<String> defaultPaymentMethodFields) {
            this.defaultPaymentMethodFields = defaultPaymentMethodFields;
            return this;
        }

        public GetAccountsParams usageRecordsFields(List<String> usageRecordsFields) {
            this.usageRecordsFields = usageRecordsFields;
            return this;
        }

        public GetAccountsParams invoicesFields(List<String> invoicesFields) {
            this.invoicesFields = invoicesFields;
            return this;
        }

        public GetAccountsParams creditMemosFields(List<String> creditMemosFields) {
            this.creditMemosFields = creditMemosFields;
            return this;
        }

        public GetAccountsParams debitMemosFields(List<String> debitMemosFields) {
            this.debitMemosFields = debitMemosFields;
            return this;
        }

        public GetAccountsParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public GetAccountsParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }
    }

    public static class GetAccountParams {
        private final String accountId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> accountFields;
        private List<String> subscriptionsFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> paymentMethodsFields;
        private List<String> paymentsFields;
        private List<String> billingDocumentsFields;
        private List<String> billingDocumentItemsFields;
        private List<String> billToFields;
        private List<String> soldToFields;
        private List<String> defaultPaymentMethodFields;
        private List<String> usageRecordsFields;
        private List<String> invoicesFields;
        private List<String> creditMemosFields;
        private List<String> debitMemosFields;
        private List<String> prepaidBalanceFields;
        private List<String> transactionsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetAccountParams(String accountId) {
            this.accountId = accountId;
        }

        public GetAccountParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetAccountParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetAccountParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetAccountParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetAccountParams subscriptionsFields(List<String> subscriptionsFields) {
            this.subscriptionsFields = subscriptionsFields;
            return this;
        }

        public GetAccountParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public GetAccountParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public GetAccountParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public GetAccountParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public GetAccountParams paymentMethodsFields(List<String> paymentMethodsFields) {
            this.paymentMethodsFields = paymentMethodsFields;
            return this;
        }

        public GetAccountParams paymentsFields(List<String> paymentsFields) {
            this.paymentsFields = paymentsFields;
            return this;
        }

        public GetAccountParams billingDocumentsFields(List<String> billingDocumentsFields) {
            this.billingDocumentsFields = billingDocumentsFields;
            return this;
        }

        public GetAccountParams billingDocumentItemsFields(List<String> billingDocumentItemsFields) {
            this.billingDocumentItemsFields = billingDocumentItemsFields;
            return this;
        }

        public GetAccountParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public GetAccountParams soldToFields(List<String> soldToFields) {
            this.soldToFields = soldToFields;
            return this;
        }

        public GetAccountParams defaultPaymentMethodFields(List<String> defaultPaymentMethodFields) {
            this.defaultPaymentMethodFields = defaultPaymentMethodFields;
            return this;
        }

        public GetAccountParams usageRecordsFields(List<String> usageRecordsFields) {
            this.usageRecordsFields = usageRecordsFields;
            return this;
        }

        public GetAccountParams invoicesFields(List<String> invoicesFields) {
            this.invoicesFields = invoicesFields;
            return this;
        }

        public GetAccountParams creditMemosFields(List<String> creditMemosFields) {
            this.creditMemosFields = creditMemosFields;
            return this;
        }

        public GetAccountParams debitMemosFields(List<String> debitMemosFields) {
            this.debitMemosFields = debitMemosFields;
            return this;
        }

        public GetAccountParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public GetAccountParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }

        public GetAccountParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetAccountParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetAccountParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GenerateBillingDocumentsParams {
        private final String accountId;
        private final GenerateBillingDocumentsAccountRequest generateBillingDocumentsAccountRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GenerateBillingDocumentsParams(String accountId, GenerateBillingDocumentsAccountRequest generateBillingDocumentsAccountRequest) {
            this.accountId = accountId;
            this.generateBillingDocumentsAccountRequest = generateBillingDocumentsAccountRequest;
        }

        public GenerateBillingDocumentsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class DeleteAccountParams {
        private final String accountId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public DeleteAccountParams(String accountId) {
            this.accountId = accountId;
        }

        public DeleteAccountParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateAccountParams {
        private final AccountCreateRequest accountCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> accountFields;
        private List<String> subscriptionsFields;
        private List<String> subscriptionPlansFields;
        private List<String> subscriptionItemsFields;
        private List<String> invoiceOwnerAccountFields;
        private List<String> planFields;
        private List<String> paymentMethodsFields;
        private List<String> paymentsFields;
        private List<String> billingDocumentsFields;
        private List<String> billingDocumentItemsFields;
        private List<String> billToFields;
        private List<String> soldToFields;
        private List<String> defaultPaymentMethodFields;
        private List<String> usageRecordsFields;
        private List<String> invoicesFields;
        private List<String> creditMemosFields;
        private List<String> debitMemosFields;
        private List<String> prepaidBalanceFields;
        private List<String> transactionsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateAccountParams(AccountCreateRequest accountCreateRequest) {
            this.accountCreateRequest = accountCreateRequest;
        }

        public CreateAccountParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateAccountParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateAccountParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateAccountParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CreateAccountParams subscriptionsFields(List<String> subscriptionsFields) {
            this.subscriptionsFields = subscriptionsFields;
            return this;
        }

        public CreateAccountParams subscriptionPlansFields(List<String> subscriptionPlansFields) {
            this.subscriptionPlansFields = subscriptionPlansFields;
            return this;
        }

        public CreateAccountParams subscriptionItemsFields(List<String> subscriptionItemsFields) {
            this.subscriptionItemsFields = subscriptionItemsFields;
            return this;
        }

        public CreateAccountParams invoiceOwnerAccountFields(List<String> invoiceOwnerAccountFields) {
            this.invoiceOwnerAccountFields = invoiceOwnerAccountFields;
            return this;
        }

        public CreateAccountParams planFields(List<String> planFields) {
            this.planFields = planFields;
            return this;
        }

        public CreateAccountParams paymentMethodsFields(List<String> paymentMethodsFields) {
            this.paymentMethodsFields = paymentMethodsFields;
            return this;
        }

        public CreateAccountParams paymentsFields(List<String> paymentsFields) {
            this.paymentsFields = paymentsFields;
            return this;
        }

        public CreateAccountParams billingDocumentsFields(List<String> billingDocumentsFields) {
            this.billingDocumentsFields = billingDocumentsFields;
            return this;
        }

        public CreateAccountParams billingDocumentItemsFields(List<String> billingDocumentItemsFields) {
            this.billingDocumentItemsFields = billingDocumentItemsFields;
            return this;
        }

        public CreateAccountParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public CreateAccountParams soldToFields(List<String> soldToFields) {
            this.soldToFields = soldToFields;
            return this;
        }

        public CreateAccountParams defaultPaymentMethodFields(List<String> defaultPaymentMethodFields) {
            this.defaultPaymentMethodFields = defaultPaymentMethodFields;
            return this;
        }

        public CreateAccountParams usageRecordsFields(List<String> usageRecordsFields) {
            this.usageRecordsFields = usageRecordsFields;
            return this;
        }

        public CreateAccountParams invoicesFields(List<String> invoicesFields) {
            this.invoicesFields = invoicesFields;
            return this;
        }

        public CreateAccountParams creditMemosFields(List<String> creditMemosFields) {
            this.creditMemosFields = creditMemosFields;
            return this;
        }

        public CreateAccountParams debitMemosFields(List<String> debitMemosFields) {
            this.debitMemosFields = debitMemosFields;
            return this;
        }

        public CreateAccountParams prepaidBalanceFields(List<String> prepaidBalanceFields) {
            this.prepaidBalanceFields = prepaidBalanceFields;
            return this;
        }

        public CreateAccountParams transactionsFields(List<String> transactionsFields) {
            this.transactionsFields = transactionsFields;
            return this;
        }

        public CreateAccountParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateAccountParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateAccountParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

