/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.ExpandedUploadCsv;
import com.zuora.model.ExpandedUploadCsvStatus;
import com.zuora.model.ExpandedUploadFile;
import com.zuora.model.ExpandedUploadFileStatus;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class UploadApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public UploadApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UploadApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call integrationV1CsvUploadPostCall(String token, String templatename, String data, String filename, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/csv/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (data != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("data", data));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if (templatename != null) {
            localVarHeaderParams.put("templatename", this.localVarApiClient.parameterToString(templatename));
        }
        if (filename != null) {
            localVarHeaderParams.put("filename", this.localVarApiClient.parameterToString(filename));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call integrationV1CsvUploadPostValidateBeforeCall(String token, String templatename, String data, String filename, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling integrationV1CsvUploadPost(Async)");
        }
        if (templatename == null) {
            throw new ApiException("Missing the required parameter 'templatename' when calling integrationV1CsvUploadPost(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling integrationV1CsvUploadPost(Async)");
        }
        if (filename == null) {
            throw new ApiException("Missing the required parameter 'filename' when calling integrationV1CsvUploadPost(Async)");
        }
        return this.integrationV1CsvUploadPostCall(token, templatename, data, filename, _callback);
    }

    protected ExpandedUploadCsv integrationV1CsvUploadPost(String token, String templatename, String data, String filename) throws ApiException {
        ApiResponse<ExpandedUploadCsv> localVarResp = this.integrationV1CsvUploadPostWithHttpInfo(token, templatename, data, filename);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedUploadCsv> integrationV1CsvUploadPostWithHttpInfo(String token, String templatename, String data, String filename) throws ApiException {
        Call localVarCall = this.integrationV1CsvUploadPostValidateBeforeCall(token, templatename, data, filename, null);
        Type localVarReturnType = new TypeToken<ExpandedUploadCsv>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call integrationV1CsvUploadPostAsync(String token, String templatename, String data, String filename, ApiCallback<ExpandedUploadCsv> _callback) throws ApiException {
        Call localVarCall = this.integrationV1CsvUploadPostValidateBeforeCall(token, templatename, data, filename, _callback);
        Type localVarReturnType = new TypeToken<ExpandedUploadCsv>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public IntegrationV1CsvUploadPostApi integrationV1CsvUploadPostApi(String token, String templatename, String data, String filename) {
        return new IntegrationV1CsvUploadPostApi(token, templatename, data, filename);
    }

    private Call integrationV1CsvUploadStatusGetCall(Integer id, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/csv/upload/status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call integrationV1CsvUploadStatusGetValidateBeforeCall(Integer id, String token, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling integrationV1CsvUploadStatusGet(Async)");
        }
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling integrationV1CsvUploadStatusGet(Async)");
        }
        return this.integrationV1CsvUploadStatusGetCall(id, token, _callback);
    }

    protected ExpandedUploadCsvStatus integrationV1CsvUploadStatusGet(Integer id, String token) throws ApiException {
        ApiResponse<ExpandedUploadCsvStatus> localVarResp = this.integrationV1CsvUploadStatusGetWithHttpInfo(id, token);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedUploadCsvStatus> integrationV1CsvUploadStatusGetWithHttpInfo(Integer id, String token) throws ApiException {
        Call localVarCall = this.integrationV1CsvUploadStatusGetValidateBeforeCall(id, token, null);
        Type localVarReturnType = new TypeToken<ExpandedUploadCsvStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call integrationV1CsvUploadStatusGetAsync(Integer id, String token, ApiCallback<ExpandedUploadCsvStatus> _callback) throws ApiException {
        Call localVarCall = this.integrationV1CsvUploadStatusGetValidateBeforeCall(id, token, _callback);
        Type localVarReturnType = new TypeToken<ExpandedUploadCsvStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public IntegrationV1CsvUploadStatusGetApi integrationV1CsvUploadStatusGetApi(Integer id, String token) {
        return new IntegrationV1CsvUploadStatusGetApi(id, token);
    }

    private Call integrationV1FileuploadStatusFileRequestIdGetCall(String token, Integer fileRequestId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/fileupload/status/{file_request_id}".replace("{file_request_id}", this.localVarApiClient.escapeString(fileRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call integrationV1FileuploadStatusFileRequestIdGetValidateBeforeCall(String token, Integer fileRequestId, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling integrationV1FileuploadStatusFileRequestIdGet(Async)");
        }
        if (fileRequestId == null) {
            throw new ApiException("Missing the required parameter 'fileRequestId' when calling integrationV1FileuploadStatusFileRequestIdGet(Async)");
        }
        return this.integrationV1FileuploadStatusFileRequestIdGetCall(token, fileRequestId, _callback);
    }

    protected ExpandedUploadFileStatus integrationV1FileuploadStatusFileRequestIdGet(String token, Integer fileRequestId) throws ApiException {
        ApiResponse<ExpandedUploadFileStatus> localVarResp = this.integrationV1FileuploadStatusFileRequestIdGetWithHttpInfo(token, fileRequestId);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedUploadFileStatus> integrationV1FileuploadStatusFileRequestIdGetWithHttpInfo(String token, Integer fileRequestId) throws ApiException {
        Call localVarCall = this.integrationV1FileuploadStatusFileRequestIdGetValidateBeforeCall(token, fileRequestId, null);
        Type localVarReturnType = new TypeToken<ExpandedUploadFileStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call integrationV1FileuploadStatusFileRequestIdGetAsync(String token, Integer fileRequestId, ApiCallback<ExpandedUploadFileStatus> _callback) throws ApiException {
        Call localVarCall = this.integrationV1FileuploadStatusFileRequestIdGetValidateBeforeCall(token, fileRequestId, _callback);
        Type localVarReturnType = new TypeToken<ExpandedUploadFileStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public IntegrationV1FileuploadStatusFileRequestIdGetApi integrationV1FileuploadStatusFileRequestIdGetApi(String token, Integer fileRequestId) {
        return new IntegrationV1FileuploadStatusFileRequestIdGetApi(token, fileRequestId);
    }

    private Call integrationV1UploadFileLogFileNameGetCall(String token, Integer fileRequestId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/upload/file/log/{file_name}".replace("{file_request_id}", this.localVarApiClient.escapeString(fileRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call integrationV1UploadFileLogFileNameGetValidateBeforeCall(String token, Integer fileRequestId, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling integrationV1UploadFileLogFileNameGet(Async)");
        }
        if (fileRequestId == null) {
            throw new ApiException("Missing the required parameter 'fileRequestId' when calling integrationV1UploadFileLogFileNameGet(Async)");
        }
        return this.integrationV1UploadFileLogFileNameGetCall(token, fileRequestId, _callback);
    }

    protected ExpandedUploadFileStatus integrationV1UploadFileLogFileNameGet(String token, Integer fileRequestId) throws ApiException {
        ApiResponse<ExpandedUploadFileStatus> localVarResp = this.integrationV1UploadFileLogFileNameGetWithHttpInfo(token, fileRequestId);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedUploadFileStatus> integrationV1UploadFileLogFileNameGetWithHttpInfo(String token, Integer fileRequestId) throws ApiException {
        Call localVarCall = this.integrationV1UploadFileLogFileNameGetValidateBeforeCall(token, fileRequestId, null);
        Type localVarReturnType = new TypeToken<ExpandedUploadFileStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call integrationV1UploadFileLogFileNameGetAsync(String token, Integer fileRequestId, ApiCallback<ExpandedUploadFileStatus> _callback) throws ApiException {
        Call localVarCall = this.integrationV1UploadFileLogFileNameGetValidateBeforeCall(token, fileRequestId, _callback);
        Type localVarReturnType = new TypeToken<ExpandedUploadFileStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public IntegrationV1UploadFileLogFileNameGetApi integrationV1UploadFileLogFileNameGetApi(String token, Integer fileRequestId) {
        return new IntegrationV1UploadFileLogFileNameGetApi(token, fileRequestId);
    }

    private Call integrationV1UploadFilePostCall(String token, File _file, String templatename, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/upload/file";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("file", _file));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if (templatename != null) {
            localVarHeaderParams.put("templatename", this.localVarApiClient.parameterToString(templatename));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call integrationV1UploadFilePostValidateBeforeCall(String token, File _file, String templatename, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling integrationV1UploadFilePost(Async)");
        }
        if (_file == null) {
            throw new ApiException("Missing the required parameter '_file' when calling integrationV1UploadFilePost(Async)");
        }
        if (templatename == null) {
            throw new ApiException("Missing the required parameter 'templatename' when calling integrationV1UploadFilePost(Async)");
        }
        return this.integrationV1UploadFilePostCall(token, _file, templatename, _callback);
    }

    protected ExpandedUploadFile integrationV1UploadFilePost(String token, File _file, String templatename) throws ApiException {
        ApiResponse<ExpandedUploadFile> localVarResp = this.integrationV1UploadFilePostWithHttpInfo(token, _file, templatename);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedUploadFile> integrationV1UploadFilePostWithHttpInfo(String token, File _file, String templatename) throws ApiException {
        Call localVarCall = this.integrationV1UploadFilePostValidateBeforeCall(token, _file, templatename, null);
        Type localVarReturnType = new TypeToken<ExpandedUploadFile>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call integrationV1UploadFilePostAsync(String token, File _file, String templatename, ApiCallback<ExpandedUploadFile> _callback) throws ApiException {
        Call localVarCall = this.integrationV1UploadFilePostValidateBeforeCall(token, _file, templatename, _callback);
        Type localVarReturnType = new TypeToken<ExpandedUploadFile>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public IntegrationV1UploadFilePostApi integrationV1UploadFilePostApi(String token, File _file, String templatename) {
        return new IntegrationV1UploadFilePostApi(token, _file, templatename);
    }

    public class IntegrationV1UploadFilePostApi {
        private final String token;
        private final File _file;
        private final String templatename;

        private IntegrationV1UploadFilePostApi(String token, File _file, String templatename) {
            this.token = token;
            this._file = _file;
            this.templatename = templatename;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UploadApi.this.integrationV1UploadFilePostCall(this.token, this._file, this.templatename, _callback);
        }

        public ExpandedUploadFile execute() throws ApiException {
            ApiResponse localVarResp = UploadApi.this.integrationV1UploadFilePostWithHttpInfo(this.token, this._file, this.templatename);
            return (ExpandedUploadFile)localVarResp.getData();
        }

        private ApiResponse<ExpandedUploadFile> executeWithHttpInfo() throws ApiException {
            return UploadApi.this.integrationV1UploadFilePostWithHttpInfo(this.token, this._file, this.templatename);
        }

        public Call executeAsync(ApiCallback<ExpandedUploadFile> _callback) throws ApiException {
            return UploadApi.this.integrationV1UploadFilePostAsync(this.token, this._file, this.templatename, _callback);
        }
    }

    public class IntegrationV1UploadFileLogFileNameGetApi {
        private final String token;
        private final Integer fileRequestId;

        private IntegrationV1UploadFileLogFileNameGetApi(String token, Integer fileRequestId) {
            this.token = token;
            this.fileRequestId = fileRequestId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UploadApi.this.integrationV1UploadFileLogFileNameGetCall(this.token, this.fileRequestId, _callback);
        }

        public ExpandedUploadFileStatus execute() throws ApiException {
            ApiResponse localVarResp = UploadApi.this.integrationV1UploadFileLogFileNameGetWithHttpInfo(this.token, this.fileRequestId);
            return (ExpandedUploadFileStatus)localVarResp.getData();
        }

        private ApiResponse<ExpandedUploadFileStatus> executeWithHttpInfo() throws ApiException {
            return UploadApi.this.integrationV1UploadFileLogFileNameGetWithHttpInfo(this.token, this.fileRequestId);
        }

        public Call executeAsync(ApiCallback<ExpandedUploadFileStatus> _callback) throws ApiException {
            return UploadApi.this.integrationV1UploadFileLogFileNameGetAsync(this.token, this.fileRequestId, _callback);
        }
    }

    public class IntegrationV1FileuploadStatusFileRequestIdGetApi {
        private final String token;
        private final Integer fileRequestId;

        private IntegrationV1FileuploadStatusFileRequestIdGetApi(String token, Integer fileRequestId) {
            this.token = token;
            this.fileRequestId = fileRequestId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UploadApi.this.integrationV1FileuploadStatusFileRequestIdGetCall(this.token, this.fileRequestId, _callback);
        }

        public ExpandedUploadFileStatus execute() throws ApiException {
            ApiResponse localVarResp = UploadApi.this.integrationV1FileuploadStatusFileRequestIdGetWithHttpInfo(this.token, this.fileRequestId);
            return (ExpandedUploadFileStatus)localVarResp.getData();
        }

        private ApiResponse<ExpandedUploadFileStatus> executeWithHttpInfo() throws ApiException {
            return UploadApi.this.integrationV1FileuploadStatusFileRequestIdGetWithHttpInfo(this.token, this.fileRequestId);
        }

        public Call executeAsync(ApiCallback<ExpandedUploadFileStatus> _callback) throws ApiException {
            return UploadApi.this.integrationV1FileuploadStatusFileRequestIdGetAsync(this.token, this.fileRequestId, _callback);
        }
    }

    public class IntegrationV1CsvUploadStatusGetApi {
        private final Integer id;
        private final String token;

        private IntegrationV1CsvUploadStatusGetApi(Integer id, String token) {
            this.id = id;
            this.token = token;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UploadApi.this.integrationV1CsvUploadStatusGetCall(this.id, this.token, _callback);
        }

        public ExpandedUploadCsvStatus execute() throws ApiException {
            ApiResponse localVarResp = UploadApi.this.integrationV1CsvUploadStatusGetWithHttpInfo(this.id, this.token);
            return (ExpandedUploadCsvStatus)localVarResp.getData();
        }

        private ApiResponse<ExpandedUploadCsvStatus> executeWithHttpInfo() throws ApiException {
            return UploadApi.this.integrationV1CsvUploadStatusGetWithHttpInfo(this.id, this.token);
        }

        public Call executeAsync(ApiCallback<ExpandedUploadCsvStatus> _callback) throws ApiException {
            return UploadApi.this.integrationV1CsvUploadStatusGetAsync(this.id, this.token, _callback);
        }
    }

    public class IntegrationV1CsvUploadPostApi {
        private final String token;
        private final String templatename;
        private final String data;
        private final String filename;

        private IntegrationV1CsvUploadPostApi(String token, String templatename, String data, String filename) {
            this.token = token;
            this.templatename = templatename;
            this.data = data;
            this.filename = filename;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return UploadApi.this.integrationV1CsvUploadPostCall(this.token, this.templatename, this.data, this.filename, _callback);
        }

        public ExpandedUploadCsv execute() throws ApiException {
            ApiResponse localVarResp = UploadApi.this.integrationV1CsvUploadPostWithHttpInfo(this.token, this.templatename, this.data, this.filename);
            return (ExpandedUploadCsv)localVarResp.getData();
        }

        private ApiResponse<ExpandedUploadCsv> executeWithHttpInfo() throws ApiException {
            return UploadApi.this.integrationV1CsvUploadPostWithHttpInfo(this.token, this.templatename, this.data, this.filename);
        }

        public Call executeAsync(ApiCallback<ExpandedUploadCsv> _callback) throws ApiException {
            return UploadApi.this.integrationV1CsvUploadPostAsync(this.token, this.templatename, this.data, this.filename, _callback);
        }
    }
}

