/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.PriceFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"upTo", "from", "priceFormat", "flatAmounts", "unitAmounts", "overageAmounts", "tier"})
public class Tier {
    public static final String JSON_PROPERTY_UP_TO = "upTo";
    private Double upTo;
    public static final String JSON_PROPERTY_FROM = "from";
    private Double from;
    public static final String JSON_PROPERTY_PRICE_FORMAT = "priceFormat";
    private PriceFormat priceFormat = PriceFormat.FLAT_FEE;
    public static final String JSON_PROPERTY_FLAT_AMOUNTS = "flatAmounts";
    private Map<String, Double> flatAmounts = new HashMap<String, Double>();
    public static final String JSON_PROPERTY_UNIT_AMOUNTS = "unitAmounts";
    private Map<String, Double> unitAmounts = new HashMap<String, Double>();
    public static final String JSON_PROPERTY_OVERAGE_AMOUNTS = "overageAmounts";
    private Map<String, Double> overageAmounts = new HashMap<String, Double>();
    public static final String JSON_PROPERTY_TIER = "tier";
    private String tier;

    public Tier() {
    }

    public Tier upTo(Double upTo) {
        this.upTo = upTo;
        return this;
    }

    @Nullable
    @JsonProperty(value="upTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUpTo() {
        return this.upTo;
    }

    @JsonProperty(value="upTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpTo(Double upTo) {
        this.upTo = upTo;
    }

    public Tier from(Double from) {
        this.from = from;
        return this;
    }

    @Nullable
    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getFrom() {
        return this.from;
    }

    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFrom(Double from) {
        this.from = from;
    }

    public Tier priceFormat(PriceFormat priceFormat) {
        this.priceFormat = priceFormat;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="priceFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PriceFormat getPriceFormat() {
        return this.priceFormat;
    }

    @JsonProperty(value="priceFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriceFormat(PriceFormat priceFormat) {
        this.priceFormat = priceFormat;
    }

    public Tier flatAmounts(Map<String, Double> flatAmounts) {
        this.flatAmounts = flatAmounts;
        return this;
    }

    public Tier putFlatAmountsItem(String key, Double flatAmountsItem) {
        if (this.flatAmounts == null) {
            this.flatAmounts = new HashMap<String, Double>();
        }
        this.flatAmounts.put(key, flatAmountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="flatAmounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getFlatAmounts() {
        return this.flatAmounts;
    }

    @JsonProperty(value="flatAmounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlatAmounts(Map<String, Double> flatAmounts) {
        this.flatAmounts = flatAmounts;
    }

    public Tier unitAmounts(Map<String, Double> unitAmounts) {
        this.unitAmounts = unitAmounts;
        return this;
    }

    public Tier putUnitAmountsItem(String key, Double unitAmountsItem) {
        if (this.unitAmounts == null) {
            this.unitAmounts = new HashMap<String, Double>();
        }
        this.unitAmounts.put(key, unitAmountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="unitAmounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getUnitAmounts() {
        return this.unitAmounts;
    }

    @JsonProperty(value="unitAmounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnitAmounts(Map<String, Double> unitAmounts) {
        this.unitAmounts = unitAmounts;
    }

    public Tier overageAmounts(Map<String, Double> overageAmounts) {
        this.overageAmounts = overageAmounts;
        return this;
    }

    public Tier putOverageAmountsItem(String key, Double overageAmountsItem) {
        if (this.overageAmounts == null) {
            this.overageAmounts = new HashMap<String, Double>();
        }
        this.overageAmounts.put(key, overageAmountsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="overageAmounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getOverageAmounts() {
        return this.overageAmounts;
    }

    @JsonProperty(value="overageAmounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOverageAmounts(Map<String, Double> overageAmounts) {
        this.overageAmounts = overageAmounts;
    }

    public Tier tier(String tier) {
        this.tier = tier;
        return this;
    }

    @Nullable
    @JsonProperty(value="tier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTier() {
        return this.tier;
    }

    @JsonProperty(value="tier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTier(String tier) {
        this.tier = tier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tier tier = (Tier)o;
        return Objects.equals(this.upTo, tier.upTo) && Objects.equals(this.from, tier.from) && Objects.equals((Object)this.priceFormat, (Object)tier.priceFormat) && Objects.equals(this.flatAmounts, tier.flatAmounts) && Objects.equals(this.unitAmounts, tier.unitAmounts) && Objects.equals(this.overageAmounts, tier.overageAmounts) && Objects.equals(this.tier, tier.tier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.upTo, this.from, this.priceFormat, this.flatAmounts, this.unitAmounts, this.overageAmounts, this.tier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tier {\n");
        sb.append("    upTo: ").append(this.toIndentedString(this.upTo)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    priceFormat: ").append(this.toIndentedString((Object)this.priceFormat)).append("\n");
        sb.append("    flatAmounts: ").append(this.toIndentedString(this.flatAmounts)).append("\n");
        sb.append("    unitAmounts: ").append(this.toIndentedString(this.unitAmounts)).append("\n");
        sb.append("    overageAmounts: ").append(this.toIndentedString(this.overageAmounts)).append("\n");
        sb.append("    tier: ").append(this.toIndentedString(this.tier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TierBuilder builder() {
        return new TierBuilder();
    }

    public Tier(Double upTo, Double from, PriceFormat priceFormat, Map<String, Double> flatAmounts, Map<String, Double> unitAmounts, Map<String, Double> overageAmounts, String tier) {
        this.upTo = upTo;
        this.from = from;
        this.priceFormat = priceFormat;
        this.flatAmounts = flatAmounts;
        this.unitAmounts = unitAmounts;
        this.overageAmounts = overageAmounts;
        this.tier = tier;
    }

    public static class TierBuilder {
        private Double upTo;
        private Double from;
        private PriceFormat priceFormat;
        private Map<String, Double> flatAmounts;
        private Map<String, Double> unitAmounts;
        private Map<String, Double> overageAmounts;
        private String tier;

        TierBuilder() {
        }

        public TierBuilder upTo(Double upTo) {
            this.upTo = upTo;
            return this;
        }

        public TierBuilder from(Double from) {
            this.from = from;
            return this;
        }

        public TierBuilder priceFormat(PriceFormat priceFormat) {
            this.priceFormat = priceFormat;
            return this;
        }

        public TierBuilder flatAmounts(Map<String, Double> flatAmounts) {
            this.flatAmounts = flatAmounts;
            return this;
        }

        public TierBuilder unitAmounts(Map<String, Double> unitAmounts) {
            this.unitAmounts = unitAmounts;
            return this;
        }

        public TierBuilder overageAmounts(Map<String, Double> overageAmounts) {
            this.overageAmounts = overageAmounts;
            return this;
        }

        public TierBuilder tier(String tier) {
            this.tier = tier;
            return this;
        }

        public Tier build() {
            return new Tier(this.upTo, this.from, this.priceFormat, this.flatAmounts, this.unitAmounts, this.overageAmounts, this.tier);
        }

        public String toString() {
            return "Tier.TierBuilder(upTo=" + this.upTo + ", from=" + this.from + ", priceFormat=" + this.priceFormat + ", flatAmounts=" + this.flatAmounts + ", unitAmounts=" + this.unitAmounts + ", overageAmounts=" + this.overageAmounts + ", tier=" + this.tier + ")";
        }
    }
}

