/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.Value;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"tenant", "chargeId", "quantity", "currency", "context", "cumulativeQuantity"})
public class GetPriceRequest {
    public static final String JSON_PROPERTY_TENANT = "tenant";
    private String tenant;
    public static final String JSON_PROPERTY_CHARGE_ID = "chargeId";
    private String chargeId;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Double quantity;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_CONTEXT = "context";
    private Map<String, Value> context = new HashMap<String, Value>();
    public static final String JSON_PROPERTY_CUMULATIVE_QUANTITY = "cumulativeQuantity";
    private Double cumulativeQuantity;

    public GetPriceRequest() {
    }

    public GetPriceRequest tenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    @Nullable
    @JsonProperty(value="tenant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenant() {
        return this.tenant;
    }

    @JsonProperty(value="tenant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public GetPriceRequest chargeId(String chargeId) {
        this.chargeId = chargeId;
        return this;
    }

    @Nullable
    @JsonProperty(value="chargeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChargeId() {
        return this.chargeId;
    }

    @JsonProperty(value="chargeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChargeId(String chargeId) {
        this.chargeId = chargeId;
    }

    public GetPriceRequest quantity(Double quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public GetPriceRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public GetPriceRequest context(Map<String, Value> context) {
        this.context = context;
        return this;
    }

    public GetPriceRequest putContextItem(String key, Value contextItem) {
        if (this.context == null) {
            this.context = new HashMap<String, Value>();
        }
        this.context.put(key, contextItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Value> getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContext(Map<String, Value> context) {
        this.context = context;
    }

    public GetPriceRequest cumulativeQuantity(Double cumulativeQuantity) {
        this.cumulativeQuantity = cumulativeQuantity;
        return this;
    }

    @Nullable
    @JsonProperty(value="cumulativeQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getCumulativeQuantity() {
        return this.cumulativeQuantity;
    }

    @JsonProperty(value="cumulativeQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCumulativeQuantity(Double cumulativeQuantity) {
        this.cumulativeQuantity = cumulativeQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPriceRequest getPriceRequest = (GetPriceRequest)o;
        return Objects.equals(this.tenant, getPriceRequest.tenant) && Objects.equals(this.chargeId, getPriceRequest.chargeId) && Objects.equals(this.quantity, getPriceRequest.quantity) && Objects.equals(this.currency, getPriceRequest.currency) && Objects.equals(this.context, getPriceRequest.context) && Objects.equals(this.cumulativeQuantity, getPriceRequest.cumulativeQuantity);
    }

    public int hashCode() {
        return Objects.hash(this.tenant, this.chargeId, this.quantity, this.currency, this.context, this.cumulativeQuantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetPriceRequest {\n");
        sb.append("    tenant: ").append(this.toIndentedString(this.tenant)).append("\n");
        sb.append("    chargeId: ").append(this.toIndentedString(this.chargeId)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    cumulativeQuantity: ").append(this.toIndentedString(this.cumulativeQuantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetPriceRequestBuilder builder() {
        return new GetPriceRequestBuilder();
    }

    public GetPriceRequest(String tenant, String chargeId, Double quantity, String currency, Map<String, Value> context, Double cumulativeQuantity) {
        this.tenant = tenant;
        this.chargeId = chargeId;
        this.quantity = quantity;
        this.currency = currency;
        this.context = context;
        this.cumulativeQuantity = cumulativeQuantity;
    }

    public static class GetPriceRequestBuilder {
        private String tenant;
        private String chargeId;
        private Double quantity;
        private String currency;
        private Map<String, Value> context;
        private Double cumulativeQuantity;

        GetPriceRequestBuilder() {
        }

        public GetPriceRequestBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public GetPriceRequestBuilder chargeId(String chargeId) {
            this.chargeId = chargeId;
            return this;
        }

        public GetPriceRequestBuilder quantity(Double quantity) {
            this.quantity = quantity;
            return this;
        }

        public GetPriceRequestBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public GetPriceRequestBuilder context(Map<String, Value> context) {
            this.context = context;
            return this;
        }

        public GetPriceRequestBuilder cumulativeQuantity(Double cumulativeQuantity) {
            this.cumulativeQuantity = cumulativeQuantity;
            return this;
        }

        public GetPriceRequest build() {
            return new GetPriceRequest(this.tenant, this.chargeId, this.quantity, this.currency, this.context, this.cumulativeQuantity);
        }

        public String toString() {
            return "GetPriceRequest.GetPriceRequestBuilder(tenant=" + this.tenant + ", chargeId=" + this.chargeId + ", quantity=" + this.quantity + ", currency=" + this.currency + ", context=" + this.context + ", cumulativeQuantity=" + this.cumulativeQuantity + ")";
        }
    }
}

