/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.ChargeType;
import com.zuora.zevolve.api.model.Interval;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"type", "intervalCount", "interval", "listPrice"})
public class FeaturePrice {
    public static final String JSON_PROPERTY_TYPE = "type";
    private ChargeType type = ChargeType.ONE_TIME;
    public static final String JSON_PROPERTY_INTERVAL_COUNT = "intervalCount";
    private Double intervalCount;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private Interval interval = Interval.UNSPECIFIED;
    public static final String JSON_PROPERTY_LIST_PRICE = "listPrice";
    private Map<String, Double> listPrice = new HashMap<String, Double>();

    public FeaturePrice() {
    }

    public FeaturePrice type(ChargeType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChargeType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(ChargeType type) {
        this.type = type;
    }

    public FeaturePrice intervalCount(Double intervalCount) {
        this.intervalCount = intervalCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="intervalCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getIntervalCount() {
        return this.intervalCount;
    }

    @JsonProperty(value="intervalCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIntervalCount(Double intervalCount) {
        this.intervalCount = intervalCount;
    }

    public FeaturePrice interval(Interval interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInterval(Interval interval) {
        this.interval = interval;
    }

    public FeaturePrice listPrice(Map<String, Double> listPrice) {
        this.listPrice = listPrice;
        return this;
    }

    public FeaturePrice putListPriceItem(String key, Double listPriceItem) {
        if (this.listPrice == null) {
            this.listPrice = new HashMap<String, Double>();
        }
        this.listPrice.put(key, listPriceItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="listPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getListPrice() {
        return this.listPrice;
    }

    @JsonProperty(value="listPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setListPrice(Map<String, Double> listPrice) {
        this.listPrice = listPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeaturePrice featurePrice = (FeaturePrice)o;
        return Objects.equals((Object)this.type, (Object)featurePrice.type) && Objects.equals(this.intervalCount, featurePrice.intervalCount) && Objects.equals((Object)this.interval, (Object)featurePrice.interval) && Objects.equals(this.listPrice, featurePrice.listPrice);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.intervalCount, this.interval, this.listPrice});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeaturePrice {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    intervalCount: ").append(this.toIndentedString(this.intervalCount)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString((Object)this.interval)).append("\n");
        sb.append("    listPrice: ").append(this.toIndentedString(this.listPrice)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static FeaturePriceBuilder builder() {
        return new FeaturePriceBuilder();
    }

    public FeaturePrice(ChargeType type, Double intervalCount, Interval interval, Map<String, Double> listPrice) {
        this.type = type;
        this.intervalCount = intervalCount;
        this.interval = interval;
        this.listPrice = listPrice;
    }

    public static class FeaturePriceBuilder {
        private ChargeType type;
        private Double intervalCount;
        private Interval interval;
        private Map<String, Double> listPrice;

        FeaturePriceBuilder() {
        }

        public FeaturePriceBuilder type(ChargeType type) {
            this.type = type;
            return this;
        }

        public FeaturePriceBuilder intervalCount(Double intervalCount) {
            this.intervalCount = intervalCount;
            return this;
        }

        public FeaturePriceBuilder interval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public FeaturePriceBuilder listPrice(Map<String, Double> listPrice) {
            this.listPrice = listPrice;
            return this;
        }

        public FeaturePrice build() {
            return new FeaturePrice(this.type, this.intervalCount, this.interval, this.listPrice);
        }

        public String toString() {
            return "FeaturePrice.FeaturePriceBuilder(type=" + this.type + ", intervalCount=" + this.intervalCount + ", interval=" + this.interval + ", listPrice=" + this.listPrice + ")";
        }
    }
}

