/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.ErrorCode;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"code", "message", "locale", "localizedMessage", "parameter"})
public class Error {
    public static final String JSON_PROPERTY_CODE = "code";
    private ErrorCode code = ErrorCode.INVALID_PARAMETER;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_LOCALE = "locale";
    private String locale;
    public static final String JSON_PROPERTY_LOCALIZED_MESSAGE = "localizedMessage";
    private String localizedMessage;
    public static final String JSON_PROPERTY_PARAMETER = "parameter";
    private String parameter;

    public Error() {
    }

    public Error code(ErrorCode code) {
        this.code = code;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ErrorCode getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCode(ErrorCode code) {
        this.code = code;
    }

    public Error message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public Error locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Nullable
    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocale() {
        return this.locale;
    }

    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Error localizedMessage(String localizedMessage) {
        this.localizedMessage = localizedMessage;
        return this;
    }

    @Nullable
    @JsonProperty(value="localizedMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocalizedMessage() {
        return this.localizedMessage;
    }

    @JsonProperty(value="localizedMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalizedMessage(String localizedMessage) {
        this.localizedMessage = localizedMessage;
    }

    public Error parameter(String parameter) {
        this.parameter = parameter;
        return this;
    }

    @Nullable
    @JsonProperty(value="parameter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getParameter() {
        return this.parameter;
    }

    @JsonProperty(value="parameter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals((Object)this.code, (Object)error.code) && Objects.equals(this.message, error.message) && Objects.equals(this.locale, error.locale) && Objects.equals(this.localizedMessage, error.localizedMessage) && Objects.equals(this.parameter, error.parameter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.message, this.locale, this.localizedMessage, this.parameter});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    localizedMessage: ").append(this.toIndentedString(this.localizedMessage)).append("\n");
        sb.append("    parameter: ").append(this.toIndentedString(this.parameter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ErrorBuilder builder() {
        return new ErrorBuilder();
    }

    public Error(ErrorCode code, String message, String locale, String localizedMessage, String parameter) {
        this.code = code;
        this.message = message;
        this.locale = locale;
        this.localizedMessage = localizedMessage;
        this.parameter = parameter;
    }

    public static class ErrorBuilder {
        private ErrorCode code;
        private String message;
        private String locale;
        private String localizedMessage;
        private String parameter;

        ErrorBuilder() {
        }

        public ErrorBuilder code(ErrorCode code) {
            this.code = code;
            return this;
        }

        public ErrorBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ErrorBuilder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public ErrorBuilder localizedMessage(String localizedMessage) {
            this.localizedMessage = localizedMessage;
            return this;
        }

        public ErrorBuilder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        public Error build() {
            return new Error(this.code, this.message, this.locale, this.localizedMessage, this.parameter);
        }

        public String toString() {
            return "Error.ErrorBuilder(code=" + this.code + ", message=" + this.message + ", locale=" + this.locale + ", localizedMessage=" + this.localizedMessage + ", parameter=" + this.parameter + ")";
        }
    }
}

