/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.CreateFeatureParams;
import com.zuora.zevolve.api.model.FeaturePrice;
import com.zuora.zevolve.api.model.FulfillmentMap;
import com.zuora.zevolve.api.model.Interval;
import com.zuora.zevolve.api.model.TrialOptions;
import com.zuora.zevolve.api.model.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"name", "description", "featureNumber", "type", "startDate", "endDate", "status", "minimumQuantity", "maximumQuantity", "customFields", "tags", "entitlementParams", "unitOfMeasure", "policy", "fulfillmentMap", "intervalCount", "interval", "defaultQuantity", "fulfillmentOptions", "trialOptions", "prices"})
public class CreateFeatureRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_FEATURE_NUMBER = "featureNumber";
    private String featureNumber;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private String startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private String endDate;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_MINIMUM_QUANTITY = "minimumQuantity";
    private Double minimumQuantity;
    public static final String JSON_PROPERTY_MAXIMUM_QUANTITY = "maximumQuantity";
    private Double maximumQuantity;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Map<String, Value> customFields = new HashMap<String, Value>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();
    public static final String JSON_PROPERTY_ENTITLEMENT_PARAMS = "entitlementParams";
    private Map<String, CreateFeatureParams> entitlementParams = new HashMap<String, CreateFeatureParams>();
    public static final String JSON_PROPERTY_UNIT_OF_MEASURE = "unitOfMeasure";
    private String unitOfMeasure;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private String policy;
    public static final String JSON_PROPERTY_FULFILLMENT_MAP = "fulfillmentMap";
    private String fulfillmentMap;
    public static final String JSON_PROPERTY_INTERVAL_COUNT = "intervalCount";
    private String intervalCount;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private Interval interval = Interval.UNSPECIFIED;
    public static final String JSON_PROPERTY_DEFAULT_QUANTITY = "defaultQuantity";
    private Double defaultQuantity;
    public static final String JSON_PROPERTY_FULFILLMENT_OPTIONS = "fulfillmentOptions";
    private FulfillmentMap fulfillmentOptions;
    public static final String JSON_PROPERTY_TRIAL_OPTIONS = "trialOptions";
    private TrialOptions trialOptions;
    public static final String JSON_PROPERTY_PRICES = "prices";
    private List<@Valid FeaturePrice> prices = new ArrayList<FeaturePrice>();

    public CreateFeatureRequest() {
    }

    public CreateFeatureRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateFeatureRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateFeatureRequest featureNumber(String featureNumber) {
        this.featureNumber = featureNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="featureNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFeatureNumber() {
        return this.featureNumber;
    }

    @JsonProperty(value="featureNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeatureNumber(String featureNumber) {
        this.featureNumber = featureNumber;
    }

    public CreateFeatureRequest type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public CreateFeatureRequest startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public CreateFeatureRequest endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public CreateFeatureRequest status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    public CreateFeatureRequest minimumQuantity(Double minimumQuantity) {
        this.minimumQuantity = minimumQuantity;
        return this;
    }

    @Nullable
    @JsonProperty(value="minimumQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getMinimumQuantity() {
        return this.minimumQuantity;
    }

    @JsonProperty(value="minimumQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinimumQuantity(Double minimumQuantity) {
        this.minimumQuantity = minimumQuantity;
    }

    public CreateFeatureRequest maximumQuantity(Double maximumQuantity) {
        this.maximumQuantity = maximumQuantity;
        return this;
    }

    @Nullable
    @JsonProperty(value="maximumQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getMaximumQuantity() {
        return this.maximumQuantity;
    }

    @JsonProperty(value="maximumQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaximumQuantity(Double maximumQuantity) {
        this.maximumQuantity = maximumQuantity;
    }

    public CreateFeatureRequest customFields(Map<String, Value> customFields) {
        this.customFields = customFields;
        return this;
    }

    public CreateFeatureRequest putCustomFieldsItem(String key, Value customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Value>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Value> getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Map<String, Value> customFields) {
        this.customFields = customFields;
    }

    public CreateFeatureRequest tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public CreateFeatureRequest putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateFeatureRequest entitlementParams(Map<String, CreateFeatureParams> entitlementParams) {
        this.entitlementParams = entitlementParams;
        return this;
    }

    public CreateFeatureRequest putEntitlementParamsItem(String key, CreateFeatureParams entitlementParamsItem) {
        if (this.entitlementParams == null) {
            this.entitlementParams = new HashMap<String, CreateFeatureParams>();
        }
        this.entitlementParams.put(key, entitlementParamsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="entitlementParams")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, CreateFeatureParams> getEntitlementParams() {
        return this.entitlementParams;
    }

    @JsonProperty(value="entitlementParams")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntitlementParams(Map<String, CreateFeatureParams> entitlementParams) {
        this.entitlementParams = entitlementParams;
    }

    public CreateFeatureRequest unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    @JsonProperty(value="unitOfMeasure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    @JsonProperty(value="unitOfMeasure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public CreateFeatureRequest policy(String policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public CreateFeatureRequest fulfillmentMap(String fulfillmentMap) {
        this.fulfillmentMap = fulfillmentMap;
        return this;
    }

    @Nullable
    @JsonProperty(value="fulfillmentMap")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFulfillmentMap() {
        return this.fulfillmentMap;
    }

    @JsonProperty(value="fulfillmentMap")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentMap(String fulfillmentMap) {
        this.fulfillmentMap = fulfillmentMap;
    }

    public CreateFeatureRequest intervalCount(String intervalCount) {
        this.intervalCount = intervalCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="intervalCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIntervalCount() {
        return this.intervalCount;
    }

    @JsonProperty(value="intervalCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIntervalCount(String intervalCount) {
        this.intervalCount = intervalCount;
    }

    public CreateFeatureRequest interval(Interval interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInterval(Interval interval) {
        this.interval = interval;
    }

    public CreateFeatureRequest defaultQuantity(Double defaultQuantity) {
        this.defaultQuantity = defaultQuantity;
        return this;
    }

    @Nullable
    @JsonProperty(value="defaultQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getDefaultQuantity() {
        return this.defaultQuantity;
    }

    @JsonProperty(value="defaultQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultQuantity(Double defaultQuantity) {
        this.defaultQuantity = defaultQuantity;
    }

    public CreateFeatureRequest fulfillmentOptions(FulfillmentMap fulfillmentOptions) {
        this.fulfillmentOptions = fulfillmentOptions;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="fulfillmentOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FulfillmentMap getFulfillmentOptions() {
        return this.fulfillmentOptions;
    }

    @JsonProperty(value="fulfillmentOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentOptions(FulfillmentMap fulfillmentOptions) {
        this.fulfillmentOptions = fulfillmentOptions;
    }

    public CreateFeatureRequest trialOptions(TrialOptions trialOptions) {
        this.trialOptions = trialOptions;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="trialOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TrialOptions getTrialOptions() {
        return this.trialOptions;
    }

    @JsonProperty(value="trialOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrialOptions(TrialOptions trialOptions) {
        this.trialOptions = trialOptions;
    }

    public CreateFeatureRequest prices(List<@Valid FeaturePrice> prices) {
        this.prices = prices;
        return this;
    }

    public CreateFeatureRequest addPricesItem(FeaturePrice pricesItem) {
        if (this.prices == null) {
            this.prices = new ArrayList<FeaturePrice>();
        }
        this.prices.add(pricesItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="prices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid FeaturePrice> getPrices() {
        return this.prices;
    }

    @JsonProperty(value="prices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrices(List<@Valid FeaturePrice> prices) {
        this.prices = prices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFeatureRequest createFeatureRequest = (CreateFeatureRequest)o;
        return Objects.equals(this.name, createFeatureRequest.name) && Objects.equals(this.description, createFeatureRequest.description) && Objects.equals(this.featureNumber, createFeatureRequest.featureNumber) && Objects.equals(this.type, createFeatureRequest.type) && Objects.equals(this.startDate, createFeatureRequest.startDate) && Objects.equals(this.endDate, createFeatureRequest.endDate) && Objects.equals(this.status, createFeatureRequest.status) && Objects.equals(this.minimumQuantity, createFeatureRequest.minimumQuantity) && Objects.equals(this.maximumQuantity, createFeatureRequest.maximumQuantity) && Objects.equals(this.customFields, createFeatureRequest.customFields) && Objects.equals(this.tags, createFeatureRequest.tags) && Objects.equals(this.entitlementParams, createFeatureRequest.entitlementParams) && Objects.equals(this.unitOfMeasure, createFeatureRequest.unitOfMeasure) && Objects.equals(this.policy, createFeatureRequest.policy) && Objects.equals(this.fulfillmentMap, createFeatureRequest.fulfillmentMap) && Objects.equals(this.intervalCount, createFeatureRequest.intervalCount) && Objects.equals((Object)this.interval, (Object)createFeatureRequest.interval) && Objects.equals(this.defaultQuantity, createFeatureRequest.defaultQuantity) && Objects.equals(this.fulfillmentOptions, createFeatureRequest.fulfillmentOptions) && Objects.equals(this.trialOptions, createFeatureRequest.trialOptions) && Objects.equals(this.prices, createFeatureRequest.prices);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.featureNumber, this.type, this.startDate, this.endDate, this.status, this.minimumQuantity, this.maximumQuantity, this.customFields, this.tags, this.entitlementParams, this.unitOfMeasure, this.policy, this.fulfillmentMap, this.intervalCount, this.interval, this.defaultQuantity, this.fulfillmentOptions, this.trialOptions, this.prices});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateFeatureRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    featureNumber: ").append(this.toIndentedString(this.featureNumber)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    minimumQuantity: ").append(this.toIndentedString(this.minimumQuantity)).append("\n");
        sb.append("    maximumQuantity: ").append(this.toIndentedString(this.maximumQuantity)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    entitlementParams: ").append(this.toIndentedString(this.entitlementParams)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    fulfillmentMap: ").append(this.toIndentedString(this.fulfillmentMap)).append("\n");
        sb.append("    intervalCount: ").append(this.toIndentedString(this.intervalCount)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString((Object)this.interval)).append("\n");
        sb.append("    defaultQuantity: ").append(this.toIndentedString(this.defaultQuantity)).append("\n");
        sb.append("    fulfillmentOptions: ").append(this.toIndentedString(this.fulfillmentOptions)).append("\n");
        sb.append("    trialOptions: ").append(this.toIndentedString(this.trialOptions)).append("\n");
        sb.append("    prices: ").append(this.toIndentedString(this.prices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateFeatureRequestBuilder builder() {
        return new CreateFeatureRequestBuilder();
    }

    public CreateFeatureRequest(String name, String description, String featureNumber, String type, String startDate, String endDate, String status, Double minimumQuantity, Double maximumQuantity, Map<String, Value> customFields, Map<String, String> tags, Map<String, CreateFeatureParams> entitlementParams, String unitOfMeasure, String policy, String fulfillmentMap, String intervalCount, Interval interval, Double defaultQuantity, FulfillmentMap fulfillmentOptions, TrialOptions trialOptions, List<@Valid FeaturePrice> prices) {
        this.name = name;
        this.description = description;
        this.featureNumber = featureNumber;
        this.type = type;
        this.startDate = startDate;
        this.endDate = endDate;
        this.status = status;
        this.minimumQuantity = minimumQuantity;
        this.maximumQuantity = maximumQuantity;
        this.customFields = customFields;
        this.tags = tags;
        this.entitlementParams = entitlementParams;
        this.unitOfMeasure = unitOfMeasure;
        this.policy = policy;
        this.fulfillmentMap = fulfillmentMap;
        this.intervalCount = intervalCount;
        this.interval = interval;
        this.defaultQuantity = defaultQuantity;
        this.fulfillmentOptions = fulfillmentOptions;
        this.trialOptions = trialOptions;
        this.prices = prices;
    }

    public static class CreateFeatureRequestBuilder {
        private String name;
        private String description;
        private String featureNumber;
        private String type;
        private String startDate;
        private String endDate;
        private String status;
        private Double minimumQuantity;
        private Double maximumQuantity;
        private Map<String, Value> customFields;
        private Map<String, String> tags;
        private Map<String, CreateFeatureParams> entitlementParams;
        private String unitOfMeasure;
        private String policy;
        private String fulfillmentMap;
        private String intervalCount;
        private Interval interval;
        private Double defaultQuantity;
        private FulfillmentMap fulfillmentOptions;
        private TrialOptions trialOptions;
        private List<@Valid FeaturePrice> prices;

        CreateFeatureRequestBuilder() {
        }

        public CreateFeatureRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateFeatureRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public CreateFeatureRequestBuilder featureNumber(String featureNumber) {
            this.featureNumber = featureNumber;
            return this;
        }

        public CreateFeatureRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public CreateFeatureRequestBuilder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public CreateFeatureRequestBuilder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public CreateFeatureRequestBuilder status(String status) {
            this.status = status;
            return this;
        }

        public CreateFeatureRequestBuilder minimumQuantity(Double minimumQuantity) {
            this.minimumQuantity = minimumQuantity;
            return this;
        }

        public CreateFeatureRequestBuilder maximumQuantity(Double maximumQuantity) {
            this.maximumQuantity = maximumQuantity;
            return this;
        }

        public CreateFeatureRequestBuilder customFields(Map<String, Value> customFields) {
            this.customFields = customFields;
            return this;
        }

        public CreateFeatureRequestBuilder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public CreateFeatureRequestBuilder entitlementParams(Map<String, CreateFeatureParams> entitlementParams) {
            this.entitlementParams = entitlementParams;
            return this;
        }

        public CreateFeatureRequestBuilder unitOfMeasure(String unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
            return this;
        }

        public CreateFeatureRequestBuilder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public CreateFeatureRequestBuilder fulfillmentMap(String fulfillmentMap) {
            this.fulfillmentMap = fulfillmentMap;
            return this;
        }

        public CreateFeatureRequestBuilder intervalCount(String intervalCount) {
            this.intervalCount = intervalCount;
            return this;
        }

        public CreateFeatureRequestBuilder interval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public CreateFeatureRequestBuilder defaultQuantity(Double defaultQuantity) {
            this.defaultQuantity = defaultQuantity;
            return this;
        }

        public CreateFeatureRequestBuilder fulfillmentOptions(FulfillmentMap fulfillmentOptions) {
            this.fulfillmentOptions = fulfillmentOptions;
            return this;
        }

        public CreateFeatureRequestBuilder trialOptions(TrialOptions trialOptions) {
            this.trialOptions = trialOptions;
            return this;
        }

        public CreateFeatureRequestBuilder prices(List<@Valid FeaturePrice> prices) {
            this.prices = prices;
            return this;
        }

        public CreateFeatureRequest build() {
            return new CreateFeatureRequest(this.name, this.description, this.featureNumber, this.type, this.startDate, this.endDate, this.status, this.minimumQuantity, this.maximumQuantity, this.customFields, this.tags, this.entitlementParams, this.unitOfMeasure, this.policy, this.fulfillmentMap, this.intervalCount, this.interval, this.defaultQuantity, this.fulfillmentOptions, this.trialOptions, this.prices);
        }

        public String toString() {
            return "CreateFeatureRequest.CreateFeatureRequestBuilder(name=" + this.name + ", description=" + this.description + ", featureNumber=" + this.featureNumber + ", type=" + this.type + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", status=" + this.status + ", minimumQuantity=" + this.minimumQuantity + ", maximumQuantity=" + this.maximumQuantity + ", customFields=" + this.customFields + ", tags=" + this.tags + ", entitlementParams=" + this.entitlementParams + ", unitOfMeasure=" + this.unitOfMeasure + ", policy=" + this.policy + ", fulfillmentMap=" + this.fulfillmentMap + ", intervalCount=" + this.intervalCount + ", interval=" + this.interval + ", defaultQuantity=" + this.defaultQuantity + ", fulfillmentOptions=" + this.fulfillmentOptions + ", trialOptions=" + this.trialOptions + ", prices=" + this.prices + ")";
        }
    }
}

