/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.zuora.sdk.catalog.Catalog;
import com.zuora.sdk.error.ErrorMappers;
import com.zuora.sdk.error.Validations;
import com.zuora.sdk.http.HttpMethod;
import com.zuora.sdk.http.HttpSupport;
import com.zuora.sdk.json.PropertyNameScheme;
import com.zuora.zevolve.api.model.CreateSurchargeRequest;
import com.zuora.zevolve.api.model.GetSurchargeByCategoryRequest;
import com.zuora.zevolve.api.model.GetSurchargeRequest;
import com.zuora.zevolve.api.model.Surcharge;
import com.zuora.zevolve.api.model.SurchargeCategory;
import com.zuora.zevolve.api.model.UpdateSurchargeRequest;
import java.util.Optional;

public class SurchargeService {
    private final HttpSupport httpSupport;

    public SurchargeService(HttpSupport httpSupport) {
        this.httpSupport = httpSupport;
    }

    public Surcharge getSurcharge(GetSurchargeRequest request) {
        return (Surcharge)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/surcharges/query-by-id", Optional.of(request), (TypeReference)new TypeReference<Surcharge>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Surcharge getSurcharge(GetSurchargeByCategoryRequest request) {
        return (Surcharge)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/surcharges/query", Optional.of(request), (TypeReference)new TypeReference<Surcharge>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Surcharge createSurcharge(CreateSurchargeRequest request) {
        Validations.requireNonNull((Object)request, (String)"request is required");
        return (Surcharge)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/surcharges", Optional.of(request), (TypeReference)new TypeReference<Surcharge>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Surcharge updateSurcharge(UpdateSurchargeRequest request) {
        Validations.requireNonNull((Object)request, (String)"request is required");
        Validations.requireNotEmpty((String)request.getId(), (String)"surcharge id is required");
        return (Surcharge)this.httpSupport.call(HttpMethod.PUT, Catalog.getPathPrefix() + "/surcharges", Optional.of(request), (TypeReference)new TypeReference<Surcharge>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Boolean deleteSurcharge(SurchargeCategory category) {
        Validations.requireNonNull((Object)((Object)category), (String)"surcharge category is required");
        return "ok".equalsIgnoreCase((String)this.httpSupport.call(HttpMethod.DELETE, HttpSupport.encodePathParams((String)(Catalog.getPathPrefix() + "/surcharges/%s"), (String[])new String[]{category.getValue()}), Optional.empty(), (TypeReference)new TypeReference<String>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent()));
    }
}

