/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.zuora.sdk.Zuora;
import com.zuora.sdk.catalog.Catalog;
import com.zuora.sdk.catalog.CatalogSupport;
import com.zuora.sdk.catalog.plan.NewPlan;
import com.zuora.sdk.common.CheckedFunction;
import com.zuora.sdk.common.Either;
import com.zuora.sdk.config.StreamingConfig;
import com.zuora.sdk.error.ErrorMappers;
import com.zuora.sdk.error.SdkError;
import com.zuora.sdk.error.SdkException;
import com.zuora.sdk.error.Validations;
import com.zuora.sdk.http.HttpMethod;
import com.zuora.sdk.http.HttpSupport;
import com.zuora.sdk.json.PropertyNameScheme;
import com.zuora.sdk.stream.StreamingOptions;
import com.zuora.sdk.stream.StreamingSupport;
import com.zuora.zevolve.api.model.AttributeCombination;
import com.zuora.zevolve.api.model.ContextInformation;
import com.zuora.zevolve.api.model.CreateChargeDefinitionsRequest;
import com.zuora.zevolve.api.model.GetProductRatePlanRequest;
import com.zuora.zevolve.api.model.ProductRatePlan;
import com.zuora.zevolve.api.model.ProductRatePlanExpand;
import com.zuora.zevolve.api.model.ProductRatePlanFilter;
import com.zuora.zevolve.api.model.UpdateProductRatePlanRequest;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlansService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlansService.class);
    private final Zuora zuora;
    private final CatalogSupport catalogSupport;
    private final HttpSupport httpSupport;

    public PlansService(Zuora zuora, CatalogSupport catalogSupport, HttpSupport httpSupport) {
        this.zuora = zuora;
        this.catalogSupport = catalogSupport;
        this.httpSupport = httpSupport;
    }

    public ProductRatePlan getPlan(String planKey) {
        return this.getPlan(planKey, null);
    }

    public ProductRatePlan getPlan(String planKey, List<ContextInformation> contextAttributes) {
        Validations.requireNotEmpty((String)planKey, (String)"plan key is required");
        GetProductRatePlanRequest request = GetProductRatePlanRequest.builder().productRatePlanKey(planKey).attributes(contextAttributes).build();
        return (ProductRatePlan)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/plans/query", Optional.of(request), (TypeReference)new TypeReference<ProductRatePlan>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Stream<Either<SdkError, ProductRatePlan>> getPlans(Iterator<String> planKeys, StreamingOptions options) {
        Stream<String> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(planKeys, 16), false);
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming(stream, id -> this.catalogSupport.postNonBlocking(Catalog.getPathPrefix() + "/plans/query", GetProductRatePlanRequest.builder().productRatePlanKey((String)id).build(), new TypeReference<ProductRatePlan>(){}), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    private Iterator<ProductRatePlan> getPlans(ProductRatePlanExpand expand, ProductRatePlanFilter ... filters) {
        return null;
    }

    public ProductRatePlan createPlan(String productKey, NewPlan plan) {
        Validations.requireNotEmpty((String)productKey, (String)"product key is required");
        return (ProductRatePlan)this.httpSupport.call(HttpMethod.POST, HttpSupport.encodePathParams((String)(Catalog.getPathPrefix() + "/plans"), (String[])new String[0]), Optional.of(plan.toApi().productKey(productKey)), (TypeReference)new TypeReference<ProductRatePlan>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Stream<Either<SdkError, ProductRatePlan>> createPlans(String productKey, Iterator<NewPlan> plans, StreamingOptions options) {
        Validations.requireNotEmpty((String)productKey, (String)"product key is required");
        Stream<NewPlan> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(plans, 16), false);
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming(stream, plan -> this.catalogSupport.addRatePlanToProductNonBlocking(productKey.trim(), (NewPlan)plan), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public Stream<Either<SdkError, ProductRatePlan>> createPlans(String productKey, InputStream is, CheckedFunction<String, NewPlan> mapper, StreamingOptions options) {
        Validations.requireNotEmpty((String)productKey, (String)"product key is required");
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming((InputStream)is, mapper, plan -> this.catalogSupport.addRatePlanToProductNonBlocking(productKey.trim(), (NewPlan)plan), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public Boolean deletePlan(String planKey) throws SdkException {
        Validations.requireNotEmpty((String)planKey, (String)"plan key is required");
        String path = HttpSupport.encodePathParams((String)(Catalog.getPathPrefix() + "/plans/%s"), (String[])new String[]{planKey.trim()});
        return "ok".equalsIgnoreCase((String)this.httpSupport.call(HttpMethod.DELETE, path, Optional.empty(), (TypeReference)new TypeReference<String>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent()));
    }

    public Stream<Either<SdkError, Boolean>> deletePlans(Iterator<String> ids, StreamingOptions options) {
        LOGGER.debug("Removing plans in batched streaming mode");
        Stream<String> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ids, 16), false);
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming(stream, id -> this.catalogSupport.deleteNonBlocking(Catalog.getPathPrefix() + "/plans/%s", (String)id), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public Stream<Either<SdkError, Boolean>> deletePlans(InputStream is, StreamingOptions options) {
        LOGGER.debug("Removing plans in batched streaming mode");
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming((InputStream)is, id -> id, id -> this.catalogSupport.deleteNonBlocking(Catalog.getPathPrefix() + "/plans/%s", (String)id), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public ProductRatePlan updatePlan(UpdateProductRatePlanRequest plan) throws SdkException {
        Validations.requireNotEmpty((String)plan.getId(), (String)"id is required");
        return (ProductRatePlan)this.httpSupport.call(HttpMethod.PUT, Catalog.getPathPrefix() + "/plans", Optional.of(plan), (TypeReference)new TypeReference<ProductRatePlan>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Stream<Either<SdkError, ProductRatePlan>> updatePlans(Iterator<UpdateProductRatePlanRequest> plans, StreamingOptions options) {
        Stream<UpdateProductRatePlanRequest> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(plans, 16), false);
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming(stream, request -> this.catalogSupport.putNonBlocking(Catalog.getPathPrefix() + "/plans", request, new TypeReference<ProductRatePlan>(){}, req -> Validations.checkNotEmpty((String)req.getId(), (String)"id is required")), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public <T> Stream<Either<SdkError, ProductRatePlan>> updatePlans(InputStream is, CheckedFunction<String, UpdateProductRatePlanRequest> mapper, StreamingOptions options) {
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming((InputStream)is, mapper, request -> this.catalogSupport.putNonBlocking(Catalog.getPathPrefix() + "/plans", request, new TypeReference<ProductRatePlan>(){}, req -> Validations.checkNotEmpty((String)req.getId(), (String)"id is required")), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public Boolean createChargeDefinitions(String planNumber, List<AttributeCombination> attributeCombination) {
        Validations.requireNotEmpty((String)planNumber, (String)"planNumber is required");
        return "ok".equalsIgnoreCase((String)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/plans/charge-definitions", Optional.of(CreateChargeDefinitionsRequest.builder().productRatePlanNumber(planNumber).attributeCombinations(attributeCombination).build()), (TypeReference)new TypeReference<String>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent()));
    }

    public Boolean updateChargeDefinitions(String planNumber, List<AttributeCombination> attributeCombination) {
        Validations.requireNotEmpty((String)planNumber, (String)"planNumber is required");
        return "ok".equalsIgnoreCase((String)this.httpSupport.call(HttpMethod.PUT, Catalog.getPathPrefix() + "/plans/charge-definitions", Optional.of(CreateChargeDefinitionsRequest.builder().productRatePlanNumber(planNumber).attributeCombinations(attributeCombination).build()), (TypeReference)new TypeReference<String>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent()));
    }
}

