/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.zuora.sdk.Zuora;
import com.zuora.sdk.catalog.Catalog;
import com.zuora.sdk.catalog.CatalogSupport;
import com.zuora.sdk.common.CheckedFunction;
import com.zuora.sdk.common.Either;
import com.zuora.sdk.config.StreamingConfig;
import com.zuora.sdk.error.ErrorMappers;
import com.zuora.sdk.error.SdkError;
import com.zuora.sdk.error.SdkException;
import com.zuora.sdk.error.Validations;
import com.zuora.sdk.http.HttpMethod;
import com.zuora.sdk.http.HttpSupport;
import com.zuora.sdk.json.PropertyNameScheme;
import com.zuora.sdk.stream.StreamingOptions;
import com.zuora.sdk.stream.StreamingSupport;
import com.zuora.zevolve.api.model.ChargeTier;
import com.zuora.zevolve.api.model.ContextInformation;
import com.zuora.zevolve.api.model.GetProductRatePlanChargeRequest;
import com.zuora.zevolve.api.model.ProductRatePlanCharge;
import com.zuora.zevolve.api.model.ProductRatePlanChargeExpand;
import com.zuora.zevolve.api.model.ProductRatePlanChargeFilter;
import com.zuora.zevolve.api.model.UpdateProductRatePlanChargeRequest;
import com.zuora.zevolve.api.model.UpdateProductRatePlanChargeTierRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChargesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChargesService.class);
    private final Zuora zuora;
    private final CatalogSupport catalogSupport;
    private final HttpSupport httpSupport;

    public ChargesService(Zuora zuora, CatalogSupport catalogSupport, HttpSupport httpSupport) {
        this.zuora = zuora;
        this.catalogSupport = catalogSupport;
        this.httpSupport = httpSupport;
    }

    public ProductRatePlanCharge getCharge(String chargeKey) throws SdkException {
        return this.getChargeWithContext(chargeKey, null);
    }

    public ProductRatePlanCharge getChargeWithContext(String chargeKey, List<ContextInformation> contextAttributes) throws SdkException {
        Validations.requireNotEmpty((String)chargeKey, (String)"charge key is required");
        return (ProductRatePlanCharge)this.httpSupport.call(HttpMethod.POST, Catalog.getPathPrefix() + "/charges/query", Optional.of(GetProductRatePlanChargeRequest.builder().productRatePlanChargeKey(chargeKey).attributes(contextAttributes).build()), (TypeReference)new TypeReference<ProductRatePlanCharge>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    private Iterator<ProductRatePlanCharge> getCharges(ProductRatePlanChargeExpand expand, ProductRatePlanChargeFilter ... filters) {
        return null;
    }

    public Stream<Either<SdkError, ProductRatePlanCharge>> getCharges(Iterator<String> chargeKeys, StreamingOptions options) {
        Stream<String> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(chargeKeys, 16), false);
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming(stream, id -> this.catalogSupport.postNonBlocking(Catalog.getPathPrefix() + "/charges/query", GetProductRatePlanChargeRequest.builder().productRatePlanChargeKey((String)id).build(), new TypeReference<ProductRatePlanCharge>(){}), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public ProductRatePlanCharge updateCharge(UpdateProductRatePlanChargeRequest request) throws SdkException {
        Validations.requireNonNull((Object)request, (String)"id is required");
        Validations.requireNonNull((Object)request.getCharge(), (String)"id is required");
        Validations.requireNotEmpty((String)request.getCharge().getId(), (String)"id is required");
        return (ProductRatePlanCharge)this.httpSupport.call(HttpMethod.PUT, Catalog.getPathPrefix() + "/charges", Optional.of(request), (TypeReference)new TypeReference<ProductRatePlanCharge>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    public Stream<Either<SdkError, ProductRatePlanCharge>> updateCharges(Iterator<UpdateProductRatePlanChargeRequest> charges, StreamingOptions options) {
        Stream<UpdateProductRatePlanChargeRequest> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(charges, 16), false);
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming(stream, request -> this.catalogSupport.putNonBlocking(Catalog.getPathPrefix() + "/charges", request, new TypeReference<ProductRatePlanCharge>(){}, req -> Validations.checkNotEmpty((String)req.getCharge().getId(), (String)"id is required")), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public Stream<Either<SdkError, ProductRatePlanCharge>> updateCharges(InputStream is, CheckedFunction<String, UpdateProductRatePlanChargeRequest> mapper, StreamingOptions options) {
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming((InputStream)is, mapper, request -> this.catalogSupport.putNonBlocking(Catalog.getPathPrefix() + "/charges", request, new TypeReference<ProductRatePlanCharge>(){}, req -> Validations.checkNotEmpty((String)req.getCharge().getId(), (String)"id is required")), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public Boolean deleteCharge(String chargeKey) throws SdkException {
        Validations.requireNotEmpty((String)chargeKey, (String)"charge key is required");
        String path = HttpSupport.encodePathParams((String)(Catalog.getPathPrefix() + "/charges/%s"), (String[])new String[]{chargeKey.trim()});
        return "ok".equalsIgnoreCase((String)this.httpSupport.call(HttpMethod.DELETE, path, Optional.empty(), (TypeReference)new TypeReference<String>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent()));
    }

    public Stream<Either<SdkError, Boolean>> deleteCharges(Iterator<String> ids, StreamingOptions options) {
        Stream<String> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(ids, 16), false);
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming(stream, id -> this.catalogSupport.deleteNonBlocking(Catalog.getPathPrefix() + "/charges/%s", (String)id), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public Stream<Either<SdkError, Boolean>> deleteCharges(InputStream is, StreamingOptions options) {
        StreamingConfig streamingConfig = this.zuora.getConfiguration().getStreamingConfig();
        return StreamingSupport.doStreaming((InputStream)is, id -> id, id -> this.catalogSupport.deleteNonBlocking(Catalog.getPathPrefix() + "/charges/%s", (String)id), (StreamingOptions)options, (int)streamingConfig.getMaxBatchSize(), (int)streamingConfig.getMaxBatchesToBuffer());
    }

    public ChargeTier updateTier(String tierId, BigDecimal price) {
        Validations.requireNotEmpty((String)tierId, (String)"tierId is required");
        return (ChargeTier)this.httpSupport.call(HttpMethod.PUT, Catalog.getPathPrefix() + "/tiers", Optional.of(UpdateProductRatePlanChargeTierRequest.builder().id(tierId).price(price.doubleValue()).build()), (TypeReference)new TypeReference<ChargeTier>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }
}

