/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog;

import com.fasterxml.jackson.core.type.TypeReference;
import com.zuora.sdk.catalog.Catalog;
import com.zuora.sdk.catalog.plan.NewPlan;
import com.zuora.sdk.common.Either;
import com.zuora.sdk.common.Page;
import com.zuora.sdk.error.ErrorCode;
import com.zuora.sdk.error.ErrorMappers;
import com.zuora.sdk.error.ErrorType;
import com.zuora.sdk.error.SdkError;
import com.zuora.sdk.error.SdkException;
import com.zuora.sdk.error.Validations;
import com.zuora.sdk.http.HttpMethod;
import com.zuora.sdk.http.HttpSupport;
import com.zuora.sdk.json.PropertyNameScheme;
import com.zuora.zevolve.api.model.Pagination;
import com.zuora.zevolve.api.model.ProductRatePlan;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CatalogSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatalogSupport.class);
    private final HttpSupport httpSupport;

    CatalogSupport(HttpSupport httpSupport) {
        this.httpSupport = httpSupport;
    }

    <T> CompletableFuture<Either<SdkError, T>> getNonBlocking(String path, String id, TypeReference<T> typeReference) throws SdkException {
        try {
            Validations.requireNotEmpty((String)id, (String)"id is required");
        }
        catch (SdkException e) {
            return CompletableFuture.completedFuture(Either.left((SdkError)e.getError()));
        }
        CompletableFuture future = this.httpSupport.nonBlockingCall(HttpMethod.GET, HttpSupport.encodePathParams((String)path, (String[])new String[]{id.trim()}), Optional.empty(), typeReference, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
        return future;
    }

    <U, V> CompletableFuture<Either<SdkError, V>> postNonBlocking(String path, U request, TypeReference<V> responseTypeReference) throws SdkException {
        return this.httpSupport.nonBlockingCall(HttpMethod.POST, path, Optional.of(request), responseTypeReference, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }

    <U, V> CompletableFuture<Either<SdkError, V>> putNonBlocking(String path, U request, TypeReference<V> responseType, Function<U, Optional<SdkError>> payloadValidator) throws SdkException {
        LOGGER.debug("Making a non-blocking update call to path: {}", (Object)path);
        Optional<SdkError> error = payloadValidator.apply(request);
        return error.map(sdkError -> CompletableFuture.completedFuture(Either.left((SdkError)sdkError))).orElseGet(() -> this.httpSupport.nonBlockingCall(HttpMethod.PUT, path, Optional.of(request), responseType, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent()));
    }

    CompletableFuture<Either<SdkError, Boolean>> deleteNonBlocking(String path, String id) throws SdkException {
        try {
            Validations.requireNotEmpty((String)id, (String)"id is required");
        }
        catch (SdkException e) {
            return CompletableFuture.completedFuture(Either.left((SdkError)e.getError()));
        }
        return this.httpSupport.nonBlockingCall(HttpMethod.DELETE, HttpSupport.encodePathParams((String)path, (String[])new String[]{id}), Optional.empty(), (TypeReference)new TypeReference<String>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent()).thenApply(either -> either.map("ok"::equalsIgnoreCase));
    }

    static <T> Iterator<Page<T>> paginate(final int pageSize, final Function<Pagination, Optional<T>> pageProducer) {
        Validations.require((pageSize > 0 ? 1 : 0) != 0, (String)"Page size must be greater than zero");
        Validations.requireNonNull(pageProducer, (String)"Page producer must not be null");
        return new Iterator<Page<T>>(){
            Pagination pagination;
            Either<SdkError, Optional<T>> nextPageContent;
            boolean open;
            {
                this.pagination = Pagination.builder().page(1).pageSize(pageSize).build();
                this.nextPageContent = null;
                this.open = false;
            }

            private void open() {
                if (!this.open) {
                    this.nextPageContent = this.nextPage();
                    this.open = true;
                }
            }

            @Override
            public boolean hasNext() {
                this.open();
                return this.nextPageContent.isRight() && ((Optional)this.nextPageContent.get()).isPresent();
            }

            private Either<SdkError, Optional<T>> nextPage() {
                try {
                    Optional page = (Optional)pageProducer.apply(this.pagination);
                    return Either.right((Object)page);
                }
                catch (Throwable t) {
                    LOGGER.error("Error while seeking next page", t);
                    return Either.left((SdkError)SdkError.error((ErrorType)ErrorType.unexpected, (ErrorCode)ErrorCode.unexpected_error, (String)"Error while seeking next page", (Throwable)t));
                }
            }

            @Override
            public Page<T> next() {
                this.open();
                if (this.nextPageContent.isLeft()) {
                    SdkError error = this.nextPageContent.getLeft();
                    throw new SdkException(error.getCause(), error);
                }
                Optional pageContent = (Optional)this.nextPageContent.get();
                Page page = pageContent.map(content -> new Page(this.pagination.getPage().intValue(), this.pagination.getPageSize().intValue(), content)).orElse(null);
                this.pagination = Pagination.builder().page(this.pagination.getPage() + 1).pageSize(this.pagination.getPageSize()).build();
                this.nextPageContent = this.nextPage();
                return page;
            }
        };
    }

    CompletableFuture<Either<SdkError, ProductRatePlan>> addRatePlanToProductNonBlocking(String productKey, NewPlan plan) {
        try {
            Validations.requireNotEmpty((String)productKey, (String)"productKey is required");
        }
        catch (SdkException e) {
            return CompletableFuture.completedFuture(Either.left((SdkError)e.getError()));
        }
        return this.httpSupport.nonBlockingCall(HttpMethod.POST, HttpSupport.encodePathParams((String)(Catalog.getPathPrefix() + "/plans"), (String[])new String[0]), Optional.of(plan.toApi().productKey(productKey)), (TypeReference)new TypeReference<ProductRatePlan>(){}, ErrorMappers::appErrorMapper, PropertyNameScheme.LowerCamelCase, Catalog.getUserAgent());
    }
}

