/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.ParamType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"type", "enumeration", "nullable"})
public class CreateFeatureParams {
    public static final String JSON_PROPERTY_TYPE = "type";
    private ParamType type = ParamType.ANY;
    public static final String JSON_PROPERTY_ENUMERATION = "enumeration";
    private List<String> enumeration = new ArrayList<String>();
    public static final String JSON_PROPERTY_NULLABLE = "nullable";
    private Boolean nullable;

    public CreateFeatureParams() {
    }

    public CreateFeatureParams type(ParamType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ParamType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(ParamType type) {
        this.type = type;
    }

    public CreateFeatureParams enumeration(List<String> enumeration) {
        this.enumeration = enumeration;
        return this;
    }

    public CreateFeatureParams addEnumerationItem(String enumerationItem) {
        if (this.enumeration == null) {
            this.enumeration = new ArrayList<String>();
        }
        this.enumeration.add(enumerationItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="enumeration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getEnumeration() {
        return this.enumeration;
    }

    @JsonProperty(value="enumeration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnumeration(List<String> enumeration) {
        this.enumeration = enumeration;
    }

    public CreateFeatureParams nullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    @Nullable
    @JsonProperty(value="nullable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNullable() {
        return this.nullable;
    }

    @JsonProperty(value="nullable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFeatureParams createFeatureParams = (CreateFeatureParams)o;
        return Objects.equals((Object)this.type, (Object)createFeatureParams.type) && Objects.equals(this.enumeration, createFeatureParams.enumeration) && Objects.equals(this.nullable, createFeatureParams.nullable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.enumeration, this.nullable});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateFeatureParams {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    enumeration: ").append(this.toIndentedString(this.enumeration)).append("\n");
        sb.append("    nullable: ").append(this.toIndentedString(this.nullable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateFeatureParamsBuilder builder() {
        return new CreateFeatureParamsBuilder();
    }

    public CreateFeatureParams(ParamType type, List<String> enumeration, Boolean nullable) {
        this.type = type;
        this.enumeration = enumeration;
        this.nullable = nullable;
    }

    public static class CreateFeatureParamsBuilder {
        private ParamType type;
        private List<String> enumeration;
        private Boolean nullable;

        CreateFeatureParamsBuilder() {
        }

        public CreateFeatureParamsBuilder type(ParamType type) {
            this.type = type;
            return this;
        }

        public CreateFeatureParamsBuilder enumeration(List<String> enumeration) {
            this.enumeration = enumeration;
            return this;
        }

        public CreateFeatureParamsBuilder nullable(Boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public CreateFeatureParams build() {
            return new CreateFeatureParams(this.type, this.enumeration, this.nullable);
        }

        public String toString() {
            return "CreateFeatureParams.CreateFeatureParamsBuilder(type=" + this.type + ", enumeration=" + this.enumeration + ", nullable=" + this.nullable + ")";
        }
    }
}

