/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.charge.usage;

import com.zuora.sdk.catalog.charge.Billing;
import com.zuora.sdk.catalog.charge.SubscriptionRenewalOptions;
import com.zuora.sdk.catalog.charge.Taxation;
import com.zuora.sdk.catalog.charge.Tier;
import com.zuora.sdk.catalog.charge.Uom;
import com.zuora.sdk.catalog.charge.usage.UsageCharge;
import com.zuora.zevolve.api.model.Accounting;
import com.zuora.zevolve.api.model.ChargeModel;
import com.zuora.zevolve.api.model.ChargeType;
import com.zuora.zevolve.api.model.DeliverySchedule;
import com.zuora.zevolve.api.model.Drawdown;
import com.zuora.zevolve.api.model.EndDateCondition;
import com.zuora.zevolve.api.model.Netsuite;
import com.zuora.zevolve.api.model.Prepayment;
import com.zuora.zevolve.api.model.Pricing;
import com.zuora.zevolve.api.model.ProductRatePlanChargeRequest;
import com.zuora.zevolve.api.model.RatingGroup;
import com.zuora.zevolve.api.model.Revenue;
import com.zuora.zevolve.api.model.TriggerEvent;
import com.zuora.zevolve.api.model.UpToPeriodsType;
import com.zuora.zevolve.api.model.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class TieredCharge
extends UsageCharge {
    private final List<Tier> tiers = new ArrayList<Tier>();
    private Uom uom;
    private RatingGroup ratingGroup;

    private TieredCharge() {
    }

    static TieredCharge newInstance() {
        return new TieredCharge();
    }

    public TieredCharge withName(String name) {
        this.name = name;
        return this;
    }

    public TieredCharge with(Billing billing) {
        this.billing = billing;
        return this;
    }

    public TieredCharge with(TriggerEvent event) {
        this.triggerEvent = event;
        return this;
    }

    protected TieredCharge with(Accounting accounting) {
        this.accounting = accounting;
        return this;
    }

    public TieredCharge with(Revenue revenue) {
        this.revenue = revenue;
        return this;
    }

    public TieredCharge with(Taxation taxation) {
        this.taxation = taxation;
        return this;
    }

    public TieredCharge with(RatingGroup ratingGroup) {
        this.ratingGroup = ratingGroup;
        return this;
    }

    public TieredCharge with(Netsuite netsuite) {
        this.netsuite = netsuite;
        return this;
    }

    protected TieredCharge with(SubscriptionRenewalOptions options) {
        this.renewalOptions = options;
        return this;
    }

    protected TieredCharge with(EndDateCondition condition) {
        this.endDateCondition = condition;
        return this;
    }

    protected TieredCharge with(Integer periods, UpToPeriodsType periodsType) {
        this.upToPeriods = periods;
        this.upToPeriodsType = periodsType;
        return this;
    }

    protected TieredCharge with(DeliverySchedule deliverySchedule) {
        this.deliverySchedule = deliverySchedule;
        return this;
    }

    public TieredCharge with(Tier tier) {
        this.tiers.add(tier);
        return this;
    }

    public TieredCharge with(Prepayment prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    public TieredCharge with(Drawdown drawdown) {
        this.drawdown = drawdown;
        return this;
    }

    public TieredCharge uom(Uom uom) {
        this.uom = uom;
        return this;
    }

    public TieredCharge withCustomField(String name, Value value) {
        this.customFields.put(name, value);
        return this;
    }

    @Override
    public ProductRatePlanChargeRequest toApi(ProductRatePlanChargeRequest.ProductRatePlanChargeRequestBuilder builder) {
        return builder.chargeType(ChargeType.USAGE).chargeModel(ChargeModel.TIERED).unitOfMeasure((String)this.uom.value()).pricing(Pricing.builder().tiers(this.tiers.stream().map(Tier::toApi).collect(Collectors.toList())).build()).ratingGroup(this.ratingGroup).build();
    }
}

