/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.charge.usage;

import com.zuora.sdk.catalog.charge.Amount;
import com.zuora.sdk.catalog.charge.Billing;
import com.zuora.sdk.catalog.charge.Overage;
import com.zuora.sdk.catalog.charge.SubscriptionRenewalOptions;
import com.zuora.sdk.catalog.charge.Taxation;
import com.zuora.sdk.catalog.charge.Uom;
import com.zuora.sdk.catalog.charge.usage.UsageCharge;
import com.zuora.zevolve.api.model.Accounting;
import com.zuora.zevolve.api.model.ChargeModel;
import com.zuora.zevolve.api.model.ChargeType;
import com.zuora.zevolve.api.model.DeliverySchedule;
import com.zuora.zevolve.api.model.Drawdown;
import com.zuora.zevolve.api.model.EndDateCondition;
import com.zuora.zevolve.api.model.Netsuite;
import com.zuora.zevolve.api.model.Prepayment;
import com.zuora.zevolve.api.model.Pricing;
import com.zuora.zevolve.api.model.ProductRatePlanChargeRequest;
import com.zuora.zevolve.api.model.Revenue;
import com.zuora.zevolve.api.model.TriggerEvent;
import com.zuora.zevolve.api.model.UpToPeriodsType;
import com.zuora.zevolve.api.model.Value;
import java.util.ArrayList;
import java.util.List;

public final class OverageCharge
extends UsageCharge {
    private final List<Amount> amounts = new ArrayList<Amount>();
    private Uom uom;
    private Overage overage;

    private OverageCharge() {
    }

    static OverageCharge newInstance() {
        return new OverageCharge();
    }

    public OverageCharge withName(String name) {
        this.name = name;
        return this;
    }

    public OverageCharge with(Billing billing) {
        this.billing = billing;
        return this;
    }

    public OverageCharge with(TriggerEvent event) {
        this.triggerEvent = event;
        return this;
    }

    protected OverageCharge with(Accounting accounting) {
        this.accounting = accounting;
        return this;
    }

    public OverageCharge with(Revenue revenue) {
        this.revenue = revenue;
        return this;
    }

    public OverageCharge with(Taxation taxation) {
        this.taxation = taxation;
        return this;
    }

    public OverageCharge with(Netsuite netsuite) {
        this.netsuite = netsuite;
        return this;
    }

    protected OverageCharge with(SubscriptionRenewalOptions options) {
        this.renewalOptions = options;
        return this;
    }

    protected OverageCharge with(EndDateCondition condition) {
        this.endDateCondition = condition;
        return this;
    }

    protected OverageCharge with(Integer periods, UpToPeriodsType periodsType) {
        this.upToPeriods = periods;
        this.upToPeriodsType = periodsType;
        return this;
    }

    public OverageCharge with(Overage overage) {
        this.overage = overage;
        return this;
    }

    public OverageCharge with(Uom uom) {
        this.uom = uom;
        return this;
    }

    protected OverageCharge with(DeliverySchedule deliverySchedule) {
        this.deliverySchedule = deliverySchedule;
        return this;
    }

    public OverageCharge with(Prepayment prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    public OverageCharge with(Drawdown drawdown) {
        this.drawdown = drawdown;
        return this;
    }

    public OverageCharge and(Amount amount) {
        this.amounts.add(amount);
        return this;
    }

    public OverageCharge withCustomField(String name, Value value) {
        this.customFields.put(name, value);
        return this;
    }

    @Override
    public ProductRatePlanChargeRequest toApi(ProductRatePlanChargeRequest.ProductRatePlanChargeRequestBuilder builder) {
        return builder.chargeType(ChargeType.USAGE).chargeModel(ChargeModel.OVERAGE).unitOfMeasure(this.uom != null ? (String)this.uom.value() : null).overageOptions(this.overage.toApi()).pricing(Pricing.builder().build().unitAmounts(Amount.toApiMap(this.amounts))).build();
    }
}

