/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.charge;

import com.zuora.sdk.common.ApiObject;
import com.zuora.zevolve.api.model.OverageCalculationOption;
import com.zuora.zevolve.api.model.OverageOptions;
import com.zuora.zevolve.api.model.OverageSmoothingModel;
import com.zuora.zevolve.api.model.OverageUnusedUnitsCreditOption;
import java.math.BigDecimal;

public class Overage
implements ApiObject<OverageOptions> {
    private final BigDecimal includedUnits;
    private final Long numberOfPeriods;
    private final OverageSmoothingModel smoothingModel;
    private OverageCalculationOption calculationOption;
    private OverageUnusedUnitsCreditOption unusedUnitsCreditOption;

    public Overage(BigDecimal includedUnits, long numberOfPeriods, OverageSmoothingModel smoothingModel) {
        this.includedUnits = includedUnits;
        this.numberOfPeriods = numberOfPeriods;
        this.smoothingModel = smoothingModel;
    }

    public static Overage with(BigDecimal includedUnits, long numberOfPeriods, OverageSmoothingModel smoothingModel) {
        return new Overage(includedUnits, numberOfPeriods, smoothingModel);
    }

    public static Overage with(long includedUnits, long numberOfPeriods, OverageSmoothingModel smoothingModel) {
        return new Overage(BigDecimal.valueOf(includedUnits), numberOfPeriods, smoothingModel);
    }

    public Overage with(OverageCalculationOption calculationOption) {
        this.calculationOption = calculationOption;
        return this;
    }

    public Overage with(OverageUnusedUnitsCreditOption option) {
        this.unusedUnitsCreditOption = option;
        return this;
    }

    public OverageOptions toApi() {
        return OverageOptions.builder().includedUnits(this.includedUnits != null ? Double.valueOf(this.includedUnits.doubleValue()) : null).smoothingModel(this.smoothingModel).numberOfPeriods(this.numberOfPeriods != null ? Integer.valueOf(this.numberOfPeriods.intValue()) : null).calculationOption(this.calculationOption).unusedUnitsCreditOption(this.unusedUnitsCreditOption).build();
    }
}

