/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.CreditOption;
import com.zuora.zevolve.api.model.PrepaidOperationType;
import com.zuora.zevolve.api.model.RolloverApply;
import com.zuora.zevolve.api.model.ValidityPeriodType;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"creditOption", "rollover", "totalQuantity", "unitOfMeasure", "rolloverApply", "rolloverPeriods", "validityPeriod", "quantity", "rolloverPeriodLength", "prepayPeriods", "operationType"})
public class Prepayment {
    public static final String JSON_PROPERTY_CREDIT_OPTION = "creditOption";
    private CreditOption creditOption = CreditOption.TIME_BASED;
    public static final String JSON_PROPERTY_ROLLOVER = "rollover";
    private Boolean rollover;
    public static final String JSON_PROPERTY_TOTAL_QUANTITY = "totalQuantity";
    private Double totalQuantity;
    public static final String JSON_PROPERTY_UNIT_OF_MEASURE = "unitOfMeasure";
    private String unitOfMeasure;
    public static final String JSON_PROPERTY_ROLLOVER_APPLY = "rolloverApply";
    private RolloverApply rolloverApply = RolloverApply.LAST;
    public static final String JSON_PROPERTY_ROLLOVER_PERIODS = "rolloverPeriods";
    private Integer rolloverPeriods;
    public static final String JSON_PROPERTY_VALIDITY_PERIOD = "validityPeriod";
    private ValidityPeriodType validityPeriod = ValidityPeriodType.SUBSCRIPTION_TERM;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Double quantity;
    public static final String JSON_PROPERTY_ROLLOVER_PERIOD_LENGTH = "rolloverPeriodLength";
    private Integer rolloverPeriodLength;
    public static final String JSON_PROPERTY_PREPAY_PERIODS = "prepayPeriods";
    private String prepayPeriods;
    public static final String JSON_PROPERTY_OPERATION_TYPE = "operationType";
    private PrepaidOperationType operationType = PrepaidOperationType.UNSPECIFIED;

    public Prepayment() {
    }

    public Prepayment creditOption(CreditOption creditOption) {
        this.creditOption = creditOption;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="creditOption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CreditOption getCreditOption() {
        return this.creditOption;
    }

    @JsonProperty(value="creditOption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreditOption(CreditOption creditOption) {
        this.creditOption = creditOption;
    }

    public Prepayment rollover(Boolean rollover) {
        this.rollover = rollover;
        return this;
    }

    @Nullable
    @JsonProperty(value="rollover")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRollover() {
        return this.rollover;
    }

    @JsonProperty(value="rollover")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRollover(Boolean rollover) {
        this.rollover = rollover;
    }

    public Prepayment totalQuantity(Double totalQuantity) {
        this.totalQuantity = totalQuantity;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTotalQuantity() {
        return this.totalQuantity;
    }

    @JsonProperty(value="totalQuantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalQuantity(Double totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public Prepayment unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    @JsonProperty(value="unitOfMeasure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    @JsonProperty(value="unitOfMeasure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public Prepayment rolloverApply(RolloverApply rolloverApply) {
        this.rolloverApply = rolloverApply;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="rolloverApply")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RolloverApply getRolloverApply() {
        return this.rolloverApply;
    }

    @JsonProperty(value="rolloverApply")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRolloverApply(RolloverApply rolloverApply) {
        this.rolloverApply = rolloverApply;
    }

    public Prepayment rolloverPeriods(Integer rolloverPeriods) {
        this.rolloverPeriods = rolloverPeriods;
        return this;
    }

    @Nullable
    @JsonProperty(value="rolloverPeriods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRolloverPeriods() {
        return this.rolloverPeriods;
    }

    @JsonProperty(value="rolloverPeriods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRolloverPeriods(Integer rolloverPeriods) {
        this.rolloverPeriods = rolloverPeriods;
    }

    public Prepayment validityPeriod(ValidityPeriodType validityPeriod) {
        this.validityPeriod = validityPeriod;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="validityPeriod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ValidityPeriodType getValidityPeriod() {
        return this.validityPeriod;
    }

    @JsonProperty(value="validityPeriod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValidityPeriod(ValidityPeriodType validityPeriod) {
        this.validityPeriod = validityPeriod;
    }

    public Prepayment quantity(Double quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public Prepayment rolloverPeriodLength(Integer rolloverPeriodLength) {
        this.rolloverPeriodLength = rolloverPeriodLength;
        return this;
    }

    @Nullable
    @JsonProperty(value="rolloverPeriodLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRolloverPeriodLength() {
        return this.rolloverPeriodLength;
    }

    @JsonProperty(value="rolloverPeriodLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRolloverPeriodLength(Integer rolloverPeriodLength) {
        this.rolloverPeriodLength = rolloverPeriodLength;
    }

    public Prepayment prepayPeriods(String prepayPeriods) {
        this.prepayPeriods = prepayPeriods;
        return this;
    }

    @Nullable
    @JsonProperty(value="prepayPeriods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrepayPeriods() {
        return this.prepayPeriods;
    }

    @JsonProperty(value="prepayPeriods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrepayPeriods(String prepayPeriods) {
        this.prepayPeriods = prepayPeriods;
    }

    public Prepayment operationType(PrepaidOperationType operationType) {
        this.operationType = operationType;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="operationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PrepaidOperationType getOperationType() {
        return this.operationType;
    }

    @JsonProperty(value="operationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperationType(PrepaidOperationType operationType) {
        this.operationType = operationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Prepayment prepayment = (Prepayment)o;
        return Objects.equals((Object)this.creditOption, (Object)prepayment.creditOption) && Objects.equals(this.rollover, prepayment.rollover) && Objects.equals(this.totalQuantity, prepayment.totalQuantity) && Objects.equals(this.unitOfMeasure, prepayment.unitOfMeasure) && Objects.equals((Object)this.rolloverApply, (Object)prepayment.rolloverApply) && Objects.equals(this.rolloverPeriods, prepayment.rolloverPeriods) && Objects.equals((Object)this.validityPeriod, (Object)prepayment.validityPeriod) && Objects.equals(this.quantity, prepayment.quantity) && Objects.equals(this.rolloverPeriodLength, prepayment.rolloverPeriodLength) && Objects.equals(this.prepayPeriods, prepayment.prepayPeriods) && Objects.equals((Object)this.operationType, (Object)prepayment.operationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.creditOption, this.rollover, this.totalQuantity, this.unitOfMeasure, this.rolloverApply, this.rolloverPeriods, this.validityPeriod, this.quantity, this.rolloverPeriodLength, this.prepayPeriods, this.operationType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Prepayment {\n");
        sb.append("    creditOption: ").append(this.toIndentedString((Object)this.creditOption)).append("\n");
        sb.append("    rollover: ").append(this.toIndentedString(this.rollover)).append("\n");
        sb.append("    totalQuantity: ").append(this.toIndentedString(this.totalQuantity)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    rolloverApply: ").append(this.toIndentedString((Object)this.rolloverApply)).append("\n");
        sb.append("    rolloverPeriods: ").append(this.toIndentedString(this.rolloverPeriods)).append("\n");
        sb.append("    validityPeriod: ").append(this.toIndentedString((Object)this.validityPeriod)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    rolloverPeriodLength: ").append(this.toIndentedString(this.rolloverPeriodLength)).append("\n");
        sb.append("    prepayPeriods: ").append(this.toIndentedString(this.prepayPeriods)).append("\n");
        sb.append("    operationType: ").append(this.toIndentedString((Object)this.operationType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PrepaymentBuilder builder() {
        return new PrepaymentBuilder();
    }

    public Prepayment(CreditOption creditOption, Boolean rollover, Double totalQuantity, String unitOfMeasure, RolloverApply rolloverApply, Integer rolloverPeriods, ValidityPeriodType validityPeriod, Double quantity, Integer rolloverPeriodLength, String prepayPeriods, PrepaidOperationType operationType) {
        this.creditOption = creditOption;
        this.rollover = rollover;
        this.totalQuantity = totalQuantity;
        this.unitOfMeasure = unitOfMeasure;
        this.rolloverApply = rolloverApply;
        this.rolloverPeriods = rolloverPeriods;
        this.validityPeriod = validityPeriod;
        this.quantity = quantity;
        this.rolloverPeriodLength = rolloverPeriodLength;
        this.prepayPeriods = prepayPeriods;
        this.operationType = operationType;
    }

    public static class PrepaymentBuilder {
        private CreditOption creditOption;
        private Boolean rollover;
        private Double totalQuantity;
        private String unitOfMeasure;
        private RolloverApply rolloverApply;
        private Integer rolloverPeriods;
        private ValidityPeriodType validityPeriod;
        private Double quantity;
        private Integer rolloverPeriodLength;
        private String prepayPeriods;
        private PrepaidOperationType operationType;

        PrepaymentBuilder() {
        }

        public PrepaymentBuilder creditOption(CreditOption creditOption) {
            this.creditOption = creditOption;
            return this;
        }

        public PrepaymentBuilder rollover(Boolean rollover) {
            this.rollover = rollover;
            return this;
        }

        public PrepaymentBuilder totalQuantity(Double totalQuantity) {
            this.totalQuantity = totalQuantity;
            return this;
        }

        public PrepaymentBuilder unitOfMeasure(String unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
            return this;
        }

        public PrepaymentBuilder rolloverApply(RolloverApply rolloverApply) {
            this.rolloverApply = rolloverApply;
            return this;
        }

        public PrepaymentBuilder rolloverPeriods(Integer rolloverPeriods) {
            this.rolloverPeriods = rolloverPeriods;
            return this;
        }

        public PrepaymentBuilder validityPeriod(ValidityPeriodType validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        public PrepaymentBuilder quantity(Double quantity) {
            this.quantity = quantity;
            return this;
        }

        public PrepaymentBuilder rolloverPeriodLength(Integer rolloverPeriodLength) {
            this.rolloverPeriodLength = rolloverPeriodLength;
            return this;
        }

        public PrepaymentBuilder prepayPeriods(String prepayPeriods) {
            this.prepayPeriods = prepayPeriods;
            return this;
        }

        public PrepaymentBuilder operationType(PrepaidOperationType operationType) {
            this.operationType = operationType;
            return this;
        }

        public Prepayment build() {
            return new Prepayment(this.creditOption, this.rollover, this.totalQuantity, this.unitOfMeasure, this.rolloverApply, this.rolloverPeriods, this.validityPeriod, this.quantity, this.rolloverPeriodLength, this.prepayPeriods, this.operationType);
        }

        public String toString() {
            return "Prepayment.PrepaymentBuilder(creditOption=" + this.creditOption + ", rollover=" + this.rollover + ", totalQuantity=" + this.totalQuantity + ", unitOfMeasure=" + this.unitOfMeasure + ", rolloverApply=" + this.rolloverApply + ", rolloverPeriods=" + this.rolloverPeriods + ", validityPeriod=" + this.validityPeriod + ", quantity=" + this.quantity + ", rolloverPeriodLength=" + this.rolloverPeriodLength + ", prepayPeriods=" + this.prepayPeriods + ", operationType=" + this.operationType + ")";
        }
    }
}

