/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.zevolve.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.zuora.zevolve.api.model.ColumnHierarchy;
import com.zuora.zevolve.api.model.ContextField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"tenant", "contextName", "ratePlanId", "chargeId", "contextfields", "columnHierarchy"})
public class CreateChargeSelectionContextRequest {
    public static final String JSON_PROPERTY_TENANT = "tenant";
    private String tenant;
    public static final String JSON_PROPERTY_CONTEXT_NAME = "contextName";
    private String contextName;
    public static final String JSON_PROPERTY_RATE_PLAN_ID = "ratePlanId";
    private String ratePlanId;
    public static final String JSON_PROPERTY_CHARGE_ID = "chargeId";
    private String chargeId;
    public static final String JSON_PROPERTY_CONTEXTFIELDS = "contextfields";
    private Map<String, ContextField> contextfields = new HashMap<String, ContextField>();
    public static final String JSON_PROPERTY_COLUMN_HIERARCHY = "columnHierarchy";
    private List<@Valid ColumnHierarchy> columnHierarchy = new ArrayList<ColumnHierarchy>();

    public CreateChargeSelectionContextRequest() {
    }

    public CreateChargeSelectionContextRequest tenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    @Nullable
    @JsonProperty(value="tenant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenant() {
        return this.tenant;
    }

    @JsonProperty(value="tenant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public CreateChargeSelectionContextRequest contextName(String contextName) {
        this.contextName = contextName;
        return this;
    }

    @Nullable
    @JsonProperty(value="contextName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContextName() {
        return this.contextName;
    }

    @JsonProperty(value="contextName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public CreateChargeSelectionContextRequest ratePlanId(String ratePlanId) {
        this.ratePlanId = ratePlanId;
        return this;
    }

    @Nullable
    @JsonProperty(value="ratePlanId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRatePlanId() {
        return this.ratePlanId;
    }

    @JsonProperty(value="ratePlanId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRatePlanId(String ratePlanId) {
        this.ratePlanId = ratePlanId;
    }

    public CreateChargeSelectionContextRequest chargeId(String chargeId) {
        this.chargeId = chargeId;
        return this;
    }

    @Nullable
    @JsonProperty(value="chargeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChargeId() {
        return this.chargeId;
    }

    @JsonProperty(value="chargeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChargeId(String chargeId) {
        this.chargeId = chargeId;
    }

    public CreateChargeSelectionContextRequest contextfields(Map<String, ContextField> contextfields) {
        this.contextfields = contextfields;
        return this;
    }

    public CreateChargeSelectionContextRequest putContextfieldsItem(String key, ContextField contextfieldsItem) {
        if (this.contextfields == null) {
            this.contextfields = new HashMap<String, ContextField>();
        }
        this.contextfields.put(key, contextfieldsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="contextfields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, ContextField> getContextfields() {
        return this.contextfields;
    }

    @JsonProperty(value="contextfields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContextfields(Map<String, ContextField> contextfields) {
        this.contextfields = contextfields;
    }

    public CreateChargeSelectionContextRequest columnHierarchy(List<@Valid ColumnHierarchy> columnHierarchy) {
        this.columnHierarchy = columnHierarchy;
        return this;
    }

    public CreateChargeSelectionContextRequest addColumnHierarchyItem(ColumnHierarchy columnHierarchyItem) {
        if (this.columnHierarchy == null) {
            this.columnHierarchy = new ArrayList<ColumnHierarchy>();
        }
        this.columnHierarchy.add(columnHierarchyItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="columnHierarchy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid ColumnHierarchy> getColumnHierarchy() {
        return this.columnHierarchy;
    }

    @JsonProperty(value="columnHierarchy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumnHierarchy(List<@Valid ColumnHierarchy> columnHierarchy) {
        this.columnHierarchy = columnHierarchy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateChargeSelectionContextRequest createChargeSelectionContextRequest = (CreateChargeSelectionContextRequest)o;
        return Objects.equals(this.tenant, createChargeSelectionContextRequest.tenant) && Objects.equals(this.contextName, createChargeSelectionContextRequest.contextName) && Objects.equals(this.ratePlanId, createChargeSelectionContextRequest.ratePlanId) && Objects.equals(this.chargeId, createChargeSelectionContextRequest.chargeId) && Objects.equals(this.contextfields, createChargeSelectionContextRequest.contextfields) && Objects.equals(this.columnHierarchy, createChargeSelectionContextRequest.columnHierarchy);
    }

    public int hashCode() {
        return Objects.hash(this.tenant, this.contextName, this.ratePlanId, this.chargeId, this.contextfields, this.columnHierarchy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateChargeSelectionContextRequest {\n");
        sb.append("    tenant: ").append(this.toIndentedString(this.tenant)).append("\n");
        sb.append("    contextName: ").append(this.toIndentedString(this.contextName)).append("\n");
        sb.append("    ratePlanId: ").append(this.toIndentedString(this.ratePlanId)).append("\n");
        sb.append("    chargeId: ").append(this.toIndentedString(this.chargeId)).append("\n");
        sb.append("    contextfields: ").append(this.toIndentedString(this.contextfields)).append("\n");
        sb.append("    columnHierarchy: ").append(this.toIndentedString(this.columnHierarchy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreateChargeSelectionContextRequestBuilder builder() {
        return new CreateChargeSelectionContextRequestBuilder();
    }

    public CreateChargeSelectionContextRequest(String tenant, String contextName, String ratePlanId, String chargeId, Map<String, ContextField> contextfields, List<@Valid ColumnHierarchy> columnHierarchy) {
        this.tenant = tenant;
        this.contextName = contextName;
        this.ratePlanId = ratePlanId;
        this.chargeId = chargeId;
        this.contextfields = contextfields;
        this.columnHierarchy = columnHierarchy;
    }

    public static class CreateChargeSelectionContextRequestBuilder {
        private String tenant;
        private String contextName;
        private String ratePlanId;
        private String chargeId;
        private Map<String, ContextField> contextfields;
        private List<@Valid ColumnHierarchy> columnHierarchy;

        CreateChargeSelectionContextRequestBuilder() {
        }

        public CreateChargeSelectionContextRequestBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public CreateChargeSelectionContextRequestBuilder contextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        public CreateChargeSelectionContextRequestBuilder ratePlanId(String ratePlanId) {
            this.ratePlanId = ratePlanId;
            return this;
        }

        public CreateChargeSelectionContextRequestBuilder chargeId(String chargeId) {
            this.chargeId = chargeId;
            return this;
        }

        public CreateChargeSelectionContextRequestBuilder contextfields(Map<String, ContextField> contextfields) {
            this.contextfields = contextfields;
            return this;
        }

        public CreateChargeSelectionContextRequestBuilder columnHierarchy(List<@Valid ColumnHierarchy> columnHierarchy) {
            this.columnHierarchy = columnHierarchy;
            return this;
        }

        public CreateChargeSelectionContextRequest build() {
            return new CreateChargeSelectionContextRequest(this.tenant, this.contextName, this.ratePlanId, this.chargeId, this.contextfields, this.columnHierarchy);
        }

        public String toString() {
            return "CreateChargeSelectionContextRequest.CreateChargeSelectionContextRequestBuilder(tenant=" + this.tenant + ", contextName=" + this.contextName + ", ratePlanId=" + this.ratePlanId + ", chargeId=" + this.chargeId + ", contextfields=" + this.contextfields + ", columnHierarchy=" + this.columnHierarchy + ")";
        }
    }
}

