/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.catalog.charge.onetime;

import com.zuora.sdk.catalog.charge.Amount;
import com.zuora.sdk.catalog.charge.Billing;
import com.zuora.sdk.catalog.charge.SubscriptionRenewalOptions;
import com.zuora.sdk.catalog.charge.Taxation;
import com.zuora.sdk.catalog.charge.onetime.OneTimeCharge;
import com.zuora.sdk.error.ErrorCode;
import com.zuora.sdk.error.ErrorType;
import com.zuora.sdk.error.SdkError;
import com.zuora.sdk.error.SdkException;
import com.zuora.zevolve.api.model.Accounting;
import com.zuora.zevolve.api.model.ChargeModel;
import com.zuora.zevolve.api.model.ChargeType;
import com.zuora.zevolve.api.model.DeliverySchedule;
import com.zuora.zevolve.api.model.Drawdown;
import com.zuora.zevolve.api.model.Netsuite;
import com.zuora.zevolve.api.model.Prepayment;
import com.zuora.zevolve.api.model.Pricing;
import com.zuora.zevolve.api.model.ProductRatePlanChargeRequest;
import com.zuora.zevolve.api.model.Revenue;
import com.zuora.zevolve.api.model.TriggerEvent;
import com.zuora.zevolve.api.model.Value;
import java.util.ArrayList;
import java.util.List;

public final class FlatFee
extends OneTimeCharge {
    private final List<Amount> amounts = new ArrayList<Amount>();

    static FlatFee newInstance() {
        return new FlatFee();
    }

    public FlatFee withName(String name) {
        this.name = name;
        return this;
    }

    protected FlatFee with(Billing billing) {
        throw new SdkException(SdkError.error((ErrorType)ErrorType.bad_request, (ErrorCode)ErrorCode.invalid_request, (String)"One-time charges do not support billing options."));
    }

    public FlatFee with(TriggerEvent event) {
        this.triggerEvent = event;
        return this;
    }

    protected FlatFee with(Accounting accounting) {
        this.accounting = accounting;
        return this;
    }

    public FlatFee with(Revenue revenue) {
        this.revenue = revenue;
        return this;
    }

    public FlatFee with(Taxation taxation) {
        this.taxation = taxation;
        return this;
    }

    public FlatFee with(Netsuite netsuite) {
        this.netsuite = netsuite;
        return this;
    }

    protected FlatFee with(SubscriptionRenewalOptions options) {
        this.renewalOptions = options;
        return this;
    }

    protected FlatFee with(DeliverySchedule deliverySchedule) {
        this.deliverySchedule = deliverySchedule;
        return this;
    }

    public FlatFee with(Amount amount) {
        this.and(amount);
        return this;
    }

    public FlatFee with(Prepayment prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    public FlatFee with(Drawdown drawdown) {
        this.drawdown = drawdown;
        return this;
    }

    public FlatFee and(Amount amount) {
        if (amount != null) {
            this.amounts.add(amount);
        }
        return this;
    }

    public FlatFee withCustomField(String name, Value value) {
        this.customFields.put(name, value);
        return this;
    }

    @Override
    public ProductRatePlanChargeRequest toApi(ProductRatePlanChargeRequest.ProductRatePlanChargeRequestBuilder builder) {
        return builder.chargeType(ChargeType.ONE_TIME).chargeModel(ChargeModel.FLAT_FEE).pricing(Pricing.builder().flatAmounts(Amount.toApiMap(this.amounts)).build()).build();
    }
}

