/*
 * Decompiled with CFR 0.152.
 */
package com.example.refreshview;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.example.refreshview.BaseFooterView;
import com.example.refreshview.R;
import com.example.refreshview.SimpleFooterView;

public class CustomRefreshView
extends FrameLayout
implements SwipeRefreshLayout.OnRefreshListener {
    private View mEmptyView;
    private TextView mEmptyText;
    private View mErrorView;
    private FrameLayout blankView;
    private BaseFooterView mFootView;
    private RecyclerView recyclerView;
    private SwipeRefreshLayout mRefreshLayout;
    private RecyclerView.LayoutManager mLayoutManager;
    public OnLoadListener mListener;
    private DataObserver mDataObserver;
    private WrapperAdapter mWrapperAdapter;
    private boolean isEmptyViewShowing;
    private boolean isLoadingMore;
    public boolean isLoadMoreEnable;
    private boolean isRefreshEnable;
    private int lastVisiblePosition = 0;
    private Context context;

    public CustomRefreshView(Context context) {
        this(context, null);
    }

    public CustomRefreshView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CustomRefreshView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.setupSwipeRecyclerView();
    }

    private void setupSwipeRecyclerView() {
        this.isEmptyViewShowing = false;
        this.isRefreshEnable = true;
        this.isLoadingMore = false;
        this.isLoadMoreEnable = true;
        this.mFootView = new SimpleFooterView(this.getContext());
        this.mFootView.setCustomRefreshView(this);
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.custom_refresh_layout, (ViewGroup)this);
        this.mRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.SwipeRefreshLayout);
        this.blankView = (FrameLayout)view.findViewById(R.id.blank_view);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        params.gravity = 1;
        this.blankView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mRefreshLayout.setColorSchemeColors(new int[]{Color.parseColor((String)"#000000")});
        this.recyclerView = (RecyclerView)view.findViewById(R.id.RecyclerView);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mLayoutManager = this.recyclerView.getLayoutManager();
        this.mRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.recyclerView.setOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                int childCount;
                super.onScrolled(recyclerView, dx, dy);
                if (!CustomRefreshView.this.isLoadMoreEnable || CustomRefreshView.this.isRefreshing() || CustomRefreshView.this.isLoadingMore) {
                    return;
                }
                CustomRefreshView.this.mLayoutManager = recyclerView.getLayoutManager();
                if (CustomRefreshView.this.mLayoutManager instanceof LinearLayoutManager) {
                    CustomRefreshView.this.lastVisiblePosition = ((LinearLayoutManager)CustomRefreshView.this.mLayoutManager).findLastVisibleItemPosition();
                }
                int n = childCount = CustomRefreshView.this.mWrapperAdapter == null ? 0 : CustomRefreshView.this.mWrapperAdapter.getItemCount();
                if (childCount > 9 && CustomRefreshView.this.lastVisiblePosition == childCount - 1 && CustomRefreshView.this.mListener != null) {
                    CustomRefreshView.this.isLoadingMore = true;
                    CustomRefreshView.this.mListener.onLoadMore();
                }
            }
        });
    }

    public void setRefreshEnable(boolean refreshEnable) {
        this.isRefreshEnable = refreshEnable;
        this.mRefreshLayout.setEnabled(this.isRefreshEnable);
    }

    public boolean getRefreshEnable() {
        return this.isRefreshEnable;
    }

    public void setLoadMoreEnable(boolean loadMoreEnable) {
        if (!loadMoreEnable) {
            this.stopLoadingMore();
        }
        this.isLoadMoreEnable = loadMoreEnable;
    }

    public boolean getLoadMoreEnable() {
        return this.isLoadMoreEnable;
    }

    public boolean isRefreshing() {
        return this.mRefreshLayout.isRefreshing();
    }

    public boolean isLoadingMore() {
        return this.isLoadingMore;
    }

    public boolean isEmptyViewShowing() {
        return this.isEmptyViewShowing;
    }

    public SwipeRefreshLayout getSwipeRefreshLayout() {
        return this.mRefreshLayout;
    }

    public RecyclerView getRecyclerView() {
        return this.recyclerView;
    }

    public void setOnLoadListener(OnLoadListener listener) {
        this.mListener = listener;
    }

    public void setFooterView(BaseFooterView footerView) {
        if (footerView != null) {
            this.mFootView = footerView;
        }
    }

    public void setEmptyView(String s) {
        if (this.blankView.getChildCount() > 0) {
            this.blankView.removeAllViews();
        }
        if (this.mEmptyView == null) {
            this.mEmptyView = LayoutInflater.from((Context)this.context).inflate(R.layout.empty_view, null);
            this.mEmptyText = (TextView)this.mEmptyView.findViewById(R.id.module_base_empty_text);
        }
        this.blankView.addView(this.mEmptyView);
        this.mEmptyText.setText((CharSequence)s);
        if (this.mDataObserver != null) {
            this.mDataObserver.onChanged();
        }
    }

    public void setErrorView() {
        if (this.blankView.getChildCount() > 0) {
            this.blankView.removeAllViews();
        }
        if (this.mErrorView == null) {
            this.mErrorView = LayoutInflater.from((Context)this.context).inflate(R.layout.error_view, null);
            this.mErrorView.findViewById(R.id.module_base_id_fail_retry).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CustomRefreshView.this.setRefreshing(true);
                }
            });
        }
        this.blankView.addView(this.mErrorView);
        if (this.mDataObserver != null) {
            this.mDataObserver.onChanged();
        }
    }

    public void setCreateView(View createView) {
        if (this.blankView.getChildCount() > 0) {
            this.blankView.removeAllViews();
        }
        this.blankView.addView(createView);
        if (this.mDataObserver != null) {
            this.mDataObserver.onChanged();
        }
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (adapter != null) {
            if (this.mDataObserver == null) {
                this.mDataObserver = new DataObserver();
            }
            this.mWrapperAdapter = new WrapperAdapter((RecyclerView.Adapter<RecyclerView.ViewHolder>)adapter);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.mWrapperAdapter);
            adapter.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this.mDataObserver);
            this.mDataObserver.onChanged();
        }
    }

    public void complete() {
        this.mRefreshLayout.setRefreshing(false);
        this.stopLoadingMore();
    }

    public void setRefreshing(boolean refreshing) {
        this.mRefreshLayout.setRefreshing(refreshing);
        if (refreshing && !this.isLoadingMore && this.mListener != null) {
            this.mListener.onRefresh();
        }
    }

    public void stopLoadingMore() {
        this.isLoadingMore = false;
        if (this.mWrapperAdapter != null) {
            this.mWrapperAdapter.notifyItemRemoved(this.mWrapperAdapter.getItemCount());
        }
    }

    public void onRefresh() {
        if (this.mListener != null) {
            this.isLoadingMore = false;
            if (this.mFootView != null) {
                this.mFootView.onLoadingMore();
            }
            this.mListener.onRefresh();
        }
    }

    public void onLoadingMore() {
        if (this.mFootView != null) {
            this.mFootView.onLoadingMore();
        }
    }

    public void onNoMore() {
        if (this.mFootView != null) {
            this.isLoadingMore = true;
            this.mFootView.onNoMore();
        }
    }

    public void onError() {
        if (this.mFootView != null) {
            this.mFootView.onError();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mWrapperAdapter != null) {
            this.mWrapperAdapter.unregisterAdapterDataObserver(this.mDataObserver);
        }
        super.onDetachedFromWindow();
    }

    public static interface OnLoadListener {
        public void onRefresh();

        public void onLoadMore();
    }

    class DataObserver
    extends RecyclerView.AdapterDataObserver {
        DataObserver() {
        }

        public void onChanged() {
            super.onChanged();
            RecyclerView.Adapter adapter = CustomRefreshView.this.recyclerView.getAdapter();
            if (adapter != null) {
                if (adapter.getItemCount() == 0) {
                    CustomRefreshView.this.isEmptyViewShowing = true;
                    CustomRefreshView.this.recyclerView.setVisibility(8);
                    CustomRefreshView.this.blankView.setVisibility(0);
                } else {
                    CustomRefreshView.this.isEmptyViewShowing = false;
                    CustomRefreshView.this.blankView.setVisibility(8);
                    CustomRefreshView.this.recyclerView.setVisibility(0);
                }
            }
        }
    }

    private class FooterViewHolder
    extends RecyclerView.ViewHolder {
        public FooterViewHolder(View itemView) {
            super(itemView);
        }
    }

    private class WrapperAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        public static final int TYPE_FOOTER = 256;
        RecyclerView.Adapter<RecyclerView.ViewHolder> mInnerAdapter;

        public WrapperAdapter(RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
            this.mInnerAdapter = adapter;
        }

        public boolean isLoadMoreItem(int position) {
            return CustomRefreshView.this.isLoadMoreEnable && position == this.getItemCount() - 1;
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            if (256 == viewType) {
                return new FooterViewHolder((View)CustomRefreshView.this.mFootView);
            }
            return this.mInnerAdapter.onCreateViewHolder(parent, viewType);
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (this.isLoadMoreItem(position)) {
                return;
            }
            this.mInnerAdapter.onBindViewHolder(holder, position);
        }

        public int getItemViewType(int position) {
            if (this.isLoadMoreItem(position)) {
                return 256;
            }
            return this.mInnerAdapter.getItemViewType(position);
        }

        public int getItemCount() {
            int count;
            int n = count = this.mInnerAdapter == null ? 0 : this.mInnerAdapter.getItemCount();
            if (count == 0) {
                return 0;
            }
            return CustomRefreshView.this.isLoadMoreEnable ? count + 1 : count;
        }

        public long getItemId(int position) {
            return this.mInnerAdapter.getItemId(position);
        }

        public void registerAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
            Log.i((String)"tag", (String)"registerAdapterDataObserver--------------");
            this.mInnerAdapter.registerAdapterDataObserver(observer);
        }

        public void unregisterAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
            Log.i((String)"tag", (String)"unregisterAdapterDataObserver--------------");
            this.mInnerAdapter.unregisterAdapterDataObserver(observer);
        }
    }
}

