/*
 * Decompiled with CFR 0.152.
 */
package com.zr.library.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.v4.widget.DrawerLayout;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.zr.library.R;
import com.zr.library.proxy.StatusBarProxy;

public class StatusBarUtil {
    public static final int DEFAULT_STATUS_BAR_ALPHA = 0;
    private static final int FAKE_STATUS_BAR_VIEW_ID = R.id.statusbarutil_fake_status_bar_view;
    private static final int FAKE_TRANSLUCENT_VIEW_ID = R.id.statusbarutil_translucent_view;
    private static final int TAG_KEY_HAVE_SET_OFFSET = -123;

    public static void setColor(Activity activity, @ColorInt int color) {
        StatusBarUtil.setColor(activity, color, 0);
    }

    private static void setColor(Activity activity, @ColorInt int color, int statusBarAlpha) {
        if (StatusBarProxy.getInstance().checkCompatiblity()) {
            if (StatusBarProxy.getInstance().checkSpecialRom()) {
                activity.getWindow().addFlags(0x4000000);
                ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
                View fakeStatusBarView = decorView.findViewById(FAKE_STATUS_BAR_VIEW_ID);
                if (fakeStatusBarView != null) {
                    if (fakeStatusBarView.getVisibility() == 8) {
                        fakeStatusBarView.setVisibility(0);
                    }
                    fakeStatusBarView.setBackgroundColor(StatusBarUtil.calculateStatusColor(color, statusBarAlpha));
                } else {
                    decorView.addView(StatusBarUtil.createStatusBarView(activity, color, statusBarAlpha));
                }
                StatusBarUtil.setRootView(activity);
                return;
            }
            activity.getWindow().getDecorView().setSystemUiVisibility(1280);
            if (Build.VERSION.SDK_INT >= 21) {
                activity.getWindow().addFlags(Integer.MIN_VALUE);
                activity.getWindow().clearFlags(0x4000000);
                activity.getWindow().setStatusBarColor(StatusBarUtil.calculateStatusColor(color, statusBarAlpha));
            } else if (Build.VERSION.SDK_INT >= 19) {
                activity.getWindow().addFlags(0x4000000);
                ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
                View fakeStatusBarView = decorView.findViewById(FAKE_STATUS_BAR_VIEW_ID);
                if (fakeStatusBarView != null) {
                    if (fakeStatusBarView.getVisibility() == 8) {
                        fakeStatusBarView.setVisibility(0);
                    }
                    fakeStatusBarView.setBackgroundColor(StatusBarUtil.calculateStatusColor(color, statusBarAlpha));
                } else {
                    decorView.addView(StatusBarUtil.createStatusBarView(activity, color, statusBarAlpha));
                }
                StatusBarUtil.setRootView(activity);
            }
        }
    }

    public static void setColorForDrawerLayout(Activity activity, @ColorInt int color) {
        StatusBarUtil.setColorForDrawerLayout(activity, color, 0);
    }

    public static void setColorForDrawerLayout(Activity activity, @ColorInt int color, int statusBarAlpha) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (!StatusBarProxy.getInstance().checkCompatiblity()) {
            return;
        }
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        View rootView = contentView.getChildAt(0);
        if (rootView != null && rootView instanceof DrawerLayout) {
            DrawerLayout drawerLayout = (DrawerLayout)rootView;
            if (Build.VERSION.SDK_INT >= 21) {
                activity.getWindow().addFlags(Integer.MIN_VALUE);
                activity.getWindow().clearFlags(0x4000000);
                activity.getWindow().setStatusBarColor(0);
            } else {
                activity.getWindow().addFlags(0x4000000);
            }
            ViewGroup contentLayout = (ViewGroup)drawerLayout.getChildAt(0);
            View fakeStatusBarView = contentLayout.findViewById(FAKE_STATUS_BAR_VIEW_ID);
            if (fakeStatusBarView != null) {
                if (fakeStatusBarView.getVisibility() == 8) {
                    fakeStatusBarView.setVisibility(0);
                }
                fakeStatusBarView.setBackgroundColor(color);
            } else {
                contentLayout.addView(StatusBarUtil.createStatusBarView(activity, color), 0);
            }
            if (!(contentLayout instanceof LinearLayout && contentLayout instanceof FrameLayout && contentLayout instanceof RelativeLayout || contentLayout.getChildAt(1) == null)) {
                contentLayout.getChildAt(1).setPadding(contentLayout.getPaddingLeft(), StatusBarUtil.getStatusBarHeight((Context)activity) + contentLayout.getPaddingTop(), contentLayout.getPaddingRight(), contentLayout.getPaddingBottom());
            }
            StatusBarUtil.setDrawerLayoutProperty(drawerLayout, contentLayout);
        }
    }

    private static void setDrawerLayoutProperty(DrawerLayout drawerLayout, ViewGroup drawerLayoutContentLayout) {
        ViewGroup drawer = (ViewGroup)drawerLayout.getChildAt(1);
        drawerLayout.setFitsSystemWindows(false);
        drawerLayoutContentLayout.setFitsSystemWindows(false);
        drawerLayoutContentLayout.setClipToPadding(true);
        drawer.setFitsSystemWindows(false);
    }

    public static void hideFakeStatusBarView(Activity activity) {
        View fakeTranslucentView;
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View fakeStatusBarView = decorView.findViewById(FAKE_STATUS_BAR_VIEW_ID);
        if (fakeStatusBarView != null) {
            fakeStatusBarView.setVisibility(8);
        }
        if ((fakeTranslucentView = decorView.findViewById(FAKE_TRANSLUCENT_VIEW_ID)) != null) {
            fakeTranslucentView.setVisibility(8);
        }
    }

    @TargetApi(value=19)
    private static void clearPreviousSetting(Activity activity) {
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View fakeStatusBarView = decorView.findViewById(FAKE_STATUS_BAR_VIEW_ID);
        if (fakeStatusBarView != null) {
            decorView.removeView(fakeStatusBarView);
            ViewGroup rootView = (ViewGroup)((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
            rootView.setPadding(0, 0, 0, 0);
        }
    }

    private static void addTranslucentView(Activity activity, int statusBarAlpha) {
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        View fakeTranslucentView = contentView.findViewById(FAKE_TRANSLUCENT_VIEW_ID);
        if (fakeTranslucentView != null) {
            if (fakeTranslucentView.getVisibility() == 8) {
                fakeTranslucentView.setVisibility(0);
            }
            fakeTranslucentView.setBackgroundColor(Color.argb((int)statusBarAlpha, (int)0, (int)0, (int)0));
        } else {
            contentView.addView(StatusBarUtil.createTranslucentStatusBarView(activity, statusBarAlpha));
        }
    }

    private static View createStatusBarView(Activity activity, @ColorInt int color) {
        return StatusBarUtil.createStatusBarView(activity, color, 0);
    }

    private static View createStatusBarView(Activity activity, @ColorInt int color, int alpha) {
        View statusBarView = new View((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, StatusBarUtil.getStatusBarHeight((Context)activity));
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(StatusBarUtil.calculateStatusColor(color, alpha));
        statusBarView.setId(FAKE_STATUS_BAR_VIEW_ID);
        return statusBarView;
    }

    private static void setRootView(Activity activity) {
        ViewGroup parent = (ViewGroup)activity.findViewById(0x1020002);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View childView = parent.getChildAt(i);
            if (!(childView instanceof ViewGroup)) continue;
            childView.setFitsSystemWindows(true);
            ((ViewGroup)childView).setClipToPadding(true);
        }
    }

    @TargetApi(value=19)
    private static void transparentStatusBar(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().addFlags(0x8000000);
            activity.getWindow().setStatusBarColor(0);
        } else {
            activity.getWindow().addFlags(0x4000000);
        }
    }

    private static View createTranslucentStatusBarView(Activity activity, int alpha) {
        View statusBarView = new View((Context)activity);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, StatusBarUtil.getStatusBarHeight((Context)activity));
        statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        statusBarView.setBackgroundColor(Color.argb((int)alpha, (int)0, (int)0, (int)0));
        statusBarView.setId(FAKE_TRANSLUCENT_VIEW_ID);
        return statusBarView;
    }

    public static int getStatusBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    private static int calculateStatusColor(@ColorInt int color, int alpha) {
        if (alpha == 0) {
            return color;
        }
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }
}

