/*
 * Decompiled with CFR 0.152.
 */
package com.zr.library.util;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class CompatUtil {
    private static final String TAG = CompatUtil.class.getSimpleName();
    public static final String ROM_EMUI = "EMUI";
    private static final String KEY_VERSION_EMUI = "ro.build.version.emui";

    public static boolean checkSpecialRom() {
        return CompatUtil.isEmui_3_1();
    }

    public static boolean checkCompatiblity() {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        return CompatUtil.isCompactOppo();
    }

    private static boolean isCompactOppo() {
        if (CompatUtil.isOppo()) {
            return Build.VERSION.SDK_INT >= 21;
        }
        return true;
    }

    public static boolean isEmui_3_1() {
        String romVersion = CompatUtil.getRomVersion(ROM_EMUI);
        if (!TextUtils.isEmpty((CharSequence)romVersion)) {
            return romVersion.equals("EmotionUI_3.1");
        }
        return false;
    }

    public static String getRomVersion(String romType) {
        String result = null;
        switch (romType) {
            case "EMUI": {
                result = CompatUtil.getSystemProperty(KEY_VERSION_EMUI);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSystemProperty(String propName) {
        String line;
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)("Unable to read sysprop " + propName), (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Exception while closing InputStream", (Throwable)e);
                }
            }
        }
        return line;
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    private static boolean isMeizu() {
        String manufacturer = CompatUtil.getManufacturer();
        if (TextUtils.isEmpty((CharSequence)manufacturer)) {
            return false;
        }
        return CompatUtil.getManufacturer().equals("Meizu");
    }

    private static boolean isSmartisan() {
        String manufacturer = CompatUtil.getManufacturer();
        if (TextUtils.isEmpty((CharSequence)manufacturer)) {
            return false;
        }
        return CompatUtil.getManufacturer().equals("smartisan");
    }

    private static boolean isOppo() {
        String manufacturer = CompatUtil.getManufacturer();
        if (TextUtils.isEmpty((CharSequence)manufacturer)) {
            return false;
        }
        return CompatUtil.getManufacturer().equals("OPPO");
    }
}

