/*
 * Decompiled with CFR 0.152.
 */
package com.zplesac.connectionbuddy;

import android.content.Context;
import android.net.ConnectivityManager;
import com.zplesac.connectionbuddy.ConnectionBuddyCache;
import com.zplesac.connectionbuddy.LruConnectionBuddyCache;
import com.zplesac.connectionbuddy.models.ConnectivityStrength;

public class ConnectionBuddyConfiguration {
    public static final int SIGNAL_STRENGTH_NUMBER_OF_LEVELS = 3;
    public static final int DEFAULT_NETWORK_EXECUTOR_THREAD_SIZE = 4;
    private Context context;
    private boolean registeredForWiFiChanges;
    private boolean registeredForMobileNetworkChanges;
    private ConnectivityStrength minimumSignalStrength;
    private ConnectionBuddyCache networkEventsCache;
    private boolean notifyImmediately;
    private ConnectivityManager connectivityManager;
    private boolean notifyOnlyReliableEvents;
    private int testNetworkRequestExecutorSize;

    private ConnectionBuddyConfiguration(Builder builder) {
        this.context = builder.context;
        this.registeredForMobileNetworkChanges = builder.registerForMobileNetworkChanges;
        this.registeredForWiFiChanges = builder.registerForWiFiChanges;
        this.minimumSignalStrength = builder.minimumSignalStrength;
        this.notifyImmediately = builder.notifyImmediately;
        this.notifyOnlyReliableEvents = builder.notifyOnlyReliableEvents;
        this.connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        this.testNetworkRequestExecutorSize = builder.testNetworkRequestExecutorSize;
        this.networkEventsCache = builder.cache != null ? builder.cache : new LruConnectionBuddyCache();
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isRegisteredForWiFiChanges() {
        return this.registeredForWiFiChanges;
    }

    public boolean isRegisteredForMobileNetworkChanges() {
        return this.registeredForMobileNetworkChanges;
    }

    public ConnectivityStrength getMinimumSignalStrength() {
        return this.minimumSignalStrength;
    }

    public ConnectionBuddyCache getNetworkEventsCache() {
        return this.networkEventsCache;
    }

    public boolean isNotifyImmediately() {
        return this.notifyImmediately;
    }

    public ConnectivityManager getConnectivityManager() {
        return this.connectivityManager;
    }

    public boolean isNotifyOnlyReliableEvents() {
        return this.notifyOnlyReliableEvents;
    }

    public int getTestNetworkRequestExecutorSize() {
        return this.testNetworkRequestExecutorSize;
    }

    public static class Builder {
        private Context context;
        private boolean registerForWiFiChanges = true;
        private boolean registerForMobileNetworkChanges = true;
        private ConnectivityStrength minimumSignalStrength = new ConnectivityStrength(-1);
        private boolean notifyImmediately = true;
        private ConnectionBuddyCache cache;
        private boolean notifyOnlyReliableEvents = false;
        private int testNetworkRequestExecutorSize = 4;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
        }

        public Builder registerForWiFiChanges(boolean shouldRegister) {
            this.registerForWiFiChanges = shouldRegister;
            return this;
        }

        public Builder registerForMobileNetworkChanges(boolean shouldRegister) {
            this.registerForMobileNetworkChanges = shouldRegister;
            return this;
        }

        public Builder setMinimumSignalStrength(ConnectivityStrength minimumSignalStrength) {
            this.minimumSignalStrength = minimumSignalStrength;
            return this;
        }

        public Builder setNotifyImmediately(boolean shouldNotify) {
            this.notifyImmediately = shouldNotify;
            return this;
        }

        public Builder notifyOnlyReliableEvents(boolean shouldNotify) {
            this.notifyOnlyReliableEvents = shouldNotify;
            return this;
        }

        public Builder setNetworkEventsCache(ConnectionBuddyCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder setTestNetworkRequestExecutorSize(int testNetworkRequestExecutorSize) {
            this.testNetworkRequestExecutorSize = testNetworkRequestExecutorSize;
            return this;
        }

        public ConnectionBuddyConfiguration build() {
            return new ConnectionBuddyConfiguration(this);
        }
    }
}

