/*
 * Decompiled with CFR 0.152.
 */
package com.zplesac.connectionbuddy;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.zplesac.connectionbuddy.ConnectionBuddyCache;
import com.zplesac.connectionbuddy.ConnectionBuddyConfiguration;
import com.zplesac.connectionbuddy.NetworkChangeReceiver;
import com.zplesac.connectionbuddy.interfaces.ConnectivityChangeListener;
import com.zplesac.connectionbuddy.interfaces.NetworkRequestCheckListener;
import com.zplesac.connectionbuddy.interfaces.WifiConnectivityListener;
import com.zplesac.connectionbuddy.models.ConnectivityEvent;
import com.zplesac.connectionbuddy.models.ConnectivityState;
import com.zplesac.connectionbuddy.models.ConnectivityStrength;
import com.zplesac.connectionbuddy.models.ConnectivityType;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ConnectionBuddy {
    private static final String HEADER_KEY_USER_AGENT = "User-Agent";
    private static final String HEADER_VALUE_USER_AGENT = "Android";
    private static final String HEADER_KEY_CONNECTION = "Connection";
    private static final String HEADER_VALUE_CONNECTION = "close";
    private static final String NETWORK_CHECK_URL = "http://clients3.google.com/generate_204";
    private static final int CONNECTION_TIMEOUT = 1500;
    private static volatile ConnectionBuddy instance;
    private Map<String, NetworkChangeReceiver> networkReceiversHashMap = new HashMap<String, NetworkChangeReceiver>();
    private WifiScanResultReceiver wifiScanResultReceiver;
    private WifiConnectionStateChangedReceiver wifiConnectionStateChangedReceiver;
    private ConnectionBuddyConfiguration configuration;
    private ExecutorService executor;
    private Executor callbackExecutor = new Executor(){
        Handler mainHandler = new Handler(Looper.getMainLooper());

        @Override
        public void execute(Runnable command) {
            this.mainHandler.post(command);
        }
    };

    protected ConnectionBuddy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionBuddy getInstance() {
        if (instance != null) return instance;
        Class<ConnectionBuddy> clazz = ConnectionBuddy.class;
        synchronized (ConnectionBuddy.class) {
            if (instance != null) return instance;
            instance = new ConnectionBuddy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void init(ConnectionBuddyConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException();
        }
        if (this.configuration == null) {
            this.configuration = configuration;
        }
    }

    public ConnectionBuddyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void registerForConnectivityEvents(Object object, ConnectivityChangeListener listener) {
        this.registerForConnectivityEvents(object, this.configuration.isNotifyImmediately(), listener);
    }

    public void registerForConnectivityEvents(Object object, boolean notifyImmediately, ConnectivityChangeListener listener) {
        boolean hasConnection = this.hasNetworkConnection();
        ConnectionBuddyCache cache = this.configuration.getNetworkEventsCache();
        if (cache.isLastNetworkStateStored(object) && cache.getLastNetworkState(object) != hasConnection) {
            cache.setLastNetworkState(object, hasConnection);
            if (notifyImmediately) {
                this.notifyConnectionChange(hasConnection, listener);
            }
        } else if (!cache.isLastNetworkStateStored(object)) {
            cache.setLastNetworkState(object, hasConnection);
            if (notifyImmediately) {
                this.notifyConnectionChange(hasConnection, listener);
            }
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        NetworkChangeReceiver receiver = new NetworkChangeReceiver(object, listener);
        if (!this.networkReceiversHashMap.containsKey(object.toString())) {
            this.networkReceiversHashMap.put(object.toString(), receiver);
        }
        this.configuration.getContext().registerReceiver((BroadcastReceiver)receiver, filter);
    }

    public void clearNetworkCache(Object object) {
        this.configuration.getNetworkEventsCache().clearLastNetworkState(object);
    }

    public void clearNetworkCache(Object object, @Nullable Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.configuration.getNetworkEventsCache().clearLastNetworkState(object);
        }
    }

    public void notifyConnectionChange(boolean hasConnection, final ConnectivityChangeListener listener) {
        if (hasConnection) {
            final ConnectivityEvent event = new ConnectivityEvent(new ConnectivityState(1), this.getNetworkType(), this.getSignalStrength());
            if (this.configuration.isNotifyOnlyReliableEvents()) {
                this.testNetworkRequest(new NetworkRequestCheckListener(){

                    @Override
                    public void onResponseObtained() {
                        ConnectionBuddy.this.handleActiveInternetConnection(event, listener);
                    }

                    @Override
                    public void onNoResponse() {
                    }
                });
            } else {
                this.handleActiveInternetConnection(event, listener);
            }
        } else {
            listener.onConnectionChange(new ConnectivityEvent(new ConnectivityState(0), new ConnectivityType(2), new ConnectivityStrength(-1)));
        }
    }

    private void handleActiveInternetConnection(ConnectivityEvent event, ConnectivityChangeListener listener) {
        if (event.getStrength().getValue() >= this.configuration.getMinimumSignalStrength().getValue()) {
            if (event.getType().getValue() == 1 && this.configuration.isRegisteredForMobileNetworkChanges()) {
                listener.onConnectionChange(event);
            } else if (event.getType().getValue() == 0 && this.configuration.isRegisteredForWiFiChanges()) {
                listener.onConnectionChange(event);
            }
        }
    }

    public void unregisterFromConnectivityEvents(Object object) {
        NetworkChangeReceiver networkChangeReceiver = this.networkReceiversHashMap.get(object.toString());
        this.configuration.getContext().unregisterReceiver((BroadcastReceiver)networkChangeReceiver);
        this.networkReceiversHashMap.remove(object.toString());
        if (this.wifiScanResultReceiver != null) {
            this.configuration.getContext().unregisterReceiver((BroadcastReceiver)this.wifiScanResultReceiver);
            this.wifiScanResultReceiver = null;
        }
        if (this.wifiConnectionStateChangedReceiver != null) {
            this.configuration.getContext().unregisterReceiver((BroadcastReceiver)this.wifiConnectionStateChangedReceiver);
            this.wifiConnectionStateChangedReceiver = null;
        }
        networkChangeReceiver = null;
    }

    public boolean hasNetworkConnection() {
        if (this.configuration.getConnectivityManager() == null) {
            throw new IllegalStateException("Connectivity manager is null, library was not properly initialized!");
        }
        NetworkInfo networkInfo = this.configuration.getConnectivityManager().getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public void hasNetworkConnection(NetworkRequestCheckListener listener) {
        if (this.hasNetworkConnection()) {
            this.testNetworkRequest(listener);
        } else {
            listener.onNoResponse();
        }
    }

    private void testNetworkRequest(final NetworkRequestCheckListener listener) {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(this.getConfiguration().getTestNetworkRequestExecutorSize());
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(ConnectionBuddy.NETWORK_CHECK_URL).openConnection();
                    httpURLConnection.setRequestProperty(ConnectionBuddy.HEADER_KEY_USER_AGENT, ConnectionBuddy.HEADER_VALUE_USER_AGENT);
                    httpURLConnection.setRequestProperty(ConnectionBuddy.HEADER_KEY_CONNECTION, ConnectionBuddy.HEADER_VALUE_CONNECTION);
                    httpURLConnection.setConnectTimeout(1500);
                    httpURLConnection.connect();
                    if (httpURLConnection.getResponseCode() == 204 && httpURLConnection.getContentLength() == 0) {
                        ConnectionBuddy.this.callbackExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                listener.onResponseObtained();
                            }
                        });
                    } else {
                        ConnectionBuddy.this.callbackExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                listener.onNoResponse();
                            }
                        });
                    }
                }
                catch (IOException e) {
                    ConnectionBuddy.this.callbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.onNoResponse();
                        }
                    });
                }
            }
        });
    }

    public ConnectivityType getNetworkType() {
        if (this.configuration.getConnectivityManager() == null) {
            throw new IllegalStateException("Connectivity manager is null, library was not properly initialized!");
        }
        NetworkInfo networkInfo = this.configuration.getConnectivityManager().getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            switch (networkInfo.getType()) {
                case 1: {
                    return new ConnectivityType(0);
                }
                case 0: {
                    return new ConnectivityType(1);
                }
            }
            return new ConnectivityType(-1);
        }
        return new ConnectivityType(2);
    }

    public ConnectivityStrength getSignalStrength() {
        if (this.configuration.getConnectivityManager() == null) {
            throw new IllegalStateException("Connectivity manager is null, library was not properly initialized!");
        }
        NetworkInfo networkInfo = this.configuration.getConnectivityManager().getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 1) {
                return this.getWifiStrength();
            }
            return this.getMobileConnectionStrength(networkInfo);
        }
        return new ConnectivityStrength(-1);
    }

    private ConnectivityStrength getWifiStrength() {
        WifiManager wifiManager = (WifiManager)this.configuration.getContext().getApplicationContext().getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        if (wifiInfo != null) {
            int level = WifiManager.calculateSignalLevel((int)wifiInfo.getRssi(), (int)3);
            switch (level) {
                case 0: {
                    return new ConnectivityStrength(0);
                }
                case 1: {
                    return new ConnectivityStrength(1);
                }
                case 2: {
                    return new ConnectivityStrength(2);
                }
            }
            return new ConnectivityStrength(-1);
        }
        return new ConnectivityStrength(-1);
    }

    private ConnectivityStrength getMobileConnectionStrength(NetworkInfo info) {
        if (info != null && info.getType() == 0) {
            switch (info.getSubtype()) {
                case 7: {
                    return new ConnectivityStrength(0);
                }
                case 4: {
                    return new ConnectivityStrength(0);
                }
                case 2: {
                    return new ConnectivityStrength(0);
                }
                case 5: {
                    return new ConnectivityStrength(1);
                }
                case 6: {
                    return new ConnectivityStrength(1);
                }
                case 1: {
                    return new ConnectivityStrength(2);
                }
                case 8: {
                    return new ConnectivityStrength(2);
                }
                case 10: {
                    return new ConnectivityStrength(2);
                }
                case 9: {
                    return new ConnectivityStrength(2);
                }
                case 3: {
                    return new ConnectivityStrength(2);
                }
                case 14: {
                    return new ConnectivityStrength(2);
                }
                case 12: {
                    return new ConnectivityStrength(2);
                }
                case 15: {
                    return new ConnectivityStrength(2);
                }
                case 11: {
                    return new ConnectivityStrength(2);
                }
                case 13: {
                    return new ConnectivityStrength(2);
                }
            }
            return new ConnectivityStrength(-1);
        }
        return new ConnectivityStrength(-1);
    }

    public boolean isOnRoaming() {
        NetworkInfo networkInfo = this.getConfiguration().getConnectivityManager().getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isRoaming();
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void connectToWifiConfiguration(Context context, String networkSsid, String networkPassword, boolean disconnectIfNotFound) throws SecurityException {
        this.connectToWifiConfiguration(context, networkSsid, networkPassword, disconnectIfNotFound, null);
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void connectToWifiConfiguration(Context context, String networkSsid, String networkPassword, boolean disconnectIfNotFound, WifiConnectivityListener listener) throws SecurityException {
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0 || ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            throw new SecurityException("ACCESS_COARSE_LOCATION and ACCESS_FINE_LOCATION permissions have not been granted by the user.");
        }
        WifiManager wifiManager = (WifiManager)this.getConfiguration().getContext().getApplicationContext().getSystemService("wifi");
        if (!wifiManager.isWifiEnabled()) {
            wifiManager.setWifiEnabled(true);
        }
        this.wifiScanResultReceiver = new WifiScanResultReceiver(wifiManager, networkSsid, networkPassword, disconnectIfNotFound, listener);
        this.configuration.getContext().registerReceiver((BroadcastReceiver)this.wifiScanResultReceiver, new IntentFilter("android.net.wifi.SCAN_RESULTS"));
        wifiManager.startScan();
    }

    private class WifiConnectionStateChangedReceiver
    extends BroadcastReceiver {
        private WifiConnectivityListener listener;
        private String networkSsid;
        private WifiManager wifiManager;
        private boolean disconnectIfNotFound;

        public WifiConnectionStateChangedReceiver(@NonNull String networkSsid, WifiManager wifiManager, boolean disconnectIfNotFound, WifiConnectivityListener listener) {
            this.listener = listener;
            this.networkSsid = networkSsid;
            this.wifiManager = wifiManager;
            this.disconnectIfNotFound = disconnectIfNotFound;
        }

        public void onReceive(Context context, Intent intent) {
            context.unregisterReceiver((BroadcastReceiver)this);
            NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            if (this.listener != null) {
                if (networkInfo.isConnected() && this.wifiManager.getConnectionInfo().getSSID().replace("\"", "").equals(this.networkSsid)) {
                    this.listener.onConnected();
                } else {
                    if (this.disconnectIfNotFound) {
                        this.wifiManager.disconnect();
                    }
                    this.listener.onNotFound();
                }
            }
        }
    }

    private class WifiScanResultReceiver
    extends BroadcastReceiver {
        private WifiManager wifiManager;
        private WifiConnectivityListener listener;
        private String networkSsid;
        private String networkPassword;
        private boolean disconnectIfNotFound;

        public WifiScanResultReceiver(WifiManager wifiManager, String networkSsid, String networkPassword, boolean disconnectIfNotFound, WifiConnectivityListener listener) {
            this.wifiManager = wifiManager;
            this.listener = listener;
            this.networkSsid = networkSsid;
            this.networkPassword = networkPassword;
            this.disconnectIfNotFound = disconnectIfNotFound;
        }

        public void onReceive(Context context, Intent intent) {
            context.unregisterReceiver((BroadcastReceiver)this);
            if (this.wifiManager != null && this.wifiManager.getScanResults() != null && this.wifiManager.getScanResults().size() > 0) {
                for (ScanResult scanResult : this.wifiManager.getScanResults()) {
                    int networkId;
                    if (scanResult.SSID == null || !scanResult.SSID.equals(this.networkSsid)) continue;
                    WifiConfiguration wifiConfiguration = this.checkIfWifiAlreadyConfigured(this.wifiManager.getConfiguredNetworks());
                    if (wifiConfiguration == null) {
                        wifiConfiguration = new WifiConfiguration();
                        wifiConfiguration.SSID = "\"" + this.networkSsid + "\"";
                        wifiConfiguration.preSharedKey = "\"" + this.networkPassword + "\"";
                        networkId = this.wifiManager.addNetwork(wifiConfiguration);
                    } else {
                        wifiConfiguration.preSharedKey = "\"" + this.networkPassword + "\"";
                        networkId = wifiConfiguration.networkId;
                    }
                    ConnectionBuddy.this.wifiConnectionStateChangedReceiver = new WifiConnectionStateChangedReceiver(this.networkSsid, this.wifiManager, this.disconnectIfNotFound, this.listener);
                    ConnectionBuddy.this.configuration.getContext().registerReceiver((BroadcastReceiver)ConnectionBuddy.this.wifiConnectionStateChangedReceiver, new IntentFilter("android.net.wifi.STATE_CHANGE"));
                    this.wifiManager.enableNetwork(networkId, true);
                    return;
                }
            }
            if (this.listener != null) {
                this.listener.onNotFound();
            }
        }

        private WifiConfiguration checkIfWifiAlreadyConfigured(List<WifiConfiguration> wifiConfigurationList) {
            if (wifiConfigurationList != null && !wifiConfigurationList.isEmpty()) {
                for (WifiConfiguration configuration : wifiConfigurationList) {
                    if (configuration.SSID == null || !configuration.SSID.equals("\"" + this.networkSsid + "\"")) continue;
                    return configuration;
                }
            }
            return null;
        }
    }
}

