/*
 * Decompiled with CFR 0.152.
 */
package com.zplesac.connectionbuddy;

import android.content.Context;
import android.net.ConnectivityManager;
import android.util.LruCache;
import com.zplesac.connectionbuddy.models.ConnectivityStrength;

public class ConnectionBuddyConfiguration {
    public static final int SIGNAL_STRENGTH_NUMBER_OF_LEVELS = 3;
    private Context context;
    private boolean registeredForWiFiChanges;
    private boolean registeredForMobileNetworkChanges;
    private ConnectivityStrength minimumSignalStrength;
    private int cacheSize;
    private LruCache<String, Boolean> inMemoryCache;
    private boolean notifyImmediately;
    private ConnectivityManager connectivityManager;
    private boolean notifyOnlyReliableEvents;

    private ConnectionBuddyConfiguration(Builder builder) {
        this.context = builder.context;
        this.registeredForMobileNetworkChanges = builder.registerForMobileNetworkChanges;
        this.registeredForWiFiChanges = builder.registerForWiFiChanges;
        this.minimumSignalStrength = builder.minimumSignalStrength;
        this.cacheSize = builder.cacheSize;
        this.inMemoryCache = new LruCache(this.cacheSize);
        this.notifyImmediately = builder.notifyImmediately;
        this.notifyOnlyReliableEvents = builder.notifyOnlyReliableEvents;
        this.connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isRegisteredForWiFiChanges() {
        return this.registeredForWiFiChanges;
    }

    public boolean isRegisteredForMobileNetworkChanges() {
        return this.registeredForMobileNetworkChanges;
    }

    public ConnectivityStrength getMinimumSignalStrength() {
        return this.minimumSignalStrength;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public LruCache<String, Boolean> getInMemoryCache() {
        return this.inMemoryCache;
    }

    public boolean isNotifyImmediately() {
        return this.notifyImmediately;
    }

    public ConnectivityManager getConnectivityManager() {
        return this.connectivityManager;
    }

    public boolean isNotifyOnlyReliableEvents() {
        return this.notifyOnlyReliableEvents;
    }

    public static class Builder {
        private Context context;
        private final int kbSize = 1024;
        private final int memoryPart = 10;
        private final int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        private boolean registerForWiFiChanges = true;
        private boolean registerForMobileNetworkChanges = true;
        private ConnectivityStrength minimumSignalStrength = ConnectivityStrength.POOR;
        private boolean notifyImmediately = true;
        private boolean notifyOnlyReliableEvents = false;
        private int cacheSize = this.maxMemory / 10;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
        }

        public Builder registerForWiFiChanges(boolean shouldRegister) {
            this.registerForWiFiChanges = shouldRegister;
            return this;
        }

        public Builder registerForMobileNetworkChanges(boolean shouldRegister) {
            this.registerForMobileNetworkChanges = shouldRegister;
            return this;
        }

        public Builder setMinimumSignalStrength(ConnectivityStrength minimumSignalStrength) {
            this.minimumSignalStrength = minimumSignalStrength;
            return this;
        }

        public Builder setCacheSize(int size) {
            this.cacheSize = size;
            return this;
        }

        public Builder setNotifyImmediately(boolean shouldNotify) {
            this.notifyImmediately = shouldNotify;
            return this;
        }

        public Builder notifyOnlyReliableEvents(boolean shouldNotify) {
            this.notifyOnlyReliableEvents = shouldNotify;
            return this;
        }

        public ConnectionBuddyConfiguration build() {
            return new ConnectionBuddyConfiguration(this);
        }
    }
}

