/*
 * Decompiled with CFR 0.152.
 */
package com.zplesac.connectionbuddy;

import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Looper;
import android.telephony.TelephonyManager;
import com.zplesac.connectionbuddy.ConnectionBuddyConfiguration;
import com.zplesac.connectionbuddy.cache.ConnectionBuddyCache;
import com.zplesac.connectionbuddy.interfaces.ConnectivityChangeListener;
import com.zplesac.connectionbuddy.interfaces.NetworkRequestCheckListener;
import com.zplesac.connectionbuddy.models.ConnectivityEvent;
import com.zplesac.connectionbuddy.models.ConnectivityState;
import com.zplesac.connectionbuddy.models.ConnectivityStrength;
import com.zplesac.connectionbuddy.models.ConnectivityType;
import com.zplesac.connectionbuddy.receivers.NetworkChangeReceiver;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Executor;

public class ConnectionBuddy {
    private static final String HEADER_KEY_USER_AGENT = "User-Agent";
    private static final String HEADER_VALUE_USER_AGENT = "Android";
    private static final String HEADER_KEY_CONNECTION = "Connection";
    private static final String HEADER_VALUE_CONNECTION = "close";
    private static final String ACTION_CONNECTIVITY_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE";
    private static final String ACTION_WIFI_STATE_CHANGE = "android.net.wifi.WIFI_STATE_CHANGED";
    private static final String NETWORK_CHECK_URL = "http://clients3.google.com/generate_204";
    private static final int CONNECTION_TIMEOUT = 1500;
    private static HashMap<String, NetworkChangeReceiver> receiversHashMap = new HashMap();
    private static volatile ConnectionBuddy instance;
    private ConnectionBuddyConfiguration configuration;
    private Executor callbackExecutor = new Executor(){
        Handler mainHandler = new Handler(Looper.getMainLooper());

        @Override
        public void execute(Runnable command) {
            this.mainHandler.post(command);
        }
    };

    protected ConnectionBuddy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionBuddy getInstance() {
        if (instance != null) return instance;
        Class<ConnectionBuddy> clazz = ConnectionBuddy.class;
        synchronized (ConnectionBuddy.class) {
            if (instance != null) return instance;
            instance = new ConnectionBuddy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void init(ConnectionBuddyConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException();
        }
        if (this.configuration == null) {
            this.configuration = configuration;
        }
    }

    public ConnectionBuddyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void registerForConnectivityEvents(Object object, ConnectivityChangeListener listener) {
        this.registerForConnectivityEvents(object, this.configuration.isNotifyImmediately(), listener);
    }

    public void registerForConnectivityEvents(Object object, boolean notifyImmediately, ConnectivityChangeListener listener) {
        boolean hasConnection = this.hasNetworkConnection();
        if (ConnectionBuddyCache.isLastNetworkStateStored(object) && ConnectionBuddyCache.getLastNetworkState(object) != hasConnection) {
            ConnectionBuddyCache.setLastNetworkState(object, hasConnection);
            if (notifyImmediately) {
                this.notifyConnectionChange(hasConnection, listener);
            }
        } else if (!ConnectionBuddyCache.isLastNetworkStateStored(object)) {
            ConnectionBuddyCache.setLastNetworkState(object, hasConnection);
            if (notifyImmediately) {
                this.notifyConnectionChange(hasConnection, listener);
            }
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_CONNECTIVITY_CHANGE);
        filter.addAction(ACTION_WIFI_STATE_CHANGE);
        NetworkChangeReceiver receiver = new NetworkChangeReceiver(object, listener);
        if (!receiversHashMap.containsKey(object.toString())) {
            receiversHashMap.put(object.toString(), receiver);
        }
        this.configuration.getContext().registerReceiver((BroadcastReceiver)receiver, filter);
    }

    public void notifyConnectionChange(boolean hasConnection, final ConnectivityChangeListener listener) {
        if (hasConnection) {
            final ConnectivityEvent event = new ConnectivityEvent(ConnectivityState.CONNECTED, this.getNetworkType(), this.getSignalStrength());
            if (this.configuration.isNotifyOnlyReliableEvents()) {
                this.testNetworkRequest(new NetworkRequestCheckListener(){

                    @Override
                    public void onResponseObtained() {
                        ConnectionBuddy.this.handleActiveInternetConnection(event, listener);
                    }

                    @Override
                    public void onNoResponse() {
                    }
                });
            } else {
                this.handleActiveInternetConnection(event, listener);
            }
        } else {
            listener.onConnectionChange(new ConnectivityEvent(ConnectivityState.DISCONNECTED, ConnectivityType.NONE, ConnectivityStrength.UNDEFINED));
        }
    }

    private void handleActiveInternetConnection(ConnectivityEvent event, ConnectivityChangeListener listener) {
        if (event.getStrength().ordinal() < this.configuration.getMinimumSignalStrength().ordinal()) {
            return;
        }
        if (event.getType() == ConnectivityType.BOTH && this.configuration.isRegisteredForMobileNetworkChanges() && this.configuration.isRegisteredForWiFiChanges()) {
            listener.onConnectionChange(event);
        } else if (event.getType() == ConnectivityType.MOBILE && this.configuration.isRegisteredForMobileNetworkChanges()) {
            listener.onConnectionChange(event);
        } else if (event.getType() == ConnectivityType.WIFI && this.configuration.isRegisteredForWiFiChanges()) {
            listener.onConnectionChange(event);
        }
    }

    public void unregisterFromConnectivityEvents(Object object) {
        NetworkChangeReceiver receiver = receiversHashMap.get(object.toString());
        this.configuration.getContext().unregisterReceiver((BroadcastReceiver)receiver);
        receiversHashMap.remove(object.toString());
        receiver = null;
    }

    public boolean hasNetworkConnection() {
        if (this.configuration.getConnectivityManager() == null) {
            throw new IllegalStateException("Connectivity manager is null, library was not properly initialized!");
        }
        NetworkInfo networkInfoMobile = this.configuration.getConnectivityManager().getNetworkInfo(0);
        NetworkInfo networkInfoWiFi = this.configuration.getConnectivityManager().getNetworkInfo(1);
        return networkInfoMobile != null && networkInfoMobile.isConnected() || networkInfoWiFi.isConnected();
    }

    public void hasNetworkConnection(NetworkRequestCheckListener listener) {
        if (this.hasNetworkConnection()) {
            this.testNetworkRequest(listener);
        } else {
            listener.onNoResponse();
        }
    }

    private void testNetworkRequest(final NetworkRequestCheckListener listener) {
        Thread bgThread = new Thread(){

            @Override
            public void run() {
                try {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(ConnectionBuddy.NETWORK_CHECK_URL).openConnection();
                    httpURLConnection.setRequestProperty(ConnectionBuddy.HEADER_KEY_USER_AGENT, ConnectionBuddy.HEADER_VALUE_USER_AGENT);
                    httpURLConnection.setRequestProperty(ConnectionBuddy.HEADER_KEY_CONNECTION, ConnectionBuddy.HEADER_VALUE_CONNECTION);
                    httpURLConnection.setConnectTimeout(1500);
                    httpURLConnection.connect();
                    if (httpURLConnection.getResponseCode() == 204 && httpURLConnection.getContentLength() == 0) {
                        ConnectionBuddy.this.callbackExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                listener.onResponseObtained();
                            }
                        });
                    } else {
                        ConnectionBuddy.this.callbackExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                listener.onNoResponse();
                            }
                        });
                    }
                }
                catch (IOException e) {
                    ConnectionBuddy.this.callbackExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.onNoResponse();
                        }
                    });
                }
            }
        };
        bgThread.setPriority(10);
        bgThread.start();
    }

    public ConnectivityType getNetworkType() {
        if (this.configuration.getConnectivityManager() == null) {
            throw new IllegalStateException("Connectivity manager is null, library was not properly initialized!");
        }
        NetworkInfo networkInfoMobile = this.configuration.getConnectivityManager().getNetworkInfo(0);
        NetworkInfo networkInfoWiFi = this.configuration.getConnectivityManager().getNetworkInfo(1);
        if (networkInfoMobile != null && networkInfoMobile.isConnected() && networkInfoWiFi.isConnected()) {
            return ConnectivityType.BOTH;
        }
        if (networkInfoMobile != null && networkInfoMobile.isConnected()) {
            return ConnectivityType.MOBILE;
        }
        if (networkInfoWiFi.isConnected()) {
            return ConnectivityType.WIFI;
        }
        return ConnectivityType.NONE;
    }

    public ConnectivityStrength getSignalStrength() {
        if (this.configuration.getConnectivityManager() == null) {
            throw new IllegalStateException("Connectivity manager is null, library was not properly initialized!");
        }
        NetworkInfo networkInfo = this.configuration.getConnectivityManager().getActiveNetworkInfo();
        if (networkInfo.getType() == 1) {
            return this.getWifiStrength();
        }
        return this.getMobileConnectionStrength(networkInfo);
    }

    private ConnectivityStrength getWifiStrength() {
        WifiManager wifiManager = (WifiManager)this.configuration.getContext().getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        if (wifiInfo != null) {
            int level = WifiManager.calculateSignalLevel((int)wifiInfo.getRssi(), (int)3);
            switch (level) {
                case 0: {
                    return ConnectivityStrength.POOR;
                }
                case 1: {
                    return ConnectivityStrength.GOOD;
                }
                case 2: {
                    return ConnectivityStrength.EXCELLENT;
                }
            }
            return ConnectivityStrength.UNDEFINED;
        }
        return ConnectivityStrength.UNDEFINED;
    }

    private ConnectivityStrength getMobileConnectionStrength(NetworkInfo info) {
        if (info != null && info.getType() == 0) {
            switch (info.getSubtype()) {
                case 7: {
                    return ConnectivityStrength.POOR;
                }
                case 4: {
                    return ConnectivityStrength.POOR;
                }
                case 2: {
                    return ConnectivityStrength.POOR;
                }
                case 5: {
                    return ConnectivityStrength.GOOD;
                }
                case 6: {
                    return ConnectivityStrength.GOOD;
                }
                case 1: {
                    return ConnectivityStrength.EXCELLENT;
                }
                case 8: {
                    return ConnectivityStrength.EXCELLENT;
                }
                case 10: {
                    return ConnectivityStrength.EXCELLENT;
                }
                case 9: {
                    return ConnectivityStrength.EXCELLENT;
                }
                case 3: {
                    return ConnectivityStrength.EXCELLENT;
                }
                case 14: {
                    return ConnectivityStrength.EXCELLENT;
                }
                case 12: {
                    return ConnectivityStrength.EXCELLENT;
                }
                case 15: {
                    return ConnectivityStrength.EXCELLENT;
                }
                case 11: {
                    return ConnectivityStrength.EXCELLENT;
                }
                case 13: {
                    return ConnectivityStrength.EXCELLENT;
                }
            }
            return ConnectivityStrength.UNDEFINED;
        }
        return ConnectivityStrength.UNDEFINED;
    }

    public boolean isOnRoaming() {
        TelephonyManager telephonyManager = (TelephonyManager)this.configuration.getContext().getSystemService("phone");
        return telephonyManager.isNetworkRoaming();
    }
}

