/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import android.text.TextUtils;
import com.zpj.http.core.IHttp;
import java.io.InputStream;

public class HttpKeyVal
implements IHttp.KeyVal {
    private String key;
    private String value;
    private InputStream stream;
    private String contentType;
    private IHttp.OnStreamWriteListener listener;

    public static HttpKeyVal create(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (value == null) {
            value = "";
        }
        return new HttpKeyVal().key(key).value(value);
    }

    public static HttpKeyVal create(String key, String filename, InputStream stream) {
        return HttpKeyVal.create(key, filename, stream, null);
    }

    public static HttpKeyVal create(String key, String filename, InputStream stream, IHttp.OnStreamWriteListener listener) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)filename) || stream == null) {
            return null;
        }
        return new HttpKeyVal().key(key).value(filename).inputStream(stream).setListener(listener);
    }

    private HttpKeyVal() {
    }

    @Override
    public HttpKeyVal key(String key) {
        this.key = key;
        return this;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public HttpKeyVal value(String value) {
        this.value = value;
        return this;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public HttpKeyVal inputStream(InputStream inputStream) {
        this.stream = inputStream;
        return this;
    }

    @Override
    public InputStream inputStream() {
        return this.stream;
    }

    @Override
    public boolean hasInputStream() {
        return this.stream != null;
    }

    @Override
    public IHttp.KeyVal contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public IHttp.OnStreamWriteListener getListener() {
        return this.listener;
    }

    @Override
    public HttpKeyVal setListener(IHttp.OnStreamWriteListener listener) {
        this.listener = listener;
        return this;
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

