/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import android.text.TextUtils;
import com.zpj.http.ZHttp;
import com.zpj.http.core.BaseConfig;
import com.zpj.http.core.HttpKeyVal;
import com.zpj.http.core.HttpObserver;
import com.zpj.http.core.HttpRequestImpl;
import com.zpj.http.core.IHttp;
import com.zpj.http.parser.html.nodes.Document;
import com.zpj.http.utils.UrlUtil;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpConfig
extends BaseConfig<HttpConfig> {
    private final Collection<IHttp.KeyVal> data = new ArrayList<IHttp.KeyVal>();
    protected URL originalUrl;
    protected URL url;
    protected IHttp.Method method = IHttp.Method.GET;
    protected String body = null;

    protected HttpConfig() {
        ZHttp.HttpGlobalConfig globalConfig = ZHttp.config();
        ((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)((HttpConfig)this.proxy(globalConfig.proxy())).baseUrl(globalConfig.baseUrl())).debug(globalConfig.debug())).cookies(globalConfig.cookies())).userAgent(globalConfig.userAgent())).connectTimeout(globalConfig.connectTimeout())).readTimeout(globalConfig.readTimeout())).retryCount(globalConfig.retryCount())).retryDelay(globalConfig.retryDelay())).bufferSize(globalConfig.bufferSize())).maxBodySize(globalConfig.maxBodySize())).allowAllSSL(globalConfig.allowAllSSL())).headers(globalConfig.headers())).ignoreContentType(globalConfig.ignoreContentType())).ignoreHttpErrors(globalConfig.ignoreHttpErrors())).sslSocketFactory(globalConfig.sslSocketFactory())).maxRedirectCount(globalConfig.maxRedirectCount())).onRedirect(globalConfig.getOnRedirectListener())).cookieJar(globalConfig.cookieJar());
    }

    public URL url() {
        return this.url;
    }

    public URL getOriginalUrl() {
        return this.originalUrl;
    }

    public HttpConfig url(String url) {
        try {
            boolean isHttp;
            url = url.trim();
            String tempUrl = url.toLowerCase();
            boolean bl = isHttp = tempUrl.startsWith("http://") || tempUrl.startsWith("https://");
            if (!isHttp) {
                if (tempUrl.contains("://")) {
                    throw new MalformedURLException("Only http and https protocols supported!");
                }
                if (this.baseUrl == null) {
                    throw new MalformedURLException("You must set baseUrl firstly!");
                }
                if (!tempUrl.startsWith("/")) {
                    url = "/" + url;
                }
                url = this.baseUrl.resolve(url).toString();
            }
            this.url = new URL(UrlUtil.encodeUrl(url));
            if (this.originalUrl == null) {
                this.originalUrl = this.url;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed URL: " + url, e);
        }
        return this;
    }

    public HttpConfig url(URL url) {
        return this.url(url.toString());
    }

    public IHttp.Method method() {
        return this.method;
    }

    public HttpConfig method(IHttp.Method method) {
        this.method = method;
        return this;
    }

    public HttpConfig range(String range) {
        this.headers.put("Range", range);
        return this;
    }

    public HttpConfig range(long start) {
        this.headers.put("Range", String.format(Locale.ENGLISH, "bytes=%d-", start));
        return this;
    }

    public HttpConfig range(long start, long end) {
        this.headers.put("Range", String.format(Locale.ENGLISH, "bytes=%d-%d", start, end));
        return this;
    }

    public HttpConfig requestBody(String body) {
        this.body = body;
        return this;
    }

    public String requestBody() {
        return this.body;
    }

    public HttpConfig data(IHttp.KeyVal keyval) {
        if (keyval != null) {
            this.data.add(keyval);
        }
        return this;
    }

    public Collection<IHttp.KeyVal> data() {
        return this.data;
    }

    public HttpConfig data(String key, String value) {
        return this.data(HttpKeyVal.create(key, value));
    }

    public HttpConfig data(String key, String filename, InputStream inputStream) {
        return this.data(HttpKeyVal.create(key, filename, inputStream));
    }

    public HttpConfig data(String key, String filename, InputStream inputStream, IHttp.OnStreamWriteListener listener) {
        return this.data(HttpKeyVal.create(key, filename, inputStream, listener));
    }

    public HttpConfig data(String key, String filename, InputStream inputStream, String contentType) {
        return this.data(HttpKeyVal.create(key, filename, inputStream).contentType(contentType));
    }

    public HttpConfig data(Map<String, String> data) {
        if (data != null) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                this.data(HttpKeyVal.create(entry.getKey(), entry.getValue()));
            }
        }
        return this;
    }

    public HttpConfig data(Collection<IHttp.KeyVal> data) {
        if (data != null) {
            for (IHttp.KeyVal entry : data) {
                this.data(entry);
            }
        }
        return this;
    }

    public IHttp.KeyVal data(String key) {
        if (!TextUtils.isEmpty((CharSequence)key)) {
            for (IHttp.KeyVal keyVal : this.data()) {
                if (!keyVal.key().equals(key)) continue;
                return keyVal;
            }
        }
        return null;
    }

    public boolean needsMultipart() {
        for (IHttp.KeyVal keyVal : this.data()) {
            if (!keyVal.hasInputStream()) continue;
            return true;
        }
        return false;
    }

    public IHttp.Request request() {
        return new HttpRequestImpl(this);
    }

    public IHttp.Response syncExecute() throws Exception {
        return this.request().syncExecute();
    }

    public String syncToStr() throws Exception {
        return this.request().syncToStr();
    }

    public Document syncToHtml() throws Exception {
        return this.request().syncToHtml();
    }

    public JSONObject syncToJsonObject() throws Exception {
        return this.request().syncToJsonObject();
    }

    public JSONArray syncToJsonArray() throws Exception {
        return this.request().syncToJsonArray();
    }

    public Document syncToXml() throws Exception {
        return this.request().syncToXml();
    }

    public final HttpObserver<IHttp.Response> execute() {
        return this.request().execute();
    }

    public final HttpObserver<String> toStr() {
        return this.request().toStr();
    }

    public final HttpObserver<Document> toHtml() {
        return this.request().toHtml();
    }

    public final HttpObserver<JSONObject> toJsonObject() {
        return this.request().toJsonObject();
    }

    public final HttpObserver<JSONArray> toJsonArray() {
        return this.request().toJsonArray();
    }

    public final HttpObserver<Document> toXml() {
        return this.request().toXml();
    }
}

