/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http;

import com.zpj.http.core.BaseConfig;
import com.zpj.http.core.ConnectionFactory;
import com.zpj.http.core.DefaultCookieJar;
import com.zpj.http.core.HttpConfig;
import com.zpj.http.core.IHttp;
import com.zpj.http.ssl.HTTPSTrustManager;

public class ZHttp {
    private static HttpGlobalConfig HTTP_CONFIG;

    private ZHttp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpGlobalConfig config() {
        if (HTTP_CONFIG != null) return HTTP_CONFIG;
        Class<HttpGlobalConfig> clazz = HttpGlobalConfig.class;
        synchronized (HttpGlobalConfig.class) {
            if (HTTP_CONFIG != null) return HTTP_CONFIG;
            HTTP_CONFIG = new HttpGlobalConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return HTTP_CONFIG;
        }
    }

    public static HttpConfig connect(String url) {
        return ConnectionFactory.createHttpRequest(url);
    }

    public static HttpConfig get(String url) {
        return ZHttp.connect(url).method(IHttp.Method.GET);
    }

    public static HttpConfig post(String url) {
        return ZHttp.connect(url).method(IHttp.Method.POST);
    }

    public static HttpConfig head(String url) {
        return ZHttp.connect(url).method(IHttp.Method.HEAD);
    }

    public static HttpConfig put(String url) {
        return ZHttp.connect(url).method(IHttp.Method.PUT);
    }

    public static HttpConfig delete(String url) {
        return ZHttp.connect(url).method(IHttp.Method.DELETE);
    }

    public static HttpConfig patch(String url) {
        return ZHttp.connect(url).method(IHttp.Method.PATCH);
    }

    public static HttpConfig options(String url) {
        return ZHttp.connect(url).method(IHttp.Method.OPTIONS);
    }

    public static HttpConfig trace(String url) {
        return ZHttp.connect(url).method(IHttp.Method.TRACE);
    }

    public static class HttpGlobalConfig
    extends BaseConfig<HttpGlobalConfig> {
        private HttpGlobalConfig() {
            this.cookieJar(new DefaultCookieJar());
        }

        public void init() {
            if (this.allowAllSSL()) {
                HTTPSTrustManager.allowAllSSL();
            }
        }
    }
}

