/*
 * Decompiled with CFR 0.152.
 */
package com.zpj.http.core;

import java.io.InputStream;
import java.util.Map;

public class ResponseInfo {
    private int statusCode;
    private String statusMessage;
    private String contentType;
    private long contentLength;
    protected Map<String, String> headers;
    private Callback callback;

    private ResponseInfo() {
    }

    public static ResponseInfo build() {
        return new ResponseInfo();
    }

    public ResponseInfo onGetBodyStream(Callback callback) {
        this.callback = callback;
        return this;
    }

    public InputStream getBodyStream() throws Exception {
        if (this.callback != null) {
            return this.callback.get();
        }
        return null;
    }

    public ResponseInfo setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public ResponseInfo setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    public ResponseInfo setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public ResponseInfo setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public ResponseInfo setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String toString() {
        return "ResponseInfo{statusCode=" + this.statusCode + ", statusMessage='" + this.statusMessage + '\'' + ", contentType='" + this.contentType + '\'' + ", contentLength=" + this.contentLength + ", headers=" + this.headers + ", callback=" + this.callback + '}';
    }

    public static interface Callback {
        public InputStream get() throws Exception;
    }
}

